/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import android.view.View;
import android.widget.AbsListView;
import android.widget.ListView;
import com.android.tools.idea.uibuilder.api.ScrollHandler;
import org.jetbrains.annotations.NotNull;

final class ListViewScrollHandler
implements ScrollHandler {
    private final AbsListView myListView;

    ListViewScrollHandler(@NotNull ListView listView) {
        this.myListView = listView;
    }

    @Override
    public int update(int scrollAmount) {
        if (scrollAmount == 0 || this.myListView.getChildCount() == 0) {
            return 0;
        }
        View view2 = this.myListView.getChildAt(scrollAmount > 0 ? this.myListView.getChildCount() - 1 : 0);
        this.myListView.setSelectionFromTop(this.myListView.getPositionForView(view2), view2.getTop() - (scrollAmount *= 10));
        return scrollAmount;
    }

    @Override
    public void commit(int scrollAmount) {
        this.update(scrollAmount);
    }

    @Override
    public boolean canScroll(int scrollAmount) {
        return true;
    }
}

