/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.preference;

import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.command.NlWriteCommandActionUtil;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.XmlType;
import com.android.tools.idea.uibuilder.handlers.preference.PreferenceHandler;
import com.android.xml.XmlBuilder;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class EditTextPreferenceHandler
extends PreferenceHandler {
    @Override
    @Language(value="XML")
    @NotNull
    public String getXml(@NotNull String tagName, @NotNull XmlType xmlType) {
        switch (xmlType) {
            case COMPONENT_CREATION: {
                return new XmlBuilder().startTag(tagName).androidAttribute("defaultValue", "Default value").androidAttribute("selectAllOnFocus", true).androidAttribute("singleLine", true).androidAttribute("title", "Edit text preference").endTag(tagName).toString();
            }
            case PREVIEW_ON_PALETTE: 
            case DRAG_PREVIEW: {
                return "";
            }
        }
        throw new AssertionError((Object)xmlType);
    }

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"defaultValue", (Object)"key", (Object)"title", (Object)"summary", (Object)"dependency", (Object)"icon", (Object)"dialogIcon", (Object)"singleLine");
    }

    @Override
    public boolean onCreate(@Nullable NlComponent parent, @NotNull NlComponent newChild, @NotNull InsertType type) {
        if (!super.onCreate(parent, newChild, type)) {
            return false;
        }
        if (type == InsertType.CREATE) {
            NlWriteCommandActionUtil.run(newChild, "Set EditTextPreference", () -> newChild.setAndroidAttribute("key", EditTextPreferenceHandler.generateKey(newChild, "EditTextPreference", "edit_text_preference_")));
        }
        return true;
    }
}

