/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property.action;

import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.property.panel.api.TableLineModel;
import com.android.tools.property.ptable.PTableItem;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeleteMotionFieldAction
extends AnAction {
    private static final String REMOVE_ATTRIBUTE = "Remove selected attribute";
    private TableLineModel myLineModel;

    public DeleteMotionFieldAction() {
        super(REMOVE_ATTRIBUTE, REMOVE_ATTRIBUTE, AllIcons.General.Remove);
        ActionManager manager = ActionManager.getInstance();
        this.setShortcutSet(manager.getAction("$Delete").getShortcutSet());
    }

    public void setLineModel(@NotNull TableLineModel lineModel) {
        this.myLineModel = lineModel;
    }

    public void update(@NotNull AnActionEvent event) {
        boolean enabled = this.myLineModel != null && !this.myLineModel.getTableModel().getItems().isEmpty();
        event.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        NlPropertyItem property = DeleteMotionFieldAction.getSelectedOrFirstItem(this.myLineModel);
        if (property != null) {
            this.myLineModel.removeItem((PTableItem)property);
        }
    }

    @Nullable
    public static NlPropertyItem getSelectedOrFirstItem(@Nullable TableLineModel lineModel) {
        if (lineModel == null) {
            return null;
        }
        NlPropertyItem property = (NlPropertyItem)lineModel.getSelectedItem();
        if (property == null) {
            List items = lineModel.getTableModel().getItems();
            if (items.isEmpty()) {
                return null;
            }
            property = (NlPropertyItem)items.get(0);
        }
        return property;
    }
}

