/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property.action;

import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.property.MotionLayoutAttributesModel;
import com.android.tools.idea.uibuilder.handlers.motion.property.MotionSelection;
import com.android.tools.idea.uibuilder.handlers.motion.property.action.DeleteMotionFieldAction;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.property.panel.api.TableLineModel;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;

public class DeleteCustomFieldAction
extends AnAction {
    private static final String REMOVE_ATTRIBUTE = "Remove selected attribute";
    private TableLineModel myLineModel;

    public DeleteCustomFieldAction() {
        super(REMOVE_ATTRIBUTE, REMOVE_ATTRIBUTE, AllIcons.General.Remove);
        ActionManager manager = ActionManager.getInstance();
        this.setShortcutSet(manager.getAction("$Delete").getShortcutSet());
    }

    public void setLineModel(@NotNull TableLineModel lineModel) {
        this.myLineModel = lineModel;
    }

    public void update(@NotNull AnActionEvent event) {
        boolean enabled = this.myLineModel != null && !this.myLineModel.getTableModel().getItems().isEmpty();
        event.getPresentation().setEnabled(enabled);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        NlPropertyItem property = DeleteMotionFieldAction.getSelectedOrFirstItem(this.myLineModel);
        if (property == null) {
            return;
        }
        MotionSelection selection = MotionLayoutAttributesModel.getMotionSelection(property);
        if (selection == null) {
            return;
        }
        MotionSceneTag tag = selection.getMotionSceneTag();
        if (tag == null) {
            return;
        }
        MTag customTag = MotionLayoutAttributesModel.findCustomTag(tag, property.getName());
        if (customTag == null) {
            return;
        }
        MTag.TagWriter tagWriter = customTag.getTagWriter();
        tagWriter.deleteTag();
        tagWriter.commit("Delete " + property.getName());
    }
}

