/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property;

import com.android.tools.adtui.model.stdui.CommonTextFieldModel;
import com.android.tools.adtui.model.stdui.EditingErrorCategory;
import com.android.tools.adtui.model.stdui.EditingSupport;
import com.android.tools.adtui.model.stdui.EditingSupportKt;
import com.android.tools.adtui.model.stdui.ValueChangedListener;
import com.android.tools.adtui.stdui.CommonTextField;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionAttributes;
import com.android.tools.idea.uibuilder.handlers.motion.property.CustomAttributeType;
import com.android.tools.idea.uibuilder.handlers.motion.property.MotionLayoutAttributesModel;
import com.android.tools.idea.uibuilder.handlers.motion.property.MotionLayoutPropertyProvider;
import com.android.tools.idea.uibuilder.handlers.motion.property.MotionSelection;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.NlPropertyType;
import com.android.tools.property.panel.api.TableLineModel;
import com.intellij.concurrency.JobScheduler;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class NewCustomAttributePanel
extends DialogWrapper {
    private JTextField myAttributeNameEditor;
    private JTextField myInitialValueEditor;
    private JPanel myContentPanel;
    private ComboBox<CustomAttributeType> myDataType;
    private JCheckBox myAcceptAnyway;
    private JLabel myError;
    private MyTextFieldModel myNewAttributeNameModel;
    private MyTextFieldModel myInitialValueModel;
    private final MotionLayoutAttributesModel myPropertiesModel;
    private final MotionSelection mySelection;
    private final TableLineModel myLineModel;
    private final Supplier<CustomAttributeType> myTypeSupplier;
    private final DefaultComboBoxModel<CustomAttributeType> myModel;
    private final WindowFocusListener myWindowFocusListener;
    private NlPropertyItem myProperty;

    public NewCustomAttributePanel(@NotNull MotionLayoutAttributesModel propertiesModel, @NotNull MotionSelection selection, @NotNull TableLineModel lineModel) {
        super(propertiesModel.getProject(), false, DialogWrapper.IdeModalityType.MODELESS);
        this.myPropertiesModel = propertiesModel;
        this.mySelection = selection;
        this.myLineModel = lineModel;
        this.$$$setupUI$$$();
        this.myModel = new DefaultComboBoxModel();
        this.myTypeSupplier = () -> {
            Object selectedType = this.myDataType.getSelectedItem();
            if (selectedType instanceof CustomAttributeType) {
                return (CustomAttributeType)((Object)((Object)selectedType));
            }
            return CustomAttributeType.CUSTOM_STRING;
        };
        NlComponent component = selection.getComponentForCustomAttributeCompletions();
        if (component != null) {
            this.myNewAttributeNameModel.setEditingSupport(new AttributeNameEditingSupport(component, this.myTypeSupplier));
        }
        Arrays.stream(CustomAttributeType.values()).forEach(type -> this.myModel.addElement((CustomAttributeType)((Object)type)));
        this.myModel.setSelectedItem((Object)CustomAttributeType.CUSTOM_STRING);
        this.myDataType.setModel(this.myModel);
        this.myDataType.setEditable(false);
        this.initValidations();
        this.init();
        this.myWindowFocusListener = new WindowFocusListener(){
            private boolean myActivated;

            @Override
            public void windowGainedFocus(WindowEvent event) {
                Runnable setActive = () -> {
                    if (NewCustomAttributePanel.this.getWindow().isFocused()) {
                        this.myActivated = true;
                    } else {
                        NewCustomAttributePanel.this.close(0);
                    }
                };
                JobScheduler.getScheduler().schedule(setActive, 1L, TimeUnit.SECONDS);
            }

            @Override
            public void windowLostFocus(WindowEvent event) {
                if (this.myActivated) {
                    NewCustomAttributePanel.this.close(0);
                }
            }
        };
        this.getWindow().addWindowFocusListener(this.myWindowFocusListener);
    }

    protected void dispose() {
        this.getWindow().removeWindowFocusListener(this.myWindowFocusListener);
        super.dispose();
    }

    @TestOnly
    public JTextField getAttributeNameEditor() {
        return this.myAttributeNameEditor;
    }

    @TestOnly
    public JTextField getInitialValueEditor() {
        return this.myInitialValueEditor;
    }

    @TestOnly
    public ComboBox<CustomAttributeType> getDataTypeComboBox() {
        return this.myDataType;
    }

    @TestOnly
    public JCheckBox getAcceptAnyway() {
        return this.myAcceptAnyway;
    }

    @TestOnly
    public JLabel getErrorLabel() {
        return this.myError;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myDataType;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    @NotNull
    protected ActionListener createCancelAction() {
        return e -> this.doCancelAction(e);
    }

    protected void doOKAction() {
        String attributeName = this.getAttributeName();
        String value2 = this.getInitialValue();
        CustomAttributeType type = this.getType();
        this.myPropertiesModel.addCustomProperty(attributeName, value2, type, this.mySelection, this.myLineModel);
        super.doOKAction();
    }

    @NotNull
    public String getAttributeName() {
        return this.myAttributeNameEditor.getText();
    }

    @NotNull
    public CustomAttributeType getType() {
        return this.myTypeSupplier.get();
    }

    @NotNull
    public String getInitialValue() {
        return this.myInitialValueEditor.getText();
    }

    private void initValidations() {
        this.myDataType.addActionListener(event -> this.updateAfterTypeChange());
        this.myAcceptAnyway.addActionListener(event -> this.updateErrorStatus());
        this.updateAfterTypeChange();
    }

    private void updateAfterTypeChange() {
        String typeTag = this.getType().getTagName();
        NlPropertyType propertyType = MotionLayoutPropertyProvider.mapFromCustomType(typeTag);
        if (this.myProperty == null || propertyType != this.myProperty.getType()) {
            this.myProperty = MotionLayoutPropertyProvider.createCustomProperty("property", typeTag, this.mySelection, this.myPropertiesModel);
            this.myInitialValueModel.setEditingSupport(this.myProperty.getEditingSupport());
        }
        this.myNewAttributeNameModel.updateNow();
        this.myInitialValueModel.updateNow();
        this.updateErrorStatus();
    }

    private void updateErrorStatus() {
        Pair<EditingErrorCategory, String> status2 = this.myNewAttributeNameModel.validate();
        if (status2 == EditingSupportKt.EDITOR_NO_ERROR) {
            status2 = this.myInitialValueModel.validate();
        }
        this.myAcceptAnyway.setVisible(status2.getFirst() == EditingErrorCategory.ERROR);
        this.setOKActionEnabled(status2.getFirst() != EditingErrorCategory.ERROR || this.myAcceptAnyway.isSelected() && !this.myNewAttributeNameModel.getText().isEmpty());
        switch ((EditingErrorCategory)status2.getFirst()) {
            case ERROR: {
                this.myError.setVisible(true);
                this.myError.setText((String)status2.getSecond());
                this.myError.setIcon(StudioIcons.Common.ERROR_INLINE);
                break;
            }
            case WARNING: {
                this.myError.setVisible(true);
                this.myError.setText((String)status2.getSecond());
                this.myError.setIcon(StudioIcons.Common.WARNING_INLINE);
                break;
            }
            default: {
                this.myError.setVisible(false);
            }
        }
    }

    private void createUIComponents() {
        this.myNewAttributeNameModel = new MyTextFieldModel(this::updateErrorStatus);
        this.myAttributeNameEditor = new CommonTextField((CommonTextFieldModel)this.myNewAttributeNameModel);
        this.myInitialValueModel = new MyTextFieldModel(this::updateErrorStatus);
        this.myInitialValueEditor = new CommonTextField((CommonTextFieldModel)this.myInitialValueModel);
        this.myDataType = new ComboBox();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JCheckBox jCheckBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(10, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Attribute Name");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        JTextField jTextField = this.myAttributeNameEditor;
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(300, -1), null));
        JTextField jTextField2 = this.myInitialValueEditor;
        jTextField2.setText("");
        jPanel.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 7, 0, null, new Dimension(300, -1), null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Value");
        jPanel.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        this.myAcceptAnyway = jCheckBox = new JCheckBox();
        jCheckBox.setAlignmentY(0.5f);
        jCheckBox.setMargin(new Insets(1, 1, 0, 1));
        jCheckBox.setText("Accept definition with errors");
        jCheckBox.setVerticalAlignment(0);
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 2, 1, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(5, 0, 5, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Data Type");
        jPanel.add((Component)jBLabel3, new GridConstraints(0, 0, 1, 1, 0, 0, 0, 0, null, null, null));
        ComboBox<CustomAttributeType> comboBox = this.myDataType;
        jPanel.add((Component)comboBox, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, new Dimension(300, -1), null));
        this.myError = jLabel = new JLabel();
        jLabel.setText("");
        jPanel.add((Component)jLabel, new GridConstraints(4, 0, 1, 2, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPanel;
    }

    private static class AttributeNameEditingSupport
    implements EditingSupport {
        private final NlComponent myComponent;
        private final Supplier<CustomAttributeType> myType;
        private CustomAttributeType myLastLookupType;
        private Set<String> myLastLookup = Collections.emptySet();
        private List<String> myCompletions = Collections.emptyList();

        private AttributeNameEditingSupport(@NotNull NlComponent component, @NotNull Supplier<CustomAttributeType> type) {
            this.myComponent = component;
            this.myType = type;
        }

        @NotNull
        public Function1<Runnable, Unit> getUiExecution() {
            return runnable2 -> {
                runnable2.run();
                return Unit.INSTANCE;
            };
        }

        @NotNull
        public Function1<Runnable, Future<?>> getExecution() {
            return EditingSupportKt.EDITOR_IMMEDIATE_EXECUTION;
        }

        @NotNull
        public Function1<String, Pair<EditingErrorCategory, String>> getValidation() {
            return value2 -> this.validate((String)value2);
        }

        @NotNull
        public Function1<String, List<String>> getCompletion() {
            return forText -> this.getCompletions();
        }

        public boolean getAllowCustomValues() {
            return true;
        }

        private Pair<EditingErrorCategory, String> validate(@Nullable String value2) {
            if (value2 == null || value2.isEmpty()) {
                return new Pair((Object)EditingErrorCategory.ERROR, (Object)"Please supply an attribute name");
            }
            this.updateLookups();
            if (this.myLastLookup.contains(value2)) {
                return EditingSupportKt.EDITOR_NO_ERROR;
            }
            String message = "Method not found: " + AttributeNameEditingSupport.getMethodName(value2) + ";  check arguments";
            return new Pair((Object)EditingErrorCategory.ERROR, (Object)message);
        }

        @NotNull
        private static String getMethodName(@NotNull String attributeName) {
            return "set" + StringUtil.capitalize((String)attributeName);
        }

        private List<String> getCompletions() {
            this.updateLookups();
            return this.myCompletions;
        }

        private void updateLookups() {
            CustomAttributeType type = this.myType.get();
            if (type != this.myLastLookupType) {
                this.myLastLookup = MotionAttributes.getCustomAttributesFor(this.myComponent, type.getTagName());
                this.myLastLookupType = type;
                this.myCompletions = new ArrayList<String>(this.myLastLookup);
                this.myCompletions.sort(String::compareTo);
            }
        }
    }

    private static class DefaultEditingSupport
    implements EditingSupport {
        private DefaultEditingSupport() {
        }

        @NotNull
        public Function1<Runnable, Unit> getUiExecution() {
            return runnable2 -> {
                runnable2.run();
                return Unit.INSTANCE;
            };
        }

        @NotNull
        public Function1<Runnable, Future<?>> getExecution() {
            return EditingSupportKt.EDITOR_IMMEDIATE_EXECUTION;
        }

        @NotNull
        public Function1<String, Pair<EditingErrorCategory, String>> getValidation() {
            return value2 -> EditingSupportKt.EDITOR_NO_ERROR;
        }

        @NotNull
        public Function1<String, List<String>> getCompletion() {
            return forText -> Collections.emptyList();
        }

        public boolean getAllowCustomValues() {
            return true;
        }

        public boolean getAlwaysRefreshCompletions() {
            return false;
        }
    }

    private static class MyTextFieldModel
    implements CommonTextFieldModel {
        private final List<ValueChangedListener> myListeners = new ArrayList<ValueChangedListener>();
        private final Runnable myTextChanged;
        private String myText = "";
        private EditingSupport myEditingSupport = new DefaultEditingSupport();

        private MyTextFieldModel(@NotNull Runnable textChanged) {
            this.myTextChanged = textChanged;
        }

        private void setEditingSupport(final @NotNull EditingSupport editingSupport2) {
            this.myEditingSupport = new DefaultEditingSupport(){

                @Override
                @NotNull
                public Function1<String, Pair<EditingErrorCategory, String>> getValidation() {
                    return editingSupport2.getValidation();
                }

                @Override
                @NotNull
                public Function1<String, List<String>> getCompletion() {
                    return editingSupport2.getCompletion();
                }
            };
        }

        private Pair<EditingErrorCategory, String> validate() {
            return (Pair)this.myEditingSupport.getValidation().invoke((Object)this.myText);
        }

        @NotNull
        public String getValue() {
            return this.myText;
        }

        public boolean getEnabled() {
            return true;
        }

        public boolean getEditable() {
            return true;
        }

        @NotNull
        public String getPlaceHolderValue() {
            return "";
        }

        @NotNull
        public String getText() {
            return this.myText;
        }

        public void setText(@NotNull String text) {
            this.myText = text;
            this.myTextChanged.run();
        }

        public void updateNow() {
            this.myListeners.forEach(listener2 -> listener2.valueChanged());
        }

        @NotNull
        public EditingSupport getEditingSupport() {
            return this.myEditingSupport;
        }

        public void addListener(@NotNull ValueChangedListener listener2) {
            this.myListeners.add(listener2);
        }

        public void removeListener(@NotNull ValueChangedListener listener2) {
            this.myListeners.remove(listener2);
        }
    }
}

