/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.property;

import com.android.ide.common.rendering.api.AttributeFormat;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.rendering.api.ResourceReference;
import com.android.resources.ResourceType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MotionSceneAttrs;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionAttributes;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionEditorSelector;
import com.android.tools.idea.uibuilder.handlers.motion.property.MotionIdPropertyItem;
import com.android.tools.idea.uibuilder.handlers.motion.property.MotionSelection;
import com.android.tools.idea.uibuilder.property.NlFlagsPropertyItem;
import com.android.tools.idea.uibuilder.property.NlPropertiesModel;
import com.android.tools.idea.uibuilder.property.NlPropertyItem;
import com.android.tools.idea.uibuilder.property.NlPropertyType;
import com.android.tools.idea.uibuilder.property.PropertiesProvider;
import com.android.tools.idea.uibuilder.property.support.TypeResolver;
import com.android.tools.property.panel.api.PropertiesTable;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Table;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.impl.source.xml.XmlElementDescriptorProvider;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.NamespaceAwareXmlAttributeDescriptor;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.AndroidDomElementDescriptorProvider;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.dom.attrs.StyleableDefinition;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.LocalResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutPropertyProvider
implements PropertiesProvider {
    private final AndroidFacet myFacet;
    private final XmlElementDescriptorProvider myDescriptorProvider;
    private final Table<String, String, NlPropertyItem> myEmptyTable;
    private static final int EXPECTED_ROWS = 3;
    private static final int EXPECTED_CELLS_PER_ROW = 10;
    private static final List<String> INCLUDE_SUB_TAGS_OF = ImmutableList.of((Object)"Constraint", (Object)"Transition");

    public MotionLayoutPropertyProvider(@NotNull AndroidFacet facet) {
        this.myFacet = facet;
        this.myDescriptorProvider = new AndroidDomElementDescriptorProvider();
        this.myEmptyTable = ImmutableTable.of();
    }

    @Override
    @NotNull
    public PropertiesTable<NlPropertyItem> getProperties(@NotNull NlPropertiesModel model2, @Nullable Object optionalValue, @NotNull List<? extends NlComponent> components) {
        return PropertiesTable.Companion.emptyTable();
    }

    @Override
    @NotNull
    public PropertiesTable<NlPropertyItem> createEmptyTable() {
        return PropertiesTable.Companion.create((Table)HashBasedTable.create((int)3, (int)10));
    }

    @NotNull
    public Map<String, PropertiesTable<NlPropertyItem>> getAllProperties(@NotNull NlPropertiesModel model2, @NotNull MotionSelection selection) {
        if (selection.getComponents().isEmpty()) {
            return Collections.emptyMap();
        }
        ModuleResourceManagers resourceManagers = ModuleResourceManagers.getInstance((AndroidFacet)this.myFacet);
        LocalResourceManager localResourceManager = resourceManagers.getLocalResourceManager();
        FrameworkResourceManager frameworkResourceManager = resourceManagers.getFrameworkResourceManager();
        if (frameworkResourceManager == null) {
            Logger.getInstance(MotionLayoutPropertyProvider.class).error("No system resource manager for module: " + this.myFacet.getModule().getName());
            return Collections.emptyMap();
        }
        AttributeDefinitions localAttrDefs = localResourceManager.getAttributeDefinitions();
        AttributeDefinitions systemAttrDefs = frameworkResourceManager.getAttributeDefinitions();
        if (localAttrDefs == null) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, PropertiesTable<NlPropertyItem>> allProperties = new LinkedHashMap<String, PropertiesTable<NlPropertyItem>>();
        MotionSceneTag motionSceneTag = selection.getMotionSceneTag();
        XmlTag tag = selection.getXmlTag(motionSceneTag);
        if (motionSceneTag != null && tag != null) {
            XmlElementDescriptor elementDescriptor = this.myDescriptorProvider.getDescriptor(tag);
            if (elementDescriptor == null) {
                return Collections.emptyMap();
            }
            XmlAttributeDescriptor[] descriptors = elementDescriptor.getAttributesDescriptors(tag);
            HashBasedTable properties2 = HashBasedTable.create((int)3, (int)descriptors.length);
            for (XmlAttributeDescriptor descriptor : descriptors) {
                String namespaceUri = MotionLayoutPropertyProvider.getNamespace(descriptor, tag);
                String name = descriptor.getName();
                AttributeDefinitions attrDefs = "http://schemas.android.com/apk/res/android" == namespaceUri ? systemAttrDefs : localAttrDefs;
                ResourceNamespace namespace = ResourceNamespace.fromNamespaceUri((String)namespaceUri);
                AttributeDefinition attrDef = namespace != null && attrDefs != null ? attrDefs.getAttrDefinition(ResourceReference.attr((ResourceNamespace)namespace, (String)name)) : null;
                NlPropertyItem property = MotionLayoutPropertyProvider.createProperty(namespaceUri, name, attrDef, model2, selection, null);
                properties2.put((Object)namespaceUri, (Object)name, (Object)property);
            }
            allProperties.put(tag.getLocalName(), (PropertiesTable<NlPropertyItem>)PropertiesTable.Companion.create((Table)properties2));
            MotionLayoutPropertyProvider.loadCustomAttributes(model2, allProperties, motionSceneTag, selection);
            if (INCLUDE_SUB_TAGS_OF.contains(tag.getLocalName())) {
                XmlElementDescriptor[] subTagDescriptors;
                for (XmlElementDescriptor descriptor : subTagDescriptors = elementDescriptor.getElementsDescriptors(tag)) {
                    String subTagName = descriptor.getName();
                    if (subTagName.equals("CustomAttribute")) continue;
                    Table<String, String, NlPropertyItem> subTagProperties = this.loadFromStyleableName(subTagName, localAttrDefs, model2, selection);
                    allProperties.put(subTagName, (PropertiesTable<NlPropertyItem>)PropertiesTable.Companion.create(subTagProperties));
                }
            }
        } else if (selection.getType() == MotionEditorSelector.Type.CONSTRAINT) {
            Table<String, String, NlPropertyItem> constraintProperties = this.loadFromStyleableName("Constraint", localAttrDefs, model2, selection);
            NlPropertyItem id2 = MotionLayoutPropertyProvider.createProperty("http://schemas.android.com/apk/res/android", "id", null, model2, selection, null);
            constraintProperties.put((Object)id2.getNamespace(), (Object)id2.getName(), (Object)id2);
            allProperties.put("Constraint", (PropertiesTable<NlPropertyItem>)PropertiesTable.Companion.create(constraintProperties));
            MotionLayoutPropertyProvider.loadCustomAttributes(model2, allProperties, null, selection);
        }
        return allProperties;
    }

    private static void loadCustomAttributes(@NotNull NlPropertiesModel model2, @NotNull Map<String, PropertiesTable<NlPropertyItem>> allProperties, @Nullable MotionSceneTag motionSceneTag, @NotNull MotionSelection selection) {
        MTag[] customTags = motionSceneTag != null ? motionSceneTag.getChildTags("CustomAttribute") : new MTag[]{};
        List<MotionAttributes.DefinedAttribute> inheritedAttributes = Collections.emptyList();
        MotionAttributes attributes = selection.getMotionAttributes();
        if (attributes != null) {
            inheritedAttributes = attributes.getAttrMap().values().stream().filter(defined -> defined.isCustomAttribute()).collect(Collectors.toList());
        }
        if (customTags.length == 0 && inheritedAttributes.isEmpty()) {
            return;
        }
        HashBasedTable customProperties = HashBasedTable.create((int)3, (int)customTags.length);
        block0: for (MTag customTag : customTags) {
            String name = customTag.getAttributeValue("attributeName");
            if (name == null) continue;
            for (String customType : MotionSceneAttrs.ourCustomAttribute) {
                String customValue = customTag.getAttributeValue(customType);
                if (customValue == null) continue;
                NlPropertyItem item = MotionLayoutPropertyProvider.createCustomProperty(name, customType, selection, model2);
                customProperties.put((Object)item.getNamespace(), (Object)item.getName(), (Object)item);
                continue block0;
            }
        }
        inheritedAttributes.forEach(arg_0 -> MotionLayoutPropertyProvider.lambda$loadCustomAttributes$1(selection, model2, (Table)customProperties, arg_0));
        allProperties.put("CustomAttribute", (PropertiesTable<NlPropertyItem>)PropertiesTable.Companion.create((Table)customProperties));
    }

    private Table<String, String, NlPropertyItem> loadFromStyleableName(@NotNull String subTagName, @NotNull AttributeDefinitions attrDefs, @NotNull NlPropertiesModel model2, @NotNull MotionSelection selection) {
        ResourceReference reference2 = new ResourceReference(ResourceNamespace.TODO(), ResourceType.STYLEABLE, subTagName);
        StyleableDefinition styleable = attrDefs.getStyleableDefinition(reference2);
        if (styleable == null) {
            return this.myEmptyTable;
        }
        HashBasedTable properties2 = HashBasedTable.create((int)3, (int)styleable.getAttributes().size());
        styleable.getAttributes().forEach(arg_0 -> MotionLayoutPropertyProvider.lambda$loadFromStyleableName$2(model2, selection, subTagName, (Table)properties2, arg_0));
        return properties2;
    }

    public static NlPropertyItem createCustomProperty(@NotNull String name, @NotNull String customType, @NotNull MotionSelection selection, @NotNull NlPropertiesModel model2) {
        NlPropertyType type = MotionLayoutPropertyProvider.mapFromCustomType(customType);
        List<? extends NlComponent> components = selection.getComponents();
        return new NlPropertyItem("", name, type, null, "", "", model2, components, selection, "CustomAttribute");
    }

    private static NlPropertyItem createProperty(@NotNull String namespace, @NotNull String name, @Nullable AttributeDefinition attr2, @NotNull NlPropertiesModel model2, @NotNull MotionSelection selection, @Nullable String subTag) {
        List<? extends NlComponent> components = selection.getComponents();
        NlPropertyType type = TypeResolver.INSTANCE.resolveType(name, attr2, null);
        String libraryName = StringUtil.notNullize((String)(attr2 != null ? attr2.getLibraryName() : null));
        if (namespace.equals("http://schemas.android.com/apk/res/android") && name.equals("id")) {
            return new MotionIdPropertyItem(model2, attr2, "", components, selection, subTag);
        }
        if (attr2 != null && attr2.getFormats().contains(AttributeFormat.FLAGS) && attr2.getValues().length == 0) {
            return new NlFlagsPropertyItem(namespace, name, type, attr2, "", libraryName, model2, components, selection, subTag);
        }
        return new NlPropertyItem(namespace, name, type, attr2, "", libraryName, model2, components, selection, subTag);
    }

    @NotNull
    private static String getNamespace(@NotNull XmlAttributeDescriptor descriptor, @NotNull XmlTag context) {
        String namespace = null;
        if (descriptor instanceof NamespaceAwareXmlAttributeDescriptor) {
            namespace = ((NamespaceAwareXmlAttributeDescriptor)descriptor).getNamespace(context);
        }
        return namespace != null ? namespace : "http://schemas.android.com/apk/res/android";
    }

    @NotNull
    static NlPropertyType mapFromCustomType(@NotNull String customType) {
        switch (customType) {
            case "customColorValue": {
                return NlPropertyType.COLOR;
            }
            case "customColorDrawableValue": {
                return NlPropertyType.COLOR_STATE_LIST;
            }
            case "customIntegerValue": {
                return NlPropertyType.INTEGER;
            }
            case "customFloatValue": {
                return NlPropertyType.FLOAT;
            }
            case "customDimension": {
                return NlPropertyType.DIMENSION;
            }
            case "customPixelDimension": {
                return NlPropertyType.DIMENSION_PIXEL;
            }
            case "customBoolean": {
                return NlPropertyType.BOOLEAN;
            }
        }
        return NlPropertyType.STRING;
    }

    @NotNull
    static String mapToCustomType(@NotNull NlPropertyType type) {
        switch (type) {
            case COLOR: {
                return "customColorValue";
            }
            case COLOR_STATE_LIST: {
                return "customColorDrawableValue";
            }
            case INTEGER: {
                return "customIntegerValue";
            }
            case FLOAT: {
                return "customFloatValue";
            }
            case DIMENSION: {
                return "customDimension";
            }
            case DIMENSION_PIXEL: {
                return "customPixelDimension";
            }
            case BOOLEAN: {
                return "customBoolean";
            }
        }
        return "customStringValue";
    }

    private static /* synthetic */ void lambda$loadFromStyleableName$2(NlPropertiesModel model2, MotionSelection selection, String subTagName, Table properties2, AttributeDefinition attr2) {
        NlPropertyItem property = MotionLayoutPropertyProvider.createProperty(attr2.getResourceReference().getNamespace().getXmlNamespaceUri(), attr2.getName(), attr2, model2, selection, subTagName);
        properties2.put((Object)property.getNamespace(), (Object)property.getName(), (Object)property);
    }

    private static /* synthetic */ void lambda$loadCustomAttributes$1(MotionSelection selection, NlPropertiesModel model2, Table customProperties, MotionAttributes.DefinedAttribute defined) {
        NlPropertyItem item = MotionLayoutPropertyProvider.createCustomProperty(defined.getName(), defined.getCustomType(), selection, model2);
        customProperties.put((Object)item.getNamespace(), (Object)item.getName(), (Object)item);
    }
}

