/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.utils;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.FileImageOutputStream;
import javax.imageio.stream.ImageOutputStream;
import org.w3c.dom.Node;

public class GifWriter {
    private File mFile;
    private int mTimeBetweenFramesMS;
    private boolean mLoopContinuously;
    private String comment;
    private ImageWriter mGifWriter;
    private IIOMetadata mImageMetaData;
    private ImageWriteParam mImageWriteParam;
    private ImageOutputStream mOutputStream;

    public GifWriter(File file2, int timeBetweenFramesMS, boolean loopContinuously, String comment) {
        this.mFile = file2;
        this.mTimeBetweenFramesMS = timeBetweenFramesMS;
        this.mLoopContinuously = loopContinuously;
        this.comment = comment;
    }

    public void addImage(BufferedImage img) throws IOException {
        if (this.mGifWriter == null) {
            this.setup(img.getType());
        }
        this.mGifWriter.writeToSequence(new IIOImage(img, null, this.mImageMetaData), this.mImageWriteParam);
    }

    private void setup(int bufferedImageType) throws IOException {
        this.mOutputStream = new FileImageOutputStream(this.mFile);
        Iterator<ImageWriter> iter = ImageIO.getImageWritersBySuffix("gif");
        if (!iter.hasNext()) {
            throw new IOException("NO GIF writer");
        }
        this.mGifWriter = iter.next();
        this.mImageWriteParam = this.mGifWriter.getDefaultWriteParam();
        ImageTypeSpecifier imageTypeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(bufferedImageType);
        this.mImageMetaData = this.mGifWriter.getDefaultImageMetadata(imageTypeSpecifier, this.mImageWriteParam);
        String metaFormatName = this.mImageMetaData.getNativeMetadataFormatName();
        IIOMetadataNode root = (IIOMetadataNode)this.mImageMetaData.getAsTree(metaFormatName);
        String CONTROL_EXTENSION = "GraphicControlExtension";
        String COMMENT_EXTENSION = "CommentExtensions";
        String APP_EXTENSION = "ApplicationExtensions";
        IIOMetadataNode meta = null;
        IIOMetadataNode commentsNode = null;
        IIOMetadataNode appEntensionsNode = null;
        for (int i = 0; i < root.getLength(); ++i) {
            Node item = root.item(i);
            String nodeName = root.item(i).getNodeName();
            if (nodeName.equalsIgnoreCase(CONTROL_EXTENSION)) {
                meta = (IIOMetadataNode)item;
                continue;
            }
            if (nodeName.equalsIgnoreCase(COMMENT_EXTENSION)) {
                commentsNode = (IIOMetadataNode)item;
                continue;
            }
            if (!nodeName.equalsIgnoreCase(APP_EXTENSION)) continue;
            appEntensionsNode = (IIOMetadataNode)item;
        }
        if (meta == null) {
            meta = new IIOMetadataNode(CONTROL_EXTENSION);
            root.appendChild(meta);
        }
        meta.setAttribute("disposalMethod", "none");
        meta.setAttribute("userInputFlag", "FALSE");
        meta.setAttribute("transparentColorFlag", "FALSE");
        meta.setAttribute("delayTime", Integer.toString(this.mTimeBetweenFramesMS / 10));
        meta.setAttribute("transparentColorIndex", "0");
        if (commentsNode == null) {
            commentsNode = new IIOMetadataNode(COMMENT_EXTENSION);
            root.appendChild(commentsNode);
        }
        IIOMetadataNode c1 = new IIOMetadataNode("CommentExtension");
        c1.setAttribute("value", this.comment);
        commentsNode.appendChild(c1);
        if (appEntensionsNode == null) {
            appEntensionsNode = new IIOMetadataNode(APP_EXTENSION);
            root.appendChild(appEntensionsNode);
        }
        IIOMetadataNode appNode = new IIOMetadataNode("ApplicationExtension");
        appNode.setAttribute("applicationID", "NETSCAPE");
        appNode.setAttribute("authenticationCode", "2.0");
        boolean loop = !this.mLoopContinuously;
        appNode.setUserObject(new byte[]{1, (byte)(loop ? 1 : 0), 0});
        appEntensionsNode.appendChild(appNode);
        this.mImageMetaData.setFromTree(metaFormatName, root);
        this.mGifWriter.setOutput(this.mOutputStream);
        this.mGifWriter.prepareWriteSequence(null);
    }

    public void close() throws IOException {
        this.mGifWriter.endWriteSequence();
        this.mOutputStream.close();
        this.mGifWriter = null;
    }
}

