/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.utils;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEScenePicker;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MEUI;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.awt.geom.GeneralPath;
import java.awt.geom.Path2D;

public class Drawing {
    private static final boolean DEBUG = false;
    public static Stroke sDashedStroke = new BasicStroke(1.0f, 0, 2, 0.0f, new float[]{MEUI.scale(2)}, 0.0f);

    public static void drawRound(GeneralPath path, int[] xPoints, int[] yPoints, int length, int archLen) {
        int[] arches = new int[xPoints.length - 1];
        for (int i = 0; i < arches.length; ++i) {
            arches[i] = archLen;
        }
        Drawing.drawRound(path, xPoints, yPoints, length, arches);
    }

    public static void drawPick(MEScenePicker pick, Object obj, int[] xPoints, int[] yPoints, int length, int archLen) {
        int[] arches = new int[xPoints.length - 1];
        for (int i = 0; i < arches.length; ++i) {
            arches[i] = archLen;
        }
        Drawing.pickRound(pick, obj, xPoints, yPoints, length, arches);
    }

    public static void pickRound(MEScenePicker pick, Object obj, int[] xPoints, int[] yPoints, int length, int[] arches) {
        int p;
        int lastx = xPoints[0];
        int lasty = yPoints[0];
        for (p = 1; p < length - 1; ++p) {
            int dir0;
            int d0x = xPoints[p] - lastx;
            int d0y = yPoints[p] - lasty;
            int d1x = xPoints[p + 1] - xPoints[p];
            int d1y = yPoints[p + 1] - yPoints[p];
            int len0 = Math.abs(d0x) + Math.abs(d0y);
            int len1 = Math.abs(d1x) + Math.abs(d1y);
            int d0xs = Integer.signum(d0x);
            int d0ys = Integer.signum(d0y);
            int d1xs = Integer.signum(d1x);
            int d1ys = Integer.signum(d1y);
            int useArch = Math.min(len0 - 2, Math.min(len1 / 2 - 2, arches[p - 1]));
            if (useArch < 2) {
                pick.addLine(obj, 4, lastx, lasty, xPoints[p], yPoints[p], 4);
                lastx = xPoints[p];
                lasty = yPoints[p];
                continue;
            }
            pick.addLine(obj, 4, lastx, lasty, xPoints[p] - useArch * d0xs, yPoints[p] - useArch * d0ys, 4);
            lastx = xPoints[p] + useArch * d1xs;
            lasty = yPoints[p] + useArch * d1ys;
            int n = d0xs == 0 ? (d0ys < 1 ? 0 : 2) : (dir0 = d0xs > 0 ? 1 : 3);
            int dir1 = d1xs == 0 ? (d1ys < 1 ? 0 : 2) : (d1xs > 0 ? 1 : 3);
            int rot = (4 + dir1 - dir0) % 4;
            boolean dir = rot == 1;
            Drawing.pickArc(pick, obj, xPoints[p] - useArch * d0xs, yPoints[p] - useArch * d0ys, lastx, lasty, useArch, useArch, 0.0f, false, dir);
            pick.addLine(obj, 4, lastx, lasty, xPoints[p] - useArch * d0xs, yPoints[p] - useArch * d0ys, 4);
        }
        pick.addLine(obj, 4, lastx, lasty, xPoints[p], yPoints[p], 4);
    }

    private static void pickArc(MEScenePicker pick, Object obj, float x0, float y0, float x1, float y1, float a, float b, float theta, boolean isMoreThanHalf, boolean isPositiveArc) {
        double cy;
        double cx;
        double thetaD = (double)theta * Math.PI / 180.0;
        double cosTheta = Math.cos(thetaD);
        double sinTheta = Math.sin(thetaD);
        double x0p = ((double)x0 * cosTheta + (double)y0 * sinTheta) / (double)a;
        double y0p = ((double)(-x0) * sinTheta + (double)y0 * cosTheta) / (double)b;
        double x1p = ((double)x1 * cosTheta + (double)y1 * sinTheta) / (double)a;
        double y1p = ((double)(-x1) * sinTheta + (double)y1 * cosTheta) / (double)b;
        double dx = x0p - x1p;
        double dy = y0p - y1p;
        double xm = (x0p + x1p) / 2.0;
        double ym = (y0p + y1p) / 2.0;
        double dsq = dx * dx + dy * dy;
        if (dsq == 0.0) {
            return;
        }
        double disc = 1.0 / dsq - 0.25;
        if (disc < 0.0) {
            float adjust = (float)(Math.sqrt(dsq) / 1.99999);
            Drawing.pickArc(pick, obj, x0, y0, x1, y1, a * adjust, b * adjust, theta, isMoreThanHalf, isPositiveArc);
            return;
        }
        double s = Math.sqrt(disc);
        double sdx = s * dx;
        double sdy = s * dy;
        if (isMoreThanHalf == isPositiveArc) {
            cx = xm - sdy;
            cy = ym + sdx;
        } else {
            cx = xm + sdy;
            cy = ym - sdx;
        }
        double eta0 = Math.atan2(y0p - cy, x0p - cx);
        double eta1 = Math.atan2(y1p - cy, x1p - cx);
        double sweep = eta1 - eta0;
        if (isPositiveArc != sweep >= 0.0) {
            sweep = sweep > 0.0 ? (sweep -= Math.PI * 2) : (sweep += Math.PI * 2);
        }
        double tcx = cx *= (double)a;
        cx = cx * cosTheta - (cy *= (double)b) * sinTheta;
        cy = tcx * sinTheta + cy * cosTheta;
        Drawing.pickArcToBezier(pick, obj, cx, cy, a, b, x0, y0, thetaD, eta0, sweep);
    }

    private static void pickArcToBezier(MEScenePicker pick, Object obj, double cx, double cy, double a, double b, double e1x, double e1y, double theta, double start, double sweep) {
        int numSegments = Math.abs((int)Math.ceil(sweep * 4.0 / Math.PI));
        double eta1 = start;
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double cosEta1 = Math.cos(eta1);
        double sinEta1 = Math.sin(eta1);
        double ep1x = -a * cosTheta * sinEta1 - b * sinTheta * cosEta1;
        double ep1y = -a * sinTheta * sinEta1 + b * cosTheta * cosEta1;
        double anglePerSegment = sweep / (double)numSegments;
        for (int i = 0; i < numSegments; ++i) {
            double eta2 = eta1 + anglePerSegment;
            double sinEta2 = Math.sin(eta2);
            double cosEta2 = Math.cos(eta2);
            double e2x = cx + a * cosTheta * cosEta2 - b * sinTheta * sinEta2;
            double e2y = cy + a * sinTheta * cosEta2 + b * cosTheta * sinEta2;
            double ep2x = -a * cosTheta * sinEta2 - b * sinTheta * cosEta2;
            double ep2y = -a * sinTheta * sinEta2 + b * cosTheta * cosEta2;
            double tanDiff2 = Math.tan((eta2 - eta1) / 2.0);
            double alpha = Math.sin(eta2 - eta1) * (Math.sqrt(4.0 + 3.0 * tanDiff2 * tanDiff2) - 1.0) / 3.0;
            double q1x = e1x + alpha * ep1x;
            double q1y = e1y + alpha * ep1y;
            double q2x = e2x - alpha * ep2x;
            double q2y = e2y - alpha * ep2y;
            pick.addCurveTo(obj, 4, (int)e1x, (int)e1y, (int)q1x, (int)q1y, (int)q2x, (int)q2y, (int)e2x, (int)e2y, 4);
            eta1 = eta2;
            e1x = e2x;
            e1y = e2y;
            ep1x = ep2x;
            ep1y = ep2y;
        }
    }

    public static void drawRound(GeneralPath path, int[] xPoints, int[] yPoints, int length, int[] arches) {
        int p;
        int lastx = xPoints[0];
        int lasty = yPoints[0];
        for (p = 1; p < length - 1; ++p) {
            int dir0;
            int d0x = xPoints[p] - lastx;
            int d0y = yPoints[p] - lasty;
            int d1x = xPoints[p + 1] - xPoints[p];
            int d1y = yPoints[p + 1] - yPoints[p];
            int len0 = Math.abs(d0x) + Math.abs(d0y);
            int len1 = Math.abs(d1x) + Math.abs(d1y);
            int d0xs = Integer.signum(d0x);
            int d0ys = Integer.signum(d0y);
            int d1xs = Integer.signum(d1x);
            int d1ys = Integer.signum(d1y);
            int useArch = Math.min(len0 - 2, Math.min(len1 / 2 - 2, arches[p - 1]));
            if (useArch < 2) {
                path.lineTo(xPoints[p], yPoints[p]);
                lastx = xPoints[p];
                lasty = yPoints[p];
                continue;
            }
            path.lineTo(xPoints[p] - useArch * d0xs, yPoints[p] - useArch * d0ys);
            lastx = xPoints[p] + useArch * d1xs;
            lasty = yPoints[p] + useArch * d1ys;
            int n = d0xs == 0 ? (d0ys < 1 ? 0 : 2) : (dir0 = d0xs > 0 ? 1 : 3);
            int dir1 = d1xs == 0 ? (d1ys < 1 ? 0 : 2) : (d1xs > 0 ? 1 : 3);
            int rot = (4 + dir1 - dir0) % 4;
            boolean dir = rot == 1;
            Drawing.drawArc(path, xPoints[p] - useArch * d0xs, yPoints[p] - useArch * d0ys, lastx, lasty, useArch, useArch, 0.0f, false, dir);
            path.lineTo(lastx, lasty);
        }
        path.lineTo(xPoints[p], yPoints[p]);
    }

    private static void drawArc(Path2D p, float x0, float y0, float x1, float y1, float a, float b, float theta, boolean isMoreThanHalf, boolean isPositiveArc) {
        double cy;
        double cx;
        double thetaD = (double)theta * Math.PI / 180.0;
        double cosTheta = Math.cos(thetaD);
        double sinTheta = Math.sin(thetaD);
        double x0p = ((double)x0 * cosTheta + (double)y0 * sinTheta) / (double)a;
        double y0p = ((double)(-x0) * sinTheta + (double)y0 * cosTheta) / (double)b;
        double x1p = ((double)x1 * cosTheta + (double)y1 * sinTheta) / (double)a;
        double y1p = ((double)(-x1) * sinTheta + (double)y1 * cosTheta) / (double)b;
        double dx = x0p - x1p;
        double dy = y0p - y1p;
        double xm = (x0p + x1p) / 2.0;
        double ym = (y0p + y1p) / 2.0;
        double dsq = dx * dx + dy * dy;
        if (dsq == 0.0) {
            return;
        }
        double disc = 1.0 / dsq - 0.25;
        if (disc < 0.0) {
            float adjust = (float)(Math.sqrt(dsq) / 1.99999);
            Drawing.drawArc(p, x0, y0, x1, y1, a * adjust, b * adjust, theta, isMoreThanHalf, isPositiveArc);
            return;
        }
        double s = Math.sqrt(disc);
        double sdx = s * dx;
        double sdy = s * dy;
        if (isMoreThanHalf == isPositiveArc) {
            cx = xm - sdy;
            cy = ym + sdx;
        } else {
            cx = xm + sdy;
            cy = ym - sdx;
        }
        double eta0 = Math.atan2(y0p - cy, x0p - cx);
        double eta1 = Math.atan2(y1p - cy, x1p - cx);
        double sweep = eta1 - eta0;
        if (isPositiveArc != sweep >= 0.0) {
            sweep = sweep > 0.0 ? (sweep -= Math.PI * 2) : (sweep += Math.PI * 2);
        }
        double tcx = cx *= (double)a;
        cx = cx * cosTheta - (cy *= (double)b) * sinTheta;
        cy = tcx * sinTheta + cy * cosTheta;
        Drawing.arcToBezier(p, cx, cy, a, b, x0, y0, thetaD, eta0, sweep);
    }

    private static void arcToBezier(Path2D p, double cx, double cy, double a, double b, double e1x, double e1y, double theta, double start, double sweep) {
        int numSegments = Math.abs((int)Math.ceil(sweep * 4.0 / Math.PI));
        double eta1 = start;
        double cosTheta = Math.cos(theta);
        double sinTheta = Math.sin(theta);
        double cosEta1 = Math.cos(eta1);
        double sinEta1 = Math.sin(eta1);
        double ep1x = -a * cosTheta * sinEta1 - b * sinTheta * cosEta1;
        double ep1y = -a * sinTheta * sinEta1 + b * cosTheta * cosEta1;
        double anglePerSegment = sweep / (double)numSegments;
        for (int i = 0; i < numSegments; ++i) {
            double eta2 = eta1 + anglePerSegment;
            double sinEta2 = Math.sin(eta2);
            double cosEta2 = Math.cos(eta2);
            double e2x = cx + a * cosTheta * cosEta2 - b * sinTheta * sinEta2;
            double e2y = cy + a * sinTheta * cosEta2 + b * cosTheta * sinEta2;
            double ep2x = -a * cosTheta * sinEta2 - b * sinTheta * cosEta2;
            double ep2y = -a * sinTheta * sinEta2 + b * cosTheta * cosEta2;
            double tanDiff2 = Math.tan((eta2 - eta1) / 2.0);
            double alpha = Math.sin(eta2 - eta1) * (Math.sqrt(4.0 + 3.0 * tanDiff2 * tanDiff2) - 1.0) / 3.0;
            double q1x = e1x + alpha * ep1x;
            double q1y = e1y + alpha * ep1y;
            double q2x = e2x - alpha * ep2x;
            double q2y = e2y - alpha * ep2y;
            p.curveTo((float)q1x, (float)q1y, (float)q2x, (float)q2y, (float)e2x, (float)e2y);
            eta1 = eta2;
            e1x = e2x;
            e1y = e2y;
            ep1x = ep2x;
            ep1y = ep2y;
        }
    }
}

