/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.ui;

import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MotionSceneAttrs;
import java.util.ArrayList;
import java.util.HashMap;

public class ConstraintSetPanelCommands {
    private static final boolean DEBUG = false;

    public static void createAllConstraints(ArrayList<MTag> displayedRows, MTag constraintSet) {
        ArrayList<MTag> tagList = new ArrayList<MTag>();
        for (MTag row : displayedRows) {
            if (constraintSet.equals(row.getParent())) continue;
            tagList.add(row);
        }
        ConstraintSetPanelCommands.createConstraint(tagList.toArray(new MTag[0]), constraintSet);
    }

    public static void createConstraint(MTag[] selected, MTag constraintSet) {
        for (MTag mTag : selected) {
            ConstraintSetPanelCommands.createConstraint(mTag, constraintSet);
        }
    }

    public static MTag createConstraint(MTag selected, MTag constraintSet) {
        String id2 = selected.getAttributeValue("id");
        MTag.TagWriter new_constraint = constraintSet.getChildTagWriter("Constraint");
        new_constraint.setAttribute("android", "id", id2);
        HashMap<String, MTag.Attribute> list = selected.getAttrList();
        for (String type : list.keySet()) {
            MTag.Attribute attr2 = list.get(type);
            if (!MotionSceneAttrs.copyToConstraint(attr2)) continue;
            new_constraint.setAttribute(MotionSceneAttrs.lookupName(attr2), attr2.mAttribute, attr2.mValue);
        }
        return new_constraint.commit("Create Constraint");
    }

    public static void createSectionedConstraint(MTag[] selected, MTag constraintSet) {
        for (MTag mTag : selected) {
            ConstraintSetPanelCommands.createSectionedConstraint(mTag, constraintSet);
        }
    }

    public static MTag createSectionedConstraint(MTag selected, MTag constraintSet) {
        String id2 = selected.getAttributeValue("id");
        MTag.TagWriter new_constraint = constraintSet.getChildTagWriter("Constraint");
        new_constraint.setAttribute("android", "id", id2);
        HashMap<String, MTag.Attribute> list = selected.getAttrList();
        MTag.TagWriter layout2 = null;
        MTag.TagWriter propertySet = null;
        MTag.TagWriter transform = null;
        for (String type : list.keySet()) {
            MTag.Attribute attr2 = list.get(type);
            if (MotionSceneAttrs.isLayoutAttribute(attr2)) {
                if (layout2 == null) {
                    layout2 = new_constraint.getChildTagWriter("Layout");
                }
                layout2.setAttribute(MotionSceneAttrs.lookupName(attr2), attr2.mAttribute, attr2.mValue);
            }
            if (MotionSceneAttrs.isPropertySetAttribute(attr2)) {
                if (propertySet == null) {
                    propertySet = new_constraint.getChildTagWriter("PropertySet");
                }
                propertySet.setAttribute(MotionSceneAttrs.lookupName(attr2), attr2.mAttribute, attr2.mValue);
            }
            if (!MotionSceneAttrs.isTransformAttribute(attr2)) continue;
            if (transform == null) {
                transform = new_constraint.getChildTagWriter("Transform");
            }
            transform.setAttribute(MotionSceneAttrs.lookupName(attr2), attr2.mAttribute, attr2.mValue);
        }
        return new_constraint.commit("Create Constraint");
    }

    public static void clearConstraint(MTag selected, MTag ConstraintSet2) {
        selected.getTagWriter().deleteTag().commit("clear Constraint");
    }

    public static void moveConstraint(MTag selected, MTag ConstraintSet2) {
    }

    public static void convertFromSectioned(MTag selected, MTag ConstraintSet2) {
        MTag[] child = selected.getChildTags();
        MTag.TagWriter writer = selected.getTagWriter();
        for (int i = 0; i < child.length; ++i) {
            MTag mTag = child[i];
            HashMap<String, MTag.Attribute> attrs = mTag.getAttrList();
            for (MTag.Attribute value2 : attrs.values()) {
                writer.setAttribute(value2.mNamespace, value2.mAttribute, value2.mValue);
            }
            selected.getTagWriter().deleteTag().commit("convert");
        }
        writer.commit("Convert Constraint");
    }
}

