/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion.editor.targets;

import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentHelper;
import com.android.tools.idea.uibuilder.handlers.motion.MotionUtils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.Utils;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class MotionLayoutResizeBaseTarget
extends ResizeBaseTarget {
    public MotionLayoutResizeBaseTarget(@NotNull ResizeBaseTarget.Type type) {
        super(type);
    }

    @Override
    protected abstract void updateAttributes(@NotNull NlAttributesHolder var1, int var2, int var3);

    protected abstract void updateAttributes(@NotNull MTag.TagWriter var1, int var2, int var3);

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTargets, @NotNull SceneContext ignored) {
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        MotionLayoutComponentHelper motionLayout = MotionLayoutComponentHelper.create(this.myComponent.getNlComponent().getParent());
        if (!motionLayout.isInTransition()) {
            ComponentModification modification = new ComponentModification(component, "Resize " + StringUtil.getShortName((String)component.getTagName()));
            this.updateAttributes(modification, x, y);
            modification.apply();
            this.myComponent.getScene().markNeedsLayout(1);
        }
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        MotionLayoutComponentHelper motionLayout = MotionLayoutComponentHelper.create(this.myComponent.getNlComponent().getParent());
        if (!motionLayout.isInTransition()) {
            if (MotionUtils.isInBaseState(motionLayout)) {
                NlComponent component = this.myComponent.getAuthoritativeNlComponent();
                ComponentModification modification = new ComponentModification(component, "Resize " + StringUtil.getShortName((String)component.getTagName()));
                this.updateAttributes(modification, x, y);
                modification.commit();
            } else {
                String state = motionLayout.getState();
                MotionSceneTag motionScene = MotionUtils.getMotionScene(this.myComponent.getNlComponent());
                MTag[] cSet = motionScene.getChildTags("ConstraintSet");
                for (int i = 0; i < cSet.length; ++i) {
                    MTag set = cSet[i];
                    String id2 = set.getAttributeValue("id");
                    if (!(id2 = Utils.stripID(id2)).equalsIgnoreCase(state)) continue;
                    MTag[] constraints = set.getChildTags("Constraint");
                    for (int j = 0; j < constraints.length; ++j) {
                        MTag constraint = constraints[j];
                        String constraintId = constraint.getAttributeValue("id");
                        if (!(constraintId = Utils.stripID(constraintId)).equalsIgnoreCase(Utils.stripID(this.myComponent.getId()))) continue;
                        MTag.TagWriter writer = constraint.getTagWriter();
                        this.updateAttributes(writer, x, y);
                        writer.commit("Resize component");
                    }
                    break;
                }
            }
            this.myComponent.getScene().markNeedsLayout(1);
        }
    }

    @Override
    public void mouseCancel() {
        this.myComponent.setPosition(this.myStartX1, this.myStartY1);
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        AttributesTransaction transaction = component.startAttributeTransaction();
        transaction.rollback();
        component.fireLiveChangeEvent();
        this.myComponent.setDragging(false);
        this.myComponent.getScene().markNeedsLayout(1);
    }
}

