/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.motion;

import com.android.AndroidXConstants;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Placeholder;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.common.scene.target.LassoTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.uibuilder.api.AccessoryPanelInterface;
import com.android.tools.idea.uibuilder.api.CustomPanel;
import com.android.tools.idea.uibuilder.api.ViewGroupHandler;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintLayoutHandler;
import com.android.tools.idea.uibuilder.handlers.constraint.MotionConstraintPanel;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.ConstraintLayoutComponentNotchProvider;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.ConstraintLayoutNotchProvider;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.BarrierAnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.BarrierTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineAnchorTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineCycleTarget;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineTarget;
import com.android.tools.idea.uibuilder.handlers.motion.CommonActions;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentHelper;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutComponentModificationDelegate;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutPlaceholder;
import com.android.tools.idea.uibuilder.handlers.motion.MotionLayoutSceneInteraction;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionAccessoryPanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionAttributePanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneUtils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.targets.MotionLayoutAnchorTarget;
import com.android.tools.idea.uibuilder.handlers.motion.editor.targets.MotionLayoutDragTarget;
import com.android.tools.idea.uibuilder.handlers.motion.editor.targets.MotionLayoutResizeTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.android.tools.idea.uibuilder.surface.AccessoryPanel;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionLayoutHandler
extends ViewGroupHandler {
    private static final boolean DEBUG = false;
    private static HashSet<String> ourHorizontalBarriers = new HashSet<String>(Arrays.asList("top", "bottom"));
    private static String MOTION_ACCESSORY = "MotionLayoutHandler.MotionAccessory";

    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"showPaths");
    }

    @Override
    @NotNull
    public List<Target> createTargets(@NotNull SceneComponent sceneComponent) {
        sceneComponent.setNotchProvider(new ConstraintLayoutNotchProvider());
        return ImmutableList.of((Object)new LassoTarget(), (Object)new MotionLayoutAnchorTarget(AnchorTarget.Type.LEFT, true), (Object)new MotionLayoutAnchorTarget(AnchorTarget.Type.TOP, true), (Object)new MotionLayoutAnchorTarget(AnchorTarget.Type.RIGHT, true), (Object)new MotionLayoutAnchorTarget(AnchorTarget.Type.BOTTOM, true));
    }

    @Override
    @NotNull
    public List<Target> createChildTargets(@NotNull SceneComponent parentComponent, @NotNull SceneComponent childComponent) {
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        NlComponent nlComponent = childComponent.getAuthoritativeNlComponent();
        nlComponent.setComponentModificationDelegate(new MotionLayoutComponentModificationDelegate());
        ViewInfo vi = NlComponentHelperKt.getViewInfo(nlComponent);
        if (vi != null) {
            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, AndroidXConstants.CONSTRAINT_LAYOUT_GUIDELINE)) {
                String orientation2 = nlComponent.getAttribute("http://schemas.android.com/apk/res/android", "orientation");
                boolean isHorizontal = true;
                if (orientation2 != null && orientation2.equalsIgnoreCase("vertical")) {
                    isHorizontal = false;
                }
                listBuilder.add((Object)new GuidelineTarget(isHorizontal)).add((Object)(isHorizontal ? new GuidelineAnchorTarget(AnchorTarget.Type.TOP, true) : new GuidelineAnchorTarget(AnchorTarget.Type.LEFT, false))).add((Object)new GuidelineCycleTarget(isHorizontal));
                return listBuilder.build();
            }
            if (NlComponentHelperKt.isOrHasSuperclass(nlComponent, AndroidXConstants.CONSTRAINT_LAYOUT_BARRIER)) {
                @NonNls String side = nlComponent.getAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection");
                boolean isHorizontal = side == null || ourHorizontalBarriers.contains(side.toLowerCase(Locale.ROOT));
                listBuilder.add((Object)new BarrierAnchorTarget(isHorizontal ? AnchorTarget.Type.TOP : AnchorTarget.Type.RIGHT, BarrierTarget.parseDirection(side))).add((Object)new BarrierTarget(BarrierTarget.parseDirection(side)));
                return listBuilder.build();
            }
        }
        childComponent.setNotchProvider(new ConstraintLayoutComponentNotchProvider());
        listBuilder.add((Object[])new Target[]{new MotionLayoutDragTarget(), new MotionLayoutResizeTarget(ResizeBaseTarget.Type.LEFT_TOP), new MotionLayoutResizeTarget(ResizeBaseTarget.Type.LEFT_BOTTOM), new MotionLayoutResizeTarget(ResizeBaseTarget.Type.RIGHT_TOP), new MotionLayoutResizeTarget(ResizeBaseTarget.Type.RIGHT_BOTTOM), new MotionLayoutAnchorTarget(AnchorTarget.Type.LEFT, false), new MotionLayoutAnchorTarget(AnchorTarget.Type.TOP, false), new MotionLayoutAnchorTarget(AnchorTarget.Type.RIGHT, false), new MotionLayoutAnchorTarget(AnchorTarget.Type.BOTTOM, false)});
        int baseline = NlComponentHelperKt.getBaseline(childComponent.getNlComponent());
        ViewInfo info = NlComponentHelperKt.getViewInfo(childComponent.getNlComponent());
        if (baseline <= 0 && info != null) {
            baseline = info.getBaseLine();
        }
        if (baseline > 0) {
            listBuilder.add((Object)new MotionLayoutAnchorTarget(AnchorTarget.Type.BASELINE, false));
        }
        return listBuilder.build();
    }

    @Override
    public List<Placeholder> getPlaceholders(@NotNull SceneComponent component, @NotNull List<SceneComponent> draggedComponents) {
        return ImmutableList.of((Object)new MotionLayoutPlaceholder(component));
    }

    @Override
    public boolean addPopupMenuActions(@NotNull SceneComponent component, @NotNull List<ViewAction> actions2) {
        CommonActions.getPopupMenuActions(component, actions2);
        return false;
    }

    @Override
    public boolean needsAccessoryPanel(@NotNull AccessoryPanel.Type type) {
        switch (type) {
            case SOUTH_PANEL: 
            case EAST_PANEL: {
                return true;
            }
        }
        return false;
    }

    @Override
    @NotNull
    public AccessoryPanelInterface createAccessoryPanel(@NotNull DesignSurface<?> surface2, @NotNull AccessoryPanel.Type type, @NotNull NlComponent parent, @NotNull ViewGroupHandler.AccessoryPanelVisibility panelVisibility) {
        assert (surface2 instanceof NlDesignSurface) : "MotionLayoutHandler needs an NlDesignSurface";
        switch (type) {
            case SOUTH_PANEL: {
                MotionAccessoryPanel accessoryPanel = new MotionAccessoryPanel((NlDesignSurface)surface2, parent, panelVisibility);
                parent.putClientProperty(MOTION_ACCESSORY, accessoryPanel);
                return accessoryPanel;
            }
            case EAST_PANEL: {
                return new MotionAttributePanel(parent, panelVisibility);
            }
        }
        throw new IllegalArgumentException("Unsupported type");
    }

    @Override
    @Nullable
    public Interaction createInteraction(@NotNull ScreenView screenView, int x, int y, @NotNull NlComponent component) {
        MotionLayoutComponentHelper helper = MotionLayoutComponentHelper.create(component);
        if (helper.isInTransition() && MotionLayoutSceneInteraction.hitKeyFrame(screenView, x, y, helper, component)) {
            return new MotionLayoutSceneInteraction(screenView, component);
        }
        return null;
    }

    @Override
    public void cleanUpAttributes(@NotNull NlComponent component, @NotNull NlAttributesHolder attributes) {
        ConstraintComponentUtilities.cleanup(attributes, component);
    }

    @Override
    public void onChildInserted(@NotNull NlComponent layout2, @NotNull NlComponent newChild, @NotNull InsertType insertType) {
        newChild.ensureId();
        super.onChildInserted(layout2, newChild, insertType);
    }

    @Override
    public void addToolbarActions(@NotNull List<ViewAction> actions2) {
        CommonActions.getToolbarActions(actions2);
    }

    @Override
    @NotNull
    public CustomPanel getLayoutCustomPanel() {
        return new MotionConstraintPanel((List<NlComponent>)ImmutableList.of());
    }

    @Override
    public boolean deleteChildren(@NotNull NlComponent parent, @NotNull Collection<NlComponent> deleted) {
        MotionAccessoryPanel accessoryPanel = (MotionAccessoryPanel)parent.getClientProperty(MOTION_ACCESSORY);
        int count = parent.getChildCount();
        for (int i = 0; i < count; ++i) {
            NlComponent component = parent.getChild(i);
            if (deleted.contains(component)) {
                String id2 = component.getId();
                if (id2 == null || accessoryPanel == null) continue;
                MotionSceneUtils.deleteRelatedConstraintSets(accessoryPanel.getMotionScene(), id2);
                continue;
            }
            ConstraintLayoutHandler.willDelete(component, deleted);
        }
        return false;
    }
}

