/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.coordinator;

import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Placeholder;
import com.android.tools.idea.common.scene.Region;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SnappingInfo;
import com.android.tools.idea.uibuilder.handlers.relative.targets.RelativeUtilitiesKt;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import java.awt.Point;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001!B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 H\u0016R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorPlaceholder;", "Lcom/android/tools/idea/common/scene/Placeholder;", "host", "Lcom/android/tools/idea/common/scene/SceneComponent;", "anchor", "type", "Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorPlaceholder$Type;", "(Lcom/android/tools/idea/common/scene/SceneComponent;Lcom/android/tools/idea/common/scene/SceneComponent;Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorPlaceholder$Type;)V", "associatedComponent", "getAssociatedComponent", "()Lcom/android/tools/idea/common/scene/SceneComponent;", "bottom", "", "left", "region", "Lcom/android/tools/idea/common/scene/Region;", "getRegion", "()Lcom/android/tools/idea/common/scene/Region;", "right", "top", "getAnchorGravity", "", "snap", "", "info", "Lcom/android/tools/idea/common/scene/SnappingInfo;", "retPoint", "Ljava/awt/Point;", "updateAttribute", "", "sceneComponent", "attributes", "Lcom/android/tools/idea/common/model/NlAttributesHolder;", "Type", "intellij.android.designer"})
public final class CoordinatorPlaceholder
extends Placeholder {
    @NotNull
    private final SceneComponent anchor;
    @NotNull
    private final Type type;
    private final int left;
    private final int top;
    private final int right;
    private final int bottom;
    @NotNull
    private final Region region;

    public CoordinatorPlaceholder(@NotNull SceneComponent host, @NotNull SceneComponent anchor, @NotNull Type type) {
        int n;
        int n2;
        Intrinsics.checkNotNullParameter((Object)host, (String)"host");
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        super(host);
        this.anchor = anchor;
        this.type = type;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                n2 = this.anchor.getDrawX();
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                n2 = RelativeUtilitiesKt.getDrawCenterX(this.anchor) - 10;
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                n2 = this.anchor.getDrawX() + this.anchor.getDrawWidth() - 20;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.left = n2;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 1: 
            case 4: 
            case 7: {
                n = this.anchor.getDrawY();
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                n = RelativeUtilitiesKt.getDrawCenterY(this.anchor) - 10;
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                n = this.anchor.getDrawY() + this.anchor.getDrawHeight() - 20;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.top = n;
        this.right = this.left + 20;
        this.bottom = this.top + 20;
        this.region = new Region(this.left, this.top, this.right, this.bottom, this.anchor.getDepth() + 1);
    }

    @Override
    @NotNull
    public SceneComponent getAssociatedComponent() {
        return this.anchor;
    }

    @Override
    public void updateAttribute(@NotNull SceneComponent sceneComponent, @NotNull NlAttributesHolder attributes) {
        Intrinsics.checkNotNullParameter((Object)sceneComponent, (String)"sceneComponent");
        Intrinsics.checkNotNullParameter((Object)attributes, (String)"attributes");
        attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_anchorGravity", this.getAnchorGravity());
        NlComponent nlComponent = this.anchor.getNlComponent();
        Intrinsics.checkNotNullExpressionValue((Object)nlComponent, (String)"anchor.nlComponent");
        attributes.setAttribute("http://schemas.android.com/apk/res-auto", "layout_anchor", "@+id/" + NlComponentHelperKt.ensureLiveId(nlComponent));
    }

    @Override
    @NotNull
    public Region getRegion() {
        return this.region;
    }

    @Override
    public boolean snap(@NotNull SnappingInfo info, @NotNull Point retPoint) {
        Intrinsics.checkNotNullParameter((Object)info, (String)"info");
        Intrinsics.checkNotNullParameter((Object)retPoint, (String)"retPoint");
        if (this.getRegion().contains(info.getCenterX(), info.getCenterY())) {
            retPoint.x = (this.getRegion().getLeft() + this.getRegion().getRight()) / 2 - (info.getRight() - info.getLeft()) / 2;
            retPoint.y = (this.getRegion().getTop() + this.getRegion().getBottom()) / 2 - (info.getBottom() - info.getTop()) / 2;
            return true;
        }
        return false;
    }

    private final String getAnchorGravity() {
        String string;
        switch (WhenMappings.$EnumSwitchMapping$0[this.type.ordinal()]) {
            case 2: {
                string = "start|center";
                break;
            }
            case 8: {
                string = "end|center";
                break;
            }
            case 4: {
                string = "top|center";
                break;
            }
            case 6: {
                string = "bottom|center";
                break;
            }
            case 1: {
                string = "start|top";
                break;
            }
            case 3: {
                string = "start|bottom";
                break;
            }
            case 5: {
                string = "center";
                break;
            }
            case 7: {
                string = "end|top";
                break;
            }
            case 9: {
                string = "end|bottom";
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return string;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u000b\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000b\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/uibuilder/handlers/coordinator/CoordinatorPlaceholder$Type;", "", "(Ljava/lang/String;I)V", "LEFT_TOP", "LEFT", "LEFT_BOTTOM", "TOP", "CENTER", "BOTTOM", "RIGHT_TOP", "RIGHT", "RIGHT_BOTTOM", "intellij.android.designer"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type LEFT_TOP = new Type();
        public static final /* enum */ Type LEFT = new Type();
        public static final /* enum */ Type LEFT_BOTTOM = new Type();
        public static final /* enum */ Type TOP = new Type();
        public static final /* enum */ Type CENTER = new Type();
        public static final /* enum */ Type BOTTOM = new Type();
        public static final /* enum */ Type RIGHT_TOP = new Type();
        public static final /* enum */ Type RIGHT = new Type();
        public static final /* enum */ Type RIGHT_BOTTOM = new Type();
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value2) {
            return Enum.valueOf(Type.class, value2);
        }

        static {
            $VALUES = typeArray = new Type[]{Type.LEFT_TOP, Type.LEFT, Type.LEFT_BOTTOM, Type.TOP, Type.CENTER, Type.BOTTOM, Type.RIGHT_TOP, Type.RIGHT, Type.RIGHT_BOTTOM};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            nArray[Type.LEFT_TOP.ordinal()] = 1;
            nArray[Type.LEFT.ordinal()] = 2;
            nArray[Type.LEFT_BOTTOM.ordinal()] = 3;
            nArray[Type.TOP.ordinal()] = 4;
            nArray[Type.CENTER.ordinal()] = 5;
            nArray[Type.BOTTOM.ordinal()] = 6;
            nArray[Type.RIGHT_TOP.ordinal()] = 7;
            nArray[Type.RIGHT.ordinal()] = 8;
            nArray[Type.RIGHT_BOTTOM.ordinal()] = 9;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

