/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.targets;

import com.android.AndroidXConstants;
import com.android.ide.common.resources.ResourcesUtil;
import com.android.tools.adtui.common.AdtUiUtils;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneComponentHelperKt;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.analytics.NlAnalyticsManager;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.constraint.ConstraintComponentUtilities;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawAnchor;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.GuidelineAnchorTarget;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import com.android.tools.idea.uibuilder.scout.Scout;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.JBMenuItem;
import com.intellij.openapi.ui.JBPopupMenu;
import com.intellij.ui.PopupMenuListenerAdapter;
import icons.StudioIcons;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstraintAnchorTarget
extends AnchorTarget {
    private boolean myRenderingTemporaryConnection = false;
    private int myConnectedX = -1;
    private int myConnectedY = -1;
    private final HashMap<String, String> mPreviousAttributes = new HashMap();

    public ConstraintAnchorTarget(@NotNull AnchorTarget.Type type, boolean isEdge) {
        super(type, isEdge);
    }

    public boolean isHorizontalAnchor() {
        return this.myType == AnchorTarget.Type.LEFT || this.myType == AnchorTarget.Type.RIGHT;
    }

    public boolean isVerticalAnchor() {
        return this.myType == AnchorTarget.Type.TOP || this.myType == AnchorTarget.Type.BOTTOM;
    }

    public boolean isBaselineAnchor() {
        return this.myType == AnchorTarget.Type.BASELINE;
    }

    private boolean isConnected(ConstraintAnchorTarget target) {
        if (target == null) {
            return false;
        }
        if (!this.isConnected()) {
            return false;
        }
        String attribute = null;
        switch (this.myType) {
            case LEFT: {
                attribute = ConstraintComponentUtilities.getConnectionId(this.myComponent.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourLeftAttributes);
                break;
            }
            case RIGHT: {
                attribute = ConstraintComponentUtilities.getConnectionId(this.myComponent.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourRightAttributes);
                break;
            }
            case TOP: {
                attribute = ConstraintComponentUtilities.getConnectionId(this.myComponent.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourTopAttributes);
                break;
            }
            case BOTTOM: {
                attribute = ConstraintComponentUtilities.getConnectionId(this.myComponent.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourBottomAttributes);
                break;
            }
            case BASELINE: {
                attribute = this.myComponent.getAuthoritativeNlComponent().getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf");
                if (attribute == null) break;
                attribute = NlComponent.extractId(attribute);
            }
        }
        if (attribute == null) {
            return false;
        }
        return attribute.equalsIgnoreCase(target.getComponent().getId());
    }

    @Override
    protected boolean isConnected() {
        return ConstraintComponentUtilities.isAnchorConnected(this.myType, this.myComponent.getAuthoritativeNlComponent(), this.useRtlAttributes(), this.isRtl());
    }

    @Override
    public boolean canDisconnect() {
        return this.myComponent.getScene().isCtrlMetaDown();
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (this.myIsEdge) {
            return;
        }
        super.render(list, sceneContext);
        if (!this.myRenderingTemporaryConnection && this.myLastX != -1 && this.myLastY != -1 && (this.myConnectedX == -1 && this.myConnectedY == -1 || this.myLastX != this.myConnectedX || this.myLastY != this.myConnectedY)) {
            float x = this.getCenterX();
            float y = this.getCenterY();
            list.addConnection(sceneContext, x, y, this.myLastX, this.myLastY, this.myType.ordinal());
        }
    }

    @Override
    @VisibleForTesting
    public boolean isEnabled() {
        boolean matchesFilter;
        if (!super.isEnabled()) {
            return false;
        }
        if (this.myComponent.getScene().getSelection().size() > 1) {
            return false;
        }
        if (this.myComponent.isSelected()) {
            boolean hasBaselineConnection = this.isBaselineConnected();
            if (this.getType() == AnchorTarget.Type.BASELINE) {
                return this.myComponent.canShowBaseline() || hasBaselineConnection;
            }
            return !hasBaselineConnection && !this.myComponent.canShowBaseline() || hasBaselineConnection && this.isHorizontalAnchor();
        }
        Scene.FilterType filerType = this.myComponent.getScene().getFilterType();
        switch (filerType) {
            case BASELINE_ANCHOR: {
                matchesFilter = this.isBaselineAnchor();
                break;
            }
            case VERTICAL_ANCHOR: {
                matchesFilter = this.isVerticalAnchor();
                break;
            }
            case HORIZONTAL_ANCHOR: {
                matchesFilter = this.isHorizontalAnchor();
                break;
            }
            case ANCHOR: {
                matchesFilter = true;
                break;
            }
            default: {
                matchesFilter = false;
            }
        }
        Integer state = DecoratorUtilities.getTryingToConnectState(this.myComponent.getNlComponent());
        boolean tryingToConnect = state != null && (state & this.myType.getMask()) != 0 && this.isTargeted();
        return matchesFilter || tryingToConnect;
    }

    @Override
    public boolean isConnectible(@NotNull AnchorTarget dest) {
        if (!(dest instanceof ConstraintAnchorTarget)) {
            return false;
        }
        ConstraintAnchorTarget constraintAnchorDest = (ConstraintAnchorTarget)dest;
        if (this.isVerticalAnchor() && !constraintAnchorDest.isVerticalAnchor()) {
            return false;
        }
        if (this.isHorizontalAnchor() && !constraintAnchorDest.isHorizontalAnchor()) {
            return false;
        }
        if (constraintAnchorDest.isEdge() && !(dest instanceof GuidelineAnchorTarget)) {
            return this.myComponent.getParent() == constraintAnchorDest.myComponent;
        }
        return this.myComponent.getParent() == constraintAnchorDest.myComponent.getParent();
    }

    private boolean isBaselineConnected() {
        return this.myComponent.getAuthoritativeNlComponent().getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
    }

    @Override
    @NotNull
    protected DrawAnchor.Mode getDrawMode() {
        Integer state = DecoratorUtilities.getTryingToConnectState(this.myComponent.getNlComponent());
        boolean can_connect = state != null && (state & this.myType.getMask()) != 0;
        boolean doing_connection = state != null;
        boolean is_connected = this.isConnected();
        int drawState = (can_connect ? 1 : 0) | (this.mIsOver ? 2 : 0) | (is_connected ? 4 : 0) | (doing_connection ? 8 : 0) | (this.myComponent.isSelected() ? 16 : 0);
        DrawAnchor.Mode[] modeTable = new DrawAnchor.Mode[]{DrawAnchor.Mode.DO_NOT_DRAW, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.DO_NOT_DRAW, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.DO_NOT_DRAW, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.DO_NOT_DRAW, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.DO_NOT_DRAW, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.DO_NOT_DRAW, DrawAnchor.Mode.OVER, DrawAnchor.Mode.DO_NOT_DRAW, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.DO_NOT_DRAW, DrawAnchor.Mode.OVER, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.OVER, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.DELETE, DrawAnchor.Mode.OVER, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.OVER, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.NORMAL, DrawAnchor.Mode.OVER};
        return modeTable[drawState];
    }

    private void clearMe(@NotNull NlAttributesHolder transaction) {
        ConstraintComponentUtilities.clearAnchor(this.myType, transaction, this.useRtlAttributes(), this.isRtl());
    }

    private void rememberPreviousAttribute(@NotNull String uri, @NotNull ArrayList<String> attributes) {
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        for (String attribute : attributes) {
            this.mPreviousAttributes.put(attribute, component.getLiveAttribute(uri, attribute));
        }
    }

    private boolean useRtlAttributes() {
        return this.myComponent.useRtlAttributes();
    }

    private boolean isRtl() {
        return this.myComponent.getScene().isInRTL();
    }

    private String getAttribute(@NotNull Target target) {
        if (!(target instanceof ConstraintAnchorTarget)) {
            return null;
        }
        ConstraintAnchorTarget anchorTarget = (ConstraintAnchorTarget)target;
        return ConstraintComponentUtilities.getAttribute(this.myType, anchorTarget.myType, this.useRtlAttributes(), this.isRtl());
    }

    private void revertToPreviousState() {
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        ComponentModification modification = new ComponentModification(component, "Revert");
        modification.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf", null);
        for (String key : this.mPreviousAttributes.keySet()) {
            if (key.equalsIgnoreCase("layout_editor_absoluteX") || key.equalsIgnoreCase("layout_editor_absoluteY")) {
                modification.setAttribute("http://schemas.android.com/tools", key, this.mPreviousAttributes.get(key));
                continue;
            }
            if (key.equalsIgnoreCase("layout_marginTop") || key.equalsIgnoreCase("layout_marginBottom") || key.equalsIgnoreCase("layout_marginLeft") || key.equalsIgnoreCase("layout_marginRight") || key.equalsIgnoreCase("layout_marginStart") || key.equalsIgnoreCase("layout_marginEnd")) {
                modification.setAttribute("http://schemas.android.com/apk/res/android", key, this.mPreviousAttributes.get(key));
                continue;
            }
            modification.setAttribute("http://schemas.android.com/apk/res-auto", key, this.mPreviousAttributes.get(key));
        }
        modification.apply();
        this.myComponent.getScene().markNeedsLayout(2);
    }

    private ComponentModification connectMe(NlComponent component, String attribute, NlComponent targetComponent) {
        String otherSideAttrValue;
        ComponentModification modification = new ComponentModification(component, "Connect Constraint");
        NlComponent parent = component.getParent();
        assert (parent != null);
        if (NlComponentHelperKt.isOrHasSuperclass(parent, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_CONSTRAINTS)) {
            parent = parent.getParent();
        }
        Object targetId = targetComponent == parent ? "parent" : "@+id/" + NlComponentHelperKt.ensureLiveId(targetComponent);
        modification.setAttribute("http://schemas.android.com/apk/res-auto", attribute, (String)targetId);
        if (this.myType == AnchorTarget.Type.BASELINE) {
            ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourTopAttributes, (NlAttributesHolder)modification);
            ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourBottomAttributes, (NlAttributesHolder)modification);
            modification.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
            modification.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
            modification.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
        } else if (ConstraintComponentUtilities.ourReciprocalAttributes.get(attribute) != null) {
            modification.setAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourReciprocalAttributes.get(attribute), null);
        }
        String otherSideAttr = ConstraintComponentUtilities.ourOtherSideAttributes.get(attribute);
        String string = otherSideAttrValue = otherSideAttr != null ? component.getAttribute("http://schemas.android.com/apk/res-auto", otherSideAttr) : null;
        if (ConstraintAnchorTarget.isOppositeSideConnectedToSameTarget((String)targetId, otherSideAttrValue)) {
            this.removeOppositeSideMargin(modification, otherSideAttr);
        } else if (ConstraintComponentUtilities.ourMapMarginAttributes.get(attribute) != null) {
            Scene scene = this.myComponent.getScene();
            int marginValue = this.getDistance(attribute, targetComponent, scene);
            marginValue = !scene.isCtrlMetaDown() ? (marginValue < 0 ? 0 : Scout.getMargin()) : Math.max(marginValue, 0);
            String margin = Scout.getMarginResource() == null ? String.format("%ddp", marginValue) : Scout.getMarginResource();
            String attr2 = ConstraintComponentUtilities.ourMapMarginAttributes.get(attribute);
            modification.setAttribute("http://schemas.android.com/apk/res/android", attr2, margin);
            if ("layout_marginEnd".equals(attr2)) {
                modification.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", margin);
            } else if ("layout_marginStart".equals(attr2)) {
                modification.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", margin);
            }
            scene.needsRebuildList();
            this.myConnectedX = this.myLastX;
            this.myConnectedY = this.myLastY;
        }
        ConstraintComponentUtilities.cleanup(modification, this.myComponent.getNlComponent());
        modification.apply();
        this.myComponent.getScene().markNeedsLayout(2);
        this.myRenderingTemporaryConnection = true;
        return modification;
    }

    private void removeOppositeSideMargin(@NotNull NlAttributesHolder attributes, @NotNull String otherSideAttr) {
        String alternateAttr;
        String otherSideMargin = ConstraintComponentUtilities.ourMapMarginAttributes.get(otherSideAttr);
        if (otherSideMargin == null) {
            return;
        }
        boolean rtl = this.isRtl();
        switch (otherSideMargin) {
            case "layout_marginLeft": {
                alternateAttr = rtl ? "layout_marginEnd" : "layout_marginStart";
                break;
            }
            case "layout_marginRight": {
                alternateAttr = rtl ? "layout_marginStart" : "layout_marginEnd";
                break;
            }
            case "layout_marginStart": {
                alternateAttr = rtl ? "layout_marginRight" : "layout_marginLeft";
                break;
            }
            case "layout_marginEnd": {
                alternateAttr = rtl ? "layout_marginLeft" : "layout_marginRight";
                break;
            }
            default: {
                alternateAttr = null;
            }
        }
        attributes.setAttribute("http://schemas.android.com/apk/res/android", otherSideMargin, null);
        if (alternateAttr != null) {
            attributes.setAttribute("http://schemas.android.com/apk/res/android", alternateAttr, null);
        }
    }

    private static boolean isOppositeSideConnectedToSameTarget(@NotNull String targetId, @Nullable String otherSideAttrValue) {
        return otherSideAttrValue != null && ResourcesUtil.stripPrefixFromId((String)otherSideAttrValue).equals(ResourcesUtil.stripPrefixFromId((String)targetId));
    }

    private int getDistance(String attribute, NlComponent targetComponent, Scene scene) {
        int marginValue;
        ConstraintAnchorTarget targetAnchor = ConstraintComponentUtilities.getTargetAnchor(scene, targetComponent, attribute, this.useRtlAttributes(), this.isRtl());
        if (targetAnchor == null) {
            return 0;
        }
        block0 : switch (this.myType) {
            case LEFT: {
                switch (targetAnchor.getType()) {
                    case LEFT: 
                    case RIGHT: {
                        marginValue = (int)(this.getCenterX() - targetAnchor.getCenterX());
                        break block0;
                    }
                }
                marginValue = 0;
                break;
            }
            case RIGHT: {
                switch (targetAnchor.getType()) {
                    case LEFT: 
                    case RIGHT: {
                        marginValue = (int)(targetAnchor.getCenterX() - this.getCenterX());
                        break block0;
                    }
                }
                marginValue = 0;
                break;
            }
            case TOP: {
                switch (targetAnchor.getType()) {
                    case TOP: 
                    case BOTTOM: {
                        marginValue = (int)(this.getCenterY() - targetAnchor.getCenterY());
                        break block0;
                    }
                }
                marginValue = 0;
                break;
            }
            case BOTTOM: {
                switch (targetAnchor.getType()) {
                    case TOP: 
                    case BOTTOM: {
                        marginValue = (int)(targetAnchor.getCenterY() - this.getCenterY());
                        break block0;
                    }
                }
                marginValue = 0;
                break;
            }
            default: {
                marginValue = 0;
            }
        }
        return marginValue;
    }

    private void disconnectMe(NlComponent component) {
        ComponentModification modification = new ComponentModification(component, "Constraint Disconnected");
        this.clearMe(modification);
        ConstraintComponentUtilities.cleanup(modification, this.myComponent.getNlComponent());
        modification.commit();
        ConstraintAnchorTarget.logConstraintDisconnected(this.myComponent);
        this.myComponent.getScene().markNeedsLayout(2);
    }

    @Override
    public int getPreferenceLevel() {
        return 70;
    }

    @Override
    public void mouseDown(int x, int y) {
        super.mouseDown(x, y);
        Scene scene = this.myComponent.getScene();
        if (this.isHorizontalAnchor()) {
            scene.setFilterType(Scene.FilterType.HORIZONTAL_ANCHOR);
        } else {
            scene.setFilterType(Scene.FilterType.VERTICAL_ANCHOR);
        }
        if (this.getType() == AnchorTarget.Type.BASELINE) {
            scene.setFilterType(Scene.FilterType.BASELINE_ANCHOR);
        }
        this.myConnectedX = -1;
        this.myConnectedY = -1;
        NlComponent component = this.myComponent.getAuthoritativeNlComponent();
        this.mPreviousAttributes.clear();
        this.mPreviousAttributes.put("layout_editor_absoluteX", component.getLiveAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX"));
        this.mPreviousAttributes.put("layout_editor_absoluteY", component.getLiveAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY"));
        this.mPreviousAttributes.put("layout_constraintBaseline_toBaselineOf", component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf"));
        switch (this.myType) {
            case LEFT: 
            case RIGHT: {
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourLeftAttributes);
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourRightAttributes);
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourStartAttributes);
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourEndAttributes);
                this.mPreviousAttributes.put("layout_marginLeft", component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft"));
                this.mPreviousAttributes.put("layout_marginRight", component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight"));
                this.mPreviousAttributes.put("layout_marginStart", component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart"));
                this.mPreviousAttributes.put("layout_marginEnd", component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd"));
                this.mPreviousAttributes.put("layout_constraintHorizontal_bias", component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias"));
                break;
            }
            case TOP: {
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourTopAttributes);
                this.mPreviousAttributes.put("layout_marginTop", component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop"));
                this.mPreviousAttributes.put("layout_constraintVertical_bias", component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias"));
                break;
            }
            case BOTTOM: {
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourBottomAttributes);
                this.mPreviousAttributes.put("layout_marginBottom", component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom"));
                this.mPreviousAttributes.put("layout_constraintVertical_bias", component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias"));
                break;
            }
            case BASELINE: {
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourTopAttributes);
                this.rememberPreviousAttribute("http://schemas.android.com/apk/res-auto", ConstraintComponentUtilities.ourBottomAttributes);
                this.mPreviousAttributes.put("layout_marginTop", component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop"));
                this.mPreviousAttributes.put("layout_marginBottom", component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom"));
                this.mPreviousAttributes.put("layout_constraintVertical_bias", component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias"));
            }
        }
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> closestTargets, @NotNull SceneContext sceneContext) {
        super.mouseDrag(x, y, closestTargets, sceneContext);
        ConstraintAnchorTarget targetAnchor = this.getClosestConnectibleTarget(closestTargets);
        if (!this.myIsDragging) {
            this.myIsDragging = true;
            DecoratorUtilities.setTryingToConnectState(this.myComponent.getNlComponent(), this.myType, true);
        }
        if (targetAnchor != null) {
            NlComponent component = this.myComponent.getAuthoritativeNlComponent();
            String attribute = this.getAttribute(targetAnchor);
            if (attribute != null && targetAnchor.myComponent != this.myComponent && !targetAnchor.isConnected(this)) {
                if (this.myComponent.getParent() != targetAnchor.myComponent) {
                    Integer state = DecoratorUtilities.getTryingToConnectState(targetAnchor.myComponent.getNlComponent());
                    if (state == null) {
                        return;
                    }
                    int mask = state & targetAnchor.myType.getMask();
                    if (mask == 0) {
                        return;
                    }
                }
                NlComponent targetComponent = targetAnchor.myComponent.getAuthoritativeNlComponent();
                this.connectMe(component, attribute, targetComponent);
                return;
            }
        }
        if (this.myRenderingTemporaryConnection) {
            this.revertToPreviousState();
            this.myRenderingTemporaryConnection = false;
            return;
        }
        this.myComponent.getScene().needsRebuildList();
    }

    @Nullable
    private ConstraintAnchorTarget getClosestConnectibleTarget(@NotNull List<Target> closestTargets) {
        BaseTarget closest = null;
        for (Target target : closestTargets) {
            ConstraintAnchorTarget anchorTarget;
            if (target == this || !(target instanceof ConstraintAnchorTarget) || !this.isConnectible(anchorTarget = (ConstraintAnchorTarget)target) || closest != null && closest.getComponent().getDepth() >= anchorTarget.getComponent().getDepth()) continue;
            closest = anchorTarget;
        }
        return closest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> closestTargets) {
        super.mouseRelease(x, y, closestTargets);
        try {
            ConstraintAnchorTarget closestTarget = this.myComponent.getScene().isCtrlMetaDown() && closestTargets.contains(this) ? this : this.getClosestConnectibleTarget(closestTargets);
            if (closestTarget != null && !closestTarget.isConnected(this)) {
                NlComponent component = this.myComponent.getAuthoritativeNlComponent();
                if (closestTarget == this) {
                    if (this.canDisconnect()) {
                        this.disconnectMe(component);
                    }
                } else {
                    String attribute = this.getAttribute(closestTarget);
                    if (attribute != null) {
                        if (closestTarget.myComponent == this.myComponent) {
                            return;
                        }
                        if (this.myComponent.getParent() != closestTarget.myComponent) {
                            Integer state = DecoratorUtilities.getTryingToConnectState(closestTarget.myComponent.getNlComponent());
                            if (state == null) {
                                return;
                            }
                            int mask = state & closestTarget.myType.getMask();
                            if (mask == 0) {
                                return;
                            }
                        }
                        NlComponent targetComponent = closestTarget.myComponent.getAuthoritativeNlComponent();
                        ComponentModification modification = this.connectMe(component, attribute, targetComponent);
                        modification.commit();
                        ConstraintAnchorTarget.logConstraintConnected(this.myComponent);
                        this.myComponent.getScene().markNeedsLayout(2);
                    }
                }
            } else {
                Collection<SceneComponent> components = this.myComponent.getScene().getSceneComponents();
                Rectangle rectangle = new Rectangle();
                ArrayList<NlComponent> list = new ArrayList<NlComponent>();
                list.add(this.myComponent.getAuthoritativeNlComponent());
                list.add(this.myComponent.getAuthoritativeNlComponent());
                ArrayList<SceneComponent> allItems = new ArrayList<SceneComponent>();
                for (SceneComponent component : components) {
                    rectangle.width = component.getDrawWidth();
                    rectangle.height = component.getDrawHeight();
                    rectangle.x = component.getDrawX();
                    rectangle.y = component.getDrawY();
                    if (!rectangle.contains(x, y) || !SceneComponentHelperKt.isSibling(this.myComponent, component)) continue;
                    allItems.add(component);
                }
                if (!allItems.isEmpty()) {
                    AnchorTarget.Type typeToConnect = this.myType;
                    JBPopupMenu menu = new JBPopupMenu("Connect to:");
                    if (this.isRtl()) {
                        if (typeToConnect == AnchorTarget.Type.LEFT) {
                            typeToConnect = AnchorTarget.Type.RIGHT;
                        } else if (typeToConnect == AnchorTarget.Type.RIGHT) {
                            typeToConnect = AnchorTarget.Type.LEFT;
                        }
                    }
                    for (SceneComponent component : allItems) {
                        list.set(1, component.getAuthoritativeNlComponent());
                        switch (typeToConnect) {
                            case LEFT: {
                                this.addConnectMenu(list, allItems, component, menu, Scout.Connect.ConnectStartToStart, "Start ", " start", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_START_TO_START);
                                this.addConnectMenu(list, allItems, component, menu, Scout.Connect.ConnectStartToEnd, "Start ", " end", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_START_TO_END);
                                break;
                            }
                            case RIGHT: {
                                this.addConnectMenu(list, allItems, component, menu, Scout.Connect.ConnectEndToStart, "End ", " start", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_END_TO_START);
                                this.addConnectMenu(list, allItems, component, menu, Scout.Connect.ConnectEndToEnd, "End ", " end", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_END_TO_END);
                                break;
                            }
                            case TOP: {
                                this.addConnectMenu(list, allItems, component, menu, Scout.Connect.ConnectTopToTop, "Top ", " top", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TOP_TO_TOP);
                                this.addConnectMenu(list, allItems, component, menu, Scout.Connect.ConnectTopToBottom, "Top ", " bottom", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_TOP_TO_BOTTOM);
                                break;
                            }
                            case BOTTOM: {
                                this.addConnectMenu(list, allItems, component, menu, Scout.Connect.ConnectBottomToTop, "Bottom ", " top", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_BOTTOM_TO_TOP);
                                this.addConnectMenu(list, allItems, component, menu, Scout.Connect.ConnectBottomToBottom, "Bottom ", " bottom", StudioIcons.LayoutEditor.Toolbar.CONSTRAIN_BOTTOM_TO_BOTTOM);
                                break;
                            }
                            case BASELINE: {
                                this.addConnectMenu(list, allItems, component, menu, Scout.Connect.ConnectBaseLineToBaseLine, "Baseline ", " baseline", StudioIcons.LayoutEditor.Toolbar.BASELINE_ALIGNED_CONSTRAINT);
                            }
                        }
                    }
                    SceneView view2 = this.myComponent.getScene().getSceneManager().getSceneView();
                    int swingX = Coordinates.getSwingXDip(view2, x);
                    int swingY = Coordinates.getSwingYDip(view2, y);
                    this.myIsDragging = false;
                    DecoratorUtilities.setTryingToConnectState(this.myComponent.getAuthoritativeNlComponent(), this.myType, false);
                    final List allItemsNlComponents = allItems.stream().map(item -> item.getAuthoritativeNlComponent()).collect(Collectors.toCollection(ArrayList::new));
                    menu.addPopupMenuListener((PopupMenuListener)new PopupMenuListenerAdapter(){

                        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                            super.popupMenuWillBecomeVisible(e);
                            DecoratorUtilities.setTryingToConnectState(ConstraintAnchorTarget.this.myComponent.getAuthoritativeNlComponent(), allItemsNlComponents, ConstraintAnchorTarget.this.myType, true);
                        }

                        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                            super.popupMenuWillBecomeInvisible(e);
                            DecoratorUtilities.setTryingToConnectState(ConstraintAnchorTarget.this.myComponent.getAuthoritativeNlComponent(), allItemsNlComponents, ConstraintAnchorTarget.this.myType, false);
                            ConstraintAnchorTarget.this.myComponent.getScene().setFilterType(Scene.FilterType.NONE);
                        }
                    });
                    if (menu.getComponentCount() > 0) {
                        menu.show((Component)this.myComponent.getScene().getDesignSurface().getPreferredFocusedComponent(), swingX, swingY);
                    }
                }
            }
        }
        finally {
            if (this.myIsDragging) {
                this.myIsDragging = false;
                DecoratorUtilities.setTryingToConnectState(this.myComponent.getNlComponent(), this.myType, false);
                this.myComponent.getScene().needsRebuildList();
            }
        }
    }

    private static void logConstraintConnected(SceneComponent component) {
        DesignSurface<?> surface2 = component.getScene().getDesignSurface();
        if (!(surface2 instanceof NlDesignSurface)) {
            return;
        }
        NlAnalyticsManager manager = ((NlDesignSurface)surface2).getAnalyticsManager();
        manager.trackAddConstraint();
    }

    private static void logConstraintDisconnected(SceneComponent component) {
        DesignSurface<?> surface2 = component.getScene().getDesignSurface();
        if (!(surface2 instanceof NlDesignSurface)) {
            return;
        }
        NlAnalyticsManager manager = ((NlDesignSurface)surface2).getAnalyticsManager();
        manager.trackRemoveConstraint();
    }

    @Override
    public void mouseCancel() {
        super.mouseCancel();
        DecoratorUtilities.setTryingToConnectState(this.myComponent.getNlComponent(), this.myType, false);
        this.revertToPreviousState();
    }

    @Override
    public void addHit(@NotNull SceneContext transform, @NotNull ScenePicker picker, @JdkConstants.InputEventMask int modifiersEx) {
        if (!this.myIsEdge || this instanceof GuidelineAnchorTarget) {
            super.addHit(transform, picker, modifiersEx);
            return;
        }
        if ((modifiersEx & 0x1000) > 0) {
            return;
        }
        int x1 = 0;
        int x2 = 0;
        int y1 = 0;
        int y2 = 0;
        int centerX = transform.getSwingXDip(this.getCenterX());
        int centerY = transform.getSwingYDip(this.getCenterY());
        int componentWidth = transform.getSwingDimensionDip(this.myComponent.getDrawWidth());
        int componentHeight = transform.getSwingDimensionDip(this.myComponent.getDrawHeight());
        Rectangle renderableArea = transform.getRenderableBounds();
        switch (this.myType) {
            case LEFT: {
                x1 = Math.min(centerX - ANCHOR_SIZE, (int)renderableArea.getX());
                x2 = centerX + ANCHOR_SIZE;
                y1 = centerY - componentHeight / 2;
                y2 = centerY + componentHeight / 2;
                break;
            }
            case RIGHT: {
                x1 = centerX - ANCHOR_SIZE;
                x2 = Math.max(centerX + ANCHOR_SIZE, (int)(renderableArea.getX() + renderableArea.getWidth()));
                y1 = centerY - componentHeight / 2;
                y2 = centerY + componentHeight / 2;
                break;
            }
            case TOP: {
                x1 = centerX - componentWidth / 2;
                x2 = centerX + componentWidth / 2;
                y1 = Math.min(centerY - ANCHOR_SIZE, (int)renderableArea.getY());
                y2 = centerY + ANCHOR_SIZE;
                break;
            }
            case BOTTOM: {
                x1 = centerX - componentWidth / 2;
                x2 = centerX + componentWidth / 2;
                y1 = centerY - ANCHOR_SIZE;
                y2 = Math.max(centerY + ANCHOR_SIZE, (int)(renderableArea.getY() + renderableArea.getHeight()));
                break;
            }
            case BASELINE: {
                Logger.getInstance(this.getClass()).warn("The baseline anchor should be a edge anchor.");
            }
        }
        picker.addRect(this, 0, x1, y1, x2, y2);
    }

    @Override
    public String getToolTipText() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append(super.getToolTipText());
        if (this.isConnected()) {
            builder2.append(" (").append(AdtUiUtils.getActionKeyText()).append("+Click)");
        }
        return builder2.toString();
    }

    private void addConnectMenu(ArrayList<NlComponent> list, List<SceneComponent> allItems, SceneComponent component, JBPopupMenu menu, Scout.Connect type, String from, String to, Icon icon2) {
        if (Scout.connectCheck(list, type, false)) {
            menu.add((JMenuItem)((Object)new ConnectMenu(allItems, this.myComponent, from, component, to, icon2, type, this.isRtl())));
        }
    }

    static class ConnectMenu
    extends JBMenuItem
    implements ActionListener,
    ChangeListener {
        SceneComponent mySrc;
        SceneComponent myDest;
        Scout.Connect myType;
        @Nullable
        AnchorTarget myDestTarget;
        List<SceneComponent> mAllItems;

        public ConnectMenu(List<SceneComponent> allItems, SceneComponent src, String from, SceneComponent dest, String text, Icon icon2, Scout.Connect type, boolean isRtl) {
            super(from + "to " + dest.getId() + text, icon2);
            this.mAllItems = allItems;
            this.mySrc = src;
            this.myDest = dest;
            this.myType = type;
            for (Target target : this.myDest.getTargets()) {
                if (!(target instanceof AnchorTarget) || ((AnchorTarget)target).getType() != this.myType.getDstAnchorType(isRtl)) continue;
                this.myDestTarget = (AnchorTarget)target;
            }
            this.addActionListener(this);
            this.addChangeListener(this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            List<NlComponent> list = Arrays.asList(this.mySrc.getAuthoritativeNlComponent(), this.myDest.getAuthoritativeNlComponent());
            Scout.connect(list, this.myType, false, true);
            ConstraintAnchorTarget.logConstraintConnected(this.mySrc);
            NlDesignSurface designSurface = (NlDesignSurface)this.mySrc.getScene().getDesignSurface();
            designSurface.forceLayersPaint(true);
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            for (SceneComponent item : this.mAllItems) {
                item.setDrawState(SceneComponent.DrawState.NORMAL);
            }
            if (this.myDestTarget != null) {
                this.myDestTarget.setMouseHovered(this.isSelected() || this.isArmed());
            }
            this.myDest.setDrawState(this.isSelected() || this.isArmed() ? SceneComponent.DrawState.HOVER : SceneComponent.DrawState.NORMAL);
            this.myDest.getScene().needsRebuildList();
            this.myDest.getScene().repaint();
        }
    }
}

