/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint.draw;

import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.draw.ColorSet;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.draw.DrawRegion;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Stroke;

public class DrawAnimatedFrame
extends DrawRegion {
    private int mDirection;
    private boolean mDrawAsDelete;
    private int[] mXPoints = new int[6];
    private int[] mYPoints = new int[6];
    private static final Stroke myBasicStroke = new BasicStroke(2.0f);
    private static final Stroke myAnimationStroke = new BasicStroke(2.0f, 2, 0, 1.0f, new float[]{10.0f, 10.0f}, 0.0f);
    private static final int REPAT_MS = 1000;
    private static final int PATERN_LENGTH = 20;

    public DrawAnimatedFrame(String s) {
        String[] sp = s.split(",");
        int c = 0;
        c = super.parse(sp, c);
        this.mDirection = Integer.parseInt(sp[c++]);
        this.mDrawAsDelete = Boolean.parseBoolean(sp[c]);
    }

    @Override
    public int getLevel() {
        return 100;
    }

    public DrawAnimatedFrame(int x, int y, int width2, int height2, int direction, boolean asDelete) {
        super(x, y, width2, height2);
        this.mDirection = direction;
        this.mDrawAsDelete = asDelete;
    }

    @Override
    public void paint(Graphics2D g, SceneContext sceneContext) {
        ColorSet colorSet = sceneContext.getColorSet();
        sceneContext.repaint();
        Stroke previousStroke = g.getStroke();
        Color previousColor = g.getColor();
        int shift = (int)(sceneContext.getTime() % 1000L);
        shift /= 50;
        switch (this.mDirection) {
            case 0: {
                this.mXPoints[0] = this.x;
                this.mYPoints[0] = this.y + this.height / 2 - Math.min(shift, this.height / 2);
                this.mXPoints[1] = this.x;
                this.mYPoints[1] = this.y;
                this.mXPoints[2] = this.x + this.width;
                this.mYPoints[2] = this.y;
                this.mXPoints[3] = this.x + this.width;
                this.mYPoints[3] = this.y + this.height;
                this.mXPoints[4] = this.x;
                this.mYPoints[4] = this.y + this.height;
                this.mXPoints[5] = this.x;
                this.mYPoints[5] = this.y + this.height / 2;
                break;
            }
            case 1: {
                this.mXPoints[0] = this.x + this.width;
                this.mYPoints[0] = this.y + this.height / 2 + Math.min(shift, this.height / 2);
                this.mXPoints[1] = this.x + this.width;
                this.mYPoints[1] = this.y + this.height;
                this.mXPoints[2] = this.x;
                this.mYPoints[2] = this.y + this.height;
                this.mXPoints[3] = this.x;
                this.mYPoints[3] = this.y;
                this.mXPoints[4] = this.x + this.width;
                this.mYPoints[4] = this.y;
                this.mXPoints[5] = this.x + this.width;
                this.mYPoints[5] = this.y + this.height / 2;
                break;
            }
            case 2: {
                this.mXPoints[0] = this.x + this.width / 2 + Math.min(shift, this.width / 2);
                this.mYPoints[0] = this.y;
                this.mXPoints[1] = this.x + this.width;
                this.mYPoints[1] = this.y;
                this.mXPoints[2] = this.x + this.width;
                this.mYPoints[2] = this.y + this.height;
                this.mXPoints[3] = this.x;
                this.mYPoints[3] = this.y + this.height;
                this.mXPoints[4] = this.x;
                this.mYPoints[4] = this.y;
                this.mXPoints[5] = this.x + this.width / 2;
                this.mYPoints[5] = this.y;
                break;
            }
            case 3: {
                this.mXPoints[0] = this.x + this.width / 2 - Math.min(shift, this.width / 2);
                this.mYPoints[0] = this.y + this.height;
                this.mXPoints[1] = this.x;
                this.mYPoints[1] = this.y + this.height;
                this.mXPoints[2] = this.x;
                this.mYPoints[2] = this.y;
                this.mXPoints[3] = this.x + this.width;
                this.mYPoints[3] = this.y;
                this.mXPoints[4] = this.x + this.width;
                this.mYPoints[4] = this.y + this.height;
                this.mXPoints[5] = this.x + this.width / 2;
                this.mYPoints[5] = this.y + this.height;
            }
        }
        g.setStroke(myAnimationStroke);
        g.setColor(colorSet.getHighlightedFrames());
        g.drawPolyline(this.mXPoints, this.mYPoints, this.mXPoints.length);
        g.setStroke(myBasicStroke);
        g.setColor(this.mDrawAsDelete ? colorSet.getAnchorDisconnectionCircle() : colorSet.getSelectedFrames());
        int dx = 4 * Math.abs(Integer.signum(this.mXPoints[4] - this.mXPoints[1]));
        int dy = 4 * Math.abs(Integer.signum(this.mYPoints[4] - this.mYPoints[1]));
        int x = Math.min(this.mXPoints[1], this.mXPoints[4]) - 1 + dx;
        int y = Math.min(this.mYPoints[1], this.mYPoints[4]) - 1 + dy;
        int w = 4 + Math.abs(this.mXPoints[1] - this.mXPoints[4]) - dx;
        int h = 4 + Math.abs(this.mYPoints[1] - this.mYPoints[4]) - dy;
        g.fillRoundRect(x, y, w, h, 4, 4);
        g.setStroke(previousStroke);
        g.setColor(previousColor);
    }

    @Override
    public String serialize() {
        return super.serialize() + "," + this.mDirection + "," + this.mDrawAsDelete;
    }

    public static void add(DisplayList list, Rectangle rect, int direction, boolean asDelete) {
        list.add(new DrawAnimatedFrame(rect.x, rect.y, rect.width, rect.height, direction, asDelete));
    }
}

