/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.handlers.constraint.WidgetConstraintModel;
import com.android.tools.idea.uibuilder.handlers.constraint.WidgetConstraintPanel;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneUtils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.handlers.motion.editor.ui.MotionAttributes;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Disposer;
import java.util.HashMap;
import java.util.List;
import javax.swing.Timer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MotionConstraintPanel
extends WidgetConstraintPanel {
    NlComponent myComponent;

    public MotionConstraintPanel(@NotNull List<NlComponent> components) {
        super(components);
        if (components == null || components.size() == 0) {
            this.mTitle.setText("Constraints");
            return;
        }
        this.myComponent = components.get(0);
        MotionAttributes attr2 = MotionSceneUtils.getAttributes(this.myComponent);
        if (attr2 != null) {
            this.mTitle.setText("Constraints from " + attr2.getLayoutSource());
        }
    }

    @Override
    protected WidgetConstraintModel getWidgetModel(Runnable modelUpdate) {
        return new MotionWidgetConstraintModel(modelUpdate);
    }

    class MotionWidgetConstraintModel
    extends WidgetConstraintModel {
        private boolean mPendingLayoutChanges;
        private MTag.TagWriter mTagWriter;
        private Timer myTimer;

        public MotionWidgetConstraintModel(Runnable modelUpdateCallback) {
            super(modelUpdateCallback);
            this.myTimer = new Timer(400, c -> {
                if (MotionConstraintPanel.this.myComponent != null) {
                    ApplicationManager.getApplication().invokeLater(() -> this.commit(), ignore2 -> Disposer.isDisposed((Disposable)MotionConstraintPanel.this.myComponent.getModel()));
                }
            });
        }

        @Override
        public void removeAttributes(NlComponent component, @NotNull String namespace, @NotNull String attribute) {
            this.setAttribute(component, namespace, attribute, null);
            this.commit();
        }

        @Override
        protected String getValue(NlComponent component, String namespace, @NotNull String attribute) {
            if (component == null) {
                return null;
            }
            MotionAttributes attr2 = MotionSceneUtils.getAttributes(component);
            if (attr2 == null) {
                return super.getValue(component, namespace, attribute);
            }
            HashMap<String, MotionAttributes.DefinedAttribute> map = attr2.getAttrMap();
            if (map == null) {
                return null;
            }
            MotionAttributes.DefinedAttribute v = map.get(attribute);
            if (v == null) {
                return null;
            }
            return v.getValue();
        }

        @Override
        protected void setAttribute(NlComponent component, String namespace, @NotNull String attribute, @Nullable String value2) {
            if (component == null) {
                return;
            }
            MotionAttributes attr2 = MotionSceneUtils.getAttributes(component);
            if (attr2 == null) {
                super.setAttribute(component, namespace, attribute, value2);
                this.mPendingLayoutChanges = true;
                this.mTagWriter = null;
                return;
            }
            this.mTagWriter = MotionSceneUtils.getTagWriter(component);
            this.mTagWriter.setAttribute(namespace, attribute, value2);
            this.myTimer.setRepeats(false);
            this.myTimer.restart();
        }

        @Override
        public void commit() {
            if (this.mPendingLayoutChanges) {
                super.commit();
                this.mPendingLayoutChanges = false;
                return;
            }
            if (this.mTagWriter == null) {
                return;
            }
            this.mTagWriter.commit("Constraint modified");
            this.mTagWriter = null;
        }
    }
}

