/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers.constraint;

import com.android.AndroidXConstants;
import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.repository.GradleVersion;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.idea.common.model.AttributesTransaction;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlAttributesHolder;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlDependencyManager;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.target.AnchorTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.handlers.constraint.ComponentModification;
import com.android.tools.idea.uibuilder.handlers.constraint.SecondarySelector;
import com.android.tools.idea.uibuilder.handlers.constraint.targets.ConstraintAnchorTarget;
import com.android.tools.idea.uibuilder.handlers.motion.editor.MotionSceneUtils;
import com.android.tools.idea.uibuilder.handlers.motion.editor.adapters.MTag;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import com.android.tools.idea.uibuilder.scout.Direction;
import com.android.utils.Pair;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ConstraintComponentUtilities {
    public static final HashMap<String, String> ourReciprocalAttributes;
    public static final Map<String, String> ourOtherSideAttributes;
    public static final HashMap<String, String> ourMapMarginAttributes;
    private static final HashMap<String, AnchorTarget.Type> ourMapSideToOriginAnchors;
    public static final ArrayList<String> ourLeftAttributes;
    public static final ArrayList<String> ourTopAttributes;
    public static final ArrayList<String> ourRightAttributes;
    public static final ArrayList<String> ourBottomAttributes;
    public static final ArrayList<String> ourStartAttributes;
    public static final ArrayList<String> ourEndAttributes;
    public static final ArrayList<String> ourBaselineAttributes;
    private static final ArrayList<String> ourHorizontalAttributes;
    private static final ArrayList<String> ourVerticalAttributes;
    public static final HashMap<String, String> ourLayoutUriToPrefix;
    public static final ArrayList<Pair<String, String>> ourLayoutAttributes;
    private static final HashMap<Pair<AnchorTarget.Type, AnchorTarget.Type>, String> ourConstraintAttributes;
    private static final HashMap<String, String> ourLTRConvertedAttributes;
    private static final HashMap<Pair<AnchorTarget.Type, AnchorTarget.Type>, String> ourLTRConstraintAnchorsToMargin;
    public static final HashMap<String, AnchorTarget.Type> ourLTRMapSideToTargetAnchors;
    private static final HashMap<String, String> ourRTLConvertedAttributes;
    private static final HashMap<Pair<AnchorTarget.Type, AnchorTarget.Type>, String> ourRTLConstraintAnchorsToMargin;
    public static final HashMap<String, AnchorTarget.Type> ourRTLMapSideToTargetAnchors;
    public static final HashMap<AnchorTarget.Type, Pair<String, String>> ourPotentialAttributes;
    public static final HashMap<AnchorTarget.Type, Pair<String, String>> ourPotentialLTRAttributes;
    public static final HashMap<AnchorTarget.Type, Pair<String, String>> ourPotentialRTLAttributes;
    public static final String[] ourConstraintLayoutAttributesToClear;
    private static final String[] ourLayoutAttributesToClear;
    private static String[][] ATTRIB_MATRIX;
    private static String[][] ATTRIB_CLEAR;
    private static String[] ATTRIB_MARGIN;
    private static String[] ATTRIB_MARGIN_LR;

    public static String getAttribute(AnchorTarget.Type source, AnchorTarget.Type destination, boolean useRtlAttributes, boolean isRtl) {
        String converted;
        if (source == AnchorTarget.Type.BASELINE && destination == AnchorTarget.Type.BASELINE) {
            return "layout_constraintBaseline_toBaselineOf";
        }
        String attribute = ourConstraintAttributes.get(Pair.of((Object)((Object)source), (Object)((Object)destination)));
        if (useRtlAttributes && (converted = isRtl ? ourRTLConvertedAttributes.get(attribute) : ourLTRConvertedAttributes.get(attribute)) != null) {
            attribute = converted;
        }
        return attribute;
    }

    public static void clearAnchor(AnchorTarget.Type type, NlAttributesHolder transaction, boolean useRtlAttributes, boolean isRtl) {
        switch (type) {
            case LEFT: {
                ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourPotentialAttributes.get((Object)AnchorTarget.Type.LEFT), transaction);
                if (!useRtlAttributes) break;
                if (isRtl) {
                    ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourPotentialRTLAttributes.get((Object)AnchorTarget.Type.LEFT), transaction);
                    break;
                }
                ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourPotentialLTRAttributes.get((Object)AnchorTarget.Type.LEFT), transaction);
                break;
            }
            case RIGHT: {
                ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourPotentialAttributes.get((Object)AnchorTarget.Type.RIGHT), transaction);
                if (!useRtlAttributes) break;
                if (isRtl) {
                    ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourPotentialRTLAttributes.get((Object)AnchorTarget.Type.RIGHT), transaction);
                    break;
                }
                ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourPotentialLTRAttributes.get((Object)AnchorTarget.Type.RIGHT), transaction);
                break;
            }
            case TOP: {
                ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourTopAttributes, transaction);
                break;
            }
            case BOTTOM: {
                ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourBottomAttributes, transaction);
                break;
            }
            case BASELINE: {
                transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf", null);
            }
        }
    }

    public static boolean isAnchorConnected(AnchorTarget.Type type, NlComponent component, boolean useRtlAttributes, boolean isRtl) {
        if (type == AnchorTarget.Type.BASELINE) {
            return component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
        }
        boolean isConnected = false;
        Pair<String, String> pair = ourPotentialAttributes.get((Object)type);
        if (pair != null) {
            isConnected |= component.getLiveAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getFirst()) != null;
            isConnected |= component.getLiveAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getSecond()) != null;
        }
        if (useRtlAttributes) {
            if (isRtl) {
                pair = ourPotentialRTLAttributes.get((Object)type);
                if (pair != null) {
                    isConnected |= component.getLiveAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getFirst()) != null;
                    isConnected |= component.getLiveAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getSecond()) != null;
                }
            } else {
                pair = ourPotentialLTRAttributes.get((Object)type);
                if (pair != null) {
                    isConnected |= component.getLiveAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getFirst()) != null;
                    isConnected |= component.getLiveAttribute("http://schemas.android.com/apk/res-auto", (String)pair.getSecond()) != null;
                }
            }
        }
        return isConnected;
    }

    public static ConstraintAnchorTarget getOriginAnchor(Scene scene, NlComponent targetComponent, String attribute) {
        AnchorTarget.Type type = ourMapSideToOriginAnchors.get(attribute);
        SceneComponent component = scene.getSceneComponent(targetComponent);
        if (component != null) {
            return ConstraintComponentUtilities.getAnchorTarget(component, type);
        }
        return null;
    }

    public static ConstraintAnchorTarget getTargetAnchor(Scene scene, NlComponent targetComponent, String attribute, boolean supportsRtl, boolean isInRtl) {
        SceneComponent component = scene.getSceneComponent(targetComponent);
        if (component == null) {
            return null;
        }
        if (supportsRtl) {
            if (isInRtl) {
                return ConstraintComponentUtilities.getAnchorTarget(component, ourRTLMapSideToTargetAnchors.get(attribute));
            }
            return ConstraintComponentUtilities.getAnchorTarget(component, ourLTRMapSideToTargetAnchors.get(attribute));
        }
        return ConstraintComponentUtilities.getAnchorTarget(component, ourLTRMapSideToTargetAnchors.get(attribute));
    }

    public static ConstraintAnchorTarget getAnchorTarget(@NotNull SceneComponent component, @NotNull AnchorTarget.Type type) {
        for (Target target : component.getTargets()) {
            if (!(target instanceof ConstraintAnchorTarget) || ((ConstraintAnchorTarget)target).getType() != type) continue;
            return (ConstraintAnchorTarget)target;
        }
        return null;
    }

    private static boolean hasConstraints(NlComponent component, String uri, ArrayList<String> constraints) {
        int count = constraints.size();
        for (int i = 0; i < count; ++i) {
            if (component.getLiveAttribute(uri, constraints.get(i)) == null) continue;
            return true;
        }
        return false;
    }

    public static boolean hasHorizontalConstraints(NlComponent component) {
        return ConstraintComponentUtilities.hasConstraints(component, "http://schemas.android.com/apk/res-auto", ourHorizontalAttributes);
    }

    public static boolean hasVerticalConstraints(NlComponent component) {
        return ConstraintComponentUtilities.hasConstraints(component, "http://schemas.android.com/apk/res-auto", ourVerticalAttributes);
    }

    public static int getDpValue(@NotNull NlComponent component, String value2) {
        Configuration configuration;
        ResourceResolver resourceResolver;
        if (value2 != null && (resourceResolver = (configuration = component.getModel().getConfiguration()).getResourceResolver()) != null) {
            Integer px = ViewEditor.resolveDimensionPixelSize((RenderResources)resourceResolver, value2, configuration);
            return px == null ? 0 : Coordinates.pxToDp(component.getModel(), (int)px);
        }
        return 0;
    }

    public static int getGuidelineMode(SceneComponent component) {
        NlComponent nlComponent = component.getAuthoritativeNlComponent();
        String begin = nlComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_begin");
        String end = nlComponent.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintGuide_end");
        if (begin != null) {
            return 0;
        }
        if (end != null) {
            return 1;
        }
        return 16;
    }

    private static NlComponent getOriginalComponent(@NotNull NlComponent component) {
        if (NlComponentHelperKt.isOrHasSuperclass(component, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_REFERENCE)) {
            NlComponent parent = component.getParent();
            assert (parent != null);
            if (NlComponentHelperKt.isOrHasSuperclass(parent, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_CONSTRAINTS)) {
                parent = parent.getParent();
                assert (parent != null);
                if (NlComponentHelperKt.isOrHasSuperclass(parent, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT)) {
                    for (NlComponent child : parent.getChildren()) {
                        if (child.getId() == null || !child.getId().equals(component.getId())) continue;
                        return child;
                    }
                }
            }
        }
        return component;
    }

    public static void clearAttributes(@NotNull NlComponent component) {
        ComponentModification modification = new ComponentModification(component, "Cleared all constraints");
        ConstraintComponentUtilities.clearAllAttributes(component, modification);
        modification.commit();
    }

    public static void setDpAttribute(String uri, String attribute, NlAttributesHolder transaction, int value2) {
        if (value2 > 0) {
            String position = String.format("%ddp", value2);
            transaction.setAttribute(uri, attribute, position);
        }
    }

    public static void clearAttributes(String uri, ArrayList<String> attributes, NlAttributesHolder transaction) {
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            transaction.setAttribute(uri, attribute, null);
        }
    }

    public static void clearAttributes(String uri, String[] attributes, NlAttributesHolder transaction) {
        for (int i = 0; i < attributes.length; ++i) {
            transaction.setAttribute(uri, attributes[i], null);
        }
    }

    public static void clearAttributes(String uri, Pair<String, String> attributes, NlAttributesHolder transaction) {
        transaction.setAttribute(uri, (String)attributes.getFirst(), null);
        transaction.setAttribute(uri, (String)attributes.getSecond(), null);
    }

    private static void clearConnections(NlComponent component, ArrayList<String> attributes, NlAttributesHolder transaction) {
        NlComponent parent;
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", attribute, null);
        }
        if (attributes == ourLeftAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        } else if (attributes == ourRightAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        } else if (attributes == ourStartAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        } else if (attributes == ourEndAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        } else if (attributes == ourTopAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
        } else if (attributes == ourBottomAttributes) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
        }
        if (!ConstraintComponentUtilities.hasHorizontalConstraints(component)) {
            int offsetX = 0;
            parent = component.getParent();
            if (parent != null) {
                offsetX = NlComponentHelperKt.getX(component) - NlComponentHelperKt.getX(parent);
                offsetX = Coordinates.pxToDp(component.getModel(), offsetX);
            }
            ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", transaction, offsetX);
        }
        if (!ConstraintComponentUtilities.hasVerticalConstraints(component)) {
            int offsetY = 0;
            parent = component.getParent();
            if (parent != null) {
                offsetY = NlComponentHelperKt.getY(component) - NlComponentHelperKt.getY(parent);
                offsetY = Coordinates.pxToDp(component.getModel(), offsetY);
            }
            ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", transaction, offsetY);
        }
    }

    public static boolean clearSelectedConstraint(@NotNull DesignSurface<?> surface2) {
        SelectionModel selectionModel = surface2.getSelectionModel();
        Object secondarySelection = selectionModel.getSecondarySelection();
        Scene scene = surface2.getScene();
        if (secondarySelection instanceof SecondarySelector.Constraint && scene != null) {
            SecondarySelector.Constraint constraint = (SecondarySelector.Constraint)((Object)secondarySelection);
            AnchorTarget.Type type = null;
            switch (constraint) {
                case LEFT: {
                    type = AnchorTarget.Type.LEFT;
                    break;
                }
                case TOP: {
                    type = AnchorTarget.Type.TOP;
                    break;
                }
                case RIGHT: {
                    type = AnchorTarget.Type.RIGHT;
                    break;
                }
                case BOTTOM: {
                    type = AnchorTarget.Type.BOTTOM;
                    break;
                }
                case BASELINE: {
                    type = AnchorTarget.Type.BASELINE;
                }
            }
            SceneComponent component = scene.getSceneComponent(selectionModel.getPrimary());
            if (component == null) {
                return false;
            }
            AnchorTarget selectedTarget = AnchorTarget.findAnchorTarget(component, type);
            if (selectedTarget != null) {
                NlComponent nlComponent = component.getNlComponent();
                ComponentModification modification = new ComponentModification(nlComponent, "Constraint Disconnected");
                ConstraintComponentUtilities.clearAnchor(type, modification, component.useRtlAttributes(), scene.isInRTL());
                ConstraintComponentUtilities.cleanup(modification, nlComponent);
                modification.commit();
                scene.markNeedsLayout(2);
                selectionModel.clearSecondary();
                return true;
            }
        }
        return false;
    }

    private static void clearAllAttributes(NlComponent component, NlAttributesHolder transaction) {
        if (ConstraintComponentUtilities.isWidthConstrained(component) && ConstraintComponentUtilities.isHorizontalResizable(component)) {
            String fixedWidth = String.format("%ddp", ConstraintComponentUtilities.getDpWidth(component));
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", fixedWidth);
        }
        if (ConstraintComponentUtilities.isHeightConstrained(component) && ConstraintComponentUtilities.isVerticalResizable(component)) {
            String fixedHeight = String.format("%ddp", ConstraintComponentUtilities.getDpHeight(component));
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", fixedHeight);
        }
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", ourConstraintLayoutAttributesToClear, transaction);
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res/android", ourLayoutAttributesToClear, transaction);
        component = ConstraintComponentUtilities.getOriginalComponent(component);
        int offsetX = Coordinates.pxToDp(component.getModel(), NlComponentHelperKt.getX(component) - (component.isRoot() ? 0 : NlComponentHelperKt.getX(component.getParent())));
        int offsetY = Coordinates.pxToDp(component.getModel(), NlComponentHelperKt.getY(component) - (component.isRoot() ? 0 : NlComponentHelperKt.getY(component.getParent())));
        ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", transaction, offsetX);
        ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", transaction, offsetY);
    }

    public static void updateOnDelete(NlComponent component, String targetId) {
        ComponentModification transaction = null;
        transaction = ConstraintComponentUtilities.updateOnDelete(component, ourLeftAttributes, transaction, targetId);
        transaction = ConstraintComponentUtilities.updateOnDelete(component, ourTopAttributes, transaction, targetId);
        transaction = ConstraintComponentUtilities.updateOnDelete(component, ourRightAttributes, transaction, targetId);
        transaction = ConstraintComponentUtilities.updateOnDelete(component, ourBottomAttributes, transaction, targetId);
        transaction = ConstraintComponentUtilities.updateOnDelete(component, ourBaselineAttributes, transaction, targetId);
        transaction = ConstraintComponentUtilities.updateOnDelete(component, ourStartAttributes, transaction, targetId);
        if ((transaction = ConstraintComponentUtilities.updateOnDelete(component, ourEndAttributes, transaction, targetId)) != null) {
            transaction.commit();
        }
    }

    private static ComponentModification updateOnDelete(NlComponent component, ArrayList<String> attributes, ComponentModification modification, String targetId) {
        if (ConstraintComponentUtilities.isConnectedTo(component, attributes, targetId)) {
            if (modification == null) {
                modification = new ComponentModification(component, "Update on Delete");
            }
            ConstraintComponentUtilities.clearConnections(component, attributes, modification);
        }
        return modification;
    }

    private static boolean isConnectedTo(NlComponent component, ArrayList<String> attributes, String targetId) {
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            String target = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", attribute);
            if ((target = NlComponent.extractId(target)) == null || !target.equalsIgnoreCase(targetId)) continue;
            return true;
        }
        return false;
    }

    public static void ensureHorizontalPosition(NlComponent component, NlAttributesHolder transaction) {
        if (ConstraintComponentUtilities.hasHorizontalConstraints(component)) {
            return;
        }
        int dx = ConstraintComponentUtilities.getXfromParent(component);
        if (dx > 0) {
            String position = String.format("%ddp", Coordinates.pxToDp(component.getModel(), dx));
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", position);
        }
    }

    public static void ensureVerticalPosition(NlComponent component, NlAttributesHolder transaction) {
        if (ConstraintComponentUtilities.hasVerticalConstraints(component)) {
            return;
        }
        int dy = ConstraintComponentUtilities.getYfromParent(component);
        if (dy > 0) {
            String position = String.format("%ddp", Coordinates.pxToDp(component.getModel(), dy));
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", position);
        }
    }

    private static int getXfromParent(@NotNull NlComponent component) {
        return NlComponentHelperKt.getX(component) - (component.getParent() != null ? NlComponentHelperKt.getX(component.getParent()) : 0);
    }

    private static int getYfromParent(@NotNull NlComponent component) {
        return NlComponentHelperKt.getY(component) - (component.getParent() != null ? NlComponentHelperKt.getY(component.getParent()) : 0);
    }

    public static boolean isConstraintModelGreaterThan(@NotNull ViewEditor editor, int major, int ... version) {
        GoogleMavenArtifactId artifact = GoogleMavenArtifactId.ANDROIDX_CONSTRAINT_LAYOUT;
        GradleVersion v = NlDependencyManager.getInstance().getModuleDependencyVersion(artifact, editor.getModel().getFacet());
        return ConstraintComponentUtilities.versionGreaterThan(v, major, version.length > 0 ? version[0] : -1, version.length > 1 ? version[1] : -1, version.length > 2 ? version[2] : -1, version.length > 3 ? version[3] : -1);
    }

    private static boolean versionGreaterThan(GradleVersion v, int major, int minor, int micro, int beta, int alpha) {
        if (v == null) {
            return true;
        }
        if (v.getMajor() != major) {
            return v.getMajor() > major;
        }
        if (v.getMinor() != minor) {
            return v.getMinor() > minor;
        }
        if (micro == -1) {
            return false;
        }
        if (v.getMicro() != micro) {
            return v.getMicro() > micro;
        }
        if (alpha > 0) {
            if ("alpha".equals(v.getPreviewType())) {
                return v.getPreview() > alpha;
            }
            return true;
        }
        if (beta > 0) {
            if ("beta".equals(v.getPreviewType())) {
                return v.getPreview() > beta;
            }
            return true;
        }
        return false;
    }

    public static int getDpX(@NotNull NlComponent component) {
        return Coordinates.pxToDp(component.getModel(), NlComponentHelperKt.getX(component));
    }

    private static boolean hasAttributes(@NotNull NlAttributesHolder transaction, String uri, ArrayList<String> attributes) {
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            if (transaction.getAttribute(uri, attribute) == null) continue;
            return true;
        }
        return false;
    }

    public static String getConnectionId(@NotNull NlComponent component, String uri, ArrayList<String> attributes) {
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = component.getLiveAttribute(uri, attributes.get(i));
            if (attribute == null) continue;
            return NlComponent.extractId(attribute);
        }
        return null;
    }

    private static boolean hasLeft(@NotNull NlAttributesHolder transaction) {
        return ConstraintComponentUtilities.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourLeftAttributes);
    }

    private static boolean hasTop(@NotNull NlAttributesHolder transaction) {
        return ConstraintComponentUtilities.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourTopAttributes);
    }

    private static boolean hasRight(@NotNull NlAttributesHolder transaction) {
        return ConstraintComponentUtilities.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourRightAttributes);
    }

    private static boolean hasBottom(@NotNull NlAttributesHolder transaction) {
        return ConstraintComponentUtilities.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourBottomAttributes);
    }

    private static boolean hasStart(@NotNull NlAttributesHolder transaction) {
        return ConstraintComponentUtilities.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourStartAttributes);
    }

    private static boolean hasEnd(@NotNull NlAttributesHolder transaction) {
        return ConstraintComponentUtilities.hasAttributes(transaction, "http://schemas.android.com/apk/res-auto", ourEndAttributes);
    }

    private static boolean isInFlow(@NotNull NlComponent component) {
        NlComponent parent = component.getParent();
        if (parent == null) {
            return false;
        }
        String componentId = component.getId();
        for (NlComponent child : parent.getChildren()) {
            String attr2;
            if (!NlComponentHelperKt.isOrHasSuperclass(child, AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_FLOW) || (attr2 = child.getAttribute("http://schemas.android.com/apk/res-auto", "constraint_referenced_ids")) == null) continue;
            for (String id2 : attr2.split(",")) {
                if (!id2.equals(componentId)) continue;
                return true;
            }
        }
        return false;
    }

    public static void cleanup(@NotNull NlAttributesHolder transaction, @NotNull NlComponent component) {
        boolean hasLeft = ConstraintComponentUtilities.hasLeft(transaction);
        boolean hasRight = ConstraintComponentUtilities.hasRight(transaction);
        boolean hasTop = ConstraintComponentUtilities.hasTop(transaction);
        boolean hasBottom = ConstraintComponentUtilities.hasBottom(transaction);
        boolean hasBaseline = transaction.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBaseline_toBaselineOf") != null;
        boolean hasStart = ConstraintComponentUtilities.hasStart(transaction);
        boolean hasEnd = ConstraintComponentUtilities.hasEnd(transaction);
        boolean inFlow = ConstraintComponentUtilities.isInFlow(component);
        AndroidModuleInfo moduleInfo = AndroidModuleInfo.getInstance((AndroidFacet)component.getModel().getFacet());
        boolean remove_left_right = moduleInfo.getMinSdkVersion().isGreaterOrEqualThan(17);
        String margin = transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft");
        if (margin != null && margin.equalsIgnoreCase("0dp")) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
        }
        if ((margin = transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight")) != null && margin.equalsIgnoreCase("0dp")) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
        }
        if (!hasStart) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart", null);
            if (!hasLeft) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
            }
        } else {
            margin = transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart");
            if (margin != null && margin.equalsIgnoreCase("0dp")) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart", null);
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft", null);
            }
        }
        if (!hasEnd) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd", null);
            if (!hasRight) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
            }
        } else {
            margin = transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd");
            if (margin != null && margin.equalsIgnoreCase("0dp")) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd", null);
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight", null);
            }
        }
        if (!(hasLeft && hasRight || hasStart && hasEnd)) {
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", null);
        }
        if (!(hasLeft || hasRight || hasStart || hasEnd)) {
            if (transaction.getAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX") == null && !inFlow) {
                ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", transaction, ConstraintComponentUtilities.pixelToDP(component, ConstraintComponentUtilities.getXfromParent(component)));
                transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_chainStyle", null);
            }
        } else {
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", null);
        }
        if (!hasTop) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
        } else {
            margin = transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop");
            if (margin != null && margin.equalsIgnoreCase("0dp")) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginTop", null);
            }
        }
        if (!hasBottom) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
            transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", null);
        } else {
            margin = transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom");
            if (margin != null && margin.equalsIgnoreCase("0dp")) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", "layout_marginBottom", null);
            }
        }
        if (!(hasTop || hasBottom || hasBaseline)) {
            if (transaction.getAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY") == null && !inFlow) {
                ConstraintComponentUtilities.setDpAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", transaction, ConstraintComponentUtilities.pixelToDP(component, ConstraintComponentUtilities.getYfromParent(component)));
                transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_chainStyle", null);
            }
        } else {
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", null);
        }
        if (ConstraintComponentUtilities.isGuideLine(component) || ConstraintComponentUtilities.isBarrier(component) || ConstraintComponentUtilities.isGroup(component)) {
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteX", null);
            transaction.setAttribute("http://schemas.android.com/tools", "layout_editor_absoluteY", null);
        }
        if (remove_left_right) {
            boolean end;
            boolean start;
            boolean bl = start = null != transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart");
            if (start) {
                boolean left;
                boolean bl2 = left = null != transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft");
                if (left) {
                    transaction.removeAttribute("http://schemas.android.com/apk/res/android", "layout_marginLeft");
                }
            }
            boolean bl3 = end = null != transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd");
            if (end) {
                boolean right2;
                boolean bl4 = right2 = null != transaction.getAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight");
                if (right2) {
                    transaction.removeAttribute("http://schemas.android.com/apk/res/android", "layout_marginRight");
                }
            }
        }
    }

    public static boolean isGuideLine(@NotNull NlComponent component) {
        return AndroidXConstants.CONSTRAINT_LAYOUT_GUIDELINE.isEqualsIgnoreCase(component.getTagName());
    }

    private static boolean isBarrier(@NotNull NlComponent component) {
        return AndroidXConstants.CONSTRAINT_LAYOUT_BARRIER.isEqualsIgnoreCase(component.getTagName());
    }

    private static boolean isGroup(@NotNull NlComponent component) {
        return AndroidXConstants.CLASS_CONSTRAINT_LAYOUT_GROUP.isEqualsIgnoreCase(component.getTagName());
    }

    @Nullable
    public static SceneComponent findChainHead(@NotNull SceneComponent component, @NotNull ArrayList<String> sideA, @NotNull ArrayList<String> sideB) {
        int maxAttempts = 1000;
        for (int i = 0; i < 1000; ++i) {
            NlComponent nlComponent = component.getAuthoritativeNlComponent();
            String attributeA = ConstraintComponentUtilities.getConnectionId(nlComponent, "http://schemas.android.com/apk/res-auto", sideA);
            if (attributeA == null) {
                return component;
            }
            SceneComponent target = component.getScene().getSceneComponent(attributeA);
            if (target == null) {
                return component;
            }
            String attributeB = ConstraintComponentUtilities.getConnectionId(target.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", sideB);
            if (attributeB == null) {
                return component;
            }
            if (!attributeB.equalsIgnoreCase(nlComponent.getId())) {
                return component;
            }
            component = target;
        }
        return null;
    }

    public static boolean isInChain(ArrayList<String> sideA, ArrayList<String> sideB, SceneComponent component) {
        String attributeB;
        SceneComponent target;
        String attributeA = ConstraintComponentUtilities.getConnectionId(component.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", sideA);
        return attributeA != null && (target = component.getScene().getSceneComponent(attributeA)) != null && (attributeB = ConstraintComponentUtilities.getConnectionId(target.getAuthoritativeNlComponent(), "http://schemas.android.com/apk/res-auto", sideB)) != null && attributeB.equalsIgnoreCase(component.getAuthoritativeNlComponent().getId());
    }

    @Nullable
    public static NlComponent findChainHead(@NotNull NlComponent component, @Nullable ArrayList<String> sideA, @Nullable ArrayList<String> sideB) {
        int maxAttempts = 1000;
        for (int i = 0; i < 1000; ++i) {
            String attributeA = ConstraintComponentUtilities.getConnectionId(component, "http://schemas.android.com/apk/res-auto", sideA);
            if (attributeA == null) {
                return component;
            }
            NlComponent parent = component.getParent();
            assert (parent != null);
            List<NlComponent> list = parent.getChildren();
            NlComponent target = ConstraintComponentUtilities.getComponent(list, attributeA);
            if (target == null) {
                return component;
            }
            String attributeB = ConstraintComponentUtilities.getConnectionId(target, "http://schemas.android.com/apk/res-auto", sideB);
            if (attributeB == null) {
                return component;
            }
            if (!attributeB.equalsIgnoreCase(component.getId())) {
                return component;
            }
            component = target;
        }
        return null;
    }

    public static NlComponent getComponent(List<NlComponent> list, String id2) {
        for (NlComponent nlComponent : list) {
            if (!id2.equals(nlComponent.getId())) continue;
            return nlComponent;
        }
        return null;
    }

    public static boolean isInChain(@NotNull ArrayList<String> sideA, @NotNull ArrayList<String> sideB, @NotNull NlComponent component) {
        String attributeB;
        List<NlComponent> list;
        NlComponent target;
        String attributeA = ConstraintComponentUtilities.getConnectionId(component, "http://schemas.android.com/apk/res-auto", sideA);
        NlComponent parent = component.getParent();
        return attributeA != null && parent != null && (target = ConstraintComponentUtilities.getComponent(list = parent.getChildren(), attributeA)) != null && (attributeB = ConstraintComponentUtilities.getConnectionId(target, "http://schemas.android.com/apk/res-auto", sideB)) != null && attributeB.equalsIgnoreCase(component.getId());
    }

    public static int getDpY(@NotNull NlComponent component) {
        return Coordinates.pxToDp(component.getModel(), NlComponentHelperKt.getY(component));
    }

    public static int getDpWidth(@NotNull NlComponent component) {
        return Coordinates.pxToDp(component.getModel(), NlComponentHelperKt.getW(component));
    }

    public static int getDpHeight(@NotNull NlComponent component) {
        return Coordinates.pxToDp(component.getModel(), NlComponentHelperKt.getH(component));
    }

    public static int pixelToDP(@NotNull NlComponent component, int size) {
        return Coordinates.pxToDp(component.getModel(), size);
    }

    public static int getDpBaseline(@NotNull NlComponent component) {
        return Coordinates.pxToDp(component.getModel(), NlComponentHelperKt.getBaseline(component));
    }

    public static boolean hasBaseline(@NotNull NlComponent component) {
        return NlComponentHelperKt.getBaseline(component) > 0;
    }

    public static boolean isLine(@NotNull NlComponent component) {
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component);
        if (viewInfo == null) {
            return false;
        }
        if (NlComponentHelperKt.isOrHasSuperclass(component, AndroidXConstants.CONSTRAINT_LAYOUT_GUIDELINE)) {
            return true;
        }
        return NlComponentHelperKt.isOrHasSuperclass(component, AndroidXConstants.CONSTRAINT_LAYOUT_BARRIER);
    }

    public static boolean isVerticalLine(@NotNull NlComponent component) {
        String dir;
        String orientation2;
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component);
        if (viewInfo == null) {
            return false;
        }
        if (NlComponentHelperKt.isOrHasSuperclass(component, AndroidXConstants.CONSTRAINT_LAYOUT_GUIDELINE) && (orientation2 = component.getAttribute("http://schemas.android.com/apk/res/android", "orientation")) != null && orientation2.equalsIgnoreCase("vertical")) {
            return true;
        }
        return NlComponentHelperKt.isOrHasSuperclass(component, AndroidXConstants.CONSTRAINT_LAYOUT_BARRIER) && (dir = component.getAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection")) != null && (dir.equalsIgnoreCase("left") || dir.equalsIgnoreCase("right") || dir.equalsIgnoreCase("start") || dir.equalsIgnoreCase("end"));
    }

    public static boolean isHorizontalLine(@NotNull NlComponent component) {
        String dir;
        String orientation2;
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component);
        if (viewInfo == null) {
            return false;
        }
        if (NlComponentHelperKt.isOrHasSuperclass(component, AndroidXConstants.CONSTRAINT_LAYOUT_GUIDELINE) && (orientation2 = component.getAttribute("http://schemas.android.com/apk/res/android", "orientation")) != null && orientation2.equalsIgnoreCase("horizontal")) {
            return true;
        }
        return NlComponentHelperKt.isOrHasSuperclass(component, AndroidXConstants.CONSTRAINT_LAYOUT_BARRIER) && (dir = component.getAttribute("http://schemas.android.com/apk/res-auto", "barrierDirection")) != null && (dir.equalsIgnoreCase("top") || dir.equalsIgnoreCase("bottom"));
    }

    public static boolean isHorizontalGuideline(@NotNull NlComponent component) {
        String orientation2;
        return NlComponentHelperKt.getViewInfo(component) != null && NlComponentHelperKt.isOrHasSuperclass(component, AndroidXConstants.CONSTRAINT_LAYOUT_GUIDELINE) && (orientation2 = component.getAttribute("http://schemas.android.com/apk/res/android", "orientation")) != null && orientation2.equalsIgnoreCase("horizontal");
    }

    public static boolean isVerticalGuideline(@NotNull NlComponent component) {
        String orientation2;
        return NlComponentHelperKt.getViewInfo(component) != null && NlComponentHelperKt.isOrHasSuperclass(component, AndroidXConstants.CONSTRAINT_LAYOUT_GUIDELINE) && (orientation2 = component.getAttribute("http://schemas.android.com/apk/res/android", "orientation")) != null && orientation2.equalsIgnoreCase("vertical");
    }

    private static boolean isHeightConstrained(@NotNull NlComponent component) {
        String tb = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toBottomOf");
        String tt = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintTop_toTopOf");
        if (tt == null && tb == null) {
            return false;
        }
        String bb = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toBottomOf");
        String bt = component.getAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintBottom_toTopOf");
        return bt != null || bb != null;
    }

    private static boolean isWidthConstrained(@NotNull NlComponent component) {
        String se = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintStart_toEndOf");
        String ss = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintStart_toStartOf");
        String ee = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintEnd_toEndOf");
        String es = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintEnd_toStartOf");
        if (ee != null || es != null || se != null || ss != null) {
            return !(ee == null && es == null || se == null && ss == null);
        }
        String ll = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toLeftOf");
        String lr = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintLeft_toRightOf");
        String rr = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toRightOf");
        String rl = component.getLiveAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintRight_toLeftOf");
        return !(ll == null && lr == null || rl == null && rr == null);
    }

    public static boolean isHorizontalResizable(@NotNull NlComponent component) {
        String dimension = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_width");
        if (dimension == null) {
            return false;
        }
        return dimension.equalsIgnoreCase("0dp");
    }

    public static boolean isVerticalResizable(@NotNull NlComponent component) {
        String dimension = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_height");
        if (dimension == null) {
            return false;
        }
        return dimension.equalsIgnoreCase("0dp");
    }

    public static boolean hasUserResizedHorizontally(@NotNull NlComponent component) {
        String dimension = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_width");
        assert (dimension != null || "include".equals(component.getTagName()));
        return dimension != null && !dimension.equalsIgnoreCase("wrap_content");
    }

    public static boolean hasUserResizedVertically(@NotNull NlComponent component) {
        String dimension = component.getAttribute("http://schemas.android.com/apk/res/android", "layout_height");
        assert (dimension != null || "include".equals(component.getTagName()));
        return dimension != null && !dimension.equalsIgnoreCase("wrap_content");
    }

    public static int getMargin(@NotNull NlComponent component, String margin_attr) {
        int margin = 0;
        String marginString = component.getLiveAttribute("http://schemas.android.com/apk/res/android", margin_attr);
        if (marginString == null) {
            marginString = "layout_marginLeft".equalsIgnoreCase(margin_attr) ? component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginStart") : component.getLiveAttribute("http://schemas.android.com/apk/res/android", "layout_marginEnd");
        }
        if (marginString == null || marginString.startsWith("@")) {
            // empty if block
        }
        return Coordinates.pxToDp(component.getModel(), margin);
    }

    public static void setScoutAbsoluteDpX(@NotNull NlComponent component, int dp, boolean apply) {
        ConstraintComponentUtilities.setScoutAttributeValue(component, "http://schemas.android.com/tools", "layout_editor_absoluteX", dp, apply);
    }

    public static void setScoutAbsoluteDpY(@NotNull NlComponent component, int dp, boolean apply) {
        ConstraintComponentUtilities.setScoutAttributeValue(component, "http://schemas.android.com/tools", "layout_editor_absoluteY", dp, apply);
    }

    public static void setScoutAbsoluteDpWidth(@NotNull NlComponent component, int dp, boolean apply) {
        ConstraintComponentUtilities.setScoutAttributeValue(component, "http://schemas.android.com/apk/res/android", "layout_width", dp, apply);
    }

    public static void setScoutAbsoluteDpHeight(@NotNull NlComponent component, int dp, boolean apply) {
        ConstraintComponentUtilities.setScoutAttributeValue(component, "http://schemas.android.com/apk/res/android", "layout_height", dp, apply);
    }

    public static void setScoutVerticalBiasPercent(@NotNull NlComponent component, float value2) {
        AttributesTransaction transaction = component.startAttributeTransaction();
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintVertical_bias", Float.toString(value2));
        transaction.apply();
    }

    public static void setScoutHorizontalBiasPercent(@NotNull NlComponent component, float value2) {
        AttributesTransaction transaction = component.startAttributeTransaction();
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", "layout_constraintHorizontal_bias", Float.toString(value2));
        transaction.apply();
    }

    private static void setScoutAttributeValue(@NotNull NlComponent component, @NotNull String uri, @NotNull String attribute, int dp, boolean apply) {
        if (dp <= 0) {
            return;
        }
        String position = String.format("%ddp", dp);
        AttributesTransaction transaction = component.startAttributeTransaction();
        transaction.setAttribute(uri, attribute, position);
        if (apply) {
            transaction.apply();
        }
    }

    public static void scoutClearAttributes(@NotNull NlComponent component, ArrayList<String> attributes) {
        AttributesTransaction transaction = component.startAttributeTransaction();
        ConstraintComponentUtilities.clearConnections(component, attributes, transaction);
        transaction.apply();
    }

    public static void setScoutAttributeValue(@NotNull NlComponent component, @NotNull String uri, @NotNull String attribute, @NotNull String value2) {
        AttributesTransaction transaction = component.startAttributeTransaction();
        transaction.setAttribute(uri, attribute, value2);
        transaction.apply();
    }

    public static boolean isConstraintLayout(@NotNull NlComponent component) {
        return NlComponentHelperKt.isOrHasSuperclass(component, AndroidXConstants.CONSTRAINT_LAYOUT) || AndroidXConstants.CONSTRAINT_LAYOUT.isEquals(component.getTagDeprecated().getName());
    }

    public static void clearAttributes(String uri, ArrayList<String> attributes, MTag.TagWriter tagwriter) {
        int count = attributes.size();
        for (int i = 0; i < count; ++i) {
            String attribute = attributes.get(i);
            tagwriter.setAttribute(uri, attribute, null);
        }
    }

    public static void scoutConstraintSetConnect(NlComponent source, Direction sourceDirection, NlComponent target, Direction targetDirection, int margin) {
        String str;
        int srcIndex = sourceDirection.ordinal();
        String attrib = ATTRIB_MATRIX[srcIndex][targetDirection.ordinal()];
        if (attrib == null) {
            throw new RuntimeException("cannot connect " + sourceDirection + " to " + targetDirection);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < ATTRIB_CLEAR[srcIndex].length; ++i) {
            String clr_attr = ATTRIB_CLEAR[srcIndex][i];
            if (attrib.equals(clr_attr)) continue;
            list.add(clr_attr);
        }
        MTag.TagWriter tagwriter = MotionSceneUtils.getTagWriter(source);
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", list, tagwriter);
        Object targetId = target == source.getParent() ? "parent" : "@+id/" + NlComponentHelperKt.ensureLiveId(target);
        tagwriter.setAttribute("http://schemas.android.com/apk/res-auto", attrib, (String)targetId);
        if (srcIndex <= Direction.BASELINE.ordinal() && margin > 0) {
            tagwriter.setAttribute("http://schemas.android.com/apk/res/android", ATTRIB_MARGIN[srcIndex], margin + "dp");
            if (ATTRIB_MARGIN_LR[srcIndex] != null) {
                tagwriter.setAttribute("http://schemas.android.com/apk/res/android", ATTRIB_MARGIN_LR[srcIndex], margin + "dp");
            }
        }
        tagwriter.commit("create connection");
        switch (sourceDirection) {
            case BASELINE: {
                str = "baseline";
                break;
            }
            case BOTTOM: {
                str = "bottom";
                break;
            }
            case LEFT: {
                str = "left";
                break;
            }
            case RIGHT: {
                str = "right";
                break;
            }
            case TOP: {
                str = "north";
                break;
            }
            default: {
                str = null;
            }
        }
        if (str != null) {
            DecoratorUtilities.setTimeChange(source, str, DecoratorUtilities.ViewStates.INFERRED, DecoratorUtilities.ViewStates.SELECTED);
        }
    }

    public static void scoutConnect(NlComponent source, Direction sourceDirection, NlComponent target, Direction targetDirection, int margin) {
        String str;
        if (MotionSceneUtils.isUnderConstraintSet(source)) {
            ConstraintComponentUtilities.scoutConstraintSetConnect(source, sourceDirection, target, targetDirection, margin);
            return;
        }
        int srcIndex = sourceDirection.ordinal();
        String attrib = ATTRIB_MATRIX[srcIndex][targetDirection.ordinal()];
        if (attrib == null) {
            throw new RuntimeException("cannot connect " + sourceDirection + " to " + targetDirection);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < ATTRIB_CLEAR[srcIndex].length; ++i) {
            String clr_attr = ATTRIB_CLEAR[srcIndex][i];
            if (attrib.equals(clr_attr)) continue;
            list.add(clr_attr);
        }
        AttributesTransaction transaction = source.startAttributeTransaction();
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", list, (NlAttributesHolder)transaction);
        Object targetId = target == source.getParent() ? "parent" : "@+id/" + NlComponentHelperKt.ensureLiveId(target);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", attrib, (String)targetId);
        if (srcIndex <= Direction.BASELINE.ordinal() && margin > 0) {
            transaction.setAttribute("http://schemas.android.com/apk/res/android", ATTRIB_MARGIN[srcIndex], margin + "dp");
            if (ATTRIB_MARGIN_LR[srcIndex] != null) {
                transaction.setAttribute("http://schemas.android.com/apk/res/android", ATTRIB_MARGIN_LR[srcIndex], margin + "dp");
            }
        }
        transaction.apply();
        switch (sourceDirection) {
            case BASELINE: {
                str = "baseline";
                break;
            }
            case BOTTOM: {
                str = "bottom";
                break;
            }
            case LEFT: {
                str = "left";
                break;
            }
            case RIGHT: {
                str = "right";
                break;
            }
            case TOP: {
                str = "north";
                break;
            }
            default: {
                str = null;
            }
        }
        if (str != null) {
            DecoratorUtilities.setTimeChange(source, str, DecoratorUtilities.ViewStates.INFERRED, DecoratorUtilities.ViewStates.SELECTED);
        }
    }

    public static void scoutChainConnect(NlComponent source, Direction sourceDirection, NlComponent target, Direction targetDirection, ArrayList<String[]> attrList) {
        int srcIndex = sourceDirection.ordinal();
        String attrib = ATTRIB_MATRIX[srcIndex][targetDirection.ordinal()];
        if (attrib == null) {
            throw new RuntimeException("cannot connect " + sourceDirection + " to " + targetDirection);
        }
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < ATTRIB_CLEAR[srcIndex].length; ++i) {
            String clr_attr = ATTRIB_CLEAR[srcIndex][i];
            if (attrib.equals(clr_attr)) continue;
            list.add(clr_attr);
        }
        AttributesTransaction transaction = source.startAttributeTransaction();
        ConstraintComponentUtilities.clearAttributes("http://schemas.android.com/apk/res-auto", list, (NlAttributesHolder)transaction);
        Object targetId = target == source.getParent() ? "parent" : "@+id/" + NlComponentHelperKt.ensureLiveId(target);
        transaction.setAttribute("http://schemas.android.com/apk/res-auto", attrib, (String)targetId);
        for (int i = 0; i < attrList.size(); ++i) {
            String[] bundle = attrList.get(i);
            transaction.setAttribute(bundle[0], bundle[1], bundle[2]);
        }
        transaction.apply();
        String str = null;
        switch (sourceDirection) {
            case BASELINE: {
                str = "baseline";
                break;
            }
            case BOTTOM: {
                str = "bottom";
                break;
            }
            case LEFT: {
                str = "left";
                break;
            }
            case RIGHT: {
                str = "right";
                break;
            }
            case TOP: {
                str = "north";
            }
        }
        DecoratorUtilities.setTimeChange(source, str, DecoratorUtilities.ViewStates.INFERRED, DecoratorUtilities.ViewStates.SELECTED);
    }

    public static boolean wouldCreateLoop(NlComponent source, Direction sourceDirection, NlComponent target) {
        if (source.getParent() == null) {
            return true;
        }
        List<NlComponent> sisters = source.getParent().getChildren();
        switch (sourceDirection) {
            case BOTTOM: 
            case TOP: {
                HashSet<NlComponent> connected = DecoratorUtilities.getConnectedNlComponents(source, sisters, ourBottomAttributes, ourTopAttributes, ourBaselineAttributes);
                return connected.contains(target);
            }
            case LEFT: 
            case RIGHT: {
                HashSet<NlComponent> connected = DecoratorUtilities.getConnectedNlComponents(source, sisters, ourRightAttributes, ourLeftAttributes, ourStartAttributes, ourEndAttributes);
                return connected.contains(target);
            }
            case BASELINE: {
                HashSet<NlComponent> connected = DecoratorUtilities.getConnectedNlComponents(source, sisters, ourBottomAttributes, ourTopAttributes, ourBaselineAttributes);
                return connected.contains(target);
            }
        }
        return false;
    }

    @SafeVarargs
    private static HashSet<String> getConnected(NlComponent c, List<NlComponent> sisters, ArrayList<String> ... list) {
        int lastCount;
        HashSet<String> set = new HashSet<String>();
        set.add(c.getId());
        do {
            lastCount = set.size();
            for (NlComponent sister : sisters) {
                for (int i = 0; i < list.length; ++i) {
                    String str = ConstraintComponentUtilities.getConnectionId(sister, "http://schemas.android.com/apk/res-auto", list[i]);
                    if (!set.contains(str)) continue;
                    set.add(sister.getId());
                }
            }
        } while (set.size() > lastCount);
        return set;
    }

    @SafeVarargs
    private static boolean isConnected(NlComponent component, ArrayList<String> ... list) {
        for (int i = 0; i < list.length; ++i) {
            int count = list[i].size();
            for (int k = 0; k < count; ++k) {
                if (null == component.getLiveAttribute("http://schemas.android.com/apk/res-auto", list[i].get(k))) continue;
                return true;
            }
        }
        return false;
    }

    static boolean useLeftRight(NlComponent component) {
        if (ConstraintComponentUtilities.isConnected(component, ourStartAttributes, ourEndAttributes)) {
            return false;
        }
        return ConstraintComponentUtilities.isConnected(component, ourLeftAttributes, ourRightAttributes);
    }

    static {
        ourLayoutUriToPrefix = new HashMap();
        ourLayoutUriToPrefix.put("http://schemas.android.com/apk/res/android", "android:");
        ourLayoutUriToPrefix.put("http://schemas.android.com/apk/res-auto", "app:");
        ourLayoutAttributes = new ArrayList();
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_width"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_height"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_marginStart"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_marginEnd"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_marginLeft"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_marginRight"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_marginTop"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res/android", (Object)"layout_marginBottom"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintEnd_toStartOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintEnd_toEndOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintStart_toStartOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintStart_toEndOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintLeft_toLeftOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintLeft_toRightOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintRight_toLeftOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintRight_toRightOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintTop_toTopOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintTop_toBottomOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintBottom_toTopOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintBottom_toBottomOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintBaseline_toBaselineOf"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintHorizontal_bias"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintVertical_bias"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintHorizontal_chainStyle"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintVertical_chainStyle"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintHorizontal_weight"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintVertical_weight"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintDimensionRatio"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"horizontal"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"vertical"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_goneMarginStart"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_goneMarginEnd"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_goneMarginLeft"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_goneMarginRight"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_goneMarginTop"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_goneMarginBottom"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintWidth_default"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintHeight_default"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_minWidth"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_minHeight"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_maxWidth"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_maxHeight"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_minWidth"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/tools", (Object)"layout_editor_absoluteX"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/tools", (Object)"layout_editor_absoluteY"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintGuide_begin"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintGuide_end"));
        ourLayoutAttributes.add((Pair<String, String>)Pair.of((Object)"http://schemas.android.com/apk/res-auto", (Object)"layout_constraintGuide_percent"));
        ourConstraintAttributes = new HashMap();
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.LEFT), (Object)((Object)AnchorTarget.Type.LEFT)), "layout_constraintLeft_toLeftOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.LEFT), (Object)((Object)AnchorTarget.Type.RIGHT)), "layout_constraintLeft_toRightOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.RIGHT), (Object)((Object)AnchorTarget.Type.LEFT)), "layout_constraintRight_toLeftOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.RIGHT), (Object)((Object)AnchorTarget.Type.RIGHT)), "layout_constraintRight_toRightOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.TOP), (Object)((Object)AnchorTarget.Type.TOP)), "layout_constraintTop_toTopOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.TOP), (Object)((Object)AnchorTarget.Type.BOTTOM)), "layout_constraintTop_toBottomOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.BOTTOM), (Object)((Object)AnchorTarget.Type.TOP)), "layout_constraintBottom_toTopOf");
        ourConstraintAttributes.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.BOTTOM), (Object)((Object)AnchorTarget.Type.BOTTOM)), "layout_constraintBottom_toBottomOf");
        ourLTRConvertedAttributes = new HashMap();
        ourLTRConstraintAnchorsToMargin = new HashMap();
        ourLTRMapSideToTargetAnchors = new HashMap();
        ourLTRConvertedAttributes.put("layout_constraintLeft_toLeftOf", "layout_constraintStart_toStartOf");
        ourLTRConvertedAttributes.put("layout_constraintLeft_toRightOf", "layout_constraintStart_toEndOf");
        ourLTRConvertedAttributes.put("layout_constraintRight_toLeftOf", "layout_constraintEnd_toStartOf");
        ourLTRConvertedAttributes.put("layout_constraintRight_toRightOf", "layout_constraintEnd_toEndOf");
        ourLTRConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.LEFT), (Object)((Object)AnchorTarget.Type.LEFT)), "layout_marginStart");
        ourLTRConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.LEFT), (Object)((Object)AnchorTarget.Type.RIGHT)), "layout_marginStart");
        ourLTRConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.RIGHT), (Object)((Object)AnchorTarget.Type.LEFT)), "layout_marginEnd");
        ourLTRConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.RIGHT), (Object)((Object)AnchorTarget.Type.RIGHT)), "layout_marginEnd");
        ourLTRMapSideToTargetAnchors.put("layout_constraintLeft_toLeftOf", AnchorTarget.Type.LEFT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintLeft_toRightOf", AnchorTarget.Type.RIGHT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintRight_toLeftOf", AnchorTarget.Type.LEFT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintRight_toRightOf", AnchorTarget.Type.RIGHT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintTop_toTopOf", AnchorTarget.Type.TOP);
        ourLTRMapSideToTargetAnchors.put("layout_constraintTop_toBottomOf", AnchorTarget.Type.BOTTOM);
        ourLTRMapSideToTargetAnchors.put("layout_constraintBottom_toTopOf", AnchorTarget.Type.TOP);
        ourLTRMapSideToTargetAnchors.put("layout_constraintBottom_toBottomOf", AnchorTarget.Type.BOTTOM);
        ourLTRMapSideToTargetAnchors.put("layout_constraintBaseline_toBaselineOf", AnchorTarget.Type.BASELINE);
        ourLTRMapSideToTargetAnchors.put("layout_constraintStart_toStartOf", AnchorTarget.Type.LEFT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintStart_toEndOf", AnchorTarget.Type.RIGHT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintEnd_toStartOf", AnchorTarget.Type.LEFT);
        ourLTRMapSideToTargetAnchors.put("layout_constraintEnd_toEndOf", AnchorTarget.Type.RIGHT);
        ourRTLConvertedAttributes = new HashMap();
        ourRTLConstraintAnchorsToMargin = new HashMap();
        ourRTLMapSideToTargetAnchors = new HashMap();
        ourRTLConvertedAttributes.put("layout_constraintLeft_toLeftOf", "layout_constraintEnd_toEndOf");
        ourRTLConvertedAttributes.put("layout_constraintLeft_toRightOf", "layout_constraintEnd_toStartOf");
        ourRTLConvertedAttributes.put("layout_constraintRight_toLeftOf", "layout_constraintStart_toEndOf");
        ourRTLConvertedAttributes.put("layout_constraintRight_toRightOf", "layout_constraintStart_toStartOf");
        ourRTLConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.LEFT), (Object)((Object)AnchorTarget.Type.LEFT)), "layout_marginEnd");
        ourRTLConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.LEFT), (Object)((Object)AnchorTarget.Type.RIGHT)), "layout_marginEnd");
        ourRTLConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.RIGHT), (Object)((Object)AnchorTarget.Type.LEFT)), "layout_marginStart");
        ourRTLConstraintAnchorsToMargin.put((Pair<AnchorTarget.Type, AnchorTarget.Type>)Pair.of((Object)((Object)AnchorTarget.Type.RIGHT), (Object)((Object)AnchorTarget.Type.RIGHT)), "layout_marginStart");
        ourRTLMapSideToTargetAnchors.put("layout_constraintLeft_toLeftOf", AnchorTarget.Type.LEFT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintLeft_toRightOf", AnchorTarget.Type.RIGHT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintRight_toLeftOf", AnchorTarget.Type.LEFT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintRight_toRightOf", AnchorTarget.Type.RIGHT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintTop_toTopOf", AnchorTarget.Type.TOP);
        ourRTLMapSideToTargetAnchors.put("layout_constraintTop_toBottomOf", AnchorTarget.Type.BOTTOM);
        ourRTLMapSideToTargetAnchors.put("layout_constraintBottom_toTopOf", AnchorTarget.Type.TOP);
        ourRTLMapSideToTargetAnchors.put("layout_constraintBottom_toBottomOf", AnchorTarget.Type.BOTTOM);
        ourRTLMapSideToTargetAnchors.put("layout_constraintBaseline_toBaselineOf", AnchorTarget.Type.BASELINE);
        ourRTLMapSideToTargetAnchors.put("layout_constraintStart_toStartOf", AnchorTarget.Type.RIGHT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintStart_toEndOf", AnchorTarget.Type.LEFT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintEnd_toStartOf", AnchorTarget.Type.RIGHT);
        ourRTLMapSideToTargetAnchors.put("layout_constraintEnd_toEndOf", AnchorTarget.Type.LEFT);
        ourPotentialAttributes = new HashMap();
        ourPotentialAttributes.put(AnchorTarget.Type.LEFT, (Pair<String, String>)Pair.of((Object)"layout_constraintLeft_toLeftOf", (Object)"layout_constraintLeft_toRightOf"));
        ourPotentialAttributes.put(AnchorTarget.Type.RIGHT, (Pair<String, String>)Pair.of((Object)"layout_constraintRight_toLeftOf", (Object)"layout_constraintRight_toRightOf"));
        ourPotentialAttributes.put(AnchorTarget.Type.TOP, (Pair<String, String>)Pair.of((Object)"layout_constraintTop_toTopOf", (Object)"layout_constraintTop_toBottomOf"));
        ourPotentialAttributes.put(AnchorTarget.Type.BOTTOM, (Pair<String, String>)Pair.of((Object)"layout_constraintBottom_toTopOf", (Object)"layout_constraintBottom_toBottomOf"));
        ourPotentialLTRAttributes = new HashMap();
        ourPotentialLTRAttributes.put(AnchorTarget.Type.LEFT, (Pair<String, String>)Pair.of((Object)"layout_constraintStart_toStartOf", (Object)"layout_constraintStart_toEndOf"));
        ourPotentialLTRAttributes.put(AnchorTarget.Type.RIGHT, (Pair<String, String>)Pair.of((Object)"layout_constraintEnd_toStartOf", (Object)"layout_constraintEnd_toEndOf"));
        ourPotentialRTLAttributes = new HashMap();
        ourPotentialRTLAttributes.put(AnchorTarget.Type.LEFT, (Pair<String, String>)Pair.of((Object)"layout_constraintEnd_toEndOf", (Object)"layout_constraintEnd_toStartOf"));
        ourPotentialRTLAttributes.put(AnchorTarget.Type.RIGHT, (Pair<String, String>)Pair.of((Object)"layout_constraintStart_toEndOf", (Object)"layout_constraintStart_toStartOf"));
        ourConstraintLayoutAttributesToClear = new String[]{"layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf", "layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf", "layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", "layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf", "layout_constraintBaseline_toBaselineOf", "layout_constraintStart_toEndOf", "layout_constraintStart_toStartOf", "layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf", "layout_goneMarginLeft", "layout_goneMarginTop", "layout_goneMarginRight", "layout_goneMarginBottom", "layout_goneMarginStart", "layout_goneMarginEnd", "layout_constraintHorizontal_bias", "layout_constraintVertical_bias", "layout_constraintWidth_default", "layout_constraintHeight_default", "layout_constraintWidth_min", "layout_constraintWidth_max", "layout_constraintHeight_min", "layout_constraintHeight_max", "layout_constraintLeft_creator", "layout_constraintTop_creator", "layout_constraintRight_creator", "layout_constraintBottom_creator", "layout_constraintBaseline_creator", "layout_constraintDimensionRatio", "layout_constraintHorizontal_weight", "layout_constraintVertical_weight", "layout_constraintHorizontal_chainStyle", "layout_constraintVertical_chainStyle"};
        ourLayoutAttributesToClear = new String[]{"layout_margin", "layout_marginLeft", "layout_marginStart", "layout_marginRight", "layout_marginEnd", "layout_marginTop", "layout_marginBottom", "layout_marginStart"};
        ourReciprocalAttributes = new HashMap();
        ourReciprocalAttributes.put("layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf");
        ourReciprocalAttributes.put("layout_constraintLeft_toRightOf", "layout_constraintLeft_toLeftOf");
        ourReciprocalAttributes.put("layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf");
        ourReciprocalAttributes.put("layout_constraintRight_toRightOf", "layout_constraintRight_toLeftOf");
        ourReciprocalAttributes.put("layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf");
        ourReciprocalAttributes.put("layout_constraintTop_toBottomOf", "layout_constraintTop_toTopOf");
        ourReciprocalAttributes.put("layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf");
        ourReciprocalAttributes.put("layout_constraintBottom_toBottomOf", "layout_constraintBottom_toTopOf");
        ourReciprocalAttributes.put("layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf");
        ourReciprocalAttributes.put("layout_constraintStart_toEndOf", "layout_constraintStart_toStartOf");
        ourReciprocalAttributes.put("layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf");
        ourReciprocalAttributes.put("layout_constraintEnd_toEndOf", "layout_constraintEnd_toStartOf");
        ourOtherSideAttributes = new ImmutableMap.Builder().put((Object)"layout_constraintLeft_toLeftOf", (Object)"layout_constraintRight_toRightOf").put((Object)"layout_constraintRight_toRightOf", (Object)"layout_constraintLeft_toLeftOf").put((Object)"layout_constraintEnd_toEndOf", (Object)"layout_constraintStart_toStartOf").put((Object)"layout_constraintStart_toStartOf", (Object)"layout_constraintEnd_toEndOf").put((Object)"layout_constraintTop_toTopOf", (Object)"layout_constraintBottom_toBottomOf").put((Object)"layout_constraintBottom_toBottomOf", (Object)"layout_constraintTop_toTopOf").build();
        ourMapMarginAttributes = new HashMap();
        ourMapMarginAttributes.put("layout_constraintLeft_toLeftOf", "layout_marginLeft");
        ourMapMarginAttributes.put("layout_constraintLeft_toRightOf", "layout_marginLeft");
        ourMapMarginAttributes.put("layout_constraintRight_toLeftOf", "layout_marginRight");
        ourMapMarginAttributes.put("layout_constraintRight_toRightOf", "layout_marginRight");
        ourMapMarginAttributes.put("layout_constraintTop_toTopOf", "layout_marginTop");
        ourMapMarginAttributes.put("layout_constraintTop_toBottomOf", "layout_marginTop");
        ourMapMarginAttributes.put("layout_constraintBottom_toTopOf", "layout_marginBottom");
        ourMapMarginAttributes.put("layout_constraintBottom_toBottomOf", "layout_marginBottom");
        ourMapMarginAttributes.put("layout_constraintStart_toStartOf", "layout_marginStart");
        ourMapMarginAttributes.put("layout_constraintStart_toEndOf", "layout_marginStart");
        ourMapMarginAttributes.put("layout_constraintEnd_toStartOf", "layout_marginEnd");
        ourMapMarginAttributes.put("layout_constraintEnd_toEndOf", "layout_marginEnd");
        ourMapSideToOriginAnchors = new HashMap();
        ourMapSideToOriginAnchors.put("layout_constraintLeft_toLeftOf", AnchorTarget.Type.LEFT);
        ourMapSideToOriginAnchors.put("layout_constraintLeft_toRightOf", AnchorTarget.Type.LEFT);
        ourMapSideToOriginAnchors.put("layout_constraintRight_toLeftOf", AnchorTarget.Type.RIGHT);
        ourMapSideToOriginAnchors.put("layout_constraintRight_toRightOf", AnchorTarget.Type.RIGHT);
        ourMapSideToOriginAnchors.put("layout_constraintTop_toTopOf", AnchorTarget.Type.TOP);
        ourMapSideToOriginAnchors.put("layout_constraintTop_toBottomOf", AnchorTarget.Type.TOP);
        ourMapSideToOriginAnchors.put("layout_constraintBottom_toTopOf", AnchorTarget.Type.BOTTOM);
        ourMapSideToOriginAnchors.put("layout_constraintBottom_toBottomOf", AnchorTarget.Type.BOTTOM);
        ourMapSideToOriginAnchors.put("layout_constraintBaseline_toBaselineOf", AnchorTarget.Type.BASELINE);
        ourLeftAttributes = new ArrayList();
        ourLeftAttributes.add("layout_constraintLeft_toLeftOf");
        ourLeftAttributes.add("layout_constraintLeft_toRightOf");
        ourTopAttributes = new ArrayList();
        ourTopAttributes.add("layout_constraintTop_toTopOf");
        ourTopAttributes.add("layout_constraintTop_toBottomOf");
        ourRightAttributes = new ArrayList();
        ourRightAttributes.add("layout_constraintRight_toLeftOf");
        ourRightAttributes.add("layout_constraintRight_toRightOf");
        ourBottomAttributes = new ArrayList();
        ourBottomAttributes.add("layout_constraintBottom_toTopOf");
        ourBottomAttributes.add("layout_constraintBottom_toBottomOf");
        ourBaselineAttributes = new ArrayList();
        ourBaselineAttributes.add("layout_constraintBaseline_toBaselineOf");
        ourStartAttributes = new ArrayList();
        ourStartAttributes.add("layout_constraintStart_toStartOf");
        ourStartAttributes.add("layout_constraintStart_toEndOf");
        ourEndAttributes = new ArrayList();
        ourEndAttributes.add("layout_constraintEnd_toStartOf");
        ourEndAttributes.add("layout_constraintEnd_toEndOf");
        ourHorizontalAttributes = new ArrayList();
        ourHorizontalAttributes.add("layout_constraintLeft_toLeftOf");
        ourHorizontalAttributes.add("layout_constraintLeft_toRightOf");
        ourHorizontalAttributes.add("layout_constraintRight_toLeftOf");
        ourHorizontalAttributes.add("layout_constraintRight_toRightOf");
        ourHorizontalAttributes.add("layout_constraintStart_toStartOf");
        ourHorizontalAttributes.add("layout_constraintStart_toEndOf");
        ourHorizontalAttributes.add("layout_constraintEnd_toStartOf");
        ourHorizontalAttributes.add("layout_constraintEnd_toEndOf");
        ourVerticalAttributes = new ArrayList();
        ourVerticalAttributes.add("layout_constraintTop_toTopOf");
        ourVerticalAttributes.add("layout_constraintTop_toBottomOf");
        ourVerticalAttributes.add("layout_constraintBottom_toTopOf");
        ourVerticalAttributes.add("layout_constraintBottom_toBottomOf");
        ourVerticalAttributes.add("layout_constraintBaseline_toBaselineOf");
        ATTRIB_MATRIX = new String[][]{{"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", null, null, null}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf", null, null, null}, {null, null, "layout_constraintStart_toStartOf", "layout_constraintStart_toEndOf", null}, {null, null, "layout_constraintEnd_toStartOf", "layout_constraintEnd_toEndOf", null}, {null, null, null, null, "layout_constraintBaseline_toBaselineOf"}};
        ATTRIB_CLEAR = new String[][]{{"layout_constraintTop_toTopOf", "layout_constraintTop_toBottomOf", "layout_constraintBaseline_toBaselineOf"}, {"layout_constraintBottom_toTopOf", "layout_constraintBottom_toBottomOf", "layout_constraintBaseline_toBaselineOf"}, {"layout_constraintLeft_toLeftOf", "layout_constraintLeft_toRightOf"}, {"layout_constraintRight_toLeftOf", "layout_constraintRight_toRightOf", "layout_toStartOf"}, {"layout_constraintBaseline_toBaselineOf"}};
        ATTRIB_MARGIN = new String[]{"layout_marginTop", "layout_marginBottom", "layout_marginStart", "layout_marginEnd"};
        ATTRIB_MARGIN_LR = new String[]{null, null, "layout_marginLeft", "layout_marginRight"};
    }
}

