/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.handlers;

import android.view.View;
import android.view.ViewGroup;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.api.ScrollHandler;
import com.android.tools.idea.uibuilder.api.ScrollViewScrollHandler;
import com.android.tools.idea.uibuilder.api.ViewEditor;
import com.android.tools.idea.uibuilder.api.actions.ViewAction;
import com.android.tools.idea.uibuilder.handlers.ScrollViewHandler;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HorizontalScrollViewHandler
extends ScrollViewHandler {
    @Override
    @NotNull
    public List<String> getInspectorProperties() {
        return ImmutableList.of((Object)"fillViewport");
    }

    @Override
    public void onChildInserted(@NotNull NlComponent parent, @NotNull NlComponent child, @NotNull InsertType insertType) {
        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_width", "wrap_content");
        child.setAttribute("http://schemas.android.com/apk/res/android", "layout_height", "match_parent");
    }

    @Override
    @Nullable
    public ScrollHandler createScrollHandler(@NotNull ViewEditor editor, @NotNull NlComponent component) {
        ViewGroup viewGroup = HorizontalScrollViewHandler.getViewGroupFromComponent(component);
        if (viewGroup == null) {
            return null;
        }
        int maxScrollableWidth = ScrollViewScrollHandler.getMaxScrollable(viewGroup, View::getWidth, View::getMeasuredWidth);
        if (maxScrollableWidth > 0) {
            return ScrollViewScrollHandler.createHandler(viewGroup, maxScrollableWidth, 10, ScrollViewScrollHandler.Orientation.HORIZONTAL);
        }
        return null;
    }

    @Override
    public void addToolbarActions(@NotNull List<ViewAction> actions2) {
        actions2.add(new ScrollViewHandler.ToggleRenderModeAction());
    }
}

