/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssuePanelService;
import com.android.tools.idea.common.error.IssueProviderListener;
import com.android.tools.idea.uibuilder.editor.ResourceFileTrafficLightRendererKt;
import com.intellij.codeInsight.daemon.impl.ErrorStripeUpdateManager;
import com.intellij.codeInsight.daemon.impl.TrafficLightRenderer;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.EditorMarkupModelImpl;
import com.intellij.openapi.editor.markup.AnalyzerStatus;
import com.intellij.openapi.editor.markup.StatusItem;
import com.intellij.openapi.editor.markup.UIController;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.util.messages.MessageBusConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0015\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u001cB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\nH\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016J\u0012\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0014R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR:\u0010\r\u001a.\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f \u0010*\u0015\u0012\f\u0012\n \u0010*\u0004\u0018\u00010\u000f0\u000f0\u0012\u00a2\u0006\u0002\b\u00110\u000e\u00a2\u0006\u0002\b\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/uibuilder/editor/ResourceFileTrafficLightRender;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer;", "file", "Lcom/intellij/psi/PsiFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/openapi/editor/Editor;)V", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "errorCountArray", "", "getFile", "()Lcom/intellij/psi/PsiFile;", "severities", "", "Lcom/intellij/lang/annotation/HighlightSeverity;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "createUIController", "Lcom/intellij/openapi/editor/markup/UIController;", "getErrorCounts", "getStatus", "Lcom/intellij/openapi/editor/markup/AnalyzerStatus;", "refresh", "", "editorMarkupModel", "Lcom/intellij/openapi/editor/impl/EditorMarkupModelImpl;", "ResourceFileUIController", "intellij.android.designer"})
public final class ResourceFileTrafficLightRender
extends TrafficLightRenderer {
    @NotNull
    private final PsiFile file;
    @NotNull
    private final Editor editor;
    @NotNull
    private final List<HighlightSeverity> severities;
    @NotNull
    private final int[] errorCountArray;

    public ResourceFileTrafficLightRender(@NotNull PsiFile file2, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        super(file2.getProject(), editor.getDocument());
        this.file = file2;
        this.editor = editor;
        List list = this.getSeverityRegistrar().getAllSeverities();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"severityRegistrar.allSeverities");
        this.severities = list;
        this.errorCountArray = new int[this.severities.size()];
        MessageBusConnection messageBusConnection = this.getProject().getMessageBus().connect((Disposable)this);
        Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect(this)");
        MessageBusConnection messageBusConnection2 = messageBusConnection;
        messageBusConnection2.subscribe(IssueProviderListener.TOPIC, (Object)new IssueProviderListener(){

            @Override
            public final void issueUpdated(@NotNull Object object, @NotNull List<? extends Issue> list) {
                Intrinsics.checkNotNullParameter((Object)object, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter(list, (String)"<anonymous parameter 1>");
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public final void run() {
                        if (!this.getProject().isDisposed()) {
                            ErrorStripeUpdateManager.getInstance((Project)this.getProject()).repaintErrorStripePanel(this.getEditor());
                        }
                    }
                });
            }
        });
    }

    @NotNull
    public final PsiFile getFile() {
        return this.file;
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    protected void refresh(@Nullable EditorMarkupModelImpl editorMarkupModel) {
        super.refresh(editorMarkupModel);
        if (editorMarkupModel == null) {
            return;
        }
        ArraysKt.fill$default((int[])this.errorCountArray, (int)0, (int)0, (int)0, (int)6, null);
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        List<Issue> list = IssuePanelService.Companion.getInstance(project).getSharedPanelIssues();
        if (list == null) {
            return;
        }
        List<Issue> issues = list;
        Iterable $this$forEach$iv = issues;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Issue it = (Issue)element$iv;
            boolean bl = false;
            int index = this.severities.indexOf(it.getSeverity());
            if (index <= -1) continue;
            int[] nArray = this.errorCountArray;
            int n = nArray[index];
            nArray[index] = n + 1;
        }
    }

    @NotNull
    public int[] getErrorCounts() {
        return this.errorCountArray;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public AnalyzerStatus getStatus() {
        void $this$mapTo$iv$iv;
        int it;
        Iterable $this$filterNotTo$iv$iv;
        AnalyzerStatus analyzerStatus = super.getStatus();
        Intrinsics.checkNotNullExpressionValue((Object)analyzerStatus, (String)"super.getStatus()");
        AnalyzerStatus status2 = analyzerStatus;
        Iterable $this$filterNot$iv = (Iterable)RangesKt.reversed((IntProgression)((IntProgression)ArraysKt.getIndices((int[])this.errorCountArray)));
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            if (this.errorCountArray[it] == 0) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getSeverityRegistrar().getSeverityByIndex(it));
        }
        List nonZeroSeverities = (List)destination$iv$iv;
        List items = new ArrayList();
        List currentItems = status2.getExpandedStatus();
        if (currentItems.size() != nonZeroSeverities.size()) {
            return status2;
        }
        int n = currentItems.size();
        for (int index = 0; index < n; ++index) {
            StatusItem item = (StatusItem)currentItems.get(index);
            Icon icon2 = (Icon)ResourceFileTrafficLightRendererKt.access$getSEVERITY_TO_ICON$p().get(nonZeroSeverities.get(index));
            if (icon2 == null) {
                icon2 = item.getIcon();
            }
            Icon icon3 = icon2;
            items.add(new StatusItem(item.getText(), icon3, item.getDetailsText()));
        }
        status2.withExpandedStatus(items);
        return status2;
    }

    @NotNull
    protected UIController createUIController() {
        return (UIController)new ResourceFileUIController();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/uibuilder/editor/ResourceFileTrafficLightRender$ResourceFileUIController;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer$DefaultUIController;", "Lcom/intellij/codeInsight/daemon/impl/TrafficLightRenderer;", "(Lcom/android/tools/idea/uibuilder/editor/ResourceFileTrafficLightRender;)V", "toggleProblemsView", "", "intellij.android.designer"})
    public final class ResourceFileUIController
    extends TrafficLightRenderer.DefaultUIController {
        public ResourceFileUIController() {
            super((TrafficLightRenderer)ResourceFileTrafficLightRender.this);
        }

        public void toggleProblemsView() {
            Project project = ResourceFileTrafficLightRender.this.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            IssuePanelService issuePanelService = IssuePanelService.Companion.getInstance(project);
            IssuePanelService.setSharedIssuePanelVisibility$default(issuePanelService, !issuePanelService.isShowingIssuePanel(null), null, 2, null);
        }
    }
}

