/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.editor;

import com.android.resources.ResourceUrl;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.uibuilder.editor.AnimatedSelectorModel;
import com.android.tools.idea.uibuilder.editor.EmptyModelUpdater;
import com.android.tools.idea.util.FileExtensions;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import java.io.Closeable;
import java.io.File;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B;\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u001c\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J>\u0010\u001b\u001a\u00020\u00162\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\b\u0010\u001d\u001a\u00020\u0003H\u0002J\u0006\u0010\u001e\u001a\u00020\u0016J\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00120 J\u0010\u0010!\u001a\u0004\u0018\u00010\u00122\u0006\u0010\"\u001a\u00020\u0012J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020\u0013H\u0002J\u000e\u0010%\u001a\u00020&2\u0006\u0010\"\u001a\u00020\u0012R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/uibuilder/editor/AnimatedSelectorModel;", "", "originalFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "componentRegistrar", "Ljava/util/function/Consumer;", "Lcom/android/tools/idea/common/model/NlComponent;", "config", "Lcom/android/tools/idea/configurations/Configuration;", "(Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/Disposable;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/android/facet/AndroidFacet;Ljava/util/function/Consumer;Lcom/android/tools/idea/configurations/Configuration;)V", "animationTags", "", "", "Lcom/intellij/psi/xml/XmlTag;", "currentOption", "nlModelOfTempFile", "Lcom/android/tools/idea/common/model/NlModel;", "tempModelFile", "createIdAnimationMap", "xmlFile", "Lcom/intellij/psi/xml/XmlFile;", "createModelWithFile", "file", "createTempAnimatedSelectorFile", "getNlModel", "getPreviewOption", "", "getPreviewOptionTagName", "option", "getTransitionContent", "embeddedAnimationTag", "setPreviewOption", "", "intellij.android.designer"})
public final class AnimatedSelectorModel {
    @NotNull
    private Map<String, ? extends XmlTag> animationTags;
    @NotNull
    private final VirtualFile tempModelFile;
    @NotNull
    private final NlModel nlModelOfTempFile;
    @Nullable
    private String currentOption;

    public AnimatedSelectorModel(final @NotNull VirtualFile originalFile, @NotNull Disposable parentDisposable, @NotNull Project project, @NotNull AndroidFacet facet, @NotNull Consumer<NlComponent> componentRegistrar2, @NotNull Configuration config) {
        Intrinsics.checkNotNullParameter((Object)originalFile, (String)"originalFile");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter(componentRegistrar2, (String)"componentRegistrar");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        PsiFile psiFile2 = PhysicalFileSystemUtilsKt.toPsiFile((VirtualFile)originalFile, (Project)project);
        Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        final XmlFile xmlFile = (XmlFile)psiFile2;
        this.tempModelFile = this.createTempAnimatedSelectorFile();
        this.nlModelOfTempFile = this.createModelWithFile(parentDisposable, project, facet, componentRegistrar2, config, this.tempModelFile);
        this.animationTags = this.createIdAnimationMap(xmlFile);
        VirtualFileManager.getInstance().addVirtualFileListener(new VirtualFileListener(){

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (Intrinsics.areEqual((Object)event.getFile(), (Object)originalFile)) {
                    animationTags = this.createIdAnimationMap(xmlFile);
                    String string = currentOption;
                    if (string == null) {
                        string = "Select Transition...";
                    }
                    this.setPreviewOption(string);
                }
            }
        });
        this.setPreviewOption("Select Transition...");
    }

    private final Map<String, XmlTag> createIdAnimationMap(XmlFile xmlFile) {
        XmlTag xmlTag = xmlFile.getRootTag();
        Intrinsics.checkNotNull((Object)xmlTag);
        XmlTag rootTag = xmlTag;
        XmlTag[] xmlTagArray = rootTag.getSubTags();
        Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray, (String)"rootTag.subTags");
        List transitions2 = SequencesKt.toList((Sequence)SequencesKt.filter((Sequence)ArraysKt.asSequence((Object[])xmlTagArray), (Function1)createIdAnimationMap.transitions.1.INSTANCE));
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Select Transition...", (Object)rootTag)};
        Map maps = MapsKt.mutableMapOf((Pair[])pairArray);
        for (XmlTag transition : transitions2) {
            XmlTag animationTag;
            Object object;
            String toId;
            String fromId;
            block2: {
                Object object2 = transition.getAttribute("fromId", "http://schemas.android.com/apk/res/android");
                if (object2 == null || (object2 = object2.getValue()) == null) continue;
                Object fromIdAttribute = object2;
                Object object3 = transition.getAttribute("toId", "http://schemas.android.com/apk/res/android");
                if (object3 == null || (object3 = object3.getValue()) == null) continue;
                Object toIdAttribute = object3;
                ResourceUrl resourceUrl = ResourceUrl.parse((String)fromIdAttribute);
                if ((resourceUrl != null ? resourceUrl.name : null) == null) continue;
                fromId = fromId;
                ResourceUrl resourceUrl2 = ResourceUrl.parse((String)toIdAttribute);
                if ((resourceUrl2 != null ? resourceUrl2.name : null) == null) continue;
                toId = toId;
                XmlTag[] xmlTagArray2 = transition.getSubTags();
                Intrinsics.checkNotNullExpressionValue((Object)xmlTagArray2, (String)"transition.subTags");
                Object[] $this$firstOrNull$iv = xmlTagArray2;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    XmlTag it = (XmlTag)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual((Object)it.getName(), (Object)"animated-vector") || Intrinsics.areEqual((Object)it.getName(), (Object)"animation-list"))) continue;
                    object = element$iv;
                    break block2;
                }
                object = null;
            }
            if ((XmlTag)object == null) continue;
            String transitionId = fromId + " to " + toId;
            maps.put(transitionId, animationTag);
        }
        return maps;
    }

    private final NlModel createModelWithFile(Disposable parentDisposable, Project project, AndroidFacet facet, Consumer<NlComponent> componentRegistrar2, Configuration config, VirtualFile file2) {
        PsiFile psiFile2 = PhysicalFileSystemUtilsKt.toPsiFile((VirtualFile)file2, (Project)project);
        Intrinsics.checkNotNull((Object)psiFile2, (String)"null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
        XmlFile psiXmlFile = (XmlFile)psiFile2;
        psiXmlFile.putUserData(ModuleUtilCore.KEY_MODULE, (Object)facet.getModule());
        return NlModel.builder(facet, file2, config).withParentDisposable(parentDisposable).withComponentRegistrar(componentRegistrar2).withModelUpdater(EmptyModelUpdater.INSTANCE).withXmlProvider(new BiFunction(psiXmlFile){
            final /* synthetic */ XmlFile $psiXmlFile;
            {
                this.$psiXmlFile = $psiXmlFile;
            }

            @NotNull
            public final XmlFile apply(@NotNull Project project, @NotNull VirtualFile virtualFile2) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"<anonymous parameter 0>");
                Intrinsics.checkNotNullParameter((Object)virtualFile2, (String)"<anonymous parameter 1>");
                return this.$psiXmlFile;
            }
        }).build();
    }

    private final VirtualFile createTempAnimatedSelectorFile() {
        ApplicationManager.getApplication().assertWriteAccessAllowed();
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String fileName = "drawable_" + StringsKt.replace$default((String)string, (String)"-", (String)"_", (boolean)false, (int)4, null);
        VirtualFile virtualFile2 = PhysicalFileSystemUtilsKt.toVirtualFile((File)new File(FileUtilRt.getTempDirectory()));
        Intrinsics.checkNotNull((Object)virtualFile2);
        VirtualFile systemTempDir = virtualFile2;
        VirtualFile virtualFile3 = systemTempDir.findChild("drawable-temp");
        if (virtualFile3 == null) {
            virtualFile3 = systemTempDir.createChildDirectory((Object)this, "drawable-temp");
        }
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile3, (String)"systemTempDir.findChild(\u2026ANIMATED_SELECTOR_FOLDER)");
        VirtualFile tempDrawableDir = virtualFile3;
        File file2 = FileUtilRt.createTempFile((File)FileExtensions.toIoFile((VirtualFile)tempDrawableDir), (String)fileName, (String)".xml", (boolean)true, (boolean)true);
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"createTempFile(tempDrawa\u2026Name, \".xml\", true, true)");
        File physicalChildInTempDrawableFile = file2;
        VirtualFile virtualFile4 = FileExtensions.toVirtualFile((File)physicalChildInTempDrawableFile, (boolean)true);
        Intrinsics.checkNotNull((Object)virtualFile4);
        return virtualFile4;
    }

    private final String getTransitionContent(XmlTag embeddedAnimationTag) {
        String originalText = embeddedAnimationTag.getText();
        String string = embeddedAnimationTag.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"embeddedAnimationTag.name");
        String tag = string;
        Intrinsics.checkNotNullExpressionValue((Object)originalText, (String)"originalText");
        return StringsKt.substringBefore$default((String)originalText, (String)tag, null, (int)2, null) + tag + " xmlns:android=\"http://schemas.android.com/apk/res/android\" " + StringsKt.substringAfter$default((String)originalText, (String)tag, null, (int)2, null);
    }

    @NotNull
    public final NlModel getNlModel() {
        return this.nlModelOfTempFile;
    }

    public final void setPreviewOption(@NotNull String option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        if (Intrinsics.areEqual((Object)this.currentOption, (Object)option)) {
            return;
        }
        this.currentOption = option;
        XmlTag xmlTag = this.animationTags.get(option);
        if (xmlTag == null) {
            return;
        }
        XmlTag tag = xmlTag;
        WriteCommandAction.runWriteCommandAction((Project)this.nlModelOfTempFile.getProject(), (Runnable)new Runnable(this, tag){
            final /* synthetic */ AnimatedSelectorModel this$0;
            final /* synthetic */ XmlTag $tag;
            {
                this.this$0 = $receiver;
                this.$tag = $tag;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public final void run() {
                OutputStream outputStream = AnimatedSelectorModel.access$getTempModelFile$p(this.this$0).getOutputStream((Object)this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"tempModelFile.getOutputStream(this)");
                Closeable closeable = outputStream;
                Object object = Charsets.UTF_8;
                closeable = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
                object = this.this$0;
                XmlTag xmlTag = this.$tag;
                Throwable throwable = null;
                try {
                    OutputStreamWriter it = (OutputStreamWriter)closeable;
                    boolean bl = false;
                    it.write(AnimatedSelectorModel.access$getTransitionContent((AnimatedSelectorModel)object, xmlTag));
                    Unit unit2 = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        });
    }

    @Nullable
    public final String getPreviewOptionTagName(@NotNull String option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        XmlTag xmlTag = this.animationTags.get(option);
        return xmlTag != null ? xmlTag.getName() : null;
    }

    @NotNull
    public final Set<String> getPreviewOption() {
        return this.animationTags.keySet();
    }

    public static final /* synthetic */ VirtualFile access$getTempModelFile$p(AnimatedSelectorModel $this) {
        return $this.tempModelFile;
    }

    public static final /* synthetic */ String access$getTransitionContent(AnimatedSelectorModel $this, XmlTag embeddedAnimationTag) {
        return $this.getTransitionContent(embeddedAnimationTag);
    }
}

