/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.api;

import com.android.ide.common.rendering.api.RenderResources;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.rendering.api.ViewInfo;
import com.android.ide.common.resources.ResourceResolver;
import com.android.resources.ResourceType;
import com.android.sdklib.AndroidVersion;
import com.android.tools.idea.common.api.InsertType;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.FloatResources;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.ui.resourcechooser.util.ResourceChooserHelperKt;
import com.android.tools.idea.ui.resourcemanager.ResourcePickerDialog;
import com.android.tools.idea.uibuilder.editor.LayoutNavigationManager;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.awt.Dimension;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.uipreview.ChooseClassDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ViewEditor {
    @Nullable
    public static Integer resolveDimensionPixelSize(@NotNull RenderResources resources, @NotNull String value2, @NotNull Configuration configuration) {
        FloatResources.TypedValue out;
        String resValue = IdeResourcesUtil.resolveStringValue((RenderResources)resources, (String)value2);
        if (FloatResources.parseFloatAttribute((String)resValue, (FloatResources.TypedValue)(out = new FloatResources.TypedValue()), (boolean)true)) {
            return FloatResources.TypedValue.complexToDimensionPixelSize((int)out.data, (Configuration)configuration);
        }
        return null;
    }

    public int dpToPx(int dp) {
        return Coordinates.dpToPx(this.getScene().getSceneManager(), (float)dp);
    }

    public int pxToDp(int px) {
        return Coordinates.pxToDp(this.getScene().getSceneManager(), px);
    }

    @Nullable
    public abstract AndroidVersion getCompileSdkVersion();

    @NotNull
    public abstract AndroidVersion getMinSdkVersion();

    @NotNull
    public abstract AndroidVersion getTargetSdkVersion();

    @NotNull
    public abstract Configuration getConfiguration();

    @NotNull
    public abstract NlModel getModel();

    @NotNull
    public abstract LayoutlibSceneManager getSceneBuilder();

    @NotNull
    public abstract Collection<ViewInfo> getRootViews();

    @Nullable
    public abstract CompletableFuture<Map<NlComponent, Dimension>> measureChildren(@NotNull NlComponent var1, @Nullable RenderTask.AttributeFilter var2);

    @Nullable
    public static String displayResourceInput(@NotNull NlModel model2, @NotNull EnumSet<ResourceType> types) {
        return ViewEditor.displayResourceInput(model2, "", types);
    }

    @Nullable
    public static String displayResourceInput(@NotNull NlModel model2, @NotNull EnumSet<ResourceType> types, boolean includeSampleData) {
        return ViewEditor.displayResourceInput(model2, "", types, includeSampleData);
    }

    @Nullable
    public static String displayResourceInput(@NotNull NlModel model2, @NotNull String title, @NotNull EnumSet<ResourceType> types) {
        return ViewEditor.displayResourceInput(model2, title, types, false);
    }

    @Nullable
    public static String displayResourceInput(@NotNull NlModel model2, @NotNull String title, @NotNull EnumSet<ResourceType> types, boolean includeSampleData) {
        String resource;
        ResourcePickerDialog dialog = ResourceChooserHelperKt.createResourcePickerDialog((String)(title.isEmpty() ? "Pick a Resource" : title), null, (AndroidFacet)model2.getFacet(), types, null, (boolean)false, (boolean)includeSampleData, (boolean)true, (VirtualFile)model2.getVirtualFile());
        dialog.show();
        if (dialog.isOK() && (resource = dialog.getResourceName()) != null && !resource.isEmpty()) {
            return resource;
        }
        return null;
    }

    @Nullable
    public static String displayClassInput(@NotNull NlModel model2, @NotNull String title, @NotNull Set<String> superTypes, @Nullable Predicate<String> filter2, @Nullable String currentValue) {
        Module module = model2.getModule();
        String[] superTypesArray = ArrayUtil.toStringArray(superTypes);
        Predicate psiFilter = ChooseClassDialog.getIsPublicAndUnrestrictedFilter();
        if (filter2 == null) {
            filter2 = ChooseClassDialog.getIsUserDefinedFilter();
        }
        psiFilter = psiFilter.and(ChooseClassDialog.qualifiedNameFilter((Predicate)filter2));
        return ChooseClassDialog.openDialog((Module)module, (String)title, (String)currentValue, psiFilter, (String[])superTypesArray);
    }

    @NotNull
    public abstract Scene getScene();

    public abstract boolean canInsertChildren(@NotNull NlComponent var1, @NotNull List<NlComponent> var2, int var3);

    public abstract void insertChildren(@NotNull NlComponent var1, @NotNull List<NlComponent> var2, int var3, @NotNull InsertType var4);

    public static void openResourceFile(@NotNull NlModel model2, @NotNull String resourceId) {
        ResourceValue resValue;
        Configuration config = model2.getConfiguration();
        ResourceResolver resourceResolver = config.getResourceResolver();
        VirtualFile file2 = IdeResourcesUtil.resolveLayout((RenderResources)resourceResolver, (ResourceValue)(resValue = resourceResolver.findResValue(resourceId, false)));
        if (file2 == null) {
            return;
        }
        LayoutNavigationManager.getInstance(config.getModule().getProject()).pushFile(model2.getVirtualFile(), file2);
    }

    public abstract boolean moduleDependsOnAppCompat();
}

