/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.tools.idea.uibuilder.api.ViewHandler;
import com.android.tools.idea.uibuilder.handlers.ViewHandlerManager;
import com.android.tools.idea.uibuilder.palette.Palette;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.project.Project;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.util.Consumer;
import com.intellij.util.textCompletion.TextFieldWithCompletion;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.jetbrains.android.dom.layout.AndroidLayoutUtil;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MorphPanel
extends JPanel {
    public static final String MORPH_DIALOG_NAME = "MorphPanel";
    private final AndroidFacet myFacet;
    private final Project myProject;
    private JBLabel myNewTagLabel;
    private TextFieldWithCompletion myNewTagText;
    private JPanel myRoot;
    private JButton myOkButton;
    private JList<Palette.Item> mySuggestionsList;
    private Consumer<String> myOkAction;
    @Nullable
    private Consumer<String> myNameChangeConsumer;

    public MorphPanel(@NotNull AndroidFacet facet, @NotNull Project project, @NotNull String oldTag, @NotNull List<String> tagSuggestions) {
        this.myFacet = facet;
        this.myProject = project;
        this.$$$setupUI$$$();
        this.setName(MORPH_DIALOG_NAME);
        this.setFocusable(true);
        this.myOkButton.addActionListener(e -> this.doOkAction());
        this.setupTextTagField(oldTag);
        this.setupButtonList(tagSuggestions, oldTag);
    }

    private void setupButtonList(List<String> suggestions, @NotNull String oldTag) {
        DefaultListModel<Palette.Item> model2 = new DefaultListModel<Palette.Item>();
        ViewHandlerManager manager = ViewHandlerManager.get(this.myProject);
        for (String tagSuggestion : suggestions) {
            ViewHandler handler = manager.getHandlerOrDefault(tagSuggestion);
            model2.addElement(new Palette.Item(tagSuggestion, handler));
        }
        this.mySuggestionsList.setModel(model2);
        this.mySuggestionsList.setSelectionMode(0);
        this.mySuggestionsList.setLayoutOrientation(2);
        this.mySuggestionsList.setCellRenderer((ListCellRenderer<Palette.Item>)SimpleListCellRenderer.create((label, value2, index) -> {
            String name = value2.getTagName();
            int i = name.lastIndexOf(46);
            if (i > -1 && i < name.length() - 1) {
                name = name.substring(i + 1);
            }
            label.setText(name);
            label.setIcon(value2.getIcon());
        }));
        this.mySuggestionsList.setBackground(this.getBackground().brighter());
        this.mySuggestionsList.setVisibleRowCount(5);
        int oldTagPos = suggestions.indexOf(oldTag);
        if (oldTagPos > -1) {
            this.mySuggestionsList.setSelectedIndex(oldTagPos);
        } else {
            this.myNewTagText.setText(suggestions.get(0));
            this.mySuggestionsList.setSelectedIndex(0);
        }
        this.mySuggestionsList.addListSelectionListener(e -> {
            String tag = this.mySuggestionsList.getSelectedValue().getTagName();
            this.myNewTagText.setText(tag);
        });
    }

    private void setupTextTagField(@NotNull String oldTag) {
        this.myNewTagText.addDocumentListener(this.createDocumentListener());
        this.myNewTagText.setText(oldTag);
        this.myNewTagText.registerKeyboardAction(e -> this.doOkAction(), KeyStroke.getKeyStroke(10, 0), 2);
        this.myNewTagText.setRequestFocusEnabled(true);
        this.myNewTagText.requestFocusInWindow();
        this.myNewTagText.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                MorphPanel.this.myNewTagText.selectAll();
            }
        });
    }

    private void doOkAction() {
        if (this.myOkAction != null) {
            this.myOkAction.consume((Object)this.myNewTagText.getText());
        }
    }

    @NotNull
    private DocumentListener createDocumentListener() {
        return new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent e) {
                if (MorphPanel.this.myNameChangeConsumer != null) {
                    MorphPanel.this.myNameChangeConsumer.consume((Object)e.getDocument().getText());
                }
            }
        };
    }

    public void createUIComponents() {
        this.myRoot = this;
        this.myNewTagText = this.createAutoCompleteTagField();
    }

    @NotNull
    private TextFieldWithCompletion createAutoCompleteTagField() {
        List possibleRoots = AndroidLayoutUtil.getPossibleRoots((AndroidFacet)this.myFacet);
        Collections.sort(possibleRoots);
        TextFieldWithAutoCompletion.StringsCompletionProvider completionProvider = new TextFieldWithAutoCompletion.StringsCompletionProvider((Collection)possibleRoots, null);
        return new TextFieldWithAutoCompletion(this.myProject, (TextFieldWithAutoCompletionListProvider)completionProvider, true, null);
    }

    public void setOkAction(@Nullable Consumer<String> okAction) {
        this.myOkAction = okAction;
    }

    public void setTagNameChangeConsumer(@Nullable Consumer<String> consumer) {
        this.myNameChangeConsumer = consumer;
    }

    @NotNull
    public JComponent getPreferredFocusComponent() {
        return this.myNewTagText;
    }

    @VisibleForTesting
    void setTagNameText(String name) {
        this.myNewTagLabel.setText(name);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JBLabel jBLabel;
        this.createUIComponents();
        JPanel jPanel = this.myRoot;
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(10, 10, 10, 10), -1, -1, false, false));
        this.myNewTagLabel = jBLabel = new JBLabel();
        Font font = this.$$$getFont$$$(null, 1, -1, jBLabel.getFont());
        if (font != null) {
            jBLabel.setFont(font);
        }
        jBLabel.setText("Convert View to:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        TextFieldWithCompletion textFieldWithCompletion = this.myNewTagText;
        jPanel.add((Component)textFieldWithCompletion, new GridConstraints(0, 1, 1, 2, 0, 1, 6, 0, new Dimension(200, -1), null, null));
        this.myOkButton = jButton = new JButton();
        jButton.setText("Apply");
        jPanel.add((Component)jButton, new GridConstraints(2, 2, 1, 1, 4, 0, 3, 0, null, null, null));
        JList jList = new JList();
        this.mySuggestionsList = jList;
        jList.setName("suggestionList");
        jPanel.add(jList, new GridConstraints(1, 0, 1, 3, 0, 1, 3, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myRoot;
    }

    private /* synthetic */ Font $$$getFont$$$(String string, int n, int n2, Font font) {
        Font font2;
        if (font == null) {
            return null;
        }
        String string2 = string == null ? font.getName() : ((font2 = new Font(string, 0, 10)).canDisplay('a') && font2.canDisplay('1') ? string : font.getName());
        return new Font(string2, n >= 0 ? n : font.getStyle(), n2 >= 0 ? n2 : font.getSize());
    }
}

