/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.ide.common.rendering.api.ViewInfo;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.util.NlTreeDumper;
import com.android.tools.idea.rendering.parsers.AttributeSnapshot;
import com.android.tools.idea.uibuilder.editor.NlEditor;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.google.common.base.CaseFormat;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilBase;
import icons.StudioIcons;
import java.awt.Rectangle;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GenerateLayoutTestSkeletonAction
extends AnAction {
    private static final Pattern XML_PROLOG = Pattern.compile("^<\\?xml version.*$");

    public GenerateLayoutTestSkeletonAction() {
        super("Generate LayoutTest Skeleton");
    }

    public void update(@NotNull AnActionEvent event) {
        event.getPresentation().setEnabled(GenerateLayoutTestSkeletonAction.getModel(event.getProject()) != null);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        NlModel model2 = GenerateLayoutTestSkeletonAction.getModel(event.getProject());
        if (model2 == null) {
            return;
        }
        int option = Messages.showDialog((Project)model2.getProject(), (String)"Generate LayoutTest skeleton with the current layout components.", (String)"Generate LayoutTest Skeleton", (String[])new String[]{"Copy to Clipboard", "Cancel"}, (int)0, (Icon)StudioIcons.Shell.Filetree.ANDROID_TEST_ROOT);
        if (option == 0) {
            CopyPasteManager.getInstance().setContents((Transferable)new StringSelection(GenerateLayoutTestSkeletonAction.generateModelFixture(model2)));
        }
    }

    @Nullable
    private static NlModel getModel(@Nullable Project project) {
        if (project == null) {
            return null;
        }
        DesignSurface<?> surface2 = GenerateLayoutTestSkeletonAction.getSurface(project);
        if (surface2 == null) {
            return null;
        }
        SceneView screenView = surface2.getFocusedSceneView();
        if (screenView == null) {
            return null;
        }
        return screenView.getSceneManager().getModel();
    }

    @Nullable
    private static DesignSurface<?> getSurface(@NotNull Project project) {
        FileEditor[] editors;
        FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)project);
        for (FileEditor fileEditor : editors = fileEditorManager.getSelectedEditors()) {
            if (!(fileEditor instanceof NlEditor)) continue;
            return ((NlEditor)fileEditor).getComponent().getSurface();
        }
        Editor editor = fileEditorManager.getSelectedTextEditor();
        if (editor == null) {
            return null;
        }
        PsiFile file2 = PsiUtilBase.getPsiFileInEditor((Editor)editor, (Project)project);
        if (file2 == null) {
            return null;
        }
        for (FileEditor fileEditor : fileEditorManager.getEditors(file2.getVirtualFile())) {
            if (!(fileEditor instanceof NlEditor)) continue;
            return ((NlEditor)fileEditor).getComponent().getSurface();
        }
        return null;
    }

    @NotNull
    private static String generateModelFixture(@NotNull NlModel model2) {
        ImmutableList<NlComponent> components = model2.getComponents();
        StringBuilder builder2 = new StringBuilder();
        builder2.append("import com.android.tools.idea.uibuilder.LayoutTestCase;\n").append("import com.android.tools.idea.uibuilder.fixtures.ModelBuilder;\n").append("import com.android.tools.idea.uibuilder.model.NlModel;\n").append("import com.android.tools.idea.uibuilder.util.NlTreeDumper;\n").append("import org.jetbrains.annotations.NotNull;\n").append("\n").append("import static com.android.SdkConstants.*;\n").append("\n").append("public class NewTest extends LayoutTestCase {\n").append("\n").append("  // TODO: Rename this test method\n").append("  public void testRenameThis() {\n").append("    NlModel model = createModel();\n").append("  }\n").append("\n").append("  @NotNull\n").append("  private NlModel createModel() {\n").append("    ModelBuilder builder = model(\"").append(model2.getFile().getName()).append("\",\n");
        for (NlComponent component : components) {
            GenerateLayoutTestSkeletonAction.appendComponent(component, "\"    ModelBuilder builder = model(".length(), builder2);
        }
        builder2.append(");\n");
        builder2.append("    NlModel model = builder.build();\n").append("    format(model.getFile());\n").append("    assertEquals(").append(components.size()).append(", model.getComponents().size());\n");
        GenerateLayoutTestSkeletonAction.appendTreeComparison(components, builder2);
        GenerateLayoutTestSkeletonAction.appendXmlComparison(model2, builder2);
        builder2.append("\n").append("    return model;\n").append("  }\n").append("}\n");
        return builder2.toString();
    }

    private static void appendComponent(@NotNull NlComponent component, int indent, @NotNull StringBuilder builder2) {
        builder2.append(StringUtil.repeat((String)" ", (int)indent)).append("component(").append(GenerateLayoutTestSkeletonAction.getTagSymbol(component.getTagName())).append(")\n").append(StringUtil.repeat((String)" ", (int)(indent + 2))).append(GenerateLayoutTestSkeletonAction.makeBounds(component)).append("\n");
        for (AttributeSnapshot attribute : component.getAttributes()) {
            GenerateLayoutTestSkeletonAction.appendAttribute(attribute, indent + 4, builder2);
        }
        if (component.getChildCount() > 0) {
            builder2.append(StringUtil.repeat((String)" ", (int)(indent + 2))).append(".children(\n");
            for (NlComponent child : component.getChildren()) {
                GenerateLayoutTestSkeletonAction.appendComponent(child, indent + 4, builder2);
                builder2.replace(builder2.length() - 1, builder2.length(), ",\n\n");
            }
            builder2.replace(builder2.length() - 3, builder2.length(), ")\n");
        }
    }

    private static void appendAttribute(@NotNull AttributeSnapshot attribute, int indent, @NotNull StringBuilder builder2) {
        if (GenerateLayoutTestSkeletonAction.implicitAttribute(attribute)) {
            return;
        }
        assert (attribute.value != null);
        if ("android".equals(attribute.prefix)) {
            switch (attribute.name) {
                case "id": {
                    GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".id", attribute.value, builder2);
                    return;
                }
                case "text": {
                    GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".text", attribute.value, builder2);
                    return;
                }
                case "layout_height": {
                    GenerateLayoutTestSkeletonAction.appendHeightOrWidth(indent, attribute.value, "height", builder2);
                    return;
                }
                case "layout_width": {
                    GenerateLayoutTestSkeletonAction.appendHeightOrWidth(indent, attribute.value, "width", builder2);
                    return;
                }
            }
        }
        GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".withAttribute", attribute.prefix, attribute.name, attribute.value, builder2);
    }

    private static void appendHeightOrWidth(int indent, @NotNull String value2, @NotNull String orientation2, @NotNull StringBuilder builder2) {
        switch (value2) {
            case "wrap_content": {
                GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".wrapContent" + StringUtil.capitalize((String)orientation2), builder2);
                break;
            }
            case "match_parent": {
                GenerateLayoutTestSkeletonAction.appendAttribute(indent, ".matchParent" + StringUtil.capitalize((String)orientation2), builder2);
                break;
            }
            default: {
                GenerateLayoutTestSkeletonAction.appendAttribute(indent, "." + orientation2, value2, builder2);
            }
        }
    }

    private static void appendAttribute(int indent, @NotNull String with, @NotNull StringBuilder builder2) {
        builder2.append(StringUtil.repeat((String)" ", (int)indent)).append(with).append("()\n");
    }

    private static void appendAttribute(int indent, @NotNull String with, @Nullable String value2, @NotNull StringBuilder builder2) {
        GenerateLayoutTestSkeletonAction.appendAttribute(indent, with, null, null, value2, builder2);
    }

    private static void appendAttribute(int indent, @NotNull String with, @Nullable String prefix, @Nullable String name, @Nullable String value2, @NotNull StringBuilder builder2) {
        if (value2 == null) {
            return;
        }
        builder2.append(StringUtil.repeat((String)" ", (int)indent)).append(with).append("(\"");
        if (prefix != null) {
            builder2.append(prefix).append(":");
        }
        if (name != null) {
            builder2.append(name).append("\", \"");
        }
        builder2.append(value2).append("\")\n");
    }

    private static boolean implicitAttribute(@NotNull AttributeSnapshot attribute) {
        if ("xmlns".equals(attribute.prefix)) {
            return true;
        }
        return attribute.value == null;
    }

    @NotNull
    private static String makeBounds(@NotNull NlComponent component) {
        Rectangle bounds2 = GenerateLayoutTestSkeletonAction.getBounds(component);
        return String.format(".withBounds(%d, %d, %d, %d)", bounds2.x, bounds2.y, bounds2.width, bounds2.height);
    }

    @NotNull
    private static Rectangle getBounds(@NotNull NlComponent component) {
        NlComponent parent = component.getParent();
        Rectangle parentBounds = parent != null ? GenerateLayoutTestSkeletonAction.getBounds(parent) : new Rectangle(0, 0, 1000, 1000);
        ViewInfo viewInfo = NlComponentHelperKt.getViewInfo(component);
        if (viewInfo == null) {
            return new Rectangle(parentBounds.x, parentBounds.y, 100, 100);
        }
        return new Rectangle(viewInfo.getLeft() + parentBounds.x, viewInfo.getTop() + parentBounds.y, viewInfo.getRight() - viewInfo.getLeft(), viewInfo.getBottom() - viewInfo.getTop());
    }

    @NotNull
    private static String getTagSymbol(@NotNull String tagName) {
        tagName = tagName.substring(1 + tagName.lastIndexOf(46));
        return StringUtil.toUpperCase((String)CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, tagName));
    }

    private static void appendTreeComparison(@NotNull List<NlComponent> components, @NotNull StringBuilder builder2) {
        GenerateLayoutTestSkeletonAction.appendMultilineAssert(NlTreeDumper.dumpTree(components), "NlTreeDumper.dumpTree(model.getComponents())", builder2, (List<Pattern>)ImmutableList.of(), false);
    }

    private static void appendXmlComparison(@NotNull NlModel model2, @NotNull StringBuilder builder2) {
        GenerateLayoutTestSkeletonAction.appendMultilineAssert(model2.getFile().getText(), "model.getFile().getText()", builder2, (List<Pattern>)ImmutableList.of((Object)XML_PROLOG), true);
    }

    private static void appendMultilineAssert(@NotNull String expectedMultilineResult, @NotNull String subject, @NotNull StringBuilder builder2, @NotNull List<Pattern> lineFilters, boolean addNewlineToLastLine) {
        String assertEquals = "    assertEquals(";
        builder2.append(assertEquals);
        String lastLine = "";
        int indent = 0;
        for (String line : Splitter.on((String)"\n").split((CharSequence)expectedMultilineResult)) {
            if (GenerateLayoutTestSkeletonAction.matches(line, lineFilters)) continue;
            builder2.append(StringUtil.repeat((String)" ", (int)indent));
            builder2.append("\"").append(line.replace("\"", "\\\"")).append("\\n\" +\n");
            indent = assertEquals.length();
            lastLine = line;
        }
        if (indent > 0) {
            builder2.setLength(builder2.length() - 6);
            if (lastLine.isEmpty()) {
                builder2.setLength(builder2.length() - 1 - indent - 6);
            }
            if (addNewlineToLastLine) {
                builder2.append("\\n");
            }
            builder2.append("\",\n");
        } else {
            builder2.append("\"\",\n");
        }
        builder2.append(StringUtil.repeat((String)" ", (int)assertEquals.length()));
        builder2.append(subject).append(");\n");
    }

    private static boolean matches(@NotNull String line, @NotNull List<Pattern> lineFilters) {
        for (Pattern pattern : lineFilters) {
            if (!pattern.matcher(line).matches()) continue;
            return true;
        }
        return false;
    }
}

