/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.actions;

import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.uibuilder.actions.DrawableBackgroundMenuActionKt;
import com.android.tools.idea.uibuilder.actions.DrawableBackgroundType;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntProgression;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/uibuilder/actions/DrawableBackgroundLayer;", "Lcom/android/tools/idea/common/surface/Layer;", "screenView", "Lcom/android/tools/idea/uibuilder/surface/ScreenView;", "backgroundType", "Lcom/android/tools/idea/uibuilder/actions/DrawableBackgroundType;", "(Lcom/android/tools/idea/uibuilder/surface/ScreenView;Lcom/android/tools/idea/uibuilder/actions/DrawableBackgroundType;)V", "getBackgroundType", "()Lcom/android/tools/idea/uibuilder/actions/DrawableBackgroundType;", "setBackgroundType", "(Lcom/android/tools/idea/uibuilder/actions/DrawableBackgroundType;)V", "dim", "Ljava/awt/Dimension;", "paint", "", "gc", "Ljava/awt/Graphics2D;", "intellij.android.designer"})
final class DrawableBackgroundLayer
extends Layer {
    @NotNull
    private final ScreenView screenView;
    @NotNull
    private DrawableBackgroundType backgroundType;
    @NotNull
    private final Dimension dim;

    public DrawableBackgroundLayer(@NotNull ScreenView screenView, @NotNull DrawableBackgroundType backgroundType) {
        Intrinsics.checkNotNullParameter((Object)screenView, (String)"screenView");
        Intrinsics.checkNotNullParameter((Object)((Object)backgroundType), (String)"backgroundType");
        this.screenView = screenView;
        this.backgroundType = backgroundType;
        this.dim = new Dimension();
    }

    @NotNull
    public final DrawableBackgroundType getBackgroundType() {
        return this.backgroundType;
    }

    public final void setBackgroundType(@NotNull DrawableBackgroundType drawableBackgroundType) {
        Intrinsics.checkNotNullParameter((Object)((Object)drawableBackgroundType), (String)"<set-?>");
        this.backgroundType = drawableBackgroundType;
    }

    @Override
    public void paint(@NotNull Graphics2D gc) {
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        DrawableBackgroundType currentType = this.backgroundType;
        if (currentType == DrawableBackgroundType.NONE) {
            return;
        }
        int startX = this.screenView.getX();
        int startY = this.screenView.getY();
        this.screenView.getScaledContentSize(this.dim);
        int width2 = this.dim.width;
        int height2 = this.dim.height;
        gc.clipRect(startX, startY, width2, height2);
        if (currentType == DrawableBackgroundType.WHITE) {
            gc.setColor(Color.WHITE);
            gc.fillRect(startX, startY, width2, height2);
            return;
        }
        if (currentType == DrawableBackgroundType.BLACK) {
            gc.setColor(Color.BLACK);
            gc.fillRect(startX, startY, width2, height2);
            return;
        }
        gc.setColor(Color.WHITE);
        gc.fillRect(startX, startY, width2, height2);
        boolean isOddRow = false;
        gc.setColor(DrawableBackgroundMenuActionKt.access$getCHECKERED_GRID_GRAY$p());
        IntProgression intProgression = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)startY, (int)(startY + height2))), (int)12);
        int y = intProgression.getFirst();
        int n = intProgression.getLast();
        int n2 = intProgression.getStep();
        if (n2 > 0 && y <= n || n2 < 0 && n <= y) {
            while (true) {
                int shift = isOddRow ? 0 : 12;
                IntProgression intProgression2 = RangesKt.step((IntProgression)((IntProgression)RangesKt.until((int)(startX + shift), (int)(startX + width2))), (int)24);
                int x = intProgression2.getFirst();
                int n3 = intProgression2.getLast();
                int n4 = intProgression2.getStep();
                if (n4 > 0 && x <= n3 || n4 < 0 && n3 <= x) {
                    while (true) {
                        gc.fillRect(x, y, 12, 12);
                        if (x == n3) break;
                        x += n4;
                    }
                }
                boolean bl = isOddRow = !isOddRow;
                if (y == n) break;
                y += n2;
            }
        }
    }
}

