/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.preview;

import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.util.LogUtilKt;
import com.android.tools.idea.rendering.RenderLogger;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.run.util.StopWatch;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0002\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006J\u0016\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u0006J\u0014\u0010\u000e\u001a\u00020\t2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/preview/PreviewElementDebugLogger;", "", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "(Lcom/intellij/openapi/diagnostic/Logger;)V", "refreshId", "", "stopwatch", "Lcom/android/tools/idea/run/util/StopWatch;", "", "message", "logPreviewElement", "previewElementLogString", "previewXmlContent", "logRenderComplete", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "Lcom/android/tools/idea/uibuilder/scene/LayoutlibSceneManager;", "intellij.android.preview-designer"})
public final class PreviewElementDebugLogger {
    @NotNull
    private final Logger log;
    @NotNull
    private final String refreshId;
    @NotNull
    private final StopWatch stopwatch;

    public PreviewElementDebugLogger(@NotNull Logger log) {
        Intrinsics.checkNotNullParameter((Object)log, (String)"log");
        this.log = log;
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        this.refreshId = string;
        this.stopwatch = new StopWatch();
    }

    public final void logPreviewElement(@NotNull String previewElementLogString, @NotNull String previewXmlContent) {
        Intrinsics.checkNotNullParameter((Object)previewElementLogString, (String)"previewElementLogString");
        Intrinsics.checkNotNullParameter((Object)previewXmlContent, (String)"previewXmlContent");
        this.log(StringsKt.trimIndent((String)("Preview found at " + this.stopwatch.getDuration().toMillis() + "ms\n        " + previewElementLogString + "\n\n        " + previewXmlContent + "\n     ")));
    }

    public final void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.log.debug("[" + this.refreshId + "] " + message);
    }

    public final void logRenderComplete(@NotNull DesignSurface<LayoutlibSceneManager> surface2) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        this.log("Render completed in " + this.stopwatch.getDuration().toMillis() + "ms");
        ImmutableList<LayoutlibSceneManager> immutableList = surface2.getSceneManagers();
        Intrinsics.checkNotNullExpressionValue(immutableList, (String)"surface.sceneManagers");
        Iterable $this$forEach$iv = (Iterable)immutableList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RenderLogger renderLogger;
            RenderResult result;
            LayoutlibSceneManager it = (LayoutlibSceneManager)element$iv;
            boolean bl = false;
            String modelName = it.getModel().getModelDisplayName();
            if (it.getRenderResult() == null) continue;
            boolean bl2 = false;
            Intrinsics.checkNotNullExpressionValue((Object)result.getLogger(), (String)"result.logger");
            boolean bl3 = renderLogger.hasErrors();
            Set set = renderLogger.getMissingClasses();
            List list = renderLogger.getMessages();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"renderLogger.messages");
            this.log(StringsKt.trimMargin$default((String)("modelName=\"" + modelName + "\" result\n                  | " + result + "\n                  | hasErrors=" + bl3 + "\n                  | missingClasses=" + set + "\n                  | messages=" + LogUtilKt.asLogString(list) + "\n                  | exceptions=" + renderLogger.getBrokenClasses().values() + "\n                "), null, (int)1, null));
        }
    }
}

