/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.surface;

import com.android.annotations.concurrency.UiThread;
import com.android.ide.common.rendering.api.ResourceValue;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.resources.ResourceResolver;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.AndroidStudioKotlinPluginUtils;
import com.android.tools.idea.common.editor.DesignerEditorPanel;
import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.DnDTransferComponent;
import com.android.tools.idea.common.model.DnDTransferItem;
import com.android.tools.idea.common.model.ItemTransferable;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.model.SelectionModel;
import com.android.tools.idea.common.scene.LerpDouble;
import com.android.tools.idea.common.scene.LerpPoint;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceHelper;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.common.surface.SinglePositionableContentLayoutManager;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.configurations.ConfigurationStateManager;
import com.android.tools.idea.naveditor.analytics.NavUsageTracker;
import com.android.tools.idea.naveditor.editor.NavActionManager;
import com.android.tools.idea.naveditor.model.ActionType;
import com.android.tools.idea.naveditor.model.NavComponentHelperKt;
import com.android.tools.idea.naveditor.scene.NavActionHelperKt;
import com.android.tools.idea.naveditor.scene.NavSceneManager;
import com.android.tools.idea.naveditor.scene.NavSceneManagerKt;
import com.android.tools.idea.naveditor.surface.NavDesignSurfaceActionHandler;
import com.android.tools.idea.naveditor.surface.NavInteractionHandler;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemSyncUtil;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.rendering.parsers.TagSnapshot;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.NavEditorEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.reference.SoftReference;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.UIUtil;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.geom.Point2D;
import java.io.File;
import java.util.List;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.jetbrains.android.dom.navigation.NavigationSchema;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.refactoring.MigrateToAndroidxUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class NavDesignSurface
extends DesignSurface<NavSceneManager> {
    private static final int SCROLL_DURATION_MS = 300;
    private static final Object CONNECTION_CLIENT_PROPERTY_KEY = new Object();
    private static final String FAILED_DEPENDENCY = "Failed to add navigation dependency";
    private static final String FAILED_DEPENDENCY_TITLE = "Failed to Add Dependency";
    private NlComponent myCurrentNavigation;
    @VisibleForTesting
    AtomicReference<Future<?>> myScheduleRef = new AtomicReference();
    private DesignerEditorPanel myEditorPanel;
    private static final WeakHashMap<AndroidFacet, SoftReference<ConfigurationManager>> ourConfigurationManagers = new WeakHashMap();
    private static final List<GradleCoordinate> NAVIGATION_DEPENDENCIES = ImmutableList.of((Object)GoogleMavenArtifactId.NAVIGATION_FRAGMENT.getCoordinate("+"), (Object)GoogleMavenArtifactId.NAVIGATION_UI.getCoordinate("+"));
    private static final List<GradleCoordinate> NAVIGATION_DEPENDENCIES_KTX = ImmutableList.of((Object)GoogleMavenArtifactId.NAVIGATION_FRAGMENT_KTX.getCoordinate("+"), (Object)GoogleMavenArtifactId.NAVIGATION_UI_KTX.getCoordinate("+"));
    private static final List<GradleCoordinate> ANDROIDX_NAVIGATION_DEPENDENCIES = ImmutableList.of((Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_FRAGMENT.getCoordinate("+"), (Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_UI.getCoordinate("+"));
    private static final List<GradleCoordinate> ANDROIDX_NAVIGATION_DEPENDENCIES_KTX = ImmutableList.of((Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_FRAGMENT_KTX.getCoordinate("+"), (Object)GoogleMavenArtifactId.ANDROIDX_NAVIGATION_UI_KTX.getCoordinate("+"));

    @TestOnly
    public NavDesignSurface(@NotNull Project project, @NotNull Disposable parentDisposable) {
        this(project, null, parentDisposable);
    }

    public NavDesignSurface(@NotNull Project project, @Nullable DesignerEditorPanel editorPanel2, @NotNull Disposable parentDisposable) {
        super(project, parentDisposable, surface2 -> new NavActionManager((NavDesignSurface)((Object)surface2)), NavInteractionHandler::new, surface2 -> new SinglePositionableContentLayoutManager(), surface2 -> new NavDesignSurfaceActionHandler((NavDesignSurface)((Object)surface2)), DesignSurface.ZoomControlsPolicy.VISIBLE);
        this.myEditorPanel = editorPanel2;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                NavDesignSurface.this.removeComponentListener(this);
                NavDesignSurface.this.requestRender();
            }
        });
        this.getSelectionModel().addListener((SelectionModel unused, List<NlComponent> selection) -> this.updateCurrentNavigation(selection));
    }

    @Override
    @NotNull
    public CompletableFuture<Void> requestRender() {
        SceneManager manager = (SceneManager)Iterables.getFirst(this.getSceneManagers(), null);
        return manager != null ? manager.requestRenderAsync() : CompletableFuture.completedFuture(null);
    }

    @Override
    public void dispose() {
        Future<?> future2 = this.getScheduleRef().get();
        if (future2 != null) {
            future2.cancel(false);
        }
        this.getScheduleRef().set(null);
        super.dispose();
    }

    @Override
    public Object getData(@NotNull @NonNls String dataId) {
        Point2D.Float p2d;
        SceneComponent sceneComponent;
        Scene scene;
        NlComponent selection;
        if (PlatformDataKeys.CONTEXT_MENU_POINT.is(dataId) && (selection = this.getSelectionModel().getPrimary()) != null && NavComponentHelperKt.isAction(selection) && (scene = this.getScene()) != null && (sceneComponent = scene.getSceneComponent(selection)) != null && (p2d = NavActionHelperKt.getAnyPoint(sceneComponent, SceneContext.get(this.getFocusedSceneView()))) != null) {
            return new Point((int)p2d.x, (int)p2d.y);
        }
        return super.getData(dataId);
    }

    @NotNull
    public CompletableFuture<Void> forceUserRequestedRefresh() {
        return this.forceRefresh();
    }

    @NotNull
    public CompletableFuture<Void> forceRefresh() {
        return CompletableFuture.completedFuture(null);
    }

    @Override
    @NotNull
    protected NavSceneManager createSceneManager(@NotNull NlModel model2) {
        return new NavSceneManager(model2, this);
    }

    @Override
    @Nullable
    public NavSceneManager getSceneManager() {
        return (NavSceneManager)super.getSceneManager();
    }

    @Override
    public CompletableFuture<?> goingToSetModel(final NlModel model2) {
        model2.getConfiguration().getResourceResolver();
        final AndroidFacet facet = model2.getFacet();
        final CompletableFuture result = new CompletableFuture();
        final Application application = ApplicationManager.getApplication();
        application.executeOnPooledThread(() -> {
            if (NavDesignSurface.tryToCreateSchema(facet)) {
                result.complete(null);
            } else if (this.requestAddDependency(facet)) {
                ListenableFuture syncResult = ProjectSystemUtil.getSyncManager((Project)this.getProject()).syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
                Futures.addCallback((ListenableFuture)syncResult, (FutureCallback)new FutureCallback<Object>(){

                    public void onSuccess(@Nullable Object unused) {
                        application.executeOnPooledThread(() -> {
                            if (!NavDesignSurface.tryToCreateSchema(facet)) {
                                NavDesignSurface.this.showFailToAddMessage(result, model2);
                            } else {
                                result.complete(null);
                            }
                        });
                    }

                    public void onFailure(@Nullable Throwable t) {
                        NavDesignSurface.this.showFailToAddMessage(result, model2);
                    }
                }, (Executor)MoreExecutors.directExecutor());
            } else {
                this.showFailToAddMessage(result, model2);
            }
        });
        return result;
    }

    @Override
    public CompletableFuture<Void> setModel(@Nullable NlModel model2) {
        CompletableFuture<Void> future2 = super.setModel(model2);
        NavUsageTracker.Companion.getInstance(model2).createEvent(NavEditorEvent.NavEditorEventType.OPEN_FILE).withNavigationContents().log();
        return future2;
    }

    private void showFailToAddMessage(@NotNull CompletableFuture<?> result, final @NotNull NlModel model2) {
        if (this.myEditorPanel != null) {
            ProjectSystemSyncManager.SyncResultListener syncFailedListener = new ProjectSystemSyncManager.SyncResultListener(){

                public void syncEnded(@NotNull ProjectSystemSyncManager.SyncResult result) {
                    ApplicationManager.getApplication().executeOnPooledThread(() -> {
                        if (NavDesignSurface.tryToCreateSchema(model2.getFacet())) {
                            NavDesignSurface.this.myEditorPanel.initNeleModel();
                            ((MessageBusConnection)NavDesignSurface.this.myEditorPanel.getClientProperty(CONNECTION_CLIENT_PROPERTY_KEY)).disconnect();
                            NavDesignSurface.this.myEditorPanel.putClientProperty(CONNECTION_CLIENT_PROPERTY_KEY, null);
                        }
                    });
                }
            };
            MessageBusConnection connection = this.getProject().getMessageBus().connect((Disposable)this);
            this.myEditorPanel.putClientProperty(CONNECTION_CLIENT_PROPERTY_KEY, connection);
            connection.subscribe(ProjectSystemSyncUtil.PROJECT_SYSTEM_SYNC_TOPIC, (Object)syncFailedListener);
        }
        ApplicationManager.getApplication().invokeLater(() -> this.onFailedToAddDependency());
        result.completeExceptionally(new Exception(FAILED_DEPENDENCY));
    }

    private void onFailedToAddDependency() {
        Messages.showErrorDialog((Project)this.getProject(), (String)FAILED_DEPENDENCY, (String)FAILED_DEPENDENCY_TITLE);
        if (this.myEditorPanel != null) {
            this.myEditorPanel.getWorkBench().loadingStopped(FAILED_DEPENDENCY);
        }
    }

    private boolean requestAddDependency(@NotNull AndroidFacet facet) {
        List<GradleCoordinate> dependencies = NavDesignSurface.getDependencies(facet.getModule());
        AtomicBoolean didAdd = new AtomicBoolean(false);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            try {
                didAdd.set(DependencyManagementUtil.addDependenciesWithUiConfirmation((Module)facet.getModule(), (List)dependencies, (boolean)true, (boolean)false).isEmpty());
            }
            catch (Throwable t) {
                Logger.getInstance(NavDesignSurface.class).warn("Failed to add dependencies", t);
                didAdd.set(false);
            }
        });
        return didAdd.get();
    }

    @NotNull
    public static List<GradleCoordinate> getDependencies(@NotNull Module module) {
        boolean isKotlin = AndroidStudioKotlinPluginUtils.hasKotlinFacet((Module)module);
        if (MigrateToAndroidxUtil.isAndroidx((Project)module.getProject())) {
            return isKotlin ? ANDROIDX_NAVIGATION_DEPENDENCIES_KTX : ANDROIDX_NAVIGATION_DEPENDENCIES;
        }
        return isKotlin ? NAVIGATION_DEPENDENCIES_KTX : NAVIGATION_DEPENDENCIES;
    }

    private static boolean tryToCreateSchema(@NotNull AndroidFacet facet) {
        Module module = facet.getModule();
        return (Boolean)DumbService.getInstance((Project)module.getProject()).runReadActionInSmartMode(() -> {
            try {
                NavigationSchema.createIfNecessary((Module)module);
                return true;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        });
    }

    @Override
    public void activate() {
        super.activate();
        NlModel model2 = this.getModel();
        if (model2 != null) {
            Module module = model2.getModule();
            try {
                NavigationSchema.createIfNecessary((Module)module);
            }
            catch (ClassNotFoundException e) {
                return;
            }
            NavigationSchema schema = NavigationSchema.get((Module)module);
            if (!schema.quickValidate()) {
                if (this.myEditorPanel == null) {
                    return;
                }
                this.myEditorPanel.getWorkBench().showLoading("Refreshing Navigators...");
                ApplicationManager.getApplication().executeOnPooledThread(() -> {
                    try {
                        schema.rebuildSchema().get();
                        ApplicationManager.getApplication().invokeLater(() -> this.myEditorPanel.getWorkBench().hideLoading());
                    }
                    catch (Exception e) {
                        ApplicationManager.getApplication().invokeLater(() -> this.myEditorPanel.getWorkBench().loadingStopped("Error refreshing Navigators"));
                    }
                });
            } else {
                schema.rebuildSchema();
            }
        }
    }

    @Override
    @NotNull
    public ItemTransferable getSelectionAsTransferable() {
        NlModel model2 = this.getModel();
        ImmutableList components = (ImmutableList)this.getSelectionModel().getSelection().stream().map(component -> new DnDTransferComponent(component.getTagName(), component.getTagDeprecated().getText(), 0, 0)).collect(ImmutableList.toImmutableList());
        return new ItemTransferable(new DnDTransferItem(model2 != null ? model2.getId() : 0L, (ImmutableList<DnDTransferComponent>)components));
    }

    @NotNull
    public NlComponent getCurrentNavigation() {
        if (!this.validateCurrentNavigation().booleanValue()) {
            this.refreshRoot();
        }
        return this.myCurrentNavigation;
    }

    private Boolean validateCurrentNavigation() {
        NlComponent current = this.myCurrentNavigation;
        if (current == null || current.getModel() != this.getModel()) {
            return false;
        }
        while (current.getParent() != null) {
            NlComponent parent = current.getParent();
            if (!parent.getChildren().contains(current)) {
                return false;
            }
            current = parent;
        }
        ImmutableList<NlComponent> components = this.getModel().getComponents();
        assert (components.size() == 1);
        return current == components.get(0);
    }

    public void setCurrentNavigation(@NotNull NlComponent currentNavigation) {
        this.myCurrentNavigation = currentNavigation;
        this.getSceneManager().update();
        this.getSceneManager().layout(false);
        this.zoomToFit();
        currentNavigation.getModel().notifyModified(NlModel.ChangeType.UPDATE_HIERARCHY);
        this.repaint();
    }

    @Override
    protected Dimension getScrollToVisibleOffset() {
        return new Dimension(0, 0);
    }

    @Override
    public boolean isLayoutDisabled() {
        return false;
    }

    @Override
    public boolean setScale(double scale, int x, int y) {
        SceneView view2 = this.getFocusedSceneView();
        if (view2 == null) {
            return false;
        }
        Point oldViewPosition = this.getScrollPosition();
        if (x < 0 || y < 0) {
            x = oldViewPosition.x + this.getViewport().getViewportComponent().getWidth() / 2;
            y = oldViewPosition.y + this.getViewport().getViewportComponent().getHeight() / 2;
        }
        int androidX = Coordinates.getAndroidXDip(view2, x);
        int androidY = Coordinates.getAndroidYDip(view2, y);
        boolean ret = super.setScale(scale, x, y);
        int shiftedX = Coordinates.getSwingXDip(view2, androidX);
        int shiftedY = Coordinates.getSwingYDip(view2, androidY);
        this.getViewport().setViewPosition(new Point(oldViewPosition.x + shiftedX - x, oldViewPosition.y + shiftedY - y));
        return ret;
    }

    @Override
    protected boolean isKeepingScaleWhenReopen() {
        return false;
    }

    @Override
    protected double getMinScale() {
        return this.isEmpty() ? 1.0 : 0.1;
    }

    @Override
    protected double getMaxScale() {
        return this.isEmpty() ? 1.0 : 3.0;
    }

    @Override
    public boolean canZoomToFit() {
        if (this.isEmpty()) {
            return false;
        }
        Double fitScale = this.getFitScale();
        Double scale = this.getScale();
        return Math.abs(fitScale - scale) > 0.005;
    }

    @Override
    public double getFitScale() {
        Dimension size = new Dimension();
        SceneView view2 = this.getFocusedSceneView();
        if (view2 != null) {
            SceneComponent root = view2.getScene().getRoot();
            if (root == null) {
                size.setSize(0, 0);
            } else {
                Rectangle boundingBox = NavSceneManagerKt.getBoundingBox(root);
                size.setSize(boundingBox.getSize());
            }
        } else {
            size.setSize(0, 0);
        }
        double scale = DesignSurfaceHelper.getFitContentIntoWindowScale(this, size);
        return Math.min(scale, 1.0);
    }

    private boolean isEmpty() {
        NavSceneManager sceneManager = this.getSceneManager();
        return sceneManager == null || sceneManager.isEmpty();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void notifyComponentActivate(@NotNull NlComponent component) {
        VirtualFile virtualFile2;
        PsiFile file2;
        PsiClass psiClass;
        String className2;
        NavEditorEvent.NavEditorEventType metricsEventType;
        String id2;
        if (this.myCurrentNavigation == component) {
            return;
        }
        if (NavComponentHelperKt.isNavigation(component)) {
            if (!NavComponentHelperKt.isInclude(component)) {
                this.setCurrentNavigation(component);
                NavUsageTracker.Companion.getInstance(this.getModel()).createEvent(NavEditorEvent.NavEditorEventType.ACTIVATE_NESTED).log();
                return;
            }
            id2 = component.getAttribute("http://schemas.android.com/apk/res-auto", "graph");
            metricsEventType = NavEditorEvent.NavEditorEventType.ACTIVATE_INCLUDE;
            if (id2 == null) {
                return;
            }
        } else {
            id2 = component.getAttribute("http://schemas.android.com/tools", "layout");
            metricsEventType = NavEditorEvent.NavEditorEventType.ACTIVATE_LAYOUT;
        }
        if (id2 != null) {
            VirtualFile virtualFile3;
            File file3;
            String fileName;
            Configuration configuration = (Configuration)Iterables.getOnlyElement(this.getConfigurations(), null);
            ResourceResolver resolver = configuration != null ? configuration.getResourceResolver() : null;
            ResourceValue value2 = resolver != null ? resolver.findResValue(id2, false) : null;
            String string = fileName = value2 != null ? value2.getValue() : null;
            if (fileName != null && (file3 = new File(fileName)).exists() && (virtualFile3 = VfsUtil.findFileByIoFile((File)file3, (boolean)false)) != null) {
                FileEditorManager.getInstance((Project)this.getProject()).openFile(virtualFile3, true);
                NavUsageTracker.Companion.getInstance(this.getModel()).createEvent(metricsEventType).log();
                return;
            }
        }
        if ((className2 = component.getAttribute("http://schemas.android.com/apk/res/android", "name")) != null && (psiClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(className2, GlobalSearchScope.allScope((Project)this.getProject()))) != null && (file2 = psiClass.getContainingFile()) != null && (virtualFile2 = file2.getVirtualFile()) != null) {
            FileEditorManager.getInstance((Project)this.getProject()).openFile(virtualFile2, true);
            NavUsageTracker.Companion.getInstance(this.getModel()).createEvent(NavEditorEvent.NavEditorEventType.ACTIVATE_CLASS).log();
            return;
        }
        super.notifyComponentActivate(component);
    }

    @Override
    @UiThread
    public boolean zoom(@NotNull ZoomType type, int x, int y) {
        NavSceneManager sceneManager;
        boolean isFitZoom;
        this.getAnalyticsManager().trackZoom(type);
        boolean scaled = super.zoom(type, x, y);
        boolean bl = isFitZoom = type == ZoomType.FIT;
        if ((scaled || isFitZoom) && (sceneManager = this.getSceneManager()) != null) {
            sceneManager.layout(false);
            this.validateScrollArea();
        }
        if (isFitZoom) {
            Dimension visibleSize = this.getExtentSize();
            Dimension size = this.getViewSize();
            this.setScrollPosition((size.width - visibleSize.width) / 2, (size.height - visibleSize.height) / 2);
        }
        return scaled;
    }

    @Override
    public void scrollToCenter(@NotNull List<NlComponent> list) {
        Scene scene = this.getScene();
        SceneView view2 = this.getFocusedSceneView();
        if (list.isEmpty() || scene == null || view2 == null) {
            return;
        }
        Rectangle selectionBounds = NavSceneManagerKt.getBoundingBox(list.stream().map(nlComponent -> scene.getSceneComponent((NlComponent)nlComponent)).filter(sceneComponent -> sceneComponent != null).collect(Collectors.toList()));
        Dimension swingViewportSize = this.getExtentSize();
        int swingStartCenterXInViewport = Coordinates.getSwingX(view2, (int)selectionBounds.getCenterX()) - this.getScrollPosition().x;
        int swingStartCenterYInViewport = Coordinates.getSwingY(view2, (int)selectionBounds.getCenterY()) - this.getScrollPosition().y;
        Point start = new Point(swingStartCenterXInViewport, swingStartCenterYInViewport);
        Point end = new Point(swingViewportSize.width / 2, swingViewportSize.height / 2);
        LerpPoint lerpPoint = new LerpPoint(start, end, this.getScrollDurationMs());
        double fitSelectionScale = DesignSurfaceHelper.getFitContentIntoWindowScale(this, selectionBounds.getSize());
        fitSelectionScale = Math.min(fitSelectionScale, 1.0);
        LerpDouble zoomLerp = new LerpDouble(view2.getScale(), fitSelectionScale, this.getScrollDurationMs());
        if (this.getScheduleRef().get() != null) {
            this.getScheduleRef().get().cancel(false);
        }
        Runnable action2 = () -> UIUtil.invokeAndWaitIfNeeded(() -> {
            long time = System.currentTimeMillis();
            Point pointSwingValue = (Point)lerpPoint.getValue(time);
            int targetSwingX = Coordinates.getSwingX(view2, (int)selectionBounds.getCenterX());
            int targetSwingY = Coordinates.getSwingY(view2, (int)selectionBounds.getCenterY());
            this.setScrollPosition(targetSwingX - pointSwingValue.x, targetSwingY - pointSwingValue.y);
            this.setScale((Double)zoomLerp.getValue(time), targetSwingX, targetSwingY);
            if (lerpPoint.isComplete(time)) {
                this.getScheduleRef().get().cancel(false);
                this.getScheduleRef().set(null);
            }
        });
        this.getScheduleRef().set(AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(action2, 0L, 10L, TimeUnit.MILLISECONDS));
    }

    @VisibleForTesting
    @NotNull
    AtomicReference<Future<?>> getScheduleRef() {
        return this.myScheduleRef;
    }

    int getScrollDurationMs() {
        return 300;
    }

    public void refreshRoot() {
        NlModel model2 = this.getModel();
        if (model2 == null) {
            return;
        }
        NlComponent match = (NlComponent)model2.getComponents().get(0);
        if (this.myCurrentNavigation != null) {
            boolean includingParent = false;
            TagSnapshot currentSnapshot = this.myCurrentNavigation.getSnapshot();
            NlComponent currentParent = this.myCurrentNavigation.getParent();
            for (NlComponent component : model2.flattenComponents()::iterator) {
                if (!NavComponentHelperKt.isNavigation(component)) continue;
                if (component == this.myCurrentNavigation) {
                    return;
                }
                TagSnapshot componentSnapshot = component.getSnapshot();
                if (currentSnapshot != null && currentSnapshot == componentSnapshot) {
                    match = component;
                    break;
                }
                if (includingParent || !Objects.equals(component.getId(), this.myCurrentNavigation.getId())) continue;
                match = component;
                NlComponent componentParent = component.getParent();
                if (componentParent == null != (currentParent == null) || componentParent != null && !Objects.equals(componentParent.getId(), currentParent.getId())) continue;
                includingParent = true;
            }
        }
        if (this.myCurrentNavigation != match) {
            this.myCurrentNavigation = match;
            this.getSelectionModel().setSelection((List<? extends NlComponent>)ImmutableList.of((Object)this.myCurrentNavigation));
        }
    }

    @Override
    @NotNull
    public ConfigurationManager getConfigurationManager(@NotNull AndroidFacet facet) {
        SoftReference<ConfigurationManager> ref = ourConfigurationManagers.get(facet);
        ConfigurationManager result = null;
        if (ref != null) {
            result = (ConfigurationManager)ref.get();
        }
        if (result == null) {
            result = new MyConfigurationManager(facet.getModule());
            ourConfigurationManagers.put(facet, (SoftReference<ConfigurationManager>)new SoftReference((Object)result));
        }
        return result;
    }

    @Override
    protected boolean getSupportPinchAndZoom() {
        return false;
    }

    @Override
    @NotNull
    public List<NlComponent> getSelectableComponents() {
        NlComponent root = this.getCurrentNavigation();
        return root.flatten().filter(component -> component == root || NavComponentHelperKt.isDestination(component) && component.getParent() == root || NavComponentHelperKt.isAction(component) && (component.getParent() == root || component.getParent() != null && component.getParent().getParent() == root || NavComponentHelperKt.getActionType(component, root) == ActionType.EXIT_DESTINATION)).collect(Collectors.toList());
    }

    private void updateCurrentNavigation(@NotNull List<NlComponent> selection) {
        if (selection.isEmpty()) {
            return;
        }
        if (this.getSelectableComponents().stream().anyMatch(selection::contains)) {
            return;
        }
        NlComponent selected = selection.get(0);
        NlComponent next = selected.getParent();
        if (next == null) {
            next = selected;
        }
        while (next != null && !NavComponentHelperKt.isNavigation(next)) {
            next = next.getParent();
        }
        if (next != null) {
            this.setCurrentNavigation(next);
        }
    }

    private static class MyConfigurationManager
    extends ConfigurationManager {
        MyConfigurationManager(@NotNull Module module) {
            super(module);
        }

        public ConfigurationStateManager getStateManager() {
            return new ConfigurationStateManager();
        }
    }
}

