/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.naveditor.scene;

import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.naveditor.scene.RefinableImage;
import com.android.tools.idea.naveditor.scene.ThumbnailManager;
import com.android.tools.idea.naveditor.scene.ThumbnailManagerKt;
import com.android.tools.idea.rendering.RenderResult;
import com.android.tools.idea.rendering.RenderService;
import com.android.tools.idea.rendering.RenderTask;
import com.android.tools.idea.res.LocalResourceRepository;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashBasedTable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.reference.SoftReference;
import com.intellij.ui.scale.ScaleContext;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.ImageUtil;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0006\b\u0016\u0018\u0000 12\u00020\u0001:\u00011B\u000f\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J.\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u00122\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\"\u001a\u00020#H\u0014J \u0010$\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00122\u0006\u0010!\u001a\u00020\r2\u0006\u0010%\u001a\u00020 H\u0002J(\u0010&\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u00122\u0006\u0010%\u001a\u00020 2\u0006\u0010\u001f\u001a\u00020\u000b2\u0006\u0010!\u001a\u00020\rH\u0015J0\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00122\u0006\u0010%\u001a\u00020 2\u0006\u0010!\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u001bH\u0002J&\u0010*\u001a\u00020\u00132\u0006\u0010%\u001a\u00020 2\u0006\u0010!\u001a\u00020\r2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u001bJ\b\u0010+\u001a\u00020,H\u0014J\u0010\u0010-\u001a\u00020,2\u0006\u0010\u0002\u001a\u00020\u0003H\u0014J\u0018\u0010.\u001a\u00020\u000f2\u0006\u0010/\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u001aH\u0002J&\u00100\u001a\b\u0012\u0004\u0012\u00020\u001c0\u00122\u0006\u0010/\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020\u001a2\u0006\u0010)\u001a\u00020\u001bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0082\u0001\u0010\t\u001av\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000f \f*\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e0\u000e \f*:\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000f \f*\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000e0\u000e\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\"\u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\u000b\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00130\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rj\u0010\u0014\u001a^\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00150\u0015 \f*.\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000Rj\u0010\u0016\u001a^\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00150\u0015 \f*.\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00150\u0015\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u00d3\u0001\u0010\u0019\u001a\u00c6\u0001\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r\u0012@\u0012>\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u000e \f*\u001e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u000e\u0018\u00010\n0\n \f*b\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b\u0012\f\u0012\n \f*\u0004\u0018\u00010\r0\r\u0012@\u0012>\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u000e \f*\u001e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001c\u0018\u00010\u000e\u0018\u00010\n0\n\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/android/tools/idea/naveditor/scene/ThumbnailManager;", "Lorg/jetbrains/android/facet/AndroidFacetScopedService;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "(Lorg/jetbrains/android/facet/AndroidFacet;)V", "disposalLock", "", "myDisposed", "", "myImages", "Lcom/google/common/collect/HashBasedTable;", "Lcom/intellij/openapi/vfs/VirtualFile;", "kotlin.jvm.PlatformType", "Lcom/android/tools/idea/configurations/Configuration;", "Lcom/intellij/reference/SoftReference;", "Ljava/awt/image/BufferedImage;", "myPendingFutures", "Ljava/util/HashMap;", "Ljava/util/concurrent/CompletableFuture;", "Lcom/android/tools/idea/naveditor/scene/RefinableImage;", "myRenderModStamps", "", "myRenderVersions", "myResourceRepository", "Lcom/android/tools/idea/res/LocalResourceRepository;", "myScaledImages", "Ljava/awt/Dimension;", "Lcom/intellij/ui/scale/ScaleContext;", "Ljava/awt/Image;", "createTask", "Lcom/android/tools/idea/rendering/RenderTask;", "file", "Lcom/intellij/psi/xml/XmlFile;", "configuration", "renderService", "Lcom/android/tools/idea/rendering/RenderService;", "getFullImage", "xmlFile", "getImage", "getScaledImage", "dimensions", "scaleContext", "getThumbnail", "onDispose", "", "onServiceDisposal", "previewScaleImage", "image", "scaleImage", "Companion", "intellij.android.nav.editor"})
public class ThumbnailManager
extends AndroidFacetScopedService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final HashBasedTable<VirtualFile, Configuration, SoftReference<BufferedImage>> myImages;
    private final HashBasedTable<VirtualFile, Configuration, HashBasedTable<Dimension, ScaleContext, SoftReference<Image>>> myScaledImages;
    private final HashBasedTable<VirtualFile, Configuration, Long> myRenderVersions;
    private final HashBasedTable<VirtualFile, Configuration, Long> myRenderModStamps;
    @NotNull
    private final LocalResourceRepository myResourceRepository;
    @NotNull
    private final HashMap<VirtualFile, CompletableFuture<RefinableImage>> myPendingFutures;
    private boolean myDisposed;
    @NotNull
    private final Object disposalLock;

    protected ThumbnailManager(@NotNull AndroidFacet facet) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        super(facet);
        this.myImages = HashBasedTable.create();
        this.myScaledImages = HashBasedTable.create();
        this.myRenderVersions = HashBasedTable.create();
        this.myRenderModStamps = HashBasedTable.create();
        LocalResourceRepository localResourceRepository = ResourceRepositoryManager.getAppResources((AndroidFacet)facet);
        Intrinsics.checkNotNullExpressionValue((Object)localResourceRepository, (String)"getAppResources(facet)");
        this.myResourceRepository = localResourceRepository;
        this.myPendingFutures = new HashMap();
        this.disposalLock = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onDispose() {
        Object object;
        CompletableFuture[] futures = null;
        Object object2 = object = this.disposalLock;
        synchronized (object2) {
            boolean bl = false;
            this.myDisposed = true;
            Collection<CompletableFuture<RefinableImage>> collection = this.myPendingFutures.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"myPendingFutures.values");
            Collection<CompletableFuture<RefinableImage>> $this$toTypedArray$iv = collection;
            boolean $i$f$toTypedArray = false;
            Collection<CompletableFuture<RefinableImage>> thisCollection$iv = $this$toTypedArray$iv;
            CompletableFuture[] completableFutureArray = thisCollection$iv.toArray(new CompletableFuture[0]);
            if (completableFutureArray == null) {
                throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            }
            futures = completableFutureArray;
            this.myPendingFutures.clear();
            Unit unit2 = Unit.INSTANCE;
        }
        try {
            CompletableFuture[] completableFutureArray;
            if (futures == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"futures");
                completableFutureArray = null;
            } else {
                completableFutureArray = futures;
            }
            CompletableFuture.allOf(Arrays.copyOf(completableFutureArray, futures.length)).get(5L, TimeUnit.SECONDS);
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.onDispose();
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final RefinableImage getThumbnail(@NotNull XmlFile xmlFile, @NotNull Configuration configuration, @NotNull Dimension dimensions, @NotNull ScaleContext scaleContext) {
        RefinableImage refinableImage;
        Image cached;
        Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)dimensions, (String)"dimensions");
        Intrinsics.checkNotNullParameter((Object)scaleContext, (String)"scaleContext");
        VirtualFile file2 = xmlFile.getVirtualFile();
        HashBasedTable hashBasedTable = (HashBasedTable)this.myScaledImages.get((Object)file2, (Object)configuration);
        if (hashBasedTable == null) {
            HashBasedTable hashBasedTable2;
            HashBasedTable it = hashBasedTable2 = HashBasedTable.create();
            boolean bl = false;
            this.myScaledImages.put((Object)file2, (Object)configuration, (Object)it);
            hashBasedTable = hashBasedTable2;
        }
        HashBasedTable cachedByDimension = hashBasedTable;
        SoftReference softReference = (SoftReference)cachedByDimension.get((Object)dimensions, (Object)scaleContext);
        Image image = cached = softReference != null ? (Image)softReference.get() : null;
        if (cached != null) {
            Long l = (Long)this.myRenderVersions.get((Object)file2, (Object)configuration);
            long l2 = this.myResourceRepository.getModificationCount();
            if (l != null && l == l2) {
                Long l3 = (Long)this.myRenderModStamps.get((Object)file2, (Object)configuration);
                l2 = file2.getTimeStamp();
                if (l3 != null && l3 == l2) {
                    refinableImage = new RefinableImage(cached, null, 2, null);
                    return refinableImage;
                }
            }
        }
        refinableImage = new RefinableImage(cached, this.getScaledImage(xmlFile, configuration, dimensions, scaleContext));
        return refinableImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CompletableFuture<RefinableImage> getScaledImage(XmlFile xmlFile, Configuration configuration, Dimension dimensions, ScaleContext scaleContext) {
        VirtualFile file2 = xmlFile.getVirtualFile();
        CompletableFuture<RefinableImage> result = new CompletableFuture<RefinableImage>();
        Object object = this.disposalLock;
        synchronized (object) {
            block6: {
                block5: {
                    boolean bl = false;
                    if (!this.myDisposed) break block5;
                    CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
                    Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(null)");
                    CompletableFuture<Object> completableFuture2 = completableFuture;
                    return completableFuture2;
                }
                CompletableFuture<RefinableImage> inProgress = this.myPendingFutures.get(file2);
                if (inProgress == null) break block6;
                CompletableFuture<RefinableImage> completableFuture = inProgress;
                return completableFuture;
            }
            Map map = this.myPendingFutures;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
            map.put(file2, result);
            Unit unit2 = Unit.INSTANCE;
        }
        ((CompletableFuture)this.getFullImage(configuration, xmlFile).thenApply(new Function(this, dimensions, scaleContext, xmlFile, configuration){
            final /* synthetic */ ThumbnailManager this$0;
            final /* synthetic */ Dimension $dimensions;
            final /* synthetic */ ScaleContext $scaleContext;
            final /* synthetic */ XmlFile $xmlFile;
            final /* synthetic */ Configuration $configuration;
            {
                this.this$0 = $receiver;
                this.$dimensions = $dimensions;
                this.$scaleContext = $scaleContext;
                this.$xmlFile = $xmlFile;
                this.$configuration = $configuration;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final RefinableImage apply(@Nullable BufferedImage full) {
                if (full != null) {
                    Object object = ThumbnailManager.access$getDisposalLock$p(this.this$0);
                    ThumbnailManager thumbnailManager = this.this$0;
                    Object object2 = object;
                    synchronized (object2) {
                        block5: {
                            boolean bl = false;
                            if (!ThumbnailManager.access$getMyDisposed$p(thumbnailManager)) break block5;
                            RefinableImage refinableImage = null;
                            return refinableImage;
                        }
                        Unit unit2 = Unit.INSTANCE;
                    }
                    CompletionStage scaledFuture2 = ((CompletableFuture)ThumbnailManager.access$scaleImage(this.this$0, full, this.$dimensions, this.$scaleContext).thenApply(new Function(this.this$0, this.$xmlFile, this.$configuration, this.$dimensions, this.$scaleContext){
                        final /* synthetic */ ThumbnailManager this$0;
                        final /* synthetic */ XmlFile $xmlFile;
                        final /* synthetic */ Configuration $configuration;
                        final /* synthetic */ Dimension $dimensions;
                        final /* synthetic */ ScaleContext $scaleContext;
                        {
                            this.this$0 = $receiver;
                            this.$xmlFile = $xmlFile;
                            this.$configuration = $configuration;
                            this.$dimensions = $dimensions;
                            this.$scaleContext = $scaleContext;
                        }

                        public final Image apply(Image scaled) {
                            HashBasedTable hashBasedTable;
                            HashBasedTable hashBasedTable2 = (HashBasedTable)ThumbnailManager.access$getMyScaledImages$p(this.this$0).get((Object)this.$xmlFile.getVirtualFile(), (Object)this.$configuration);
                            if (hashBasedTable2 == null) {
                                HashBasedTable hashBasedTable3 = HashBasedTable.create();
                                ThumbnailManager thumbnailManager = this.this$0;
                                XmlFile xmlFile = this.$xmlFile;
                                Configuration configuration = this.$configuration;
                                HashBasedTable it = hashBasedTable3;
                                boolean bl = false;
                                ThumbnailManager.access$getMyScaledImages$p(thumbnailManager).put((Object)xmlFile.getVirtualFile(), (Object)configuration, (Object)it);
                                HashBasedTable hashBasedTable4 = hashBasedTable3;
                                hashBasedTable = hashBasedTable4;
                                Intrinsics.checkNotNullExpressionValue((Object)hashBasedTable4, (String)"create<Dimension, ScaleC\u2026tion, it)\n              }");
                            } else {
                                hashBasedTable = hashBasedTable2;
                            }
                            HashBasedTable dimensionMap = hashBasedTable;
                            dimensionMap.put((Object)this.$dimensions, (Object)this.$scaleContext, (Object)new SoftReference((Object)scaled));
                            return scaled;
                        }
                    })).thenApply(getScaledImage.scaledFuture.2.INSTANCE);
                    return new RefinableImage(ThumbnailManager.access$previewScaleImage(this.this$0, full, this.$dimensions), (CompletableFuture<RefinableImage>)scaledFuture2);
                }
                return new RefinableImage(null, null, 3, null);
            }
        })).handle(new BiFunction(result, this, file2){
            final /* synthetic */ CompletableFuture<RefinableImage> $result;
            final /* synthetic */ ThumbnailManager this$0;
            final /* synthetic */ VirtualFile $file;
            {
                this.$result = $result;
                this.this$0 = $receiver;
                this.$file = $file;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Nullable
            public final CompletableFuture<RefinableImage> apply(@Nullable RefinableImage image, Throwable exception) {
                CompletableFuture completableFuture;
                if (exception != null) {
                    this.$result.completeExceptionally(exception);
                } else {
                    this.$result.complete(image);
                }
                Object object = ThumbnailManager.access$getDisposalLock$p(this.this$0);
                ThumbnailManager thumbnailManager = this.this$0;
                VirtualFile virtualFile2 = this.$file;
                Object object2 = object;
                synchronized (object2) {
                    boolean bl = false;
                    completableFuture = (CompletableFuture)ThumbnailManager.access$getMyPendingFutures$p(thumbnailManager).remove(virtualFile2);
                }
                return completableFuture;
            }
        });
        return result;
    }

    /*
     * Enabled aggressive block sorting
     */
    private final CompletableFuture<BufferedImage> getFullImage(Configuration configuration, XmlFile xmlFile) {
        CompletableFuture<BufferedImage> completableFuture;
        BufferedImage fullSize;
        VirtualFile file2 = xmlFile.getVirtualFile();
        SoftReference softReference = (SoftReference)this.myImages.get((Object)file2, (Object)configuration);
        BufferedImage bufferedImage = fullSize = softReference != null ? (BufferedImage)softReference.get() : null;
        if (fullSize != null) {
            Long l = (Long)this.myRenderVersions.get((Object)file2, (Object)configuration);
            long l2 = this.myResourceRepository.getModificationCount();
            if (l != null && l == l2) {
                Long l3 = (Long)this.myRenderModStamps.get((Object)file2, (Object)configuration);
                l2 = file2.getTimeStamp();
                if (l3 != null && l3 == l2) {
                    CompletableFuture<BufferedImage> completableFuture2 = CompletableFuture.completedFuture(fullSize);
                    completableFuture = completableFuture2;
                    Intrinsics.checkNotNullExpressionValue(completableFuture2, (String)"{\n      CompletableFutur\u2026tedFuture(fullSize)\n    }");
                    return completableFuture;
                }
            }
        }
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
        completableFuture = this.getImage(xmlFile, file2, configuration);
        return completableFuture;
    }

    private final BufferedImage previewScaleImage(BufferedImage image, Dimension dimensions) {
        BufferedImage bufferedImage = ImageUtil.createImage((int)dimensions.width, (int)dimensions.height, (int)2);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(dimensions.w\u2026feredImage.TYPE_INT_ARGB)");
        BufferedImage scaled = bufferedImage;
        scaled.getGraphics().drawImage(image, 0, 0, dimensions.width, dimensions.height, null);
        return scaled;
    }

    private final CompletableFuture<Image> scaleImage(BufferedImage image, Dimension dimensions, ScaleContext scaleContext) {
        CompletableFuture<Image> result = new CompletableFuture<Image>();
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(image, scaleContext, dimensions, result){
            final /* synthetic */ BufferedImage $image;
            final /* synthetic */ ScaleContext $scaleContext;
            final /* synthetic */ Dimension $dimensions;
            final /* synthetic */ CompletableFuture<Image> $result;
            {
                this.$image = $image;
                this.$scaleContext = $scaleContext;
                this.$dimensions = $dimensions;
                this.$result = $result;
            }

            public final void run() {
                Image scaledImage = ImageUtil.ensureHiDPI((Image)this.$image, (ScaleContext)this.$scaleContext);
                scaledImage = ImageUtil.scaleImage((Image)scaledImage, (int)this.$dimensions.width, (int)this.$dimensions.height);
                this.$result.complete(scaledImage);
            }
        });
        return result;
    }

    @VisibleForTesting
    @NotNull
    protected CompletableFuture<BufferedImage> getImage(@NotNull XmlFile xmlFile, @NotNull VirtualFile file2, @NotNull Configuration configuration) {
        Intrinsics.checkNotNullParameter((Object)xmlFile, (String)"xmlFile");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        RenderService renderService = RenderService.getInstance((Project)this.getModule().getProject());
        Intrinsics.checkNotNullExpressionValue((Object)renderService, (String)"getInstance(module.project)");
        RenderService renderService2 = renderService;
        AndroidFacet androidFacet = this.getFacet();
        Intrinsics.checkNotNullExpressionValue((Object)androidFacet, (String)"facet");
        CompletableFuture<RenderTask> renderTaskFuture = this.createTask(androidFacet, xmlFile, configuration, renderService2);
        CompletionStage completionStage = ((CompletableFuture)((CompletableFuture)renderTaskFuture.thenCompose((Function)getImage.1.INSTANCE)).thenApply(new Function(this, file2, configuration){
            final /* synthetic */ ThumbnailManager this$0;
            final /* synthetic */ VirtualFile $file;
            final /* synthetic */ Configuration $configuration;
            {
                this.this$0 = $receiver;
                this.$file = $file;
                this.$configuration = $configuration;
            }

            @Nullable
            public final BufferedImage apply(RenderResult it) {
                BufferedImage image = it.getRenderedImage().getCopy();
                ThumbnailManager.access$getMyImages$p(this.this$0).put((Object)this.$file, (Object)this.$configuration, (Object)new SoftReference((Object)image));
                ThumbnailManager.access$getMyRenderVersions$p(this.this$0).put((Object)this.$file, (Object)this.$configuration, (Object)ThumbnailManager.access$getMyResourceRepository$p(this.this$0).getModificationCount());
                ThumbnailManager.access$getMyRenderModStamps$p(this.this$0).put((Object)this.$file, (Object)this.$configuration, (Object)this.$file.getTimeStamp());
                return image;
            }
        })).whenCompleteAsync(new BiConsumer(renderTaskFuture){
            final /* synthetic */ CompletableFuture<RenderTask> $renderTaskFuture;
            {
                this.$renderTaskFuture = $renderTaskFuture;
            }

            public final void accept(@Nullable BufferedImage bufferedImage, Throwable throwable) {
                block0: {
                    RenderTask renderTask = this.$renderTaskFuture.get();
                    if (renderTask == null) break block0;
                    renderTask.dispose();
                }
            }
        }, (Executor)AppExecutorUtil.getAppExecutorService());
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"@VisibleForTesting\n  pro\u2026AppExecutorService())\n  }");
        return completionStage;
    }

    @NotNull
    protected CompletableFuture<RenderTask> createTask(@NotNull AndroidFacet facet, @NotNull XmlFile file2, @NotNull Configuration configuration, @NotNull RenderService renderService) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)renderService, (String)"renderService");
        CompletionStage completionStage = renderService.taskBuilder(facet, configuration).withPsiFile((PsiFile)file2).build().whenComplete((BiConsumer)createTask.1.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"renderService.taskBuilde\u2026k.setDecorations(false) }");
        return completionStage;
    }

    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
    }

    @JvmStatic
    @NotNull
    public static final ThumbnailManager getInstance(@NotNull AndroidFacet facet) {
        return Companion.getInstance(facet);
    }

    @VisibleForTesting
    @JvmStatic
    public static final void setInstance(@NotNull AndroidFacet facet, @Nullable ThumbnailManager manager) {
        Companion.setInstance(facet, manager);
    }

    public static final /* synthetic */ Object access$getDisposalLock$p(ThumbnailManager $this) {
        return $this.disposalLock;
    }

    public static final /* synthetic */ CompletableFuture access$scaleImage(ThumbnailManager $this, BufferedImage image, Dimension dimensions, ScaleContext scaleContext) {
        return $this.scaleImage(image, dimensions, scaleContext);
    }

    public static final /* synthetic */ HashBasedTable access$getMyScaledImages$p(ThumbnailManager $this) {
        return $this.myScaledImages;
    }

    public static final /* synthetic */ BufferedImage access$previewScaleImage(ThumbnailManager $this, BufferedImage image, Dimension dimensions) {
        return $this.previewScaleImage(image, dimensions);
    }

    public static final /* synthetic */ boolean access$getMyDisposed$p(ThumbnailManager $this) {
        return $this.myDisposed;
    }

    public static final /* synthetic */ HashMap access$getMyPendingFutures$p(ThumbnailManager $this) {
        return $this.myPendingFutures;
    }

    public static final /* synthetic */ HashBasedTable access$getMyImages$p(ThumbnailManager $this) {
        return $this.myImages;
    }

    public static final /* synthetic */ HashBasedTable access$getMyRenderVersions$p(ThumbnailManager $this) {
        return $this.myRenderVersions;
    }

    public static final /* synthetic */ LocalResourceRepository access$getMyResourceRepository$p(ThumbnailManager $this) {
        return $this.myResourceRepository;
    }

    public static final /* synthetic */ HashBasedTable access$getMyRenderModStamps$p(ThumbnailManager $this) {
        return $this.myRenderModStamps;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\t\u001a\u0004\u0018\u00010\u0004H\u0007\u00a8\u0006\n"}, d2={"Lcom/android/tools/idea/naveditor/scene/ThumbnailManager$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/naveditor/scene/ThumbnailManager;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "setInstance", "", "manager", "intellij.android.nav.editor"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ThumbnailManager getInstance(@NotNull AndroidFacet facet) {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            ThumbnailManager manager = (ThumbnailManager)((Object)facet.getUserData(ThumbnailManagerKt.access$getKEY$p()));
            if (manager == null) {
                manager = new ThumbnailManager(facet);
                this.setInstance(facet, manager);
            }
            return manager;
        }

        @VisibleForTesting
        @JvmStatic
        public final void setInstance(@NotNull AndroidFacet facet, @Nullable ThumbnailManager manager) {
            Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
            facet.putUserData(ThumbnailManagerKt.access$getKEY$p(), (Object)manager);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

