/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.glance.preview;

import com.android.ide.common.rendering.api.Bridge;
import com.android.tools.adtui.stdui.ActionData;
import com.android.tools.idea.editors.build.ProjectBuildStatusManager;
import com.android.tools.idea.editors.build.ProjectStatus;
import com.android.tools.idea.editors.shortcuts.UtilsKt;
import com.android.tools.idea.glance.preview.GlancePreviewBundle;
import com.android.tools.idea.glance.preview.GlancePreviewViewModelKt;
import com.android.tools.idea.glance.preview.mvvm.PreviewView;
import com.android.tools.idea.glance.preview.mvvm.PreviewViewModel;
import com.android.tools.idea.glance.preview.mvvm.PreviewViewModelStatus;
import com.android.tools.idea.projectsystem.BuildUtilsKt;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.psi.PsiFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.EditorNotifications;
import com.intellij.util.ui.UIUtil;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\u0002\u0010\u000fJ\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020$H\u0016J\b\u0010'\u001a\u00020$H\u0016J\b\u0010(\u001a\u00020$H\u0016J\b\u0010)\u001a\u00020$H\u0016J\u0010\u0010*\u001a\u00020\u000e2\u0006\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020$H\u0016J\u0018\u0010.\u001a\u00020$2\u0006\u0010/\u001a\u00020\u000e2\u0006\u00100\u001a\u000201H\u0016J\b\u00102\u001a\u00020$H\u0016J\b\u00103\u001a\u00020$H\u0016J\u0010\u00104\u001a\u00020$2\u0006\u0010\u0017\u001a\u00020\u000eH\u0016J\b\u00105\u001a\u00020$H\u0002J\b\u00106\u001a\u00020$H\u0002J\b\u00107\u001a\u00020$H\u0002R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u0016R\u0014\u0010\u001c\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u0016R\u0014\u0010\u001d\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001e\u001a\u0004\u0018\u00010\u000b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lcom/android/tools/idea/glance/preview/GlancePreviewViewModel;", "Lcom/android/tools/idea/glance/preview/mvvm/PreviewViewModel;", "Lcom/android/tools/idea/glance/preview/mvvm/PreviewViewModelStatus;", "previewView", "Lcom/android/tools/idea/glance/preview/mvvm/PreviewView;", "projectBuildStatusManager", "Lcom/android/tools/idea/editors/build/ProjectBuildStatusManager;", "project", "Lcom/intellij/openapi/project/Project;", "psiFilePointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiFile;", "hasRenderErrors", "Lkotlin/Function0;", "", "(Lcom/android/tools/idea/glance/preview/mvvm/PreviewView;Lcom/android/tools/idea/editors/build/ProjectBuildStatusManager;Lcom/intellij/openapi/project/Project;Lcom/intellij/psi/SmartPsiElementPointer;Lkotlin/jvm/functions/Function0;)V", "buildAndRefreshAction", "Lcom/android/tools/adtui/stdui/ActionData;", "getBuildAndRefreshAction", "()Lcom/android/tools/adtui/stdui/ActionData;", "hasErrorsAndNeedsBuild", "getHasErrorsAndNeedsBuild", "()Z", "hasPreviews", "Ljava/util/concurrent/atomic/AtomicBoolean;", "hasRendered", "hasSyntaxErrors", "getHasSyntaxErrors", "isOutOfDate", "isRefreshing", "previewedFile", "getPreviewedFile", "()Lcom/intellij/psi/PsiFile;", "refreshCallsCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "activate", "", "afterPreviewsRefreshed", "beforePreviewsRefreshed", "buildFailed", "buildStarted", "buildSucceeded", "checkForNativeCrash", "runnable", "Ljava/lang/Runnable;", "onEnterSmartMode", "refreshCompleted", "isCancelled", "durationNanos", "", "refreshFinished", "refreshStarted", "setHasPreviews", "updateNotifications", "updateView", "updateViewAndNotifications", "intellij.android.glance-designer"})
public final class GlancePreviewViewModel
implements PreviewViewModel,
PreviewViewModelStatus {
    @NotNull
    private final PreviewView previewView;
    @NotNull
    private final ProjectBuildStatusManager projectBuildStatusManager;
    @NotNull
    private final Project project;
    @NotNull
    private final SmartPsiElementPointer<PsiFile> psiFilePointer;
    @NotNull
    private final Function0<Boolean> hasRenderErrors;
    @NotNull
    private final AtomicInteger refreshCallsCount;
    @NotNull
    private final AtomicBoolean hasRendered;
    @NotNull
    private final AtomicBoolean hasPreviews;

    public GlancePreviewViewModel(@NotNull PreviewView previewView2, @NotNull ProjectBuildStatusManager projectBuildStatusManager2, @NotNull Project project, @NotNull SmartPsiElementPointer<PsiFile> psiFilePointer2, @NotNull Function0<Boolean> hasRenderErrors) {
        Intrinsics.checkNotNullParameter((Object)previewView2, (String)"previewView");
        Intrinsics.checkNotNullParameter((Object)projectBuildStatusManager2, (String)"projectBuildStatusManager");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(psiFilePointer2, (String)"psiFilePointer");
        Intrinsics.checkNotNullParameter(hasRenderErrors, (String)"hasRenderErrors");
        this.previewView = previewView2;
        this.projectBuildStatusManager = projectBuildStatusManager2;
        this.project = project;
        this.psiFilePointer = psiFilePointer2;
        this.hasRenderErrors = hasRenderErrors;
        this.refreshCallsCount = new AtomicInteger(0);
        this.hasRendered = new AtomicBoolean(false);
        this.hasPreviews = new AtomicBoolean(false);
    }

    @Override
    public boolean checkForNativeCrash(@NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        if (Bridge.hasNativeCrash()) {
            String message = "The preview has been disabled following a crash in the rendering engine. If the problem persists, please report the issue.";
            ActionData actionData2 = new ActionData("Re-enable rendering", (Function0)new Function0<Unit>(this, runnable2){
                final /* synthetic */ GlancePreviewViewModel this$0;
                final /* synthetic */ Runnable $runnable;
                {
                    this.this$0 = $receiver;
                    this.$runnable = $runnable;
                    super(0);
                }

                public final void invoke() {
                    Bridge.setNativeCrash((boolean)false);
                    GlancePreviewViewModel.access$getPreviewView$p(this.this$0).showLoadingMessage("Loading...");
                    this.$runnable.run();
                }
            });
            this.previewView.showErrorMessage(message, null, actionData2);
            return true;
        }
        return false;
    }

    @Override
    public void refreshStarted() {
        this.refreshCallsCount.incrementAndGet();
        this.updateNotifications();
    }

    @Override
    public void refreshFinished() {
        this.refreshCallsCount.decrementAndGet();
        this.updateNotifications();
    }

    @Override
    public void beforePreviewsRefreshed() {
        this.updateViewAndNotifications();
    }

    @Override
    public void afterPreviewsRefreshed() {
        this.hasRendered.set(true);
        this.updateViewAndNotifications();
    }

    public void buildStarted() {
        this.updateViewAndNotifications();
    }

    public void buildSucceeded() {
        this.updateViewAndNotifications();
    }

    public void buildFailed() {
        this.updateViewAndNotifications();
    }

    @Override
    public void setHasPreviews(boolean hasPreviews) {
        this.hasPreviews.set(hasPreviews);
    }

    @Override
    public void refreshCompleted(boolean isCancelled, long durationNanos) {
        this.updateViewAndNotifications();
        ModalityState modalityState$iv = null;
        boolean $i$f$invokeLater = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(this, durationNanos){
            final /* synthetic */ GlancePreviewViewModel this$0;
            final /* synthetic */ long $durationNanos$inlined;
            {
                this.this$0 = glancePreviewViewModel;
                this.$durationNanos$inlined = l;
            }

            public final void run() {
                boolean bl = false;
                if (GlancePreviewViewModel.access$getHasRendered$p(this.this$0).get()) {
                    Duration duration = Duration.ofMillis(this.$durationNanos$inlined / (long)1000000);
                    Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"ofMillis(durationNanos / 1_000_000)");
                    String durationString = GlancePreviewViewModelKt.access$toDisplayString(duration);
                    Object[] objectArray = new Object[]{durationString};
                    Notification notification = new Notification("Glance Preview Notification", GlancePreviewBundle.INSTANCE.message("event.log.refresh.title", new Object[0]), GlancePreviewBundle.INSTANCE.message("event.log.refresh.total.elapsed.time", objectArray), NotificationType.INFORMATION);
                    Notifications.Bus.notify((Notification)notification, (Project)GlancePreviewViewModel.access$getProject$p(this.this$0));
                }
            }
        }, ModalityState.defaultModalityState());
    }

    @Override
    public void onEnterSmartMode() {
        this.updateViewAndNotifications();
    }

    @Override
    public void activate() {
        this.updateViewAndNotifications();
    }

    private final void updateNotifications() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this){
            final /* synthetic */ GlancePreviewViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public final void run() {
                GlancePreviewViewModel.access$getPreviewView$p(this.this$0).updateToolbar();
                if (!GlancePreviewViewModel.access$getProject$p(this.this$0).isDisposed()) {
                    EditorNotifications.getInstance((Project)GlancePreviewViewModel.access$getProject$p(this.this$0)).updateNotifications(GlancePreviewViewModel.access$getPsiFilePointer$p(this.this$0).getVirtualFile());
                }
            }
        });
    }

    private final void updateViewAndNotifications() {
        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this){
            final /* synthetic */ GlancePreviewViewModel this$0;
            {
                this.this$0 = $receiver;
            }

            public final void run() {
                GlancePreviewViewModel.access$updateView(this.this$0);
                GlancePreviewViewModel.access$updateNotifications(this.this$0);
            }
        });
    }

    private final ActionData getBuildAndRefreshAction() {
        String actionDataText = GlancePreviewBundle.INSTANCE.message("panel.needs.build.action.text", new Object[0]) + UtilsKt.asString$default(UtilsKt.getBuildAndRefreshShortcut(), null, null, 3, null);
        return new ActionData(actionDataText, (Function0)new Function0<Unit>(this){
            final /* synthetic */ GlancePreviewViewModel this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                block0: {
                    PsiFile psiFile2 = (PsiFile)GlancePreviewViewModel.access$getPsiFilePointer$p(this.this$0).getElement();
                    if (psiFile2 == null || (psiFile2 = psiFile2.getVirtualFile()) == null) break block0;
                    PsiFile psiFile3 = psiFile2;
                    GlancePreviewViewModel glancePreviewViewModel = this.this$0;
                    PsiFile it = psiFile3;
                    boolean bl = false;
                    BuildUtilsKt.requestBuild((Project)GlancePreviewViewModel.access$getProject$p(glancePreviewViewModel), (VirtualFile)it);
                }
            }
        });
    }

    private final void updateView() {
        if (this.hasRendered.get()) {
            this.previewView.showContent();
        } else if (DumbService.getInstance((Project)this.project).isDumb()) {
            this.previewView.showLoadingMessage(GlancePreviewBundle.INSTANCE.message("panel.indexing", new Object[0]));
        } else if (this.projectBuildStatusManager.isBuilding()) {
            this.previewView.showLoadingMessage(GlancePreviewBundle.INSTANCE.message("panel.building", new Object[0]));
        } else if (Intrinsics.areEqual((Object)this.projectBuildStatusManager.getStatus(), (Object)ProjectStatus.NeedsBuild.INSTANCE)) {
            this.previewView.showErrorMessage(GlancePreviewBundle.INSTANCE.message("panel.needs.build", new Object[0]), null, this.getBuildAndRefreshAction());
        } else {
            this.previewView.showLoadingMessage(GlancePreviewBundle.INSTANCE.message("panel.initializing", new Object[0]));
        }
    }

    @Override
    public boolean isRefreshing() {
        return this.refreshCallsCount.get() > 0;
    }

    @Override
    public boolean getHasErrorsAndNeedsBuild() {
        return this.hasPreviews.get() && (!this.hasRendered.get() || (Boolean)this.hasRenderErrors.invoke() != false);
    }

    @Override
    public boolean getHasSyntaxErrors() {
        return WolfTheProblemSolver.getInstance((Project)this.project).isProblemFile(this.psiFilePointer.getVirtualFile());
    }

    @Override
    public boolean isOutOfDate() {
        return this.projectBuildStatusManager.getStatus() instanceof ProjectStatus.OutOfDate;
    }

    @Override
    @Nullable
    public PsiFile getPreviewedFile() {
        return (PsiFile)this.psiFilePointer.getElement();
    }

    public static final /* synthetic */ PreviewView access$getPreviewView$p(GlancePreviewViewModel $this) {
        return $this.previewView;
    }

    public static final /* synthetic */ Project access$getProject$p(GlancePreviewViewModel $this) {
        return $this.project;
    }

    public static final /* synthetic */ SmartPsiElementPointer access$getPsiFilePointer$p(GlancePreviewViewModel $this) {
        return $this.psiFilePointer;
    }

    public static final /* synthetic */ void access$updateView(GlancePreviewViewModel $this) {
        $this.updateView();
    }

    public static final /* synthetic */ void access$updateNotifications(GlancePreviewViewModel $this) {
        $this.updateNotifications();
    }

    public static final /* synthetic */ AtomicBoolean access$getHasRendered$p(GlancePreviewViewModel $this) {
        return $this.hasRendered;
    }
}

