/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.animation.timeline;

import com.android.tools.idea.compose.preview.animation.ComposeUnit;
import com.android.tools.idea.compose.preview.animation.InspectorColors;
import com.android.tools.idea.compose.preview.animation.InspectorLayout;
import com.android.tools.idea.compose.preview.animation.TooltipInfo;
import com.intellij.util.ui.JBFont;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\bJ\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J0\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\bH\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010\u000e\u001a\u0004\u0018\u00010\r2\b\u0010\f\u001a\u0004\u0018\u00010\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001b"}, d2={"Lcom/android/tools/idea/compose/preview/animation/timeline/BoxedLabel;", "", "componentId", "", "grouped", "", "position", "Lkotlin/Function0;", "Ljava/awt/Point;", "(IZLkotlin/jvm/functions/Function0;)V", "boxRect", "Ljava/awt/Rectangle;", "value", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$TimelineUnit;", "timelineUnit", "getTimelineUnit", "()Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$TimelineUnit;", "setTimelineUnit", "(Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$TimelineUnit;)V", "getTooltip", "Lcom/android/tools/idea/compose/preview/animation/TooltipInfo;", "point", "paint", "", "g", "Ljava/awt/Graphics2D;", "paintBoxedLabel", "intellij.android.compose-designer"})
public final class BoxedLabel {
    private final int componentId;
    private final boolean grouped;
    @NotNull
    private final Function0<Point> position;
    @Nullable
    private ComposeUnit.TimelineUnit timelineUnit;
    @NotNull
    private Rectangle boxRect;

    public BoxedLabel(int componentId, boolean grouped, @NotNull Function0<? extends Point> position) {
        Intrinsics.checkNotNullParameter(position, (String)"position");
        this.componentId = componentId;
        this.grouped = grouped;
        this.position = position;
        this.boxRect = new Rectangle(0, 0, 0, 0);
    }

    public final void paint(@NotNull Graphics2D g) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)g, (String)"g");
            ComposeUnit.TimelineUnit timelineUnit = this.timelineUnit;
            if (timelineUnit == null) break block0;
            ComposeUnit.TimelineUnit it = timelineUnit;
            boolean bl = false;
            this.paintBoxedLabel(g, it, this.componentId, this.grouped, (Point)this.position.invoke());
        }
    }

    @Nullable
    public final TooltipInfo getTooltip(@NotNull Point point) {
        TooltipInfo tooltipInfo;
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        if (this.boxRect.contains(point)) {
            ComposeUnit.TimelineUnit timelineUnit = this.timelineUnit;
            if (timelineUnit != null) {
                String string;
                ComposeUnit.TimelineUnit it = timelineUnit;
                boolean bl = false;
                String string2 = it.getPropertyLabel();
                if (this.grouped) {
                    ComposeUnit.Unit<?> unit2 = it.getUnit();
                    string = unit2 != null ? ((Object)unit2).toString() : null;
                } else {
                    ComposeUnit.Unit<?> unit3 = it.getUnit();
                    string = unit3 != null ? unit3.toString(this.componentId) : null;
                }
                tooltipInfo = new TooltipInfo(string2, String.valueOf(string));
            } else {
                tooltipInfo = null;
            }
        } else {
            tooltipInfo = null;
        }
        return tooltipInfo;
    }

    @Nullable
    public final ComposeUnit.TimelineUnit getTimelineUnit() {
        return this.timelineUnit;
    }

    public final void setTimelineUnit(@Nullable ComposeUnit.TimelineUnit value2) {
        this.timelineUnit = value2;
        ComposeUnit.TimelineUnit $this$alsoIfNull$iv = value2;
        boolean $i$f$alsoIfNull = false;
        if ($this$alsoIfNull$iv == null) {
            boolean bl = false;
            this.boxRect = new Rectangle(0, 0, 0, 0);
        }
    }

    private final void paintBoxedLabel(Graphics2D g, ComposeUnit.TimelineUnit timelineUnit, int componentId, boolean grouped, Point point) {
        String string;
        String label = timelineUnit.getPropertyLabel() + " :  ";
        if (grouped) {
            ComposeUnit.Unit<?> unit2 = timelineUnit.getUnit();
            string = unit2 != null ? ((Object)unit2).toString() : null;
        } else {
            ComposeUnit.Unit<?> unit3 = timelineUnit.getUnit();
            string = unit3 != null ? unit3.toString(componentId) : null;
        }
        String value2 = string;
        Color color = timelineUnit.getUnit() instanceof ComposeUnit.Color ? ((ComposeUnit.Color)timelineUnit.getUnit()).getColor() : null;
        g.setFont((Font)JBFont.medium());
        TextLayout labelLayout = new TextLayout(label, g.getFont(), g.getFontRenderContext());
        TextLayout valueLayout = new TextLayout(value2, g.getFont(), g.getFontRenderContext());
        int textBoxHeight = (int)(labelLayout.getBounds().getHeight() + (double)(InspectorLayout.INSTANCE.getBoxedLabelOffset() * 2));
        int extraColorOffset = color != null ? InspectorLayout.INSTANCE.getBoxedLabelColorBoxSize().width() + InspectorLayout.INSTANCE.getBoxedLabelOffset() : 0;
        int textBoxWidth = (int)(labelLayout.getBounds().getWidth() + valueLayout.getBounds().getWidth() + (double)(InspectorLayout.INSTANCE.getBoxedLabelOffset() * 3) + (double)extraColorOffset);
        this.boxRect = new Rectangle(point.x - InspectorLayout.INSTANCE.getBoxedLabelOffset(), point.y, textBoxWidth, textBoxHeight);
        g.setColor((Color)InspectorColors.INSTANCE.getBOXED_LABEL_BACKGROUND());
        g.fillRoundRect(this.boxRect.x, this.boxRect.y, this.boxRect.width, this.boxRect.height, InspectorLayout.INSTANCE.getBoxedLabelOffset(), InspectorLayout.INSTANCE.getBoxedLabelOffset());
        g.setColor(InspectorColors.INSTANCE.getBOXED_LABEL_NAME_COLOR());
        Object prevAntiAliasHint = g.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.drawString(label, point.x, point.y - InspectorLayout.INSTANCE.getBoxedLabelOffset() + textBoxHeight);
        int xPos = point.x + InspectorLayout.INSTANCE.getBoxedLabelOffset() + (int)labelLayout.getBounds().getWidth();
        Color color2 = color;
        if (color2 != null) {
            Color it = color2;
            boolean bl = false;
            g.setColor((Color)InspectorColors.INSTANCE.getBOXED_LABEL_OUTLINE());
            g.drawRoundRect(xPos, point.y + InspectorLayout.INSTANCE.getBoxedLabelOffset(), InspectorLayout.INSTANCE.getBoxedLabelColorBoxSize().width(), InspectorLayout.INSTANCE.getBoxedLabelColorBoxSize().height(), InspectorLayout.INSTANCE.getBoxedLabelColorBoxArc().width(), InspectorLayout.INSTANCE.getBoxedLabelColorBoxArc().height());
            g.setColor(color);
            g.fillRoundRect(xPos + 1, point.y + InspectorLayout.INSTANCE.getBoxedLabelOffset() + 1, InspectorLayout.INSTANCE.getBoxedLabelColorBoxSize().width() - 2, InspectorLayout.INSTANCE.getBoxedLabelColorBoxSize().height() - 2, InspectorLayout.INSTANCE.getBoxedLabelColorBoxArc().width(), InspectorLayout.INSTANCE.getBoxedLabelColorBoxArc().height());
        }
        g.setColor(InspectorColors.INSTANCE.getBOXED_LABEL_VALUE_COLOR());
        g.drawString(value2, xPos + extraColorOffset, point.y - InspectorLayout.INSTANCE.getBoxedLabelOffset() + textBoxHeight);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, prevAntiAliasHint);
    }
}

