/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.animation.managers;

import androidx.compose.animation.tooling.ComposeAnimation;
import com.android.tools.idea.compose.preview.animation.Card;
import com.android.tools.idea.compose.preview.animation.ComposeUnit;
import com.android.tools.idea.compose.preview.animation.Transition;
import com.android.tools.idea.compose.preview.animation.managers.AnimationManager;
import com.android.tools.idea.compose.preview.animation.timeline.ElementState;
import com.android.tools.idea.compose.preview.animation.timeline.PositionProxy;
import com.android.tools.idea.compose.preview.animation.timeline.TimelineElement;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010/\u001a\u0002002\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020,2\u0006\u00104\u001a\u000205H&J\b\u00106\u001a\u00020\u0016H&J\u0016\u00107\u001a\u00020\u00162\f\u00108\u001a\b\u0012\u0004\u0012\u00020\u001609H&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR$\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R&\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00160\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0012\u0010\u001b\u001a\u00020\u001cX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR0\u0010!\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020 0\u001f@DX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R,\u0010&\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020 0\u001f\u0012\u0004\u0012\u00020\u00160\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010\u0018\"\u0004\b(\u0010\u001aR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0013\u0010+\u001a\u0004\u0018\u00010,8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010.\u00a8\u0006:"}, d2={"Lcom/android/tools/idea/compose/preview/animation/managers/AnimationManager;", "", "animation", "Landroidx/compose/animation/tooling/ComposeAnimation;", "tabTitle", "", "(Landroidx/compose/animation/tooling/ComposeAnimation;Ljava/lang/String;)V", "getAnimation", "()Landroidx/compose/animation/tooling/ComposeAnimation;", "card", "Lcom/android/tools/idea/compose/preview/animation/Card;", "getCard", "()Lcom/android/tools/idea/compose/preview/animation/Card;", "value", "Lcom/android/tools/idea/compose/preview/animation/Transition;", "currentTransition", "getCurrentTransition", "()Lcom/android/tools/idea/compose/preview/animation/Transition;", "setCurrentTransition", "(Lcom/android/tools/idea/compose/preview/animation/Transition;)V", "currentTransitionCallback", "Lkotlin/Function1;", "", "getCurrentTransitionCallback", "()Lkotlin/jvm/functions/Function1;", "setCurrentTransitionCallback", "(Lkotlin/jvm/functions/Function1;)V", "elementState", "Lcom/android/tools/idea/compose/preview/animation/timeline/ElementState;", "getElementState", "()Lcom/android/tools/idea/compose/preview/animation/timeline/ElementState;", "", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$TimelineUnit;", "selectedProperties", "getSelectedProperties", "()Ljava/util/List;", "setSelectedProperties", "(Ljava/util/List;)V", "selectedPropertiesCallback", "getSelectedPropertiesCallback", "setSelectedPropertiesCallback", "getTabTitle", "()Ljava/lang/String;", "timelineMaximumMs", "", "getTimelineMaximumMs", "()Ljava/lang/Integer;", "createTimelineElement", "Lcom/android/tools/idea/compose/preview/animation/timeline/TimelineElement;", "parent", "Ljavax/swing/JComponent;", "minY", "positionProxy", "Lcom/android/tools/idea/compose/preview/animation/timeline/PositionProxy;", "loadProperties", "setup", "callback", "Lkotlin/Function0;", "intellij.android.compose-designer"})
public abstract class AnimationManager {
    @NotNull
    private final ComposeAnimation animation;
    @NotNull
    private final String tabTitle;
    @NotNull
    private Function1<? super Transition, Unit> currentTransitionCallback;
    @NotNull
    private Transition currentTransition;
    @NotNull
    private Function1<? super List<ComposeUnit.TimelineUnit>, Unit> selectedPropertiesCallback;
    @NotNull
    private List<ComposeUnit.TimelineUnit> selectedProperties;

    public AnimationManager(@NotNull ComposeAnimation animation, @NotNull String tabTitle) {
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        Intrinsics.checkNotNullParameter((Object)tabTitle, (String)"tabTitle");
        this.animation = animation;
        this.tabTitle = tabTitle;
        this.currentTransitionCallback = currentTransitionCallback.1.INSTANCE;
        this.currentTransition = new Transition(null, 1, null);
        this.selectedPropertiesCallback = selectedPropertiesCallback.1.INSTANCE;
        this.selectedProperties = CollectionsKt.emptyList();
    }

    @NotNull
    public final ComposeAnimation getAnimation() {
        return this.animation;
    }

    @NotNull
    public final String getTabTitle() {
        return this.tabTitle;
    }

    @NotNull
    public abstract ElementState getElementState();

    @NotNull
    public abstract Card getCard();

    @NotNull
    public final Function1<Transition, Unit> getCurrentTransitionCallback() {
        return this.currentTransitionCallback;
    }

    public final void setCurrentTransitionCallback(@NotNull Function1<? super Transition, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.currentTransitionCallback = function1;
    }

    @NotNull
    public final Transition getCurrentTransition() {
        return this.currentTransition;
    }

    protected final void setCurrentTransition(@NotNull Transition value2) {
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        this.currentTransition = value2;
        this.getElementState().setValueOffset(0);
        this.currentTransitionCallback.invoke((Object)value2);
    }

    @NotNull
    public final Function1<List<ComposeUnit.TimelineUnit>, Unit> getSelectedPropertiesCallback() {
        return this.selectedPropertiesCallback;
    }

    public final void setSelectedPropertiesCallback(@NotNull Function1<? super List<ComposeUnit.TimelineUnit>, Unit> function1) {
        Intrinsics.checkNotNullParameter(function1, (String)"<set-?>");
        this.selectedPropertiesCallback = function1;
    }

    @NotNull
    public final List<ComposeUnit.TimelineUnit> getSelectedProperties() {
        return this.selectedProperties;
    }

    protected final void setSelectedProperties(@NotNull List<ComposeUnit.TimelineUnit> value2) {
        Intrinsics.checkNotNullParameter(value2, (String)"value");
        this.selectedProperties = value2;
        this.selectedPropertiesCallback.invoke(value2);
    }

    @NotNull
    public abstract TimelineElement createTimelineElement(@NotNull JComponent var1, int var2, @NotNull PositionProxy var3);

    public abstract void loadProperties();

    public abstract void setup(@NotNull Function0<Unit> var1);

    @Nullable
    public final Integer getTimelineMaximumMs() {
        Integer n;
        Integer n2 = this.currentTransition.getEndMillis();
        if (n2 != null) {
            int it = ((Number)n2).intValue();
            boolean bl = false;
            n = Math.max(it + this.getElementState().getValueOffset(), it);
        } else {
            n = null;
        }
        return n;
    }
}

