/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.animation;

import com.android.tools.idea.compose.preview.animation.InspectorColors;
import com.android.tools.idea.compose.preview.animation.InspectorLayout;
import com.android.tools.idea.compose.preview.animation.TimelinePanel;
import com.android.tools.idea.compose.preview.animation.TooltipInfo;
import com.android.tools.idea.compose.preview.animation.timeline.PositionProxy;
import com.android.tools.idea.compose.preview.animation.timeline.TimelineElement;
import com.android.tools.idea.compose.preview.animation.timeline.TimelineElementStatus;
import com.android.tools.idea.flags.StudioFlags;
import com.google.wireless.android.sdk.stats.ComposeAnimationToolingEvent;
import com.intellij.ui.JBColor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JSlider;
import javax.swing.plaf.basic.BasicSliderUI;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.internal.ProgressionUtilKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0016\u0018\u00002\u00020\u0001:\u00012B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u001d\u001a\u00020\u001eH\u0004J\b\u0010\u001f\u001a\u00020\u001eH\u0004J\u0014\u0010 \u001a\u00060!R\u00020\u00002\u0006\u0010\"\u001a\u00020#H\u0004J\b\u0010$\u001a\u00020%H\u0004J\u0010\u0010&\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0016J\u0010\u0010)\u001a\u00020\u001e2\b\u0010'\u001a\u0004\u0018\u00010*J\u0010\u0010+\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0002J\u0010\u0010,\u001a\u00020\u001e2\b\u0010'\u001a\u0004\u0018\u00010*J\u0010\u0010-\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020(H\u0002J\u000e\u0010.\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020*J\u000e\u0010/\u001a\u00020\u001e2\u0006\u0010'\u001a\u00020*J\b\u00100\u001a\u000201H\u0002R(\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006@BX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR \u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00060\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\u00a8\u00063"}, d2={"Lcom/android/tools/idea/compose/preview/animation/TimelineSliderUI;", "Ljavax/swing/plaf/basic/BasicSliderUI;", "timeline", "Lcom/android/tools/idea/compose/preview/animation/TimelinePanel;", "(Lcom/android/tools/idea/compose/preview/animation/TimelinePanel;)V", "value", "Lcom/android/tools/idea/compose/preview/animation/timeline/TimelineElement;", "activeElement", "getActiveElement", "()Lcom/android/tools/idea/compose/preview/animation/timeline/TimelineElement;", "setActiveElement", "(Lcom/android/tools/idea/compose/preview/animation/timeline/TimelineElement;)V", "elements", "", "getElements", "()Ljava/util/List;", "setElements", "(Ljava/util/List;)V", "positionProxy", "Lcom/android/tools/idea/compose/preview/animation/timeline/PositionProxy;", "getPositionProxy", "()Lcom/android/tools/idea/compose/preview/animation/timeline/PositionProxy;", "thumbRect", "Lkotlin/Function0;", "Ljava/awt/Rectangle;", "getThumbRect", "()Lkotlin/jvm/functions/Function0;", "getTimeline", "()Lcom/android/tools/idea/compose/preview/animation/TimelinePanel;", "calculateLabelRect", "", "calculateTickRect", "createTrackListener", "Lcom/android/tools/idea/compose/preview/animation/TimelineSliderUI$TimelineTrackListener;", "slider", "Ljavax/swing/JSlider;", "getThumbSize", "Ljava/awt/Dimension;", "paintElements", "g", "Ljava/awt/Graphics2D;", "paintFocus", "Ljava/awt/Graphics;", "paintFreezeLines", "paintLabels", "paintMajorTicks", "paintThumb", "paintTrack", "separateElements", "", "TimelineTrackListener", "intellij.android.compose-designer"})
public class TimelineSliderUI
extends BasicSliderUI {
    @NotNull
    private final TimelinePanel timeline;
    @NotNull
    private final PositionProxy positionProxy;
    @NotNull
    private final Function0<Rectangle> thumbRect;
    @NotNull
    private List<TimelineElement> elements;
    @Nullable
    private TimelineElement activeElement;

    public TimelineSliderUI(@NotNull TimelinePanel timeline) {
        Intrinsics.checkNotNullParameter((Object)timeline, (String)"timeline");
        super(timeline);
        this.timeline = timeline;
        this.positionProxy = new PositionProxy(this){
            final /* synthetic */ TimelineSliderUI this$0;
            {
                this.this$0 = $receiver;
            }

            public int valueForXPosition(int value2) {
                return this.this$0.valueForXPosition(value2);
            }

            public int xPositionForValue(int value2) {
                return TimelineSliderUI.access$xPositionForValue(this.this$0, value2);
            }

            public int maximumXPosition() {
                return this.xPositionForValue(TimelineSliderUI.access$getSlider$p$s-1555465546(this.this$0).getMaximum());
            }

            public int minimumXPosition() {
                return this.xPositionForValue(TimelineSliderUI.access$getSlider$p$s-1555465546(this.this$0).getMinimum());
            }

            public int maximumValue() {
                return TimelineSliderUI.access$getSlider$p$s-1555465546(this.this$0).getMaximum();
            }

            public int minimumValue() {
                return TimelineSliderUI.access$getSlider$p$s-1555465546(this.this$0).getMinimum();
            }
        };
        this.thumbRect = (Function0)new Function0<Rectangle>(this){
            final /* synthetic */ TimelineSliderUI this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final Rectangle invoke() {
                Rectangle rectangle = TimelineSliderUI.access$getThumbRect$p$s-1555465546(this.this$0);
                Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"thumbRect");
                return rectangle;
            }
        };
        this.elements = new ArrayList();
    }

    @NotNull
    public final TimelinePanel getTimeline() {
        return this.timeline;
    }

    @NotNull
    public final PositionProxy getPositionProxy() {
        return this.positionProxy;
    }

    @NotNull
    public final Function0<Rectangle> getThumbRect() {
        return this.thumbRect;
    }

    @NotNull
    public final List<TimelineElement> getElements() {
        return this.elements;
    }

    public final void setElements(@NotNull List<TimelineElement> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.elements = list;
    }

    @Nullable
    public final TimelineElement getActiveElement() {
        return this.activeElement;
    }

    /*
     * Unable to fully structure code
     */
    private final void setActiveElement(TimelineElement value) {
        if (!this.timeline.getPreviewState().isCoordinationAvailable()) ** GOTO lbl-1000
        v0 = StudioFlags.COMPOSE_ANIMATION_PREVIEW_COORDINATION_DRAG.get();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"COMPOSE_ANIMATION_PREVIEW_COORDINATION_DRAG.get()");
        if (((Boolean)v0).booleanValue()) {
            v1 = value;
        } else lbl-1000:
        // 2 sources

        {
            v1 = null;
        }
        this.activeElement = v1;
    }

    private final boolean separateElements() {
        return this.elements.size() > 1;
    }

    public void paintElements(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Iterable $this$forEach$iv = this.elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            TimelineElement it = (TimelineElement)element$iv;
            boolean bl = false;
            it.paint(g);
        }
    }

    @Override
    @NotNull
    protected final Dimension getThumbSize() {
        Dimension dimension;
        Dimension originalSize = super.getThumbSize();
        if (this.slider.getParent() == null) {
            Intrinsics.checkNotNullExpressionValue((Object)originalSize, (String)"originalSize");
            dimension = originalSize;
        } else {
            dimension = new Dimension(originalSize.width, this.slider.getParent().getHeight() - InspectorLayout.INSTANCE.timelineHeaderHeightScaled());
        }
        return dimension;
    }

    @Override
    protected final void calculateTickRect() {
        this.tickRect.x = this.thumbRect.x;
        this.tickRect.y = this.thumbRect.y;
        this.tickRect.width = this.thumbRect.width;
        this.tickRect.height = this.thumbRect.height + InspectorLayout.INSTANCE.timelineHeaderHeightScaled();
    }

    @Override
    protected final void calculateLabelRect() {
        super.calculateLabelRect();
        this.labelRect.x = 0;
        this.labelRect.y = 0;
        this.labelRect.y = InspectorLayout.INSTANCE.timelineLabelVerticalMarginScaled();
    }

    @Override
    public final void paintTrack(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        this.paintMajorTicks((Graphics2D)g);
        this.paintElements((Graphics2D)g);
        this.paintFreezeLines((Graphics2D)g);
    }

    @Override
    public final void paintFocus(@Nullable Graphics g) {
    }

    @Override
    public final void paintLabels(@Nullable Graphics g) {
        super.paintLabels(g);
        Intrinsics.checkNotNull((Object)g, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D cfr_ignored_0 = (Graphics2D)g;
        ((Graphics2D)g).setColor(JBColor.border());
        ((Graphics2D)g).setStroke(new BasicStroke(1.0f));
        int borderHeight = InspectorLayout.INSTANCE.timelineHeaderHeightScaled();
        ((Graphics2D)g).drawLine(-5, borderHeight, this.slider.getWidth() + 5, borderHeight);
    }

    @Override
    public final void paintThumb(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
    }

    @Override
    @NotNull
    protected final TimelineTrackListener createTrackListener(@NotNull JSlider slider) {
        Intrinsics.checkNotNullParameter((Object)slider, (String)"slider");
        return new TimelineTrackListener();
    }

    /*
     * Unable to fully structure code
     */
    private final void paintMajorTicks(Graphics2D g) {
        if (this.separateElements()) ** GOTO lbl-1000
        v0 = (TimelineElement)CollectionsKt.firstOrNull(this.elements);
        v1 = v0 != null ? v0.getFrozen() : false;
        if (v1) {
            v2 = (Color)InspectorColors.INSTANCE.getTIMELINE_FROZEN_BACKGROUND_COLOR();
        } else lbl-1000:
        // 2 sources

        {
            v2 = (Color)InspectorColors.INSTANCE.getTIMELINE_BACKGROUND_COLOR();
        }
        g.setColor(v2);
        g.fillRect(0, InspectorLayout.INSTANCE.timelineHeaderHeightScaled(), this.slider.getWidth(), this.slider.getHeight() - InspectorLayout.INSTANCE.timelineHeaderHeightScaled());
        totalHeight = 0;
        totalHeight = InspectorLayout.INSTANCE.timelineHeaderHeightScaled();
        if (this.separateElements()) {
            $this$forEach$iv = this.elements;
            $i$f$forEach = 0;
            for (T element$iv : $this$forEach$iv) {
                element = (TimelineElement)element$iv;
                $i$a$-forEach-TimelineSliderUI$paintMajorTicks$1 = false;
                if (element.getFrozen()) {
                    g.setColor((Color)InspectorColors.INSTANCE.getTIMELINE_FROZEN_BACKGROUND_COLOR());
                    g.fillRect(0, totalHeight, this.slider.getWidth(), element.heightScaled());
                }
                totalHeight += element.heightScaled();
            }
        }
        g.setColor((Color)InspectorColors.INSTANCE.getTIMELINE_TICK_COLOR());
        tickIncrement = Math.max(1, this.slider.getMajorTickSpacing() / 5);
        $i$f$forEach = this.slider.getMaximum();
        if (tickIncrement <= 0) {
            throw new IllegalArgumentException("Step must be positive, was: " + tickIncrement + ".");
        }
        tick = 0;
        var6_10 = ProgressionUtilKt.getProgressionLastElement((int)0, (int)$i$f$forEach, (int)tickIncrement);
        if (tick <= var6_10) {
            while (true) {
                xPos = this.xPositionForValue(tick);
                g.drawLine(xPos, InspectorLayout.INSTANCE.timelineHeaderHeightScaled(), xPos, this.tickRect.height);
                if (tick == var6_10) break;
                tick += tickIncrement;
            }
        }
        totalHeight = InspectorLayout.INSTANCE.timelineHeaderHeightScaled();
        g.setColor(InspectorColors.INSTANCE.getTIMELINE_HORIZONTAL_TICK_COLOR());
        if (this.separateElements()) {
            $this$forEach$iv = this.elements;
            $i$f$forEach = false;
            for (T element$iv : $this$forEach$iv) {
                element = (TimelineElement)element$iv;
                $i$a$-forEach-TimelineSliderUI$paintMajorTicks$2 = false;
                g.drawLine(0, totalHeight += element.heightScaled(), this.slider.getWidth(), totalHeight);
            }
        }
    }

    private final void paintFreezeLines(Graphics2D g) {
        block4: {
            TimelineElement timelineElement;
            block3: {
                g.setColor((Color)InspectorColors.INSTANCE.getFREEZE_LINE_COLOR());
                g.setStroke(InspectorLayout.INSTANCE.getFreezeLineStroke());
                int totalHeight = 0;
                totalHeight = InspectorLayout.INSTANCE.timelineHeaderHeightScaled();
                if (!this.separateElements()) break block3;
                Iterable $this$forEach$iv = this.elements;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    TimelineElement element = (TimelineElement)element$iv;
                    boolean bl = false;
                    if (element.getFrozen()) {
                        int frozenValue = element.getState().getFrozenValue();
                        g.drawLine(this.xPositionForValue(frozenValue), totalHeight + 2, this.xPositionForValue(frozenValue), totalHeight + element.heightScaled() - 2);
                    }
                    totalHeight += element.heightScaled();
                }
                break block4;
            }
            TimelineElement timelineElement2 = (TimelineElement)CollectionsKt.firstOrNull(this.elements);
            if (timelineElement2 == null) break block4;
            TimelineElement it = timelineElement = timelineElement2;
            boolean bl = false;
            if (it.getFrozen()) {
                int frozenValue = it.getState().getFrozenValue();
                g.drawLine(this.xPositionForValue(frozenValue), InspectorLayout.INSTANCE.timelineHeaderHeightScaled() + 2, this.xPositionForValue(frozenValue), this.slider.getHeight() - 2);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0086\u0004\u0018\u00002\u00060\u0001R\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0010\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u0012\u001a\u00020\u000bH\u0002J\u0010\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/compose/preview/animation/TimelineSliderUI$TimelineTrackListener;", "Ljavax/swing/plaf/basic/BasicSliderUI$TrackListener;", "Ljavax/swing/plaf/basic/BasicSliderUI;", "(Lcom/android/tools/idea/compose/preview/animation/TimelineSliderUI;)V", "dragStartXPoint", "", "isDragging", "", "tooltipAdapter", "Ljava/awt/event/MouseAdapter;", "mouseDragged", "", "e", "Ljava/awt/event/MouseEvent;", "mouseExited", "mouseMoved", "mousePressed", "mouseReleased", "updateThumbLocationAndSliderValue", "updateTooltip", "intellij.android.compose-designer"})
    public final class TimelineTrackListener
    extends BasicSliderUI.TrackListener {
        @NotNull
        private final MouseAdapter tooltipAdapter;
        private boolean isDragging;
        private int dragStartXPoint;

        public TimelineTrackListener() {
            super(TimelineSliderUI.this);
            this.tooltipAdapter = TimelineSliderUI.this.getTimeline().getTooltip().getAdapter();
        }

        @Override
        public void mousePressed(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            this.currentMouseX = e.getX();
            Container container = TimelineSliderUI.this.slider.getParent();
            if (container != null) {
                container.requestFocus();
            }
            this.dragStartXPoint = e.getX();
            TimelineElement timelineElement = TimelineSliderUI.this.getActiveElement();
            if (timelineElement != null) {
                timelineElement.setStatus(TimelineElementStatus.Dragged);
            }
            if (TimelineSliderUI.this.getActiveElement() == null) {
                this.updateThumbLocationAndSliderValue();
            }
        }

        @Override
        public void mouseDragged(@NotNull MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            super.mouseDragged(e);
            this.tooltipAdapter.mouseDragged(e);
            TimelineElement timelineElement = TimelineSliderUI.this.getActiveElement();
            if ((timelineElement != null ? timelineElement.getStatus() : null) == TimelineElementStatus.Dragged) {
                TimelineElement timelineElement2 = TimelineSliderUI.this.getActiveElement();
                if (timelineElement2 != null) {
                    timelineElement2.move(e.getX() - this.dragStartXPoint);
                }
                this.dragStartXPoint = e.getX();
            } else {
                this.updateThumbLocationAndSliderValue();
            }
            this.isDragging = true;
            this.updateTooltip(e);
            TimelineSliderUI.this.slider.repaint();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void mouseReleased(@NotNull MouseEvent e) {
            Object v3;
            TimelineSliderUI timelineSliderUI;
            block5: {
                void $this$firstOrNull$iv;
                Object it;
                Iterable $this$forEach$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.mouseReleased(e);
                TimelineSliderUI.this.getTimeline().getTracker().invoke((Object)(TimelineSliderUI.this.getActiveElement() == null ? (this.isDragging ? ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.DRAG_ANIMATION_INSPECTOR_TIMELINE : ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.CLICK_ANIMATION_INSPECTOR_TIMELINE) : (this.isDragging ? ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.DRAG_TIMELINE_LINE : ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.CLICK_ANIMATION_INSPECTOR_TIMELINE)));
                this.isDragging = false;
                TimelineElement timelineElement = TimelineSliderUI.this.getActiveElement();
                if ((timelineElement != null ? timelineElement.getStatus() : null) == TimelineElementStatus.Dragged) {
                    $this$forEach$iv = TimelineSliderUI.this.getTimeline().getDragEndListeners();
                    boolean $i$f$forEach = false;
                    for (Object element$iv : $this$forEach$iv) {
                        it = (Function0)element$iv;
                        boolean bl = false;
                        it.invoke();
                    }
                }
                TimelineElement timelineElement2 = TimelineSliderUI.this.getActiveElement();
                if (timelineElement2 != null) {
                    timelineElement2.setStatus(TimelineElementStatus.Inactive);
                }
                $this$forEach$iv = TimelineSliderUI.this.getElements();
                timelineSliderUI = TimelineSliderUI.this;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    it = (TimelineElement)element$iv;
                    boolean bl = false;
                    Point point = e.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"e.point");
                    if (!((TimelineElement)it).contains(point)) continue;
                    v3 = element$iv;
                    break block5;
                }
                v3 = null;
            }
            timelineSliderUI.setActiveElement(v3);
            TimelineElement timelineElement = TimelineSliderUI.this.getActiveElement();
            if (timelineElement != null) {
                timelineElement.setStatus(TimelineElementStatus.Hovered);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void mouseMoved(@NotNull MouseEvent e) {
            Object v2;
            TimelineSliderUI timelineSliderUI;
            block4: {
                void $this$firstOrNull$iv;
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.mouseMoved(e);
                this.tooltipAdapter.mouseMoved(e);
                TimelineSliderUI.this.slider.repaint();
                if (this.isDragging) {
                    return;
                }
                TimelineElement timelineElement = TimelineSliderUI.this.getActiveElement();
                if (timelineElement != null) {
                    timelineElement.setStatus(TimelineElementStatus.Inactive);
                }
                Iterable iterable = TimelineSliderUI.this.getElements();
                timelineSliderUI = TimelineSliderUI.this;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TimelineElement it = (TimelineElement)element$iv;
                    boolean bl = false;
                    Point point = e.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"e.point");
                    if (!it.contains(point)) continue;
                    v2 = element$iv;
                    break block4;
                }
                v2 = null;
            }
            timelineSliderUI.setActiveElement(v2);
            TimelineElement timelineElement = TimelineSliderUI.this.getActiveElement();
            if (timelineElement != null) {
                timelineElement.setStatus(TimelineElementStatus.Hovered);
            }
            this.updateTooltip(e);
        }

        @Override
        public void mouseExited(@Nullable MouseEvent e) {
            super.mouseExited(e);
            this.tooltipAdapter.mouseExited(e);
        }

        private final void updateTooltip(MouseEvent e) {
            TooltipInfo tooltipInfo;
            block5: {
                TooltipInfo tooltipInfo2;
                for (TimelineElement it : (Iterable)TimelineSliderUI.this.getElements()) {
                    boolean bl = false;
                    Point point = e.getPoint();
                    Intrinsics.checkNotNullExpressionValue((Object)point, (String)"e.point");
                    TooltipInfo tooltipInfo3 = it.getTooltip(point);
                    if (tooltipInfo3 == null) continue;
                    tooltipInfo2 = tooltipInfo3;
                    break block5;
                }
                tooltipInfo2 = tooltipInfo = null;
            }
            if (tooltipInfo != null) {
                if (TimelineSliderUI.this.getTimeline().getTooltip().getTooltipInfo() == null) {
                    this.tooltipAdapter.mouseEntered(e);
                }
                TimelineSliderUI.this.getTimeline().getTooltip().setTooltipInfo(tooltipInfo);
            } else {
                if (TimelineSliderUI.this.getTimeline().getTooltip().getTooltipInfo() != null) {
                    this.tooltipAdapter.mouseExited(e);
                }
                TimelineSliderUI.this.getTimeline().getTooltip().setTooltipInfo(null);
            }
        }

        private final void updateThumbLocationAndSliderValue() {
            int halfWidth = ((TimelineSliderUI)TimelineSliderUI.this).thumbRect.width / 2;
            int thumbX = RangesKt.coerceIn((int)this.currentMouseX, (int)TimelineSliderUI.this.xPositionForValue(TimelineSliderUI.this.slider.getMinimum()), (int)TimelineSliderUI.this.xPositionForValue(TimelineSliderUI.this.slider.getMaximum())) - halfWidth;
            TimelineSliderUI.this.setThumbLocation(thumbX, ((TimelineSliderUI)TimelineSliderUI.this).thumbRect.y);
            TimelineSliderUI.this.slider.setValue(TimelineSliderUI.this.valueForXPosition(this.currentMouseX));
        }
    }
}

