/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.animation;

import androidx.compose.animation.tooling.ComposeAnimatedProperty;
import com.android.tools.adtui.model.stdui.EditingErrorCategory;
import com.android.tools.idea.compose.preview.ComposePreviewBundle;
import com.android.tools.idea.compose.preview.animation.ComposeUnit;
import com.android.tools.idea.compose.preview.animation.picker.AnimatedPropertyItem;
import com.android.tools.idea.compose.preview.animation.validation.DoubleValidation;
import com.android.tools.idea.compose.preview.animation.validation.FloatValidationKt;
import com.android.tools.idea.compose.preview.animation.validation.IntValidation;
import com.intellij.ui.ColorUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0011\r\u000e\u000f\u0010\u0011\u0012\u0013\u0014\u0015\u0016\u0017\u0018\u0019\u001a\u001b\u001c\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0001H\u0002J\u0014\u0010\b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\u0007\u001a\u00020\nJ\u0016\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\b\u0010\f\u001a\u0004\u0018\u00010\u0001\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit;", "", "()V", "findMethodByName", "Ljava/lang/reflect/Method;", "methodName", "", "property", "parse", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "Landroidx/compose/animation/tooling/ComposeAnimatedProperty;", "parseValue", "value", "Color", "DoubleUnit", "Dp", "FloatUnit", "IntOffset", "IntSize", "IntUnit", "Offset", "Rect", "Size", "TimelineUnit", "Unit", "Unit1D", "Unit2D", "Unit3D", "Unit4D", "UnitUnknown", "intellij.android.compose-designer"})
public final class ComposeUnit {
    @NotNull
    public static final ComposeUnit INSTANCE = new ComposeUnit();

    private ComposeUnit() {
    }

    @Nullable
    public final Unit<?> parse(@NotNull ComposeAnimatedProperty property) {
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        return this.parseValue(property.getValue());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Nullable
    public final Unit<?> parseValue(@Nullable Object value2) {
        Unit unit2;
        if (value2 == null) {
            return null;
        }
        String string = JvmClassMappingKt.getKotlinClass(value2.getClass()).getQualifiedName();
        if (string != null) {
            int n = -1;
            switch (string.hashCode()) {
                case 1098275025: {
                    if (!string.equals("androidx.compose.ui.unit.IntOffset")) break;
                    n = 1;
                    break;
                }
                case -1323466364: {
                    if (!string.equals("androidx.compose.ui.geometry.Size")) break;
                    n = 2;
                    break;
                }
                case -658722474: {
                    if (!string.equals("androidx.compose.ui.geometry.Offset")) break;
                    n = 3;
                    break;
                }
                case -2133280414: {
                    if (!string.equals("kotlin.Int")) break;
                    n = 4;
                    break;
                }
                case -1323500697: {
                    if (!string.equals("androidx.compose.ui.geometry.Rect")) break;
                    n = 5;
                    break;
                }
                case -67829378: {
                    if (!string.equals("kotlin.Double")) break;
                    n = 6;
                    break;
                }
                case -1385909489: {
                    if (!string.equals("kotlin.Float")) break;
                    n = 7;
                    break;
                }
                case 1906416637: {
                    if (!string.equals("androidx.compose.ui.unit.Dp")) break;
                    n = 8;
                    break;
                }
                case 195471769: {
                    if (!string.equals("androidx.compose.ui.graphics.Color")) break;
                    n = 9;
                    break;
                }
                case -1518285889: {
                    if (!string.equals("androidx.compose.ui.unit.IntSize")) break;
                    n = 10;
                    break;
                }
            }
            switch (n) {
                case 9: {
                    unit2 = Color.Companion.create(value2);
                    return unit2;
                }
                case 8: {
                    unit2 = Dp.Companion.create(value2);
                    return unit2;
                }
                case 2: {
                    unit2 = Size.Companion.create(value2);
                    return unit2;
                }
                case 5: {
                    unit2 = Rect.Companion.create(value2);
                    return unit2;
                }
                case 1: {
                    unit2 = IntOffset.Companion.create(value2);
                    return unit2;
                }
                case 10: {
                    unit2 = IntSize.Companion.create(value2);
                    return unit2;
                }
                case 3: {
                    unit2 = Offset.Companion.create(value2);
                    return unit2;
                }
                case 4: {
                    unit2 = value2 instanceof Integer ? new IntUnit(((Number)value2).intValue()) : null;
                    return unit2;
                }
                case 6: {
                    unit2 = value2 instanceof Double ? new DoubleUnit(((Number)value2).doubleValue()) : null;
                    return unit2;
                }
                case 7: {
                    unit2 = value2 instanceof Float ? new FloatUnit(((Number)value2).floatValue()) : null;
                    return unit2;
                }
            }
        }
        unit2 = new UnitUnknown(value2);
        return unit2;
    }

    private final Method findMethodByName(String methodName, Object property) {
        Method method;
        Object object;
        block4: {
            Method[] methodArray = property.getClass().getMethods();
            Intrinsics.checkNotNullExpressionValue((Object)methodArray, (String)"property::class.java.methods");
            Object[] $this$singleOrNull$iv = methodArray;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                Method it = (Method)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)methodName)) continue;
                if (found$iv) {
                    object = null;
                    break block4;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            object = !found$iv ? null : single$iv;
        }
        Method method2 = (Method)object;
        if (method2 != null) {
            Method method3;
            Method $this$findMethodByName_u24lambda_u2d1 = method3 = method2;
            boolean bl = false;
            $this$findMethodByName_u24lambda_u2d1.setAccessible(true);
            method = method3;
        } else {
            method = null;
        }
        return method;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0017\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$TimelineUnit;", "", "propertyLabel", "", "unit", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "(Ljava/lang/String;Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;)V", "getPropertyLabel", "()Ljava/lang/String;", "getUnit", "()Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "intellij.android.compose-designer"})
    public static final class TimelineUnit {
        @NotNull
        private final String propertyLabel;
        @Nullable
        private final Unit<?> unit;

        public TimelineUnit(@NotNull String propertyLabel, @Nullable Unit<?> unit2) {
            Intrinsics.checkNotNullParameter((Object)propertyLabel, (String)"propertyLabel");
            this.propertyLabel = propertyLabel;
            this.unit = unit2;
        }

        @NotNull
        public final String getPropertyLabel() {
            return this.propertyLabel;
        }

        @Nullable
        public final Unit<?> getUnit() {
            return this.unit;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0010\u000f\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\u00020\u0004J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H&J$\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00002\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0014H&J\b\u0010\u0015\u001a\u00020\u0010H&J\u0010\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\fH&R\u0018\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0016\u00c0\u0006\u0003"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "A", "", "", "", "components", "", "getComponents", "()Ljava/util/List;", "componentAsDouble", "", "componentId", "", "createProperties", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "getPickerTitle", "parseUnit", "getValue", "Lkotlin/Function1;", "toString", "intellij.android.compose-designer"})
    public static interface Unit<A extends Number> {
        @NotNull
        public List<A> getComponents();

        @NotNull
        public String toString(int var1);

        @NotNull
        public String toString();

        default public double componentAsDouble(int componentId) {
            return ((Number)this.getComponents().get(componentId)).doubleValue();
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        default public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Iterable $this$mapIndexed$iv = this.getComponents();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void component;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Number number = (Number)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AnimatedPropertyItem(prefix + "." + (int)index, String.valueOf(component), (Function1<? super String, ? extends Pair<? extends EditingErrorCategory, String>>)((Function1)createProperties.1.1.INSTANCE), "Any"));
            }
            return (List)destination$iv$iv;
        }

        @Nullable
        public Unit<?> parseUnit(@NotNull Function1<? super Integer, String> var1);

        @NotNull
        public String getPickerTitle();

        @Metadata(mv={1, 6, 0}, k=3, xi=48)
        public static final class DefaultImpls {
            @Deprecated
            public static <A extends Number> double componentAsDouble(@NotNull Unit<A> $this, int componentId) {
                return ((Unit)$this).componentAsDouble(componentId);
            }

            @Deprecated
            @NotNull
            public static <A extends Number> List<AnimatedPropertyItem> createProperties(@NotNull Unit<A> $this, @NotNull String prefix) {
                Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
                return ((Unit)$this).createProperties(prefix);
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b&\u0018\u0000*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\t\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit1D;", "A", "", "", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "component1", "(Ljava/lang/Number;)V", "getComponent1", "()Ljava/lang/Number;", "Ljava/lang/Number;", "components", "", "getComponents", "()Ljava/util/List;", "toString", "", "componentId", "", "intellij.android.compose-designer"})
    public static abstract class Unit1D<A extends Number>
    implements Unit<A> {
        @NotNull
        private final A component1;
        @NotNull
        private final List<A> components;

        public Unit1D(@NotNull A component1) {
            Intrinsics.checkNotNullParameter(component1, (String)"component1");
            this.component1 = component1;
            this.components = CollectionsKt.listOf(this.component1);
        }

        @NotNull
        public final A getComponent1() {
            return this.component1;
        }

        @Override
        @NotNull
        public List<A> getComponents() {
            return this.components;
        }

        @Override
        @NotNull
        public String toString(int componentId) {
            return this.component1.toString();
        }

        @Override
        @NotNull
        public String toString() {
            return CollectionsKt.joinToString$default((Iterable)this.getComponents(), null, null, null, (int)0, null, (Function1)toString.1.INSTANCE, (int)31, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b&\u0018\u0000*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\u000b\u0010\tR\u001a\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit2D;", "A", "", "", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "component1", "component2", "(Ljava/lang/Number;Ljava/lang/Number;)V", "getComponent1", "()Ljava/lang/Number;", "Ljava/lang/Number;", "getComponent2", "components", "", "getComponents", "()Ljava/util/List;", "toString", "", "componentId", "", "intellij.android.compose-designer"})
    public static abstract class Unit2D<A extends Number>
    implements Unit<A> {
        @NotNull
        private final A component1;
        @NotNull
        private final A component2;
        @NotNull
        private final List<A> components;

        public Unit2D(@NotNull A component1, @NotNull A component2) {
            Intrinsics.checkNotNullParameter(component1, (String)"component1");
            Intrinsics.checkNotNullParameter(component2, (String)"component2");
            this.component1 = component1;
            this.component2 = component2;
            Object[] objectArray = new Number[]{this.component1, this.component2};
            this.components = CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final A getComponent1() {
            return this.component1;
        }

        @NotNull
        public final A getComponent2() {
            return this.component2;
        }

        @Override
        @NotNull
        public List<A> getComponents() {
            return this.components;
        }

        @Override
        @NotNull
        public String toString(int componentId) {
            return "( " + (componentId == 0 ? this.component1 : "_") + " , " + (componentId == 1 ? this.component2 : "_") + " )";
        }

        @Override
        @NotNull
        public String toString() {
            return CollectionsKt.joinToString$default((Iterable)this.getComponents(), (CharSequence)" , ", (CharSequence)"( ", (CharSequence)" )", (int)0, null, (Function1)toString.1.INSTANCE, (int)24, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b&\u0018\u0000*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B\u001d\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\f\u0010\nR\u0013\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000b\u001a\u0004\b\r\u0010\nR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00028\u00000\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit3D;", "A", "", "", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "component1", "component2", "component3", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "getComponent1", "()Ljava/lang/Number;", "Ljava/lang/Number;", "getComponent2", "getComponent3", "components", "", "getComponents", "()Ljava/util/List;", "toString", "", "componentId", "", "intellij.android.compose-designer"})
    public static abstract class Unit3D<A extends Number>
    implements Unit<A> {
        @NotNull
        private final A component1;
        @NotNull
        private final A component2;
        @NotNull
        private final A component3;
        @NotNull
        private final List<A> components;

        public Unit3D(@NotNull A component1, @NotNull A component2, @NotNull A component3) {
            Intrinsics.checkNotNullParameter(component1, (String)"component1");
            Intrinsics.checkNotNullParameter(component2, (String)"component2");
            Intrinsics.checkNotNullParameter(component3, (String)"component3");
            this.component1 = component1;
            this.component2 = component2;
            this.component3 = component3;
            Object[] objectArray = new Number[]{this.component1, this.component2, this.component3};
            this.components = CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final A getComponent1() {
            return this.component1;
        }

        @NotNull
        public final A getComponent2() {
            return this.component2;
        }

        @NotNull
        public final A getComponent3() {
            return this.component3;
        }

        @Override
        @NotNull
        public List<A> getComponents() {
            return this.components;
        }

        @Override
        @NotNull
        public String toString(int componentId) {
            return "( " + (componentId == 0 ? this.component1 : "_") + " , " + (componentId == 1 ? this.component2 : "_") + " , " + (componentId == 2 ? this.component3 : "_") + " )";
        }

        @Override
        @NotNull
        public String toString() {
            return CollectionsKt.joinToString$default((Iterable)this.getComponents(), (CharSequence)" , ", (CharSequence)"( ", (CharSequence)" )", (int)0, null, (Function1)toString.1.INSTANCE, (int)24, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\b&\u0018\u0000*\u0012\b\u0000\u0010\u0001*\u00020\u0002*\b\u0012\u0004\u0012\u0002H\u00010\u00032\b\u0012\u0004\u0012\u0002H\u00010\u0004B%\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\u0006\u0010\u0006\u001a\u00028\u0000\u0012\u0006\u0010\u0007\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0016R\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0006\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\r\u0010\u000bR\u0013\u0010\u0007\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u000e\u0010\u000bR\u0013\u0010\b\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\u000f\u0010\u000bR\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit4D;", "A", "", "", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "component1", "component2", "component3", "component4", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "getComponent1", "()Ljava/lang/Number;", "Ljava/lang/Number;", "getComponent2", "getComponent3", "getComponent4", "components", "", "getComponents", "()Ljava/util/List;", "toString", "", "componentId", "", "intellij.android.compose-designer"})
    public static abstract class Unit4D<A extends Number>
    implements Unit<A> {
        @NotNull
        private final A component1;
        @NotNull
        private final A component2;
        @NotNull
        private final A component3;
        @NotNull
        private final A component4;
        @NotNull
        private final List<A> components;

        public Unit4D(@NotNull A component1, @NotNull A component2, @NotNull A component3, @NotNull A component4) {
            Intrinsics.checkNotNullParameter(component1, (String)"component1");
            Intrinsics.checkNotNullParameter(component2, (String)"component2");
            Intrinsics.checkNotNullParameter(component3, (String)"component3");
            Intrinsics.checkNotNullParameter(component4, (String)"component4");
            this.component1 = component1;
            this.component2 = component2;
            this.component3 = component3;
            this.component4 = component4;
            Object[] objectArray = new Number[]{this.component1, this.component2, this.component3, this.component4};
            this.components = CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final A getComponent1() {
            return this.component1;
        }

        @NotNull
        public final A getComponent2() {
            return this.component2;
        }

        @NotNull
        public final A getComponent3() {
            return this.component3;
        }

        @NotNull
        public final A getComponent4() {
            return this.component4;
        }

        @Override
        @NotNull
        public List<A> getComponents() {
            return this.components;
        }

        @Override
        @NotNull
        public String toString(int componentId) {
            return "( " + (componentId == 0 ? this.component1 : "_") + " , " + (componentId == 1 ? this.component2 : "_") + " , " + (componentId == 2 ? this.component3 : "_") + " , " + (componentId == 3 ? this.component4 : "_") + " )";
        }

        @Override
        @NotNull
        public String toString() {
            return CollectionsKt.joinToString$default((Iterable)this.getComponents(), (CharSequence)" , ", (CharSequence)"( ", (CharSequence)" )", (int)0, null, (Function1)toString.1.INSTANCE, (int)24, null);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J$\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$IntUnit;", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit1D;", "", "value", "(I)V", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "getPickerTitle", "parseUnit", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "getValue", "Lkotlin/Function1;", "intellij.android.compose-designer"})
    public static final class IntUnit
    extends Unit1D<Integer> {
        public IntUnit(int value2) {
            super(value2);
        }

        @Override
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return CollectionsKt.listOf((Object)new AnimatedPropertyItem(prefix, String.valueOf(((Number)this.getComponent1()).intValue()), (Function1<? super String, ? extends Pair<? extends EditingErrorCategory, String>>)((Function1)createProperties.1.INSTANCE), "Int"));
        }

        @Override
        @Nullable
        public Unit<?> parseUnit(@NotNull Function1<? super Integer, String> getValue) {
            Unit unit2;
            Intrinsics.checkNotNullParameter(getValue, (String)"getValue");
            try {
                IntUnit intUnit;
                String string = (String)getValue.invoke((Object)0);
                if (string != null) {
                    int it = Integer.parseInt(string);
                    boolean bl = false;
                    intUnit = new IntUnit(it);
                } else {
                    intUnit = null;
                }
                unit2 = intUnit;
            }
            catch (NumberFormatException numberFormatException) {
                unit2 = null;
            }
            return unit2;
        }

        @Override
        @NotNull
        public String getPickerTitle() {
            return ComposePreviewBundle.message("animation.inspector.picker.int", new Object[0]);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J$\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$DoubleUnit;", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit1D;", "", "value", "(D)V", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "getPickerTitle", "parseUnit", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "getValue", "Lkotlin/Function1;", "", "intellij.android.compose-designer"})
    public static final class DoubleUnit
    extends Unit1D<Double> {
        public DoubleUnit(double value2) {
            super(value2);
        }

        @Override
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return CollectionsKt.listOf((Object)new AnimatedPropertyItem(prefix, String.valueOf(((Number)this.getComponent1()).doubleValue()), (Function1<? super String, ? extends Pair<? extends EditingErrorCategory, String>>)((Function1)DoubleValidation.INSTANCE), "Double"));
        }

        @Override
        @Nullable
        public Unit<?> parseUnit(@NotNull Function1<? super Integer, String> getValue) {
            Unit unit2;
            Intrinsics.checkNotNullParameter(getValue, (String)"getValue");
            try {
                DoubleUnit doubleUnit;
                String string = (String)getValue.invoke((Object)0);
                if (string != null) {
                    double it = Double.parseDouble(string);
                    boolean bl = false;
                    doubleUnit = new DoubleUnit(it);
                } else {
                    doubleUnit = null;
                }
                unit2 = doubleUnit;
            }
            catch (NumberFormatException numberFormatException) {
                unit2 = null;
            }
            return unit2;
        }

        @Override
        @NotNull
        public String getPickerTitle() {
            return ComposePreviewBundle.message("animation.inspector.picker.double", new Object[0]);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J$\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000eH\u0016\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$FloatUnit;", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit1D;", "", "value", "(F)V", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "getPickerTitle", "parseUnit", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "getValue", "Lkotlin/Function1;", "", "intellij.android.compose-designer"})
    public static final class FloatUnit
    extends Unit1D<Float> {
        public FloatUnit(float value2) {
            super((Number)Float.valueOf(value2));
        }

        @Override
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return CollectionsKt.listOf((Object)new AnimatedPropertyItem(prefix, String.valueOf(((Number)this.getComponent1()).floatValue()), FloatValidationKt.getFloatValidation(), "Float"));
        }

        @Override
        @Nullable
        public Unit<?> parseUnit(@NotNull Function1<? super Integer, String> getValue) {
            Unit unit2;
            Intrinsics.checkNotNullParameter(getValue, (String)"getValue");
            try {
                FloatUnit floatUnit;
                String string = (String)getValue.invoke((Object)0);
                if (string != null) {
                    float it = Float.parseFloat(string);
                    boolean bl = false;
                    floatUnit = new FloatUnit(it);
                } else {
                    floatUnit = null;
                }
                unit2 = floatUnit;
            }
            catch (NumberFormatException numberFormatException) {
                unit2 = null;
            }
            return unit2;
        }

        @Override
        @NotNull
        public String getPickerTitle() {
            return ComposePreviewBundle.message("animation.inspector.picker.float", new Object[0]);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\b\u0010\u0010\u001a\u00020\u000fH\u0016J$\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00122\u0014\u0010\u0013\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\u000f0\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0002H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$UnitUnknown;", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit1D;", "", "any", "", "(Ljava/lang/Object;)V", "getAny", "()Ljava/lang/Object;", "components", "", "getComponents", "()Ljava/util/List;", "createProperties", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "getPickerTitle", "parseUnit", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "getValue", "Lkotlin/Function1;", "toString", "componentId", "intellij.android.compose-designer"})
    public static final class UnitUnknown
    extends Unit1D<Integer> {
        @NotNull
        private final Object any;
        @NotNull
        private final List<Integer> components;

        public UnitUnknown(@NotNull Object any) {
            Intrinsics.checkNotNullParameter((Object)any, (String)"any");
            super(0);
            this.any = any;
            this.components = CollectionsKt.listOf((Object)0);
        }

        @NotNull
        public final Object getAny() {
            return this.any;
        }

        @Override
        @NotNull
        public List<Integer> getComponents() {
            return this.components;
        }

        @Override
        @NotNull
        public String toString(int componentId) {
            return this.any.toString();
        }

        @Override
        @NotNull
        public String toString() {
            return this.any.toString();
        }

        @Override
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return CollectionsKt.listOf((Object)new AnimatedPropertyItem(prefix, String.valueOf(this.any), (Function1<? super String, ? extends Pair<? extends EditingErrorCategory, String>>)((Function1)createProperties.1.INSTANCE), "Any"));
        }

        @Override
        @Nullable
        public Unit<?> parseUnit(@NotNull Function1<? super Integer, String> getValue) {
            Intrinsics.checkNotNullParameter(getValue, (String)"getValue");
            return null;
        }

        @Override
        @NotNull
        public String getPickerTitle() {
            return ComposePreviewBundle.message("animation.inspector.picker.value", new Object[0]);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J$\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\n0\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$IntSize;", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit2D;", "", "component1", "component2", "(II)V", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "getPickerTitle", "parseUnit", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "getValue", "Lkotlin/Function1;", "toString", "componentId", "Companion", "intellij.android.compose-designer"})
    public static final class IntSize
    extends Unit2D<Integer> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String CLASS_NAME = "androidx.compose.ui.unit.IntSize";
        @NotNull
        private static final String[] COMPONENT_NAMES;

        public IntSize(int component1, int component2) {
            super(component1, component2);
        }

        @Override
        @NotNull
        public String toString(int componentId) {
            return COMPONENT_NAMES[componentId] + " " + super.toString(componentId);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Iterable $this$mapIndexed$iv = this.getComponents();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void component;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = ((Number)item$iv$iv).intValue();
                int n3 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AnimatedPropertyItem(COMPONENT_NAMES[index], String.valueOf((int)component), (Function1<? super String, ? extends Pair<? extends EditingErrorCategory, String>>)((Function1)IntValidation.INSTANCE), "Int"));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @Nullable
        public Unit<?> parseUnit(@NotNull Function1<? super Integer, String> getValue) {
            Intrinsics.checkNotNullParameter(getValue, (String)"getValue");
            try {
                String string = (String)getValue.invoke((Object)0);
                if (string == null) {
                    return null;
                }
                int component1 = Integer.parseInt(string);
                String string2 = (String)getValue.invoke((Object)1);
                if (string2 == null) {
                    return null;
                }
                int component2 = Integer.parseInt(string2);
                return new IntSize(component1, component2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        @Override
        @NotNull
        public String getPickerTitle() {
            return ComposePreviewBundle.message("animation.inspector.picker.int.size", new Object[0]);
        }

        static {
            String[] stringArray = new String[]{"width", "height"};
            COMPONENT_NAMES = stringArray;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$IntSize$Companion;", "", "()V", "CLASS_NAME", "", "COMPONENT_NAMES", "", "[Ljava/lang/String;", "create", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$IntSize;", "property", "intellij.android.compose-designer"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final IntSize create(@Nullable Object property) {
                Object object = property;
                if (object != null) {
                    Object height2;
                    Object object2;
                    Object object3;
                    Object value2;
                    Object object4;
                    Object it = object4 = object;
                    boolean bl = false;
                    Method method = INSTANCE.findMethodByName("unbox-impl", property);
                    Object object5 = value2 = method != null ? method.invoke(property, new Object[0]) : null;
                    if (!(value2 instanceof Long)) {
                        return null;
                    }
                    Method method2 = INSTANCE.findMethodByName("getWidth-impl", property);
                    if (method2 != null) {
                        Object[] objectArray = new Object[]{value2};
                        object3 = method2.invoke(null, objectArray);
                    } else {
                        object3 = null;
                    }
                    Object width2 = object3;
                    Method method3 = INSTANCE.findMethodByName("getHeight-impl", property);
                    if (method3 != null) {
                        Object[] objectArray = new Object[]{value2};
                        object2 = method3.invoke(null, objectArray);
                    } else {
                        object2 = height2 = null;
                    }
                    if (width2 instanceof Integer && height2 instanceof Integer) {
                        return new IntSize(((Number)width2).intValue(), ((Number)height2).intValue());
                    }
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J$\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0002\u0012\u0006\u0012\u0004\u0018\u00010\n0\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\n2\u0006\u0010\u0011\u001a\u00020\u0002H\u0016\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$IntOffset;", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit2D;", "", "component1", "component2", "(II)V", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "getPickerTitle", "parseUnit", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "getValue", "Lkotlin/Function1;", "toString", "componentId", "Companion", "intellij.android.compose-designer"})
    public static final class IntOffset
    extends Unit2D<Integer> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String CLASS_NAME = "androidx.compose.ui.unit.IntOffset";
        @NotNull
        private static final String[] COMPONENT_NAMES;

        public IntOffset(int component1, int component2) {
            super(component1, component2);
        }

        @Override
        @NotNull
        public String toString(int componentId) {
            return COMPONENT_NAMES[componentId] + " " + super.toString(componentId);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Iterable $this$mapIndexed$iv = this.getComponents();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void component;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                int n2 = ((Number)item$iv$iv).intValue();
                int n3 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AnimatedPropertyItem(COMPONENT_NAMES[index], String.valueOf((int)component), (Function1<? super String, ? extends Pair<? extends EditingErrorCategory, String>>)((Function1)IntValidation.INSTANCE), "Int"));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @Nullable
        public Unit<?> parseUnit(@NotNull Function1<? super Integer, String> getValue) {
            Intrinsics.checkNotNullParameter(getValue, (String)"getValue");
            try {
                String string = (String)getValue.invoke((Object)0);
                if (string == null) {
                    return null;
                }
                int component1 = Integer.parseInt(string);
                String string2 = (String)getValue.invoke((Object)1);
                if (string2 == null) {
                    return null;
                }
                int component2 = Integer.parseInt(string2);
                return new IntOffset(component1, component2);
            }
            catch (NumberFormatException numberFormatException) {
                Unit unit2 = null;
                return unit2;
            }
        }

        @Override
        @NotNull
        public String getPickerTitle() {
            return ComposePreviewBundle.message("animation.inspector.picker.int.offset", new Object[0]);
        }

        static {
            String[] stringArray = new String[]{"x", "y"};
            COMPONENT_NAMES = stringArray;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$IntOffset$Companion;", "", "()V", "CLASS_NAME", "", "COMPONENT_NAMES", "", "[Ljava/lang/String;", "create", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$IntOffset;", "property", "intellij.android.compose-designer"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final IntOffset create(@Nullable Object property) {
                Object object = property;
                if (object != null) {
                    Object y;
                    Object object2;
                    Object object3;
                    Object value2;
                    Object object4;
                    Object it = object4 = object;
                    boolean bl = false;
                    Method method = INSTANCE.findMethodByName("unbox-impl", property);
                    Object object5 = value2 = method != null ? method.invoke(property, new Object[0]) : null;
                    if (!(value2 instanceof Long)) {
                        return null;
                    }
                    Method method2 = INSTANCE.findMethodByName("getX-impl", property);
                    if (method2 != null) {
                        Object[] objectArray = new Object[]{value2};
                        object3 = method2.invoke(null, objectArray);
                    } else {
                        object3 = null;
                    }
                    Object x = object3;
                    Method method3 = INSTANCE.findMethodByName("getY-impl", property);
                    if (method3 != null) {
                        Object[] objectArray = new Object[]{value2};
                        object2 = method3.invoke(null, objectArray);
                    } else {
                        object2 = y = null;
                    }
                    if (x instanceof Integer && y instanceof Integer) {
                        return new IntOffset(((Number)x).intValue(), ((Number)y).intValue());
                    }
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00122\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0012B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\tH\u0016J$\u0010\u000b\u001a\b\u0012\u0002\b\u0003\u0018\u00010\f2\u0014\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0006\u0012\u0004\u0018\u00010\t0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\tH\u0016J\u0010\u0010\u0010\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u000fH\u0016\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Dp;", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit1D;", "", "component1", "(F)V", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "getPickerTitle", "parseUnit", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "getValue", "Lkotlin/Function1;", "", "toString", "componentId", "Companion", "intellij.android.compose-designer"})
    public static final class Dp
    extends Unit1D<Float> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String CLASS_NAME = "androidx.compose.ui.unit.Dp";

        public Dp(float component1) {
            super((Number)Float.valueOf(component1));
        }

        @Override
        @NotNull
        public String toString(int componentId) {
            return this.getComponent1() + "dp";
        }

        @Override
        @NotNull
        public String toString() {
            return this.getComponent1() + "dp";
        }

        @Override
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            return CollectionsKt.listOf((Object)new AnimatedPropertyItem(prefix, String.valueOf(((Number)this.getComponent1()).floatValue()), FloatValidationKt.getDpValidation(), "Float"));
        }

        @Override
        @Nullable
        public Unit<?> parseUnit(@NotNull Function1<? super Integer, String> getValue) {
            Unit unit2;
            Intrinsics.checkNotNullParameter(getValue, (String)"getValue");
            try {
                Dp dp;
                String string = (String)getValue.invoke((Object)0);
                if (string != null) {
                    float it = Float.parseFloat(string);
                    boolean bl = false;
                    dp = new Dp(it);
                } else {
                    dp = null;
                }
                unit2 = dp;
            }
            catch (NumberFormatException numberFormatException) {
                unit2 = null;
            }
            return unit2;
        }

        @Override
        @NotNull
        public String getPickerTitle() {
            return ComposePreviewBundle.message("animation.inspector.picker.dp", new Object[0]);
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Dp$Companion;", "", "()V", "CLASS_NAME", "", "create", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Dp;", "property", "intellij.android.compose-designer"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Dp create(@Nullable Object property) {
                Object object = property;
                if (object != null) {
                    Object value2;
                    Object object2;
                    Object it = object2 = object;
                    boolean bl = false;
                    Method method = INSTANCE.findMethodByName("getValue", property);
                    Object object3 = value2 = method != null ? method.invoke(property, new Object[0]) : null;
                    if (value2 instanceof Float) {
                        return new Dp(((Number)value2).floatValue());
                    }
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J$\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n0\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Size;", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit2D;", "", "component1", "component2", "(FF)V", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "getPickerTitle", "parseUnit", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "getValue", "Lkotlin/Function1;", "", "toString", "componentId", "Companion", "intellij.android.compose-designer"})
    public static final class Size
    extends Unit2D<Float> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String CLASS_NAME = "androidx.compose.ui.geometry.Size";
        @NotNull
        private static final String[] COMPONENT_NAMES;

        public Size(float component1, float component2) {
            super((Number)Float.valueOf(component1), (Number)Float.valueOf(component2));
        }

        @Override
        @NotNull
        public String toString(int componentId) {
            return COMPONENT_NAMES[componentId] + " " + super.toString(componentId);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Iterable $this$mapIndexed$iv = this.getComponents();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void component;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                float f = ((Number)item$iv$iv).floatValue();
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AnimatedPropertyItem(COMPONENT_NAMES[index], String.valueOf((float)component), FloatValidationKt.getFloatValidation(), "Float"));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @Nullable
        public Unit<?> parseUnit(@NotNull Function1<? super Integer, String> getValue) {
            Intrinsics.checkNotNullParameter(getValue, (String)"getValue");
            try {
                String string = (String)getValue.invoke((Object)0);
                if (string == null) {
                    return null;
                }
                float component1 = Float.parseFloat(string);
                String string2 = (String)getValue.invoke((Object)1);
                if (string2 == null) {
                    return null;
                }
                float component2 = Float.parseFloat(string2);
                return new Size(component1, component2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        @Override
        @NotNull
        public String getPickerTitle() {
            return ComposePreviewBundle.message("animation.inspector.picker.size", new Object[0]);
        }

        static {
            String[] stringArray = new String[]{"width", "height"};
            COMPONENT_NAMES = stringArray;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Size$Companion;", "", "()V", "CLASS_NAME", "", "COMPONENT_NAMES", "", "[Ljava/lang/String;", "create", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Size;", "property", "intellij.android.compose-designer"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Size create(@Nullable Object property) {
                Object object = property;
                if (object != null) {
                    Object height2;
                    Object object2;
                    Object object3;
                    Object value2;
                    Object object4;
                    Object it = object4 = object;
                    boolean bl = false;
                    Method method = INSTANCE.findMethodByName("unbox-impl", property);
                    Object object5 = value2 = method != null ? method.invoke(property, new Object[0]) : null;
                    if (!(value2 instanceof Long)) {
                        return null;
                    }
                    Method method2 = INSTANCE.findMethodByName("getWidth-impl", property);
                    if (method2 != null) {
                        Object[] objectArray = new Object[]{value2};
                        object3 = method2.invoke(null, objectArray);
                    } else {
                        object3 = null;
                    }
                    Object width2 = object3;
                    Method method3 = INSTANCE.findMethodByName("getHeight-impl", property);
                    if (method3 != null) {
                        Object[] objectArray = new Object[]{value2};
                        object2 = method3.invoke(null, objectArray);
                    } else {
                        object2 = height2 = null;
                    }
                    if (width2 instanceof Float && height2 instanceof Float) {
                        return new Size(((Number)width2).floatValue(), ((Number)height2).floatValue());
                    }
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00152\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0015B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J$\u0010\u000e\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000f2\u0014\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0012\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0011H\u0016J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0012H\u0016\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Rect;", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit4D;", "", "component1", "component2", "component3", "component4", "(FFFF)V", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "getPickerTitle", "parseUnit", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "getValue", "Lkotlin/Function1;", "", "toString", "componentId", "Companion", "intellij.android.compose-designer"})
    public static final class Rect
    extends Unit4D<Float> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String CLASS_NAME = "androidx.compose.ui.geometry.Rect";
        @NotNull
        private static final String[] COMPONENT_NAMES;

        public Rect(float component1, float component2, float component3, float component4) {
            super((Number)Float.valueOf(component1), (Number)Float.valueOf(component2), (Number)Float.valueOf(component3), (Number)Float.valueOf(component4));
        }

        @Override
        @NotNull
        public String toString(int componentId) {
            return COMPONENT_NAMES[componentId] + " " + super.toString(componentId);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Iterable $this$mapIndexed$iv = this.getComponents();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void component;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                float f = ((Number)item$iv$iv).floatValue();
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AnimatedPropertyItem(COMPONENT_NAMES[index], String.valueOf((float)component), FloatValidationKt.getFloatValidation(), "Float"));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @Nullable
        public Unit<?> parseUnit(@NotNull Function1<? super Integer, String> getValue) {
            Intrinsics.checkNotNullParameter(getValue, (String)"getValue");
            try {
                String string = (String)getValue.invoke((Object)0);
                if (string == null) {
                    return null;
                }
                float component1 = Float.parseFloat(string);
                String string2 = (String)getValue.invoke((Object)1);
                if (string2 == null) {
                    return null;
                }
                float component2 = Float.parseFloat(string2);
                String string3 = (String)getValue.invoke((Object)2);
                if (string3 == null) {
                    return null;
                }
                float component3 = Float.parseFloat(string3);
                String string4 = (String)getValue.invoke((Object)3);
                if (string4 == null) {
                    return null;
                }
                float component4 = Float.parseFloat(string4);
                return new Rect(component1, component2, component3, component4);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        @Override
        @NotNull
        public String getPickerTitle() {
            return ComposePreviewBundle.message("animation.inspector.picker.rect", new Object[0]);
        }

        static {
            String[] stringArray = new String[]{"left", "top", "right", "bottom"};
            COMPONENT_NAMES = stringArray;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Rect$Companion;", "", "()V", "CLASS_NAME", "", "COMPONENT_NAMES", "", "[Ljava/lang/String;", "create", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Rect;", "property", "intellij.android.compose-designer"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Rect create(@Nullable Object property) {
                Object object = property;
                if (object != null) {
                    Object bottom2;
                    Object object2;
                    Object it = object2 = object;
                    boolean bl = false;
                    Method method = INSTANCE.findMethodByName("getLeft", property);
                    Object left = method != null ? method.invoke(property, new Object[0]) : null;
                    Method method2 = INSTANCE.findMethodByName("getTop", property);
                    Object top = method2 != null ? method2.invoke(property, new Object[0]) : null;
                    Method method3 = INSTANCE.findMethodByName("getRight", property);
                    Object right2 = method3 != null ? method3.invoke(property, new Object[0]) : null;
                    Method method4 = INSTANCE.findMethodByName("getBottom", property);
                    Object object3 = bottom2 = method4 != null ? method4.invoke(property, new Object[0]) : null;
                    if (left instanceof Float && right2 instanceof Float && top instanceof Float && bottom2 instanceof Float) {
                        return new Rect(((Number)left).floatValue(), ((Number)top).floatValue(), ((Number)right2).floatValue(), ((Number)bottom2).floatValue());
                    }
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00132\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0013B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\nH\u0016J$\u0010\f\u001a\b\u0012\u0002\b\u0003\u0018\u00010\r2\u0014\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n0\u000fH\u0016J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0010H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Offset;", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit2D;", "", "component1", "component2", "(FF)V", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "getPickerTitle", "parseUnit", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "getValue", "Lkotlin/Function1;", "", "toString", "componentId", "Companion", "intellij.android.compose-designer"})
    public static final class Offset
    extends Unit2D<Float> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        public static final String CLASS_NAME = "androidx.compose.ui.geometry.Offset";
        @NotNull
        private static final String[] COMPONENT_NAMES;

        public Offset(float component1, float component2) {
            super((Number)Float.valueOf(component1), (Number)Float.valueOf(component2));
        }

        @Override
        @NotNull
        public String toString(int componentId) {
            return COMPONENT_NAMES[componentId] + " " + super.toString(componentId);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Iterable $this$mapIndexed$iv = this.getComponents();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void component;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                float f = ((Number)item$iv$iv).floatValue();
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AnimatedPropertyItem(COMPONENT_NAMES[index], String.valueOf((float)component), FloatValidationKt.getFloatValidation(), "Float"));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @Nullable
        public Unit<?> parseUnit(@NotNull Function1<? super Integer, String> getValue) {
            Intrinsics.checkNotNullParameter(getValue, (String)"getValue");
            try {
                String string = (String)getValue.invoke((Object)0);
                if (string == null) {
                    return null;
                }
                float component1 = Float.parseFloat(string);
                String string2 = (String)getValue.invoke((Object)1);
                if (string2 == null) {
                    return null;
                }
                float component2 = Float.parseFloat(string2);
                return new Offset(component1, component2);
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        @Override
        @NotNull
        public String getPickerTitle() {
            return ComposePreviewBundle.message("animation.inspector.picker.offset", new Object[0]);
        }

        static {
            String[] stringArray = new String[]{"x", "y"};
            COMPONENT_NAMES = stringArray;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Offset$Companion;", "", "()V", "CLASS_NAME", "", "COMPONENT_NAMES", "", "[Ljava/lang/String;", "create", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Offset;", "property", "intellij.android.compose-designer"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Offset create(@Nullable Object property) {
                Object object = property;
                if (object != null) {
                    Object y;
                    Object object2;
                    Object object3;
                    Object value2;
                    Object object4;
                    Object it = object4 = object;
                    boolean bl = false;
                    Method method = INSTANCE.findMethodByName("unbox-impl", property);
                    Object object5 = value2 = method != null ? method.invoke(property, new Object[0]) : null;
                    if (!(value2 instanceof Long)) {
                        return null;
                    }
                    Method method2 = INSTANCE.findMethodByName("getX-impl", property);
                    if (method2 != null) {
                        Object[] objectArray = new Object[]{value2};
                        object3 = method2.invoke(null, objectArray);
                    } else {
                        object3 = null;
                    }
                    Object x = object3;
                    Method method3 = INSTANCE.findMethodByName("getY-impl", property);
                    if (method3 != null) {
                        Object[] objectArray = new Object[]{value2};
                        object2 = method3.invoke(null, objectArray);
                    } else {
                        object2 = y = null;
                    }
                    if (x instanceof Float && y instanceof Float) {
                        return new Offset(((Number)x).floatValue(), ((Number)y).floatValue());
                    }
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00192\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u0019B%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0010H\u0016J$\u0010\u0012\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00132\u0014\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00100\u0015H\u0016J\b\u0010\u0017\u001a\u00020\u0010H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0016H\u0016R\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Color;", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit4D;", "", "component1", "component2", "component3", "component4", "(FFFF)V", "color", "Ljava/awt/Color;", "getColor", "()Ljava/awt/Color;", "createProperties", "", "Lcom/android/tools/idea/compose/preview/animation/picker/AnimatedPropertyItem;", "prefix", "", "getPickerTitle", "parseUnit", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Unit;", "getValue", "Lkotlin/Function1;", "", "toString", "componentId", "Companion", "intellij.android.compose-designer"})
    public static final class Color
    extends Unit4D<Float> {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final java.awt.Color color;
        @NotNull
        public static final String CLASS_NAME = "androidx.compose.ui.graphics.Color";
        @NotNull
        private static final String[] COMPONENT_NAMES;

        public Color(float component1, float component2, float component3, float component4) {
            super((Number)Float.valueOf(component1), (Number)Float.valueOf(component2), (Number)Float.valueOf(component3), (Number)Float.valueOf(component4));
            java.awt.Color color;
            Color color2;
            Color color3 = this;
            try {
                color2 = color3;
                color = new java.awt.Color(component1, component2, component3, component4);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                color2 = color3;
                color = null;
            }
            color2.color = color;
        }

        @Nullable
        public final java.awt.Color getColor() {
            return this.color;
        }

        @Override
        @NotNull
        public String toString(int componentId) {
            return COMPONENT_NAMES[componentId] + " " + super.toString(componentId);
        }

        @Override
        @NotNull
        public String toString() {
            Object object;
            block3: {
                block2: {
                    object = this.color;
                    if (object == null) break block2;
                    java.awt.Color it = object;
                    boolean bl = false;
                    String string = ColorUtil.toHex((java.awt.Color)it, (boolean)true);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toHex(it, true)");
                    String string2 = string.toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(Locale.ROOT)");
                    String string3 = "0x" + string2;
                    object = string3;
                    if (string3 != null) break block3;
                }
                object = super.toString();
            }
            return object;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public List<AnimatedPropertyItem> createProperties(@NotNull String prefix) {
            void $this$mapIndexedTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
            Iterable $this$mapIndexed$iv = this.getComponents();
            boolean $i$f$mapIndexed = false;
            Iterable iterable = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void component;
                void index;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                float f = ((Number)item$iv$iv).floatValue();
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new AnimatedPropertyItem(COMPONENT_NAMES[index], String.valueOf((float)component), FloatValidationKt.getFloatValidation(), "Color"));
            }
            return (List)destination$iv$iv;
        }

        @Override
        @Nullable
        public Unit<?> parseUnit(@NotNull Function1<? super Integer, String> getValue) {
            Intrinsics.checkNotNullParameter(getValue, (String)"getValue");
            try {
                Color color;
                String string = (String)getValue.invoke((Object)0);
                if (string == null) {
                    return null;
                }
                float component1 = Float.parseFloat(string);
                String string2 = (String)getValue.invoke((Object)1);
                if (string2 == null) {
                    return null;
                }
                float component2 = Float.parseFloat(string2);
                String string3 = (String)getValue.invoke((Object)2);
                if (string3 == null) {
                    return null;
                }
                float component3 = Float.parseFloat(string3);
                String string4 = (String)getValue.invoke((Object)3);
                if (string4 == null) {
                    return null;
                }
                float component4 = Float.parseFloat(string4);
                Color it = color = new Color(component1, component2, component3, component4);
                boolean bl = false;
                return it.color != null ? color : null;
            }
            catch (NumberFormatException numberFormatException) {
                return null;
            }
        }

        @Override
        @NotNull
        public String getPickerTitle() {
            return ComposePreviewBundle.message("animation.inspector.picker.color", new Object[0]);
        }

        static {
            String[] stringArray = new String[]{"red", "green", "blue", "alpha"};
            COMPONENT_NAMES = stringArray;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0001R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Color$Companion;", "", "()V", "CLASS_NAME", "", "COMPONENT_NAMES", "", "[Ljava/lang/String;", "create", "Lcom/android/tools/idea/compose/preview/animation/ComposeUnit$Color;", "property", "intellij.android.compose-designer"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final Color create(@Nullable Object property) {
                Object object = property;
                if (object != null) {
                    Object alpha;
                    Object object2;
                    Object object3;
                    Object object4;
                    Object object5;
                    Object value2;
                    Object object6;
                    Object it = object6 = object;
                    boolean bl = false;
                    Method method = INSTANCE.findMethodByName("unbox-impl", property);
                    Object object7 = value2 = method != null ? method.invoke(property, new Object[0]) : null;
                    if (!(value2 instanceof Long)) {
                        return null;
                    }
                    Method method2 = INSTANCE.findMethodByName("getRed-impl", property);
                    if (method2 != null) {
                        Object[] objectArray = new Object[]{value2};
                        object5 = method2.invoke(null, objectArray);
                    } else {
                        object5 = null;
                    }
                    Object red = object5;
                    Method method3 = INSTANCE.findMethodByName("getGreen-impl", property);
                    if (method3 != null) {
                        Object[] objectArray = new Object[]{value2};
                        object4 = method3.invoke(null, objectArray);
                    } else {
                        object4 = null;
                    }
                    Object green = object4;
                    Method method4 = INSTANCE.findMethodByName("getBlue-impl", property);
                    if (method4 != null) {
                        Object[] objectArray = new Object[]{value2};
                        object3 = method4.invoke(null, objectArray);
                    } else {
                        object3 = null;
                    }
                    Object blue = object3;
                    Method method5 = INSTANCE.findMethodByName("getAlpha-impl", property);
                    if (method5 != null) {
                        Object[] objectArray = new Object[]{value2};
                        object2 = method5.invoke(null, objectArray);
                    } else {
                        object2 = alpha = null;
                    }
                    if (red instanceof Float && green instanceof Float && blue instanceof Float && alpha instanceof Float) {
                        return new Color(((Number)red).floatValue(), ((Number)green).floatValue(), ((Number)blue).floatValue(), ((Number)alpha).floatValue());
                    }
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

