/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.preview.animation;

import androidx.compose.animation.tooling.ComposeAnimation;
import com.android.annotations.concurrency.Slow;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.compose.preview.analytics.AnimationToolingEvent;
import com.android.tools.idea.compose.preview.analytics.AnimationToolingUsageTracker;
import com.android.tools.idea.compose.preview.animation.AnimationClock;
import com.android.tools.idea.compose.preview.animation.AnimationPreview;
import com.android.tools.idea.uibuilder.scene.LayoutlibSceneManager;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.ComposeAnimationToolingEvent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.ui.UIUtil;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0016\u001a\u00020\nJ:\u0010\u0017\u001a\u00020\u00042\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001e2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J\u0014\u0010!\u001a\u00020\n2\f\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001f0\u001eJ\u0006\u0010\"\u001a\u00020#J\u0006\u0010$\u001a\u00020\nJ\u0018\u0010%\u001a\u00020\n2\b\u0010&\u001a\u0004\u0018\u00010\u00012\u0006\u0010'\u001a\u00020\u0012J\u000e\u0010(\u001a\u00020\n2\u0006\u0010'\u001a\u00020\u0012R\"\u0010\u0005\u001a\u0004\u0018\u00010\u00042\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00118G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/android/tools/idea/compose/preview/animation/ComposePreviewAnimationManager;", "", "()V", "<set-?>", "Lcom/android/tools/idea/compose/preview/animation/AnimationPreview;", "currentInspector", "getCurrentInspector$intellij_android_compose_designer", "()Lcom/android/tools/idea/compose/preview/animation/AnimationPreview;", "newInspectorOpenedCallback", "Lkotlin/Function0;", "", "onSubscribedUnsubscribedExecutor", "Ljava/util/concurrent/Executor;", "kotlin.jvm.PlatformType", "getOnSubscribedUnsubscribedExecutor$intellij_android_compose_designer", "()Ljava/util/concurrent/Executor;", "subscribedAnimations", "", "Landroidx/compose/animation/tooling/ComposeAnimation;", "getSubscribedAnimations", "()Ljava/util/Set;", "subscribedAnimationsLock", "closeCurrentInspector", "createAnimationInspectorPanel", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "Lcom/android/tools/idea/uibuilder/scene/LayoutlibSceneManager;", "parent", "Lcom/intellij/openapi/Disposable;", "psiFilePointer", "Lcom/intellij/psi/SmartPsiElementPointer;", "Lcom/intellij/psi/PsiFile;", "onNewInspectorOpen", "invalidate", "isInspectorOpen", "", "onAnimationInspectorOpened", "onAnimationSubscribed", "clock", "animation", "onAnimationUnsubscribed", "intellij.android.compose-designer"})
public final class ComposePreviewAnimationManager {
    @NotNull
    public static final ComposePreviewAnimationManager INSTANCE = new ComposePreviewAnimationManager();
    @Nullable
    private static AnimationPreview currentInspector;
    @NotNull
    private static final Set<ComposeAnimation> subscribedAnimations;
    @NotNull
    private static final Object subscribedAnimationsLock;
    @Nullable
    private static Function0<Unit> newInspectorOpenedCallback;
    private static final Executor onSubscribedUnsubscribedExecutor;

    private ComposePreviewAnimationManager() {
    }

    @Nullable
    public final AnimationPreview getCurrentInspector$intellij_android_compose_designer() {
        return currentInspector;
    }

    @VisibleForTesting
    @NotNull
    public final Set<ComposeAnimation> getSubscribedAnimations() {
        return subscribedAnimations;
    }

    public final Executor getOnSubscribedUnsubscribedExecutor$intellij_android_compose_designer() {
        return onSubscribedUnsubscribedExecutor;
    }

    @Slow
    @NotNull
    public final AnimationPreview createAnimationInspectorPanel(@NotNull DesignSurface<LayoutlibSceneManager> surface2, @NotNull Disposable parent, @NotNull SmartPsiElementPointer<PsiFile> psiFilePointer2, @NotNull Function0<Unit> onNewInspectorOpen) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter(psiFilePointer2, (String)"psiFilePointer");
        Intrinsics.checkNotNullParameter(onNewInspectorOpen, (String)"onNewInspectorOpen");
        newInspectorOpenedCallback = onNewInspectorOpen;
        AnimationToolingUsageTracker.Companion.getInstance(surface2).logEvent(new AnimationToolingEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.OPEN_ANIMATION_INSPECTOR));
        return (AnimationPreview)ActionsKt.invokeAndWaitIfNeeded$default(null, (Function0)((Function0)new Function0<AnimationPreview>(surface2, psiFilePointer2, parent){
            final /* synthetic */ DesignSurface<LayoutlibSceneManager> $surface;
            final /* synthetic */ SmartPsiElementPointer<PsiFile> $psiFilePointer;
            final /* synthetic */ Disposable $parent;
            {
                this.$surface = $surface;
                this.$psiFilePointer = $psiFilePointer;
                this.$parent = $parent;
                super(0);
            }

            @NotNull
            public final AnimationPreview invoke() {
                AnimationPreview animationInspectorPanel = new AnimationPreview(this.$surface, this.$psiFilePointer);
                Disposer.register((Disposable)this.$parent, (Disposable)animationInspectorPanel);
                ComposePreviewAnimationManager.access$setCurrentInspector$p(animationInspectorPanel);
                return animationInspectorPanel;
            }
        }), (int)1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void closeCurrentInspector() {
        AnimationPreview animationPreview = currentInspector;
        if (animationPreview != null) {
            AnimationPreview it = animationPreview;
            boolean bl = false;
            Disposer.dispose((Disposable)it);
            AnimationToolingUsageTracker.Companion.getInstance(it.getSurface()).logEvent(new AnimationToolingEvent(ComposeAnimationToolingEvent.ComposeAnimationToolingEventType.CLOSE_ANIMATION_INSPECTOR));
        }
        currentInspector = null;
        newInspectorOpenedCallback = null;
        Object object = subscribedAnimationsLock;
        synchronized (object) {
            boolean bl = false;
            subscribedAnimations.clear();
            Unit unit2 = Unit.INSTANCE;
        }
    }

    public final void onAnimationInspectorOpened() {
        block0: {
            Function0<Unit> function0 = newInspectorOpenedCallback;
            if (function0 == null) break block0;
            function0.invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void onAnimationSubscribed(@Nullable Object clock, @NotNull ComposeAnimation animation) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        if (clock == null) {
            return;
        }
        AnimationPreview animationPreview = currentInspector;
        if (animationPreview == null) {
            return;
        }
        AnimationPreview inspector = animationPreview;
        if (inspector.getAnimationClock() == null) {
            inspector.setAnimationClock(new AnimationClock(clock));
        }
        AnimationClock animationClock = inspector.getAnimationClock();
        if (animationClock != null) {
            AnimationClock it = animationClock;
            boolean bl2 = false;
            if (!Intrinsics.areEqual((Object)it.getClock(), (Object)clock)) {
                void $this$forEach$iv;
                Set set;
                Object object = subscribedAnimationsLock;
                synchronized (object) {
                    boolean bl3 = false;
                    set = CollectionsKt.toSet((Iterable)subscribedAnimations);
                }
                Iterable iterable = set;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ComposeAnimation animationToUnsubscribe = (ComposeAnimation)element$iv;
                    boolean bl4 = false;
                    INSTANCE.onAnimationUnsubscribed(animationToUnsubscribe);
                }
                inspector.setAnimationClock(new AnimationClock(clock));
            }
        }
        Object object = subscribedAnimationsLock;
        synchronized (object) {
            boolean bl5 = false;
            bl = subscribedAnimations.add(animation);
        }
        if (bl) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(inspector, animation){
                final /* synthetic */ AnimationPreview $inspector;
                final /* synthetic */ ComposeAnimation $animation;
                {
                    this.$inspector = $inspector;
                    this.$animation = $animation;
                }

                public final void run() {
                    this.$inspector.createTab(this.$animation);
                    this.$inspector.setupAnimation(this.$animation, (Function0<Unit>)((Function0)new Function0<Unit>(this.$inspector, this.$animation){
                        final /* synthetic */ AnimationPreview $inspector;
                        final /* synthetic */ ComposeAnimation $animation;
                        {
                            this.$inspector = $inspector;
                            this.$animation = $animation;
                            super(0);
                        }

                        public final void invoke() {
                            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this.$inspector, this.$animation){
                                final /* synthetic */ AnimationPreview $inspector;
                                final /* synthetic */ ComposeAnimation $animation;
                                {
                                    this.$inspector = $inspector;
                                    this.$animation = $animation;
                                }

                                public final void run() {
                                    this.$inspector.addTab(this.$animation);
                                }
                            });
                        }
                    }));
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onAnimationUnsubscribed(@NotNull ComposeAnimation animation) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)animation, (String)"animation");
        Object object = subscribedAnimationsLock;
        synchronized (object) {
            boolean bl2 = false;
            bl = subscribedAnimations.remove(animation);
        }
        if (bl) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(animation){
                final /* synthetic */ ComposeAnimation $animation;
                {
                    this.$animation = $animation;
                }

                public final void run() {
                    block0: {
                        AnimationPreview animationPreview = ComposePreviewAnimationManager.INSTANCE.getCurrentInspector$intellij_android_compose_designer();
                        if (animationPreview == null) break block0;
                        animationPreview.removeTab(this.$animation);
                    }
                }
            });
        }
    }

    public final boolean isInspectorOpen() {
        return currentInspector != null;
    }

    public final void invalidate(@NotNull SmartPsiElementPointer<PsiFile> psiFilePointer2) {
        block1: {
            Intrinsics.checkNotNullParameter(psiFilePointer2, (String)"psiFilePointer");
            AnimationPreview animationPreview = currentInspector;
            if (animationPreview == null) break block1;
            AnimationPreview it = animationPreview;
            boolean bl = false;
            if (PsiManager.getInstance((Project)it.getPsiFilePointer().getProject()).areElementsEquivalent(psiFilePointer2.getElement(), it.getPsiFilePointer().getElement())) {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(it){
                    final /* synthetic */ AnimationPreview $it;
                    {
                        this.$it = $it;
                    }

                    public final void run() {
                        this.$it.invalidatePanel();
                    }
                });
            }
        }
    }

    public static final /* synthetic */ void access$setCurrentInspector$p(AnimationPreview animationPreview) {
        currentInspector = animationPreview;
    }

    static {
        subscribedAnimations = new LinkedHashSet();
        subscribedAnimationsLock = new Object();
        onSubscribedUnsubscribedExecutor = ApplicationManager.getApplication().isUnitTestMode() ? MoreExecutors.directExecutor() : (Executor)AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Animation Subscribe/Unsubscribe Callback Handler", (int)1);
    }
}

