/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.compose.annotator.check.device;

import com.android.tools.idea.compose.annotator.check.common.ExpectedValueType;
import com.android.tools.idea.compose.annotator.check.common.ParameterRule;
import com.android.tools.idea.compose.annotator.check.device.DeviceSpecCheckState;
import com.android.tools.idea.compose.annotator.check.device.DeviceSpecCheckStateKt;
import com.android.tools.idea.compose.annotator.check.device.DeviceSpecValueTypesKt;
import com.android.tools.idea.compose.annotator.check.device.DimensionParameterCheckResult;
import com.android.tools.idea.compose.annotator.check.device.ParameterCheckResult;
import com.android.tools.idea.compose.pickers.preview.property.DimUnit;
import com.android.tools.idea.compose.preview.Preview;
import com.android.tools.idea.compose.preview.util.device.DeviceSpecDimensionUtilKt;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0012\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0003H\u0002J\u0010\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u0003H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\t\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/idea/compose/annotator/check/device/DimensionParameterRule;", "Lcom/android/tools/idea/compose/annotator/check/common/ParameterRule;", "name", "", "defaultNumber", "", "(Ljava/lang/String;I)V", "defaultValue", "getDefaultValue", "()Ljava/lang/String;", "expectedType", "Lcom/android/tools/idea/compose/annotator/check/common/ExpectedValueType;", "getExpectedType", "()Lcom/android/tools/idea/compose/annotator/check/common/ExpectedValueType;", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getName", "attemptFix", "value", "dataProvider", "Lcom/intellij/openapi/actionSystem/DataProvider;", "checkValue", "", "fixNumberOrDefault", "", "valueToFix", "isBadNumber", "numberString", "intellij.android.compose-designer"})
public final class DimensionParameterRule
extends ParameterRule {
    @NotNull
    private final String name;
    private final int defaultNumber;
    @NotNull
    private final Logger log;
    @NotNull
    private final String defaultValue;
    @NotNull
    private final ExpectedValueType expectedType;

    public DimensionParameterRule(@NotNull String name, int defaultNumber) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.name = name;
        this.defaultNumber = defaultNumber;
        Logger logger2 = Logger.getInstance(this.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(this.javaClass)");
        this.log = logger2;
        this.defaultValue = "" + this.defaultNumber + Preview.DeviceSpec.INSTANCE.getDEFAULT_UNIT$intellij_android_compose_designer();
        this.expectedType = DeviceSpecValueTypesKt.getExpectedFloatWithUnit();
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public String getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    @NotNull
    public ExpectedValueType getExpectedType() {
        return this.expectedType;
    }

    @Override
    public boolean checkValue(@NotNull String value2, @NotNull DataProvider dataProvider2) {
        boolean bl;
        DimUnit expectedUnit;
        Enum enum_;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)dataProvider2, (String)"dataProvider");
        DeviceSpecCheckState deviceSpecState = (DeviceSpecCheckState)DeviceSpecCheckStateKt.getDeviceSpecCheckStateKey().getData(dataProvider2);
        String value$iv = StringsKt.takeLast((String)value2, (int)2);
        boolean $i$f$enumValueOfOrNull = false;
        try {
            enum_ = DimUnit.valueOf(value$iv);
        }
        catch (Exception _$iv) {
            enum_ = null;
        }
        DimUnit currentUnit = (DimUnit)enum_;
        if (currentUnit == null) {
            if (this.isBadNumber(value2)) {
                DeviceSpecCheckState deviceSpecCheckState = deviceSpecState;
                if (deviceSpecCheckState != null) {
                    deviceSpecCheckState.setCheckResult(this.getName(), DimensionParameterCheckResult.BadStatement);
                }
                return false;
            }
            DeviceSpecCheckState deviceSpecCheckState = deviceSpecState;
            if (deviceSpecCheckState != null) {
                deviceSpecCheckState.setCheckResult(this.getName(), DimensionParameterCheckResult.MissingUnit);
            }
            return false;
        }
        if (this.isBadNumber(StringsKt.dropLast((String)value2, (int)2))) {
            DeviceSpecCheckState deviceSpecCheckState = deviceSpecState;
            if (deviceSpecCheckState != null) {
                deviceSpecCheckState.setCheckResult(this.getName(), DimensionParameterCheckResult.BadNumber);
            }
            return false;
        }
        DeviceSpecCheckState deviceSpecCheckState = deviceSpecState;
        DimUnit dimUnit = expectedUnit = deviceSpecCheckState != null ? deviceSpecCheckState.getCommonUnit() : null;
        if (expectedUnit != null && currentUnit != expectedUnit) {
            deviceSpecState.setCheckResult(this.getName(), DimensionParameterCheckResult.WrongUnit);
            bl = false;
        } else {
            if (deviceSpecState != null && deviceSpecState.getCommonUnit() == null) {
                deviceSpecState.setCommonUnit(currentUnit);
            }
            DeviceSpecCheckState deviceSpecCheckState2 = deviceSpecState;
            if (deviceSpecCheckState2 != null) {
                deviceSpecCheckState2.setCheckResult(this.getName(), DimensionParameterCheckResult.Ok);
            }
            bl = true;
        }
        return bl;
    }

    @Override
    @Nullable
    public String attemptFix(@NotNull String value2, @NotNull DataProvider dataProvider2) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)value2, (String)"value");
        Intrinsics.checkNotNullParameter((Object)dataProvider2, (String)"dataProvider");
        DeviceSpecCheckState deviceSpecCheckState = (DeviceSpecCheckState)DeviceSpecCheckStateKt.getDeviceSpecCheckStateKey().getData(dataProvider2);
        if (deviceSpecCheckState == null) {
            DimensionParameterRule $this$attemptFix_u24lambda_u2d0 = this;
            boolean bl = false;
            $this$attemptFix_u24lambda_u2d0.log.error("Expected a " + Reflection.getOrCreateKotlinClass(DeviceSpecCheckState.class).getSimpleName() + " object");
            return null;
        }
        DeviceSpecCheckState deviceSpecState = deviceSpecCheckState;
        ParameterCheckResult parameterCheckResult = deviceSpecState.getCheckResult(this.getName());
        DimensionParameterCheckResult dimensionParameterCheckResult = parameterCheckResult instanceof DimensionParameterCheckResult ? (DimensionParameterCheckResult)parameterCheckResult : null;
        if (dimensionParameterCheckResult == null) {
            DimensionParameterRule $this$attemptFix_u24lambda_u2d1 = this;
            boolean bl = false;
            $this$attemptFix_u24lambda_u2d1.log.error("Expected " + Reflection.getOrCreateKotlinClass(DimensionParameterCheckResult.class).getSimpleName() + " for " + $this$attemptFix_u24lambda_u2d1.getName());
            return null;
        }
        DimensionParameterCheckResult parameterState = dimensionParameterCheckResult;
        DimUnit dimUnit = deviceSpecState.getCommonUnit();
        if (dimUnit == null) {
            dimUnit = Preview.DeviceSpec.INSTANCE.getDEFAULT_UNIT$intellij_android_compose_designer();
        }
        DimUnit commonUnit = dimUnit;
        switch (WhenMappings.$EnumSwitchMapping$0[parameterState.ordinal()]) {
            case 1: {
                object = StringsKt.dropLast((String)value2, (int)2) + commonUnit.name();
                break;
            }
            case 2: {
                object = value2 + commonUnit.name();
                break;
            }
            case 3: {
                object = this.fixNumberOrDefault(StringsKt.dropLast((String)value2, (int)2)) + commonUnit.name();
                break;
            }
            case 4: {
                object = this.defaultNumber + commonUnit.name();
                break;
            }
            case 5: {
                this.log.warn("Call to fix value, but nothing to fix");
                object = value2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return object;
    }

    private final Number fixNumberOrDefault(String valueToFix) {
        Float floatNumber = null;
        int lengthToFix = valueToFix.length();
        while (floatNumber == null && lengthToFix > 0) {
            floatNumber = StringsKt.toFloatOrNull((String)((Object)valueToFix.subSequence(0, lengthToFix--)).toString());
        }
        if (floatNumber == null) {
            return this.defaultNumber;
        }
        return DeviceSpecDimensionUtilKt.convertToDeviceSpecDimension(floatNumber.floatValue());
    }

    private final boolean isBadNumber(String numberString) {
        int n;
        block2: {
            CharSequence $this$indexOfLast$iv = numberString;
            boolean $i$f$indexOfLast = false;
            int n2 = $this$indexOfLast$iv.length() + -1;
            if (0 <= n2) {
                do {
                    int index$iv = n2--;
                    char it = $this$indexOfLast$iv.charAt(index$iv);
                    boolean bl = false;
                    if (!(it == '.')) continue;
                    n = index$iv;
                    break block2;
                } while (0 <= n2);
            }
            n = -1;
        }
        int decimalIndex = n;
        return StringsKt.toFloatOrNull((String)numberString) == null || decimalIndex >= 0 && numberString.length() - decimalIndex > 2;
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DimensionParameterCheckResult.values().length];
            nArray[DimensionParameterCheckResult.WrongUnit.ordinal()] = 1;
            nArray[DimensionParameterCheckResult.MissingUnit.ordinal()] = 2;
            nArray[DimensionParameterCheckResult.BadNumber.ordinal()] = 3;
            nArray[DimensionParameterCheckResult.BadStatement.ordinal()] = 4;
            nArray[DimensionParameterCheckResult.Ok.ordinal()] = 5;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

