/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.idea.common.scene.Display;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.Layer;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.surface.NlDesignSurface;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;

public class SceneLayer
extends Layer {
    private final DesignSurface<?> myDesignSurface;
    private final SceneView mySceneView;
    private final Dimension myScreenViewSize = new Dimension();
    private final Rectangle mySizeRectangle = new Rectangle();
    private final boolean myShowAlways;
    private final Display myDisplay = new Display();
    private boolean myShowOnHover = false;
    private boolean myAlwaysShowSelection;
    private boolean myTemporaryShow = false;

    public SceneLayer(@NotNull DesignSurface<?> surface2, @NotNull SceneView view2, boolean showAlways) {
        this.myDesignSurface = surface2;
        this.mySceneView = view2;
        this.myShowAlways = showAlways;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(@NotNull Graphics2D g2) {
        NlDesignSurface designSurface;
        SceneContext sceneContext = SceneContext.get(this.mySceneView);
        if (!(this.myTemporaryShow || this.myShowOnHover || this.myShowAlways || this.myAlwaysShowSelection)) {
            return;
        }
        if (!this.myShowAlways && this.getSceneView().getSurface() instanceof NlDesignSurface && (designSurface = (NlDesignSurface)this.getSceneView().getSurface()).isRenderingSynchronously() && !designSurface.isInAnimationScrubbing()) {
            return;
        }
        sceneContext.setShowOnlySelection(!this.myTemporaryShow && !this.myShowOnHover && this.myAlwaysShowSelection);
        Graphics2D g = (Graphics2D)g2.create();
        try {
            NlDesignSurface nlSurface;
            float degree;
            DesignSurface<?> sufrace;
            g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.mySceneView.getScaledContentSize(this.myScreenViewSize);
            Rectangle clipBounds = g.getClipBounds();
            this.mySizeRectangle.setBounds(this.mySceneView.getX(), this.mySceneView.getY(), this.myScreenViewSize.width, this.myScreenViewSize.height);
            Rectangle2D.intersect(this.mySizeRectangle, clipBounds, this.mySizeRectangle);
            if (this.mySizeRectangle.isEmpty()) {
                return;
            }
            sceneContext.setRenderableBounds(clipBounds);
            if (this.myShowAlways) {
                this.paintBackground(g, sceneContext);
            }
            if ((sufrace = this.mySceneView.getSurface()) instanceof NlDesignSurface && !Float.isNaN(degree = (nlSurface = (NlDesignSurface)sufrace).getRotateSurfaceDegree())) {
                return;
            }
            this.myDisplay.draw(sceneContext, g, this.mySceneView.getScene());
        }
        finally {
            g.dispose();
        }
    }

    private void paintBackground(@NotNull Graphics2D g, @NotNull SceneContext sceneContext) {
        Color backgroundColor = sceneContext.getColorSet().getBackground();
        if (backgroundColor == null) {
            return;
        }
        Shape shape2 = this.mySceneView.getScreenShape();
        if (shape2 == null) {
            g.setColor(backgroundColor);
            g.fillRect(this.mySizeRectangle.x, this.mySizeRectangle.y, this.mySizeRectangle.width, this.mySizeRectangle.height);
        } else {
            g.setColor(backgroundColor.darker());
            g.fillRect(this.mySizeRectangle.x, this.mySizeRectangle.y, this.mySizeRectangle.width, this.mySizeRectangle.height);
            Shape clip = g.getClip();
            g.setColor(backgroundColor);
            g.setClip(shape2);
            g.fillRect(this.mySizeRectangle.x, this.mySizeRectangle.y, this.mySizeRectangle.width, this.mySizeRectangle.height);
            g.setClip(clip);
        }
    }

    public boolean isShowOnHover() {
        return this.myShowOnHover;
    }

    public void setShowOnHover(boolean value2) {
        this.myShowOnHover = value2;
    }

    public SceneView getSceneView() {
        return this.mySceneView;
    }

    @Override
    public void onHover(int x, int y) {
        boolean show2 = false;
        if (this.getSceneView() == this.myDesignSurface.getSceneViewAt(x, y)) {
            show2 = true;
        }
        if (this.isShowOnHover() != show2) {
            this.setShowOnHover(show2);
            this.myDesignSurface.repaint();
        }
    }

    public void setAlwaysShowSelection(boolean alwaysShowSelection) {
        this.myAlwaysShowSelection = alwaysShowSelection;
    }

    public void setTemporaryShow(boolean temporaryShow) {
        this.myTemporaryShow = temporaryShow;
        this.myDisplay.reLayout();
    }
}

