/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.adtui.Pannable;
import com.android.tools.adtui.PannableKt;
import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceShortcut;
import com.android.tools.idea.common.surface.Interaction;
import com.android.tools.idea.common.surface.InteractionHandler;
import com.android.tools.idea.common.surface.LayoutlibInteraction;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.surface.PanInteraction;
import com.android.tools.idea.uibuilder.surface.ScreenView;
import java.awt.Cursor;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\"\u0010\u0011\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J \u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\"\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J \u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0012\u0010\u0019\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001d\u001a\u00020\u0013H\u0016J \u0010\u001e\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0010\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020!H\u0016J \u0010\"\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0016J\u0018\u0010#\u001a\u00020\u00132\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016J \u0010$\u001a\u00020\u00132\u0006\u0010%\u001a\u00020&2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/android/tools/idea/common/surface/LayoutlibInteractionHandler;", "Lcom/android/tools/idea/common/surface/InteractionHandler;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "createInteractionOnDrag", "Lcom/android/tools/idea/common/surface/Interaction;", "mouseX", "", "mouseY", "modifiersEx", "createInteractionOnDragEnter", "dragEvent", "Ljava/awt/dnd/DropTargetDragEvent;", "createInteractionOnMouseWheelMoved", "mouseWheelEvent", "Ljava/awt/event/MouseWheelEvent;", "createInteractionOnPressed", "doubleClick", "", "x", "y", "getCursorWhenNoInteraction", "Ljava/awt/Cursor;", "hoverWhenNoInteraction", "keyPressedWithoutInteraction", "keyEvent", "Ljava/awt/event/KeyEvent;", "keyReleasedWithoutInteraction", "mouseExited", "mouseReleaseWhenNoInteraction", "popupMenuTrigger", "mouseEvent", "Ljava/awt/event/MouseEvent;", "singleClick", "stayHovering", "zoom", "type", "Lcom/android/tools/adtui/actions/ZoomType;", "intellij.android.designer"})
public final class LayoutlibInteractionHandler
implements InteractionHandler {
    @NotNull
    private final DesignSurface<?> surface;

    public LayoutlibInteractionHandler(@NotNull DesignSurface<?> surface2) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        this.surface = surface2;
    }

    @Override
    @Nullable
    public Interaction createInteractionOnPressed(int mouseX, int mouseY, int modifiersEx) {
        SceneView sceneView = this.surface.getSceneViewAtOrPrimary(mouseX, mouseY);
        if (sceneView == null) {
            return null;
        }
        SceneView view2 = sceneView;
        ScreenView screenView = (ScreenView)view2;
        return new LayoutlibInteraction(screenView);
    }

    @Override
    @Nullable
    public Interaction createInteractionOnDrag(int mouseX, int mouseY, int modifiersEx) {
        return null;
    }

    @Override
    @Nullable
    public Interaction createInteractionOnDragEnter(@NotNull DropTargetDragEvent dragEvent) {
        Intrinsics.checkNotNullParameter((Object)dragEvent, (String)"dragEvent");
        return null;
    }

    @Override
    @Nullable
    public Interaction createInteractionOnMouseWheelMoved(@NotNull MouseWheelEvent mouseWheelEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseWheelEvent, (String)"mouseWheelEvent");
        return null;
    }

    @Override
    public void mouseReleaseWhenNoInteraction(int x, int y, int modifiersEx) {
    }

    @Override
    public void singleClick(int x, int y, int modifiersEx) {
    }

    @Override
    public void doubleClick(int x, int y, int modifiersEx) {
    }

    @Override
    public void zoom(@NotNull ZoomType type, int mouseX, int mouseY) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        this.surface.zoom(type, mouseX, mouseY);
    }

    @Override
    public void hoverWhenNoInteraction(int mouseX, int mouseY, int modifiersEx) {
    }

    @Override
    public void stayHovering(int mouseX, int mouseY) {
        for (SceneView sceneView : this.surface.getSceneViews()) {
            sceneView.onHover(mouseX, mouseY);
        }
    }

    @Override
    public void popupMenuTrigger(@NotNull MouseEvent mouseEvent) {
        Intrinsics.checkNotNullParameter((Object)mouseEvent, (String)"mouseEvent");
    }

    @Override
    @Nullable
    public Cursor getCursorWhenNoInteraction(int mouseX, int mouseY, int modifiersEx) {
        Scene scene = this.surface.getScene();
        return scene != null ? scene.getMouseCursor() : null;
    }

    @Override
    @Nullable
    public Interaction keyPressedWithoutInteraction(@NotNull KeyEvent keyEvent) {
        Pannable pannable;
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
        if (keyEvent.getKeyCode() == DesignSurfaceShortcut.PAN.getKeyCode()) {
            Object object = this.surface.getData(PannableKt.PANNABLE_KEY.getName());
            pannable = object instanceof Pannable ? (Pannable)object : null;
            if (pannable == null) {
                pannable = this.surface;
            }
        } else {
            SceneView sceneView = this.surface.getFocusedSceneView();
            if (sceneView == null) {
                return null;
            }
            SceneView view2 = sceneView;
            ScreenView screenView = (ScreenView)view2;
            return new LayoutlibInteraction(screenView);
        }
        return new PanInteraction(pannable);
    }

    @Override
    public void keyReleasedWithoutInteraction(@NotNull KeyEvent keyEvent) {
        Intrinsics.checkNotNullParameter((Object)keyEvent, (String)"keyEvent");
    }

    @Override
    public void mouseExited() {
    }
}

