/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueListener;
import com.android.tools.idea.common.error.IssueSource;
import com.android.tools.idea.common.error.NlComponentIssueSource;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceHelper;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintIssueProvider;
import com.google.common.collect.ImmutableCollection;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016R\u0015\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/common/surface/DesignSurfaceIssueListenerImpl;", "Lcom/android/tools/idea/common/error/IssueListener;", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "getSurface", "()Lcom/android/tools/idea/common/surface/DesignSurface;", "onIssueSelected", "", "issue", "Lcom/android/tools/idea/common/error/Issue;", "intellij.android.designer"})
public final class DesignSurfaceIssueListenerImpl
implements IssueListener {
    @NotNull
    private final DesignSurface<?> surface;

    public DesignSurfaceIssueListenerImpl(@NotNull DesignSurface<?> surface2) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        this.surface = surface2;
    }

    @NotNull
    public final DesignSurface<?> getSurface() {
        return this.surface;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onIssueSelected(@NotNull Issue issue) {
        block4: {
            void $this$filterTo$iv$iv;
            IssueSource source;
            block3: {
                PsiElement element;
                Intrinsics.checkNotNullParameter((Object)issue, (String)"issue");
                source = issue.getSource();
                if (!(source instanceof NlComponentIssueSource)) break block3;
                NlComponent component = ((NlComponentIssueSource)source).getComponent();
                this.surface.getSelectionModel().setSelection(CollectionsKt.listOf((Object)component));
                XmlTag xmlTag = component.getBackend().getTag();
                Object object = element = xmlTag != null ? xmlTag.getNavigationElement() : null;
                if (!(element instanceof Navigatable) || !PsiNavigationSupport.getInstance().canNavigate(element)) break block4;
                ((Navigatable)element).navigate(false);
                break block4;
            }
            if (!(source instanceof VisualLintIssueProvider.VisualLintIssueSource)) break block4;
            this.surface.repaint();
            ImmutableCollection<SceneView> immutableCollection = this.surface.getSceneViews();
            Intrinsics.checkNotNullExpressionValue(immutableCollection, (String)"surface.sceneViews");
            Iterable $this$filter$iv = (Iterable)immutableCollection;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                SceneView it = (SceneView)element$iv$iv;
                boolean bl = false;
                if (!((VisualLintIssueProvider.VisualLintIssueSource)source).getModels().contains(it.getSceneManager().getModel())) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            List sceneViews = (List)destination$iv$iv;
            if (sceneViews.isEmpty()) {
                return;
            }
            int minX = 0;
            minX = Integer.MAX_VALUE;
            int minY = 0;
            minY = Integer.MAX_VALUE;
            int maxX = 0;
            maxX = Integer.MIN_VALUE;
            int maxY = 0;
            maxY = Integer.MIN_VALUE;
            Iterable $this$forEach$iv = sceneViews;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SceneView it = (SceneView)element$iv;
                boolean bl = false;
                minX = Math.min(minX, it.getX());
                minY = Math.min(minY, it.getY());
                maxX = Math.max(maxX, it.getX() + it.getScaledContentSize().width);
                maxY = Math.max(maxY, it.getY() + it.getScaledContentSize().height);
            }
            double currentScale = this.surface.getScale();
            Dimension size = new Dimension((int)((double)(maxX - minX + 40) / currentScale), (int)((double)(maxY - minY + 40) / currentScale));
            double scale = DesignSurfaceHelper.getFitContentIntoWindowScale(this.surface, size);
            this.surface.setScale(scale);
            this.surface.setScrollPosition(minX - 20, minY - 20);
        }
    }
}

