/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.surface;

import com.android.ide.common.rendering.api.Bridge;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.resources.ResourceType;
import com.android.tools.adtui.stdui.ActionData;
import com.android.tools.adtui.workbench.WorkBench;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.DesignSurfaceHelper;
import com.android.tools.idea.npw.assetstudio.IconGenerator;
import com.android.tools.idea.npw.assetstudio.MaterialDesignIcons;
import com.android.tools.idea.res.ResourceRepositoryManager;
import com.google.common.io.CharStreams;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.impl.DocumentImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.AWTEvent;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.intellij.lang.annotations.Language;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000j\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a(\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\r\u001a\u001e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\r\u001a0\u0010\u0011\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002\u001a\u0016\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019\u001a\"\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001d\u001a\u00020\rH\u0002\u001a\u001e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\r\u001a\u0016\u0010#\u001a\u00020$*\u0006\u0012\u0002\b\u00030%2\u0006\u0010&\u001a\u00020'\u001a\u001c\u0010(\u001a\u00020\u0007*\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030%0)2\u0006\u0010*\u001a\u00020+\"\u001b\u0010\u0000\u001a\u00020\u00018BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0005\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006,"}, d2={"logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "logger$delegate", "Lkotlin/Lazy;", "copyLayoutToMainModuleSourceSet", "", "project", "Lcom/intellij/openapi/project/Project;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "layout", "", "xml", "copyVectorAssetToMainModuleSourceSet", "asset", "createResourceFile", "resourceDirectory", "resourceFileName", "resourceFileContent", "", "createZoomControlAutoHiddenListener", "Ljava/awt/event/AWTEventListener;", "zoomControlPaneOwner", "Ljavax/swing/JComponent;", "zoomControlComponent", "getResourceDirectoryChild", "Lcom/intellij/openapi/vfs/VirtualFile;", "child", "moduleContainsResource", "", "type", "Lcom/android/resources/ResourceType;", "name", "getFitContentIntoWindowScale", "", "Lcom/android/tools/idea/common/surface/DesignSurface;", "contentSize", "Ljava/awt/Dimension;", "handleLayoutlibNativeCrash", "Lcom/android/tools/adtui/workbench/WorkBench;", "runnable", "Ljava/lang/Runnable;", "intellij.android.designer"})
@JvmName(name="DesignSurfaceHelper")
public final class DesignSurfaceHelper {
    @NotNull
    private static final Lazy logger$delegate = LazyKt.lazy((Function0)logger.2.INSTANCE);

    private static final Logger getLogger() {
        Lazy lazy = logger$delegate;
        return (Logger)lazy.getValue();
    }

    public static final boolean moduleContainsResource(@NotNull AndroidFacet facet, @NotNull ResourceType type, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return ResourceRepositoryManager.getModuleResources((AndroidFacet)facet).hasResources(ResourceNamespace.TODO(), type, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void copyVectorAssetToMainModuleSourceSet(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull String asset) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)asset, (String)"asset");
        String string = MaterialDesignIcons.getPathForBasename((String)asset);
        if (string == null) {
            boolean bl = false;
            DesignSurfaceHelper.getLogger().warn("Cannot find the material icon path for " + asset);
            return;
        }
        String path = string;
        try {
            InputStream inputStream = IconGenerator.class.getClassLoader().getResourceAsStream(path);
            if (inputStream == null) {
                boolean bl = false;
                DesignSurfaceHelper.getLogger().warn("Cannot load the material icon for " + asset);
                return;
            }
            InputStream inputStream2 = inputStream;
            Closeable closeable = new InputStreamReader(inputStream2, Charsets.UTF_8);
            Throwable throwable = null;
            try {
                InputStreamReader reader = (InputStreamReader)closeable;
                boolean bl = false;
                String string2 = asset + ".xml";
                String string3 = CharStreams.toString((Readable)reader);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"toString(reader)");
                DesignSurfaceHelper.createResourceFile(project, facet, "drawable", string2, string3);
                Unit unit2 = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException exception) {
            DesignSurfaceHelper.getLogger().warn((Throwable)exception);
        }
    }

    public static final void copyLayoutToMainModuleSourceSet(@NotNull Project project, @NotNull AndroidFacet facet, @NotNull String layout2, @Language(value="XML") @NotNull String xml) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Intrinsics.checkNotNullParameter((Object)layout2, (String)"layout");
        Intrinsics.checkNotNullParameter((Object)xml, (String)"xml");
        String message = "Do you want to copy layout " + layout2 + " to your main module source set?";
        if (Messages.showYesNoDialog((Project)project, (String)message, (String)"Copy Layout", (Icon)Messages.getQuestionIcon()) == 1) {
            return;
        }
        DesignSurfaceHelper.createResourceFile(project, facet, "layout", layout2 + ".xml", xml);
    }

    private static final void createResourceFile(Project project, AndroidFacet facet, String resourceDirectory, String resourceFileName, CharSequence resourceFileContent) {
        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(project, facet, resourceDirectory, resourceFileName, resourceFileContent){
            final /* synthetic */ Project $project;
            final /* synthetic */ AndroidFacet $facet;
            final /* synthetic */ String $resourceDirectory;
            final /* synthetic */ String $resourceFileName;
            final /* synthetic */ CharSequence $resourceFileContent;
            {
                this.$project = $project;
                this.$facet = $facet;
                this.$resourceDirectory = $resourceDirectory;
                this.$resourceFileName = $resourceFileName;
                this.$resourceFileContent = $resourceFileContent;
            }

            public final void run() {
                try {
                    VirtualFile virtualFile2 = DesignSurfaceHelper.access$getResourceDirectoryChild(this.$project, this.$facet, this.$resourceDirectory);
                    if (virtualFile2 == null) {
                        return;
                    }
                    VirtualFile directory = virtualFile2;
                    Document document = FileDocumentManager.getInstance().getDocument(directory.createChildData((Object)this.$project, this.$resourceFileName));
                    Intrinsics.checkNotNull((Object)document);
                    Document document2 = document;
                    if (document2 instanceof DocumentImpl && SystemInfo.isWindows) {
                        ((DocumentImpl)document2).setAcceptSlashR(true);
                    }
                    document2.setText(this.$resourceFileContent);
                }
                catch (IOException exception) {
                    DesignSurfaceHelper.access$getLogger().warn((Throwable)exception);
                }
            }
        });
    }

    private static final VirtualFile getResourceDirectoryChild(Project project, AndroidFacet facet, String child) throws IOException {
        VirtualFile resourceDirectory = ResourceFolderManager.Companion.getInstance(facet).getPrimaryFolder();
        if (resourceDirectory == null) {
            DesignSurfaceHelper.getLogger().warn("resourceDirectory is null");
            return null;
        }
        VirtualFile virtualFile2 = resourceDirectory.findChild(child);
        if (virtualFile2 == null) {
            return resourceDirectory.createChildDirectory((Object)project, child);
        }
        return virtualFile2;
    }

    public static final void handleLayoutlibNativeCrash(@NotNull WorkBench<DesignSurface<?>> $this$handleLayoutlibNativeCrash, @NotNull Runnable runnable2) {
        Intrinsics.checkNotNullParameter($this$handleLayoutlibNativeCrash, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)runnable2, (String)"runnable");
        String message = "The preview has been disabled following a crash in the rendering engine. If the problem persists, please report the issue.";
        ActionData actionData2 = new ActionData("Re-enable rendering", (Function0)new Function0<Unit>($this$handleLayoutlibNativeCrash, runnable2){
            final /* synthetic */ WorkBench<DesignSurface<?>> $this_handleLayoutlibNativeCrash;
            final /* synthetic */ Runnable $runnable;
            {
                this.$this_handleLayoutlibNativeCrash = $receiver;
                this.$runnable = $runnable;
                super(0);
            }

            public final void invoke() {
                Bridge.setNativeCrash((boolean)false);
                this.$this_handleLayoutlibNativeCrash.showLoading("Loading...");
                this.$runnable.run();
            }
        });
        $this$handleLayoutlibNativeCrash.loadingStopped(message, actionData2);
    }

    @NotNull
    public static final AWTEventListener createZoomControlAutoHiddenListener(@NotNull JComponent zoomControlPaneOwner, @NotNull JComponent zoomControlComponent) {
        Intrinsics.checkNotNullParameter((Object)zoomControlPaneOwner, (String)"zoomControlPaneOwner");
        Intrinsics.checkNotNullParameter((Object)zoomControlComponent, (String)"zoomControlComponent");
        return new AWTEventListener(zoomControlPaneOwner, zoomControlComponent){
            final /* synthetic */ JComponent $zoomControlPaneOwner;
            final /* synthetic */ JComponent $zoomControlComponent;
            {
                this.$zoomControlPaneOwner = $zoomControlPaneOwner;
                this.$zoomControlComponent = $zoomControlComponent;
            }

            public final void eventDispatched(AWTEvent event) {
                int id2 = event.getID();
                if (id2 == 504) {
                    if (!this.$zoomControlPaneOwner.isShowing()) {
                        this.$zoomControlComponent.setVisible(false);
                        return;
                    }
                    Intrinsics.checkNotNull((Object)event, (String)"null cannot be cast to non-null type java.awt.event.MouseEvent");
                    MouseEvent mouseEvent = (MouseEvent)event;
                    Point location = mouseEvent.getLocationOnScreen();
                    Point screenLocation = this.$zoomControlPaneOwner.getLocationOnScreen();
                    Rectangle rect = this.$zoomControlPaneOwner.getVisibleRect();
                    rect.translate(screenLocation.x, screenLocation.y);
                    this.$zoomControlComponent.setVisible(rect.contains(location));
                }
            }
        };
    }

    public static final double getFitContentIntoWindowScale(@NotNull DesignSurface<?> $this$getFitContentIntoWindowScale, @NotNull Dimension contentSize) {
        Intrinsics.checkNotNullParameter($this$getFitContentIntoWindowScale, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)contentSize, (String)"contentSize");
        int availableWidth = $this$getFitContentIntoWindowScale.getExtentSize().width;
        int availableHeight = $this$getFitContentIntoWindowScale.getExtentSize().height;
        double scaleX = $this$getFitContentIntoWindowScale.getSize().width == 0 ? 1.0 : (double)availableWidth / (double)contentSize.width;
        double scaleY = $this$getFitContentIntoWindowScale.getSize().height == 0 ? 1.0 : (double)availableHeight / (double)contentSize.height;
        return Math.min(scaleX, Math.min(scaleY, $this$getFitContentIntoWindowScale.myMaxFitIntoScale));
    }

    public static final /* synthetic */ VirtualFile access$getResourceDirectoryChild(Project project, AndroidFacet facet, String child) {
        return DesignSurfaceHelper.getResourceDirectoryChild(project, facet, child);
    }

    public static final /* synthetic */ Logger access$getLogger() {
        return DesignSurfaceHelper.getLogger();
    }
}

