/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene.target;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.BaseTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.uibuilder.handlers.constraint.draw.DrawAnchor;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import com.android.tools.idea.uibuilder.scene.target.Notch;
import com.android.tools.idea.uibuilder.scene.target.TargetSnapper;
import com.google.common.collect.ImmutableList;
import com.intellij.util.ui.JBUI;
import java.awt.Point;
import java.util.List;
import java.util.Optional;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AnchorTarget
extends BaseTarget
implements Notch.Provider {
    private static final boolean DEBUG_RENDERER = false;
    public static final int ANCHOR_SIZE = JBUI.scale((int)6);
    public static final int EXPANDED_SIZE = JBUI.scale((int)400);
    private float myPositionX;
    private float myPositionY;
    @NotNull
    protected final Type myType;
    protected int myLastX = -1;
    protected int myLastY = -1;
    protected final boolean myIsEdge;
    protected boolean myIsDragging = false;
    protected final TargetSnapper mySnapper = new TargetSnapper();

    public AnchorTarget(@NotNull Type type, boolean isEdge) {
        this.myType = type;
        this.myIsEdge = isEdge;
    }

    @Override
    public float getCenterX() {
        return this.myPositionX;
    }

    @Override
    public float getCenterY() {
        return this.myPositionY;
    }

    @NotNull
    public Type getType() {
        return this.myType;
    }

    public boolean isEdge() {
        return this.myIsEdge;
    }

    protected abstract boolean isConnected();

    @Override
    public boolean canChangeSelection() {
        return false;
    }

    @Override
    public void componentSelectionChanged(boolean selected) {
        DecoratorUtilities.ViewStates mode = selected ? DecoratorUtilities.ViewStates.SELECTED : DecoratorUtilities.ViewStates.NORMAL;
        DecoratorUtilities.setTimeChange(this.myComponent.getNlComponent(), this.myType.toString(), mode);
    }

    @Override
    public void setMouseHovered(boolean over) {
        if (over != this.mIsOver) {
            this.mIsOver = over;
            this.myComponent.getScene().needsRebuildList();
            this.myComponent.getScene().repaint();
        }
    }

    protected boolean isTargeted() {
        return this.mIsOver && !this.myComponent.isSelected();
    }

    public boolean canDisconnect() {
        return true;
    }

    @Override
    public boolean layout(@NotNull SceneContext sceneTransform, int l, int t, int r, int b) {
        float yDiff;
        float mw = (float)(l + r) / 2.0f;
        float mh = (float)(t + b) / 2.0f;
        switch (this.myType) {
            case LEFT: {
                this.myPositionX = l;
                this.myPositionY = mh;
                break;
            }
            case TOP: {
                this.myPositionX = mw;
                this.myPositionY = t;
                break;
            }
            case RIGHT: {
                this.myPositionX = r;
                this.myPositionY = mh;
                break;
            }
            case BOTTOM: {
                this.myPositionX = mw;
                this.myPositionY = b;
                break;
            }
            case BASELINE: {
                this.myPositionX = mw;
                this.myPositionY = t + this.myComponent.getBaseline();
                return false;
            }
        }
        int anchorSizeDip = Coordinates.getAndroidDimensionDip(this.myComponent.getScene().getSceneManager().getSceneView(), ANCHOR_SIZE);
        float xDiff = this.myPositionX - mw;
        if (sceneTransform.getSwingDimensionDip(Math.abs(xDiff)) < ANCHOR_SIZE * 2) {
            float sign = Math.signum(xDiff);
            if (sign == 0.0f) {
                sign = this.myType == Type.LEFT ? -1.0f : (this.myType == Type.RIGHT ? 1.0f : 0.0f);
            }
            this.myPositionX = mw + sign * 2.0f * (float)anchorSizeDip;
        }
        if (sceneTransform.getSwingDimensionDip(Math.abs(yDiff = this.myPositionY - mh)) < ANCHOR_SIZE * 2) {
            float sign = Math.signum(yDiff);
            if (sign == 0.0f) {
                sign = this.myType == Type.TOP ? -1.0f : (this.myType == Type.BOTTOM ? 1.0f : 0.0f);
            }
            this.myPositionY = mh + sign * 2.0f * (float)anchorSizeDip;
        }
        return false;
    }

    @Override
    public void render(@NotNull DisplayList list, @NotNull SceneContext sceneContext) {
        if (!this.isEnabled()) {
            return;
        }
        if (this.myComponent.isDragging() && !this.isConnected()) {
            return;
        }
        DrawAnchor.Mode mode = this.getDrawMode();
        DrawAnchor.Type type = this.getDrawType();
        boolean drawAsConnected = this.getDrawAsConnected();
        if (mode == DrawAnchor.Mode.DELETE && !this.canDisconnect()) {
            mode = DrawAnchor.Mode.OVER;
        }
        if (mode != DrawAnchor.Mode.DO_NOT_DRAW) {
            if (type != DrawAnchor.Type.BASELINE) {
                DrawAnchor.add(list, sceneContext, this.myPositionX, this.myPositionY, type, drawAsConnected, mode);
            } else {
                DrawAnchor.addBaseline(list, sceneContext, this.myPositionX, this.myPositionY, this.myComponent.getDrawWidth(), type, drawAsConnected, mode);
            }
        }
    }

    @Override
    public void addHit(@NotNull SceneContext transform, @NotNull ScenePicker picker, @JdkConstants.InputEventMask int modifiersEx) {
        if (!this.isEnabled()) {
            return;
        }
        int swingX = transform.getSwingXDip(this.myPositionX);
        int swingY = transform.getSwingYDip(this.myPositionY);
        if (this.myIsEdge) {
            switch (this.myType) {
                case LEFT: 
                case RIGHT: {
                    int swingHeight = transform.getSwingDimensionDip(this.myComponent.getDrawHeight());
                    picker.addRect(this, 0, swingX - ANCHOR_SIZE, swingY - swingHeight / 2, swingX + ANCHOR_SIZE, swingY + swingHeight / 2);
                    break;
                }
                case TOP: 
                case BOTTOM: {
                    int swingWidth = transform.getSwingDimensionDip(this.myComponent.getDrawWidth());
                    picker.addRect(this, 0, swingX - swingWidth / 2, swingY - ANCHOR_SIZE, swingX + swingWidth / 2, swingY + ANCHOR_SIZE);
                    break;
                }
            }
        } else if (this.myType != Type.BASELINE) {
            picker.addRect(this, 0, swingX - ANCHOR_SIZE / 2, swingY - ANCHOR_SIZE / 2, swingX + ANCHOR_SIZE, swingY + ANCHOR_SIZE);
        } else {
            int swingWidth = transform.getSwingDimensionDip(this.myComponent.getDrawWidth());
            int left = swingX - swingWidth / 2 + ANCHOR_SIZE;
            int right2 = swingX + swingWidth / 2 - ANCHOR_SIZE;
            picker.addRect(this, 0, left, swingY - ANCHOR_SIZE, right2, swingY + ANCHOR_SIZE);
        }
    }

    protected boolean isEnabled() {
        Target interactingTarget = this.myComponent.getScene().getInteractingTarget();
        if (interactingTarget instanceof AnchorTarget) {
            return ((AnchorTarget)interactingTarget).isConnectible(this);
        }
        return true;
    }

    public abstract boolean isConnectible(@NotNull AnchorTarget var1);

    @NotNull
    protected abstract DrawAnchor.Mode getDrawMode();

    @NotNull
    private DrawAnchor.Type getDrawType() {
        return this.myType == Type.BASELINE ? DrawAnchor.Type.BASELINE : DrawAnchor.Type.NORMAL;
    }

    private boolean getDrawAsConnected() {
        return this.isConnected() || this.myIsDragging;
    }

    @Override
    public int getPreferenceLevel() {
        return 70;
    }

    @Override
    public void mouseDown(int x, int y) {
        this.myLastX = -1;
        this.myLastY = -1;
        this.mySnapper.reset();
        this.mySnapper.gatherNotches(this.myComponent);
    }

    @Override
    public void mouseDrag(int x, int y, @NotNull List<Target> ignored, @NotNull SceneContext ignored2) {
        Optional<Point> p = this.mySnapper.trySnapCircle(x, y);
        this.myLastX = p.map(point -> point.x).orElse(x);
        this.myLastY = p.map(point -> point.y).orElse(y);
    }

    @Override
    public void mouseRelease(int x, int y, @NotNull List<Target> ignored) {
        this.myLastX = -1;
        this.myLastY = -1;
    }

    @Override
    public void mouseCancel() {
        this.myLastX = -1;
        this.myLastY = -1;
        this.myComponent.getScene().needsRebuildList();
        this.myComponent.getScene().markNeedsLayout(1);
        this.myIsDragging = false;
    }

    @Override
    public String getToolTipText() {
        boolean supportRtl = this.myComponent.getScene().supportsRTL();
        boolean isRtl = this.myComponent.getScene().isInRTL();
        return AnchorTarget.createAnchorToolTips(this.myType, !this.isConnected(), supportRtl, isRtl);
    }

    @Override
    public void fill(@NotNull SceneComponent owner, @NotNull SceneComponent snappableComponent, @NotNull ImmutableList.Builder<Notch> notchBuilder) {
        int y;
        int x;
        if (!this.isEnabled()) {
            return;
        }
        if (this.myComponent.isDragging() && !this.isConnected()) {
            return;
        }
        switch (this.getType()) {
            case LEFT: {
                x = owner.getDrawX();
                y = owner.getDrawY() + owner.getDrawHeight() / 2;
                break;
            }
            case TOP: {
                x = owner.getDrawX() + owner.getDrawWidth() / 2;
                y = owner.getDrawY();
                break;
            }
            case RIGHT: {
                x = owner.getDrawX() + owner.getDrawWidth();
                y = owner.getDrawY() + owner.getDrawHeight() / 2;
                break;
            }
            case BOTTOM: {
                x = owner.getDrawX() + owner.getDrawWidth() / 2;
                y = owner.getDrawY() + owner.getDrawHeight();
                break;
            }
            default: {
                x = -1;
                y = -1;
            }
        }
        Notch.Circle notch2 = new Notch.Circle(owner, x, y, null);
        notch2.setGap(Coordinates.getAndroidDimensionDip(snappableComponent.getScene(), ANCHOR_SIZE * 2));
        notch2.setTarget(this);
        notchBuilder.add((Object)notch2);
    }

    @NotNull
    public static String createAnchorToolTips(@Nullable Type type, boolean isCreated, boolean isRtlSupported, boolean isRtl) {
        StringBuilder builder2 = new StringBuilder();
        builder2.append(isCreated ? "Create " : "Delete ");
        if (type != null) {
            String directionText;
            switch (type) {
                case LEFT: {
                    directionText = isRtlSupported ? (isRtl ? "End" : "Start") : "Left";
                    break;
                }
                case TOP: {
                    directionText = "Top";
                    break;
                }
                case RIGHT: {
                    directionText = isRtlSupported ? (isRtl ? "Start" : "End") : "Right";
                    break;
                }
                case BOTTOM: {
                    directionText = "Bottom";
                    break;
                }
                case BASELINE: {
                    directionText = "Baseline";
                    break;
                }
                default: {
                    directionText = "";
                }
            }
            builder2.append(directionText).append(" ");
        }
        builder2.append("Constraint");
        return builder2.toString();
    }

    @Nullable
    public static AnchorTarget findAnchorTarget(@NotNull SceneComponent component, @NotNull Type type) {
        for (Target target : component.getTargets()) {
            if (!(target instanceof AnchorTarget) || ((AnchorTarget)target).myType != type) continue;
            return (AnchorTarget)target;
        }
        return null;
    }

    public static enum Type {
        LEFT,
        TOP,
        RIGHT,
        BOTTOM,
        BASELINE;


        public int getMask() {
            switch (this) {
                case LEFT: {
                    return 4;
                }
                case TOP: {
                    return 1;
                }
                case RIGHT: {
                    return 8;
                }
                case BOTTOM: {
                    return 2;
                }
                case BASELINE: {
                    return 16;
                }
            }
            return 0;
        }

        public String toString() {
            switch (this) {
                case LEFT: {
                    return "left";
                }
                case TOP: {
                    return "north";
                }
                case RIGHT: {
                    return "right";
                }
                case BOTTOM: {
                    return "bottom";
                }
            }
            return "baseline";
        }
    }
}

