/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.Coordinates;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.ComponentProvider;
import com.android.tools.idea.common.scene.HitProvider;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.ScenePicker;
import com.android.tools.idea.common.scene.TargetProvider;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.android.tools.idea.common.scene.decorator.SceneDecorator;
import com.android.tools.idea.common.scene.draw.DisplayList;
import com.android.tools.idea.common.scene.target.CommonDragTarget;
import com.android.tools.idea.common.scene.target.Target;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.model.NlComponentHelperKt;
import com.android.tools.idea.uibuilder.scene.decorator.DecoratorUtilities;
import com.android.tools.idea.uibuilder.scene.target.Notch;
import com.android.tools.idea.uibuilder.scene.target.ResizeBaseTarget;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SceneComponent {
    @VisibleForTesting
    public static final int ANIMATION_DURATION = 350;
    public HashMap<String, Object> myCache = new HashMap();
    public SceneDecorator myDecorator;
    private TargetProvider myTargetProvider;
    private ComponentProvider myComponentProvider;
    private HitProvider myHitProvider;
    private final Scene myScene;
    private final NlComponent myNlComponent;
    private CopyOnWriteArrayList<SceneComponent> myChildren = new CopyOnWriteArrayList();
    private SceneComponent myParent = null;
    private boolean myIsToolLocked = false;
    private boolean myIsSelected = false;
    private boolean myIsHighlighted = false;
    protected boolean myDragging = false;
    private AnimatedValue myAnimatedDrawX = new AnimatedValue();
    private AnimatedValue myAnimatedDrawY = new AnimatedValue();
    private AnimatedValue myAnimatedDrawWidth = new AnimatedValue();
    private AnimatedValue myAnimatedDrawHeight = new AnimatedValue();
    private DrawState myDrawState = DrawState.NORMAL;
    private final ArrayList<Target> myTargets = new ArrayList();
    @Nullable
    private ImmutableList<Target> myCachedTargetList;
    private int myCurrentLeft = 0;
    private int myCurrentTop = 0;
    private int myCurrentRight = 0;
    private int myCurrentBottom = 0;
    private boolean myShowBaseline = false;
    @Nullable
    private Notch.Provider myNotchProvider = null;
    @Nullable
    private CommonDragTarget myDragTarget;

    public int getCenterX() {
        return this.myCurrentLeft + (this.myCurrentRight - this.myCurrentLeft) / 2;
    }

    public int getCenterY() {
        return this.myCurrentTop + (this.myCurrentBottom - this.myCurrentTop) / 2;
    }

    public SceneComponent(@NotNull Scene scene, @NotNull NlComponent component, @NotNull HitProvider hitProvider) {
        this.myScene = scene;
        this.myNlComponent = component;
        this.myScene.addComponent(this);
        SceneManager manager = scene.getSceneManager();
        this.myDecorator = manager.getSceneDecoratorFactory().get(component);
        this.myHitProvider = hitProvider;
        this.setSelected(this.myScene.getDesignSurface().getSelectionModel().isSelected(component));
    }

    public String toString() {
        return this.getNlComponent().toString() + " [ " + this.myCurrentLeft + ", " + this.myCurrentTop + " - " + this.myCurrentRight + ", " + this.myCurrentBottom + "]";
    }

    @Nullable
    public SceneComponent getParent() {
        return this.myParent;
    }

    private void setParent(@NotNull SceneComponent parent) {
        this.myParent = parent;
    }

    public int getDepth() {
        int depth = 0;
        SceneComponent current = this.myParent;
        while (current != null) {
            current = current.myParent;
            ++depth;
        }
        return depth;
    }

    private TargetProvider getTargetProvider() {
        return this.myTargetProvider;
    }

    public boolean useRtlAttributes() {
        return this.myScene.supportsRTL();
    }

    public int findTarget(Class aClass) {
        ImmutableList<Target> targets = this.getTargets();
        int count = targets.size();
        for (int i = 0; i < count; ++i) {
            if (!aClass.isInstance(targets.get(i))) continue;
            return i;
        }
        return -1;
    }

    boolean hasAncestor(SceneComponent candidate) {
        for (SceneComponent parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (parent != candidate) continue;
            return true;
        }
        return false;
    }

    public boolean isSelected() {
        return this.myIsSelected;
    }

    public boolean isHighlighted() {
        return this.myIsHighlighted;
    }

    public boolean canShowBaseline() {
        return this.myShowBaseline;
    }

    public void setShowBaseline(boolean value2) {
        this.myShowBaseline = value2;
    }

    public boolean hasNoDimension() {
        return this.myAnimatedDrawWidth.value == 0 && this.myAnimatedDrawHeight.value == 0 && this.myAnimatedDrawX.value == this.myAnimatedDrawX.target && this.myAnimatedDrawY.value == this.myAnimatedDrawY.target;
    }

    public int getDrawX() {
        return this.myAnimatedDrawX.getValue(0L);
    }

    public int getDrawY() {
        return this.myAnimatedDrawY.getValue(0L);
    }

    public int getDrawWidth() {
        return this.myAnimatedDrawWidth.getValue(0L);
    }

    public int getDrawHeight() {
        return this.myAnimatedDrawHeight.getValue(0L);
    }

    public int getDrawX(long time) {
        return this.myAnimatedDrawX.getValue(time);
    }

    public int getDrawY(long time) {
        return this.myAnimatedDrawY.getValue(time);
    }

    public int getDrawWidth(long time) {
        return this.myAnimatedDrawWidth.getValue(time);
    }

    public int getDrawHeight(long time) {
        return this.myAnimatedDrawHeight.getValue(time);
    }

    public void setPosition(int dx, int dy) {
        this.myAnimatedDrawX.setValue(dx);
        this.myAnimatedDrawY.setValue(dy);
        if (NlComponentHelperKt.getHasNlComponentInfo(this.myNlComponent)) {
            NlComponentHelperKt.setX(this.myNlComponent, Coordinates.dpToPx(this.myScene.getSceneManager(), (float)dx));
            NlComponentHelperKt.setY(this.myNlComponent, Coordinates.dpToPx(this.myScene.getSceneManager(), (float)dy));
        }
        this.myScene.needsRebuildList();
    }

    public void setPositionTarget(int dx, int dy, long time) {
        this.myAnimatedDrawX.setTarget(dx, time);
        this.myAnimatedDrawY.setTarget(dy, time);
        if (NlComponentHelperKt.getHasNlComponentInfo(this.myNlComponent)) {
            NlComponentHelperKt.setX(this.myNlComponent, Coordinates.dpToPx(this.myScene.getSceneManager(), (float)dx));
            NlComponentHelperKt.setY(this.myNlComponent, Coordinates.dpToPx(this.myScene.getSceneManager(), (float)dy));
        } else {
            this.myScene.needsRebuildList();
        }
    }

    public void setSize(int width2, int height2) {
        this.myAnimatedDrawWidth.setValue(width2);
        this.myAnimatedDrawHeight.setValue(height2);
        if (NlComponentHelperKt.getHasNlComponentInfo(this.myNlComponent)) {
            NlComponentHelperKt.setW(this.myNlComponent, Coordinates.dpToPx(this.myScene.getSceneManager(), (float)width2));
            NlComponentHelperKt.setH(this.myNlComponent, Coordinates.dpToPx(this.myScene.getSceneManager(), (float)height2));
        }
        this.myScene.needsRebuildList();
    }

    public void setSizeTarget(int width2, int height2, long time) {
        this.myAnimatedDrawWidth.setTarget(width2, time);
        this.myAnimatedDrawHeight.setTarget(height2, time);
        if (NlComponentHelperKt.getHasNlComponentInfo(this.myNlComponent)) {
            NlComponentHelperKt.setW(this.myNlComponent, Coordinates.dpToPx(this.myScene.getSceneManager(), (float)width2));
            NlComponentHelperKt.setH(this.myNlComponent, Coordinates.dpToPx(this.myScene.getSceneManager(), (float)height2));
        }
    }

    @NotNull
    public NlComponent getAuthoritativeNlComponent() {
        ComponentProvider provider2 = this.myComponentProvider;
        if (provider2 != null) {
            return provider2.getComponent(this);
        }
        return this.myNlComponent;
    }

    @NotNull
    public NlComponent getNlComponent() {
        return this.myNlComponent;
    }

    @NotNull
    public Scene getScene() {
        return this.myScene;
    }

    public List<SceneComponent> getChildren() {
        return this.myChildren;
    }

    public int getChildCount() {
        return this.myChildren.size();
    }

    public SceneComponent getChild(int i) {
        return this.myChildren.get(i);
    }

    public void setToolLocked(boolean locked) {
        this.myIsToolLocked = locked;
    }

    public boolean isToolLocked() {
        return this.myIsToolLocked;
    }

    public void setDrawState(@NotNull DrawState drawState) {
        DrawState oldState = this.myDrawState;
        this.myDrawState = drawState;
        if (this.myIsSelected) {
            this.myDrawState = DrawState.SELECTED;
        }
        if (oldState != this.myDrawState) {
            DecoratorUtilities.setTimeChange(this.myNlComponent, "view", DecoratorUtilities.mapState(drawState));
        }
    }

    public int getBaseline() {
        return Coordinates.pxToDp(this.getScene().getSceneManager(), NlComponentHelperKt.getBaseline(this.myNlComponent));
    }

    public void setHighlighted(boolean highlighted) {
        this.myIsHighlighted = highlighted;
        this.setDrawState(DrawState.NORMAL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelected(boolean selected) {
        if (!selected || !this.myIsSelected) {
            this.myShowBaseline = false;
        }
        this.myIsSelected = selected;
        if (this.myIsSelected) {
            this.setDrawState(DrawState.SELECTED);
        } else {
            this.setDrawState(DrawState.NORMAL);
        }
        ArrayList<Target> arrayList = this.myTargets;
        synchronized (arrayList) {
            this.myTargets.forEach(it -> it.componentSelectionChanged(selected));
        }
    }

    public void setDragging(boolean dragging) {
        if (!this.getNlComponent().isRoot()) {
            this.myDragging = dragging;
        }
    }

    public boolean isDragging() {
        return this.myDragging;
    }

    public DrawState getDrawState() {
        return this.myDrawState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<Target> getTargets() {
        ArrayList<Target> arrayList = this.myTargets;
        synchronized (arrayList) {
            if (this.myCachedTargetList == null) {
                this.myCachedTargetList = ImmutableList.copyOf(this.myTargets);
            }
            return this.myCachedTargetList;
        }
    }

    public SceneDecorator getDecorator() {
        return this.myDecorator;
    }

    @Nullable
    public Notch.Provider getNotchProvider() {
        return this.myNotchProvider;
    }

    public void setNotchProvider(@Nullable Notch.Provider notchProvider) {
        this.myNotchProvider = notchProvider;
    }

    @VisibleForTesting
    ResizeBaseTarget getResizeTarget(ResizeBaseTarget.Type type) {
        ImmutableList<Target> targets = this.getTargets();
        int count = targets.size();
        for (int i = 0; i < count; ++i) {
            ResizeBaseTarget target;
            if (!(targets.get(i) instanceof ResizeBaseTarget) || (target = (ResizeBaseTarget)targets.get(i)).getType() != type) continue;
            return target;
        }
        return null;
    }

    @Nullable
    public SceneComponent getSceneComponent(@NotNull String componentId) {
        if (componentId.equalsIgnoreCase(this.myNlComponent.getId())) {
            return this;
        }
        for (SceneComponent child : this.myChildren) {
            SceneComponent found = child.getSceneComponent(componentId);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    @Nullable
    public SceneComponent getSceneComponent(@NotNull NlComponent nlComponent) {
        if (nlComponent == this.myNlComponent) {
            return this;
        }
        for (SceneComponent child : this.getChildren()) {
            SceneComponent found = child.getSceneComponent(nlComponent);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public boolean intersects(@NotNull SceneContext sceneTransform, Rectangle rectangle) {
        return this.myHitProvider.intersects(this, sceneTransform, rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addTarget(@NotNull Target target) {
        target.setComponent(this);
        ArrayList<Target> arrayList = this.myTargets;
        synchronized (arrayList) {
            this.myCachedTargetList = null;
            this.myTargets.add(target);
        }
    }

    public void addChild(@NotNull SceneComponent child) {
        child.removeFromParent();
        child.setParent(this);
        this.myChildren.add(child);
    }

    public void removeFromParent() {
        SceneComponent parent = this.myParent;
        if (parent != null) {
            parent.remove(this);
        }
    }

    private void remove(@NotNull SceneComponent component) {
        if (this.myChildren.remove(component)) {
            component.myParent = null;
        }
    }

    public boolean layout(@NotNull SceneContext sceneTransform, long time) {
        boolean needsRebuildDisplayList = false;
        int left = this.myAnimatedDrawX.getValue(time);
        int top = this.myAnimatedDrawY.getValue(time);
        int right2 = left + this.myAnimatedDrawWidth.getValue(time);
        int bottom2 = top + this.myAnimatedDrawHeight.getValue(time);
        needsRebuildDisplayList |= this.myCurrentLeft != left;
        needsRebuildDisplayList |= this.myCurrentTop != top;
        needsRebuildDisplayList |= this.myCurrentRight != right2;
        needsRebuildDisplayList |= this.myCurrentBottom != bottom2;
        this.myCurrentLeft = left;
        this.myCurrentTop = top;
        this.myCurrentRight = right2;
        this.myCurrentBottom = bottom2;
        needsRebuildDisplayList |= this.isAnimating();
        ImmutableList<Target> targets = this.getTargets();
        int num = targets.size();
        for (int i = 0; i < num; ++i) {
            Target target = (Target)targets.get(i);
            needsRebuildDisplayList |= target.layout(sceneTransform, this.myCurrentLeft, this.myCurrentTop, this.myCurrentRight, this.myCurrentBottom);
        }
        for (SceneComponent child : this.myChildren) {
            needsRebuildDisplayList |= child.layout(sceneTransform, time);
        }
        return needsRebuildDisplayList;
    }

    @VisibleForTesting
    public boolean isAnimating() {
        return this.myAnimatedDrawX.isAnimating() || this.myAnimatedDrawY.isAnimating() || this.myAnimatedDrawWidth.isAnimating() || this.myAnimatedDrawHeight.isAnimating();
    }

    public Rectangle fillRect(@Nullable Rectangle rectangle) {
        if (rectangle == null) {
            rectangle = new Rectangle();
        }
        rectangle.x = this.myCurrentLeft;
        rectangle.y = this.myCurrentTop;
        rectangle.width = this.myCurrentRight - this.myCurrentLeft;
        rectangle.height = this.myCurrentBottom - this.myCurrentTop;
        return rectangle;
    }

    public void addHit(@NotNull SceneContext sceneTransform, @NotNull ScenePicker picker, @JdkConstants.InputEventMask int modifiersEx) {
        if (this.myIsToolLocked) {
            return;
        }
        this.myHitProvider.addHit(this, sceneTransform, picker);
        ImmutableList<Target> targets = this.getTargets();
        int num = targets.size();
        for (int i = 0; i < num; ++i) {
            Target target = (Target)targets.get(i);
            target.addHit(sceneTransform, picker, modifiersEx);
        }
        for (SceneComponent child : this.myChildren) {
            if (child instanceof TemporarySceneComponent) continue;
            child.addHit(sceneTransform, picker, modifiersEx);
        }
    }

    public void buildDisplayList(long time, @NotNull DisplayList list, SceneContext sceneContext) {
        this.myDecorator.buildList(list, time, sceneContext, this);
    }

    @NotNull
    public Rectangle fillDrawRect(long time, @Nullable Rectangle rec) {
        if (rec == null) {
            rec = new Rectangle();
        }
        rec.x = this.getDrawX(time);
        rec.y = this.getDrawY(time);
        rec.width = this.getDrawWidth(time);
        rec.height = this.getDrawHeight(time);
        return rec;
    }

    @NotNull
    public Rectangle2D.Float fillDrawRect2D(long time, @Nullable Rectangle2D.Float rec) {
        if (rec == null) {
            rec = new Rectangle2D.Float();
        }
        rec.x = this.getDrawX(time);
        rec.y = this.getDrawY(time);
        rec.width = this.getDrawWidth(time);
        rec.height = this.getDrawHeight(time);
        return rec;
    }

    @Nullable
    public String getId() {
        return this.myNlComponent.getId();
    }

    public boolean containsX(int xDp) {
        return this.getDrawX() <= xDp && xDp <= this.getDrawX() + this.getDrawWidth();
    }

    public boolean containsY(int yDp) {
        return this.getDrawY() <= yDp && yDp <= this.getDrawY() + this.getDrawHeight();
    }

    public void setTargetProvider(@Nullable TargetProvider targetProvider) {
        if (this.myTargetProvider == targetProvider) {
            return;
        }
        this.myTargetProvider = targetProvider;
    }

    public void setComponentProvider(@NotNull ComponentProvider provider2) {
        this.myComponentProvider = provider2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTargets() {
        TargetProvider provider2;
        ArrayList<Target> arrayList = this.myTargets;
        synchronized (arrayList) {
            this.myCachedTargetList = null;
            this.myTargets.clear();
        }
        SceneComponent parent = this.myParent;
        if (parent != null && (provider2 = parent.getTargetProvider()) != null) {
            provider2.createChildTargets(parent, this).forEach(this::addTarget);
        }
        if ((provider2 = this.myTargetProvider) != null) {
            provider2.createTargets(this).forEach(this::addTarget);
        }
        for (SceneComponent child : this.getChildren()) {
            child.updateTargets();
        }
        if (((Boolean)StudioFlags.NELE_DRAG_PLACEHOLDER.get()).booleanValue()) {
            boolean hasDragTarget;
            ArrayList<Target> arrayList2 = this.myTargets;
            synchronized (arrayList2) {
                hasDragTarget = this.myTargets.removeIf(CommonDragTarget::isSupported);
            }
            if (hasDragTarget && this.myScene.getRoot() != this) {
                if (this.myDragTarget == null) {
                    this.myDragTarget = new CommonDragTarget(this);
                }
                this.addTarget(this.myDragTarget);
            }
        }
    }

    static class AnimatedValue {
        int value;
        int target;
        long startTime;
        int duration = 350;

        AnimatedValue() {
        }

        public void setValue(int v) {
            this.value = v;
            this.target = v;
            this.startTime = 0L;
        }

        public void setTarget(int v, long time) {
            if (this.target == v) {
                return;
            }
            this.startTime = time;
            this.target = v;
        }

        public int getValue(long time) {
            if (this.startTime == 0L) {
                this.target = this.value;
                return this.value;
            }
            float progress = (float)(time - this.startTime) / (float)this.duration;
            if (progress >= 1.0f) {
                this.value = this.target;
                return this.value;
            }
            if (progress <= 0.0f) {
                return this.value;
            }
            return (int)(0.5 + this.EaseInOutInterpolator(progress, this.value, this.target));
        }

        public boolean isAnimating() {
            return this.value != this.target;
        }

        double EaseInOutInterpolator(double progress, double begin, double end) {
            double change = (end - begin) / 2.0;
            if ((progress *= 2.0) < 1.0) {
                return change * progress * progress + begin;
            }
            return -change * ((progress -= 1.0) * (progress - 2.0) - 1.0) + begin;
        }
    }

    public static enum DrawState {
        SUBDUED,
        NORMAL,
        HOVER,
        SELECTED,
        DRAG;

    }
}

