/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.scene;

import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.scene.TemporarySceneComponent;
import com.google.common.collect.ImmutableList;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DefaultSceneManagerHierarchyProvider
implements SceneManager.SceneComponentHierarchyProvider {
    @Override
    @NotNull
    public List<SceneComponent> createHierarchy(@NotNull SceneManager manager, @NotNull NlComponent component) {
        SceneComponent sceneComponent = manager.getScene().getSceneComponent(component);
        if (sceneComponent == null) {
            sceneComponent = new SceneComponent(manager.getScene(), component, manager.getHitProvider(component));
        }
        sceneComponent.setToolLocked(SceneManager.isComponentLocked(component));
        HashSet<SceneComponent> oldChildren = new HashSet<SceneComponent>(sceneComponent.getChildren());
        for (NlComponent nlChild : component.getChildren()) {
            List<SceneComponent> children = this.createHierarchy(manager, nlChild);
            oldChildren.removeAll(children);
            for (SceneComponent child : children) {
                child.removeFromParent();
                sceneComponent.addChild(child);
            }
        }
        for (SceneComponent child : oldChildren) {
            if (child instanceof TemporarySceneComponent && child.getParent() == sceneComponent || child.getParent() != sceneComponent) continue;
            child.removeFromParent();
        }
        return ImmutableList.of((Object)sceneComponent);
    }

    @Override
    public void syncFromNlComponent(@NotNull SceneComponent sceneComponent) {
        sceneComponent.setToolLocked(false);
    }
}

