/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.util.DependencyManagementUtil;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00042\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0007J\u001c\u0010\r\u001a\u00020\u00042\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\b\u001a\u00020\tJ\u001c\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u00062\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u0018\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\u0016\u001a\u00020\u00042\u0006\u0010\u0017\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/idea/common/model/NlDependencyManager;", "", "()V", "addDependencies", "", "components", "", "Lcom/android/tools/idea/common/model/NlComponent;", "facet", "Lorg/jetbrains/android/facet/AndroidFacet;", "promptUserBeforeAdding", "dependenciesPresentCallback", "Ljava/lang/Runnable;", "checkIfUserWantsToAddDependencies", "toAdd", "", "collectDependencies", "Lcom/android/ide/common/repository/GradleCoordinate;", "getModuleDependencyVersion", "Lcom/android/ide/common/repository/GradleVersion;", "artifactId", "Lcom/android/tools/idea/projectsystem/GoogleMavenArtifactId;", "isModuleDependency", "artifact", "Companion", "intellij.android.designer"})
public final class NlDependencyManager {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private NlDependencyManager() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmOverloads
    public final boolean addDependencies(@NotNull Iterable<? extends NlComponent> components, @NotNull AndroidFacet facet, boolean promptUserBeforeAdding, @Nullable Runnable dependenciesPresentCallback) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Module module = facet.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"facet.module");
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem((Module)module);
        Iterable<GradleCoordinate> $this$filter$iv = this.collectDependencies(components);
        boolean $i$f$filter = false;
        Iterable<GradleCoordinate> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GradleCoordinate it = (GradleCoordinate)element$iv$iv;
            boolean bl = false;
            if (!(moduleSystem.getRegisteredDependency(it) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List missingDependencies = (List)destination$iv$iv;
        if (missingDependencies.isEmpty()) {
            Runnable runnable2 = dependenciesPresentCallback;
            if (runnable2 != null) {
                runnable2.run();
            }
            return true;
        }
        Module module2 = facet.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module2, (String)"facet.module");
        if (!((Collection)DependencyManagementUtil.addDependenciesWithUiConfirmation((Module)module2, (List)missingDependencies, (boolean)promptUserBeforeAdding, (boolean)false)).isEmpty()) {
            return false;
        }
        Project project = facet.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"facet.module.project");
        ListenableFuture syncResult = ProjectSystemUtil.getSyncManager((Project)project).syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_MODIFIED);
        if (dependenciesPresentCallback != null) {
            Executor executor = MoreExecutors.directExecutor();
            Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"directExecutor()");
            FutureUtils.addCallback((ListenableFuture)syncResult, (Executor)executor, (Function1)((Function1)new Function1<ProjectSystemSyncManager.SyncResult, Unit>(dependenciesPresentCallback){
                final /* synthetic */ Runnable $dependenciesPresentCallback;
                {
                    this.$dependenciesPresentCallback = $dependenciesPresentCallback;
                    super(1);
                }

                public final void invoke(@Nullable ProjectSystemSyncManager.SyncResult it) {
                    this.$dependenciesPresentCallback.run();
                }
            }), (Function1)((Function1)new Function1<Throwable, Unit>(dependenciesPresentCallback){
                final /* synthetic */ Runnable $dependenciesPresentCallback;
                {
                    this.$dependenciesPresentCallback = $dependenciesPresentCallback;
                    super(1);
                }

                public final void invoke(@Nullable Throwable it) {
                    this.$dependenciesPresentCallback.run();
                }
            }));
        }
        return true;
    }

    public static /* synthetic */ boolean addDependencies$default(NlDependencyManager nlDependencyManager, Iterable iterable, AndroidFacet androidFacet, boolean bl, Runnable runnable2, int n, Object object) {
        if ((n & 8) != 0) {
            runnable2 = null;
        }
        return nlDependencyManager.addDependencies(iterable, androidFacet, bl, runnable2);
    }

    public final boolean isModuleDependency(@NotNull GoogleMavenArtifactId artifact, @NotNull AndroidFacet facet) {
        Intrinsics.checkNotNullParameter((Object)artifact, (String)"artifact");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Module module = facet.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"facet.module");
        return DependencyManagementUtil.dependsOn((Module)module, (GoogleMavenArtifactId)artifact);
    }

    @Nullable
    public final GradleVersion getModuleDependencyVersion(@NotNull GoogleMavenArtifactId artifactId, @NotNull AndroidFacet facet) {
        Intrinsics.checkNotNullParameter((Object)artifactId, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Module module = facet.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"facet.module");
        GradleCoordinate gradleCoordinate = ProjectSystemUtil.getModuleSystem((Module)module).getResolvedDependency(artifactId.getCoordinate("+"));
        return gradleCoordinate != null ? gradleCoordinate.getVersion() : null;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean checkIfUserWantsToAddDependencies(@NotNull List<? extends NlComponent> toAdd, @NotNull AndroidFacet facet) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(toAdd, (String)"toAdd");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        Iterable<GradleCoordinate> dependencies = this.collectDependencies((Iterable<? extends NlComponent>)toAdd);
        Module module = facet.getModule();
        Intrinsics.checkNotNullExpressionValue((Object)module, (String)"facet.module");
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem((Module)module);
        Iterable<GradleCoordinate> $this$filter$iv = dependencies;
        boolean $i$f$filter = false;
        Iterable<GradleCoordinate> iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            GradleCoordinate it = (GradleCoordinate)element$iv$iv;
            boolean bl = false;
            if (!(moduleSystem.getRegisteredDependency(it) == null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List missing = (List)destination$iv$iv;
        if (CollectionsKt.none((Iterable)missing)) {
            return true;
        }
        ApplicationEx application = ApplicationManagerEx.getApplicationEx();
        if (application.isWriteActionInProgress()) {
            if (_Assertions.ENABLED) {
                boolean bl = false;
                String string = "User cannot be asked to accept dependencies in a write action.Calls to this method should be made outside a write action";
                throw new AssertionError((Object)string);
            }
            return true;
        }
        Project project = facet.getModule().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"facet.module.project");
        return DependencyManagementUtil.userWantsToAdd$default((Project)project, (List)missing, null, (int)4, null);
    }

    /*
     * WARNING - void declaration
     */
    private final Iterable<GradleCoordinate> collectDependencies(Iterable<? extends NlComponent> components) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$flatMapTo$iv$iv;
        Iterable<? extends NlComponent> $this$flatMap$iv = components;
        boolean $i$f$flatMap = false;
        Iterable<? extends NlComponent> iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            NlComponent it = (NlComponent)element$iv$iv;
            boolean bl = false;
            Set<String> set = it.getDependencies();
            Intrinsics.checkNotNullExpressionValue(set, (String)"it.dependencies");
            Iterable list$iv$iv = set;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        Iterable $this$mapNotNull$iv = (List)destination$iv$iv;
        boolean $i$f$mapNotNull = false;
        $this$flatMapTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GradleCoordinate it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String artifact = (String)element$iv$iv;
            boolean bl2 = false;
            if (GradleCoordinate.parseCoordinateString((String)(artifact + ":+")) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return CollectionsKt.toList((Iterable)((List)destination$iv$iv));
    }

    @JvmOverloads
    public final boolean addDependencies(@NotNull Iterable<? extends NlComponent> components, @NotNull AndroidFacet facet, boolean promptUserBeforeAdding) {
        Intrinsics.checkNotNullParameter(components, (String)"components");
        Intrinsics.checkNotNullParameter((Object)facet, (String)"facet");
        return NlDependencyManager.addDependencies$default(this, components, facet, promptUserBeforeAdding, null, 8, null);
    }

    @JvmStatic
    @NotNull
    public static final NlDependencyManager getInstance() {
        return Companion.getInstance();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0007\u00a8\u0006\u0005"}, d2={"Lcom/android/tools/idea/common/model/NlDependencyManager$Companion;", "", "()V", "getInstance", "Lcom/android/tools/idea/common/model/NlDependencyManager;", "intellij.android.designer"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final NlDependencyManager getInstance() {
            Object object = ApplicationManager.getApplication().getService(NlDependencyManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getApplication().getServ\u2026dencyManager::class.java)");
            return (NlDependencyManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

