/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.model;

import com.android.resources.Density;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.Scene;
import com.android.tools.idea.common.scene.SceneComponent;
import com.android.tools.idea.common.scene.SceneContext;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.flags.StudioFlags;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Coordinates {
    public static final float DEFAULT_DENSITY = Density.DEFAULT_DENSITY;

    public static int getSwingX(@NotNull SceneView view2, int androidX) {
        if (((Boolean)StudioFlags.NELE_DP_SIZED_PREVIEW.get()).booleanValue()) {
            return view2.getX() + view2.getContentTranslationX() + (int)Math.round(view2.getScale() * (double)Coordinates.pxToDp(view2, androidX));
        }
        return view2.getX() + view2.getContentTranslationX() + (int)Math.round(view2.getScale() * (double)androidX);
    }

    public static float getSwingX(@NotNull SceneView view2, float androidX) {
        if (((Boolean)StudioFlags.NELE_DP_SIZED_PREVIEW.get()).booleanValue()) {
            return (float)(view2.getX() + view2.getContentTranslationX()) + (float)view2.getScale() * Coordinates.pxToDp(view2, androidX);
        }
        return (float)(view2.getX() + view2.getContentTranslationX()) + (float)view2.getScale() * androidX;
    }

    public static int getSwingY(@NotNull SceneView view2, int androidY) {
        if (((Boolean)StudioFlags.NELE_DP_SIZED_PREVIEW.get()).booleanValue()) {
            return view2.getY() + view2.getContentTranslationY() + (int)Math.round(view2.getScale() * (double)Coordinates.pxToDp(view2, androidY));
        }
        return view2.getY() + view2.getContentTranslationY() + (int)Math.round(view2.getScale() * (double)androidY);
    }

    public static float getSwingY(@NotNull SceneView view2, float androidY) {
        if (((Boolean)StudioFlags.NELE_DP_SIZED_PREVIEW.get()).booleanValue()) {
            return (float)(view2.getY() + view2.getContentTranslationY()) + (float)view2.getScale() * Coordinates.pxToDp(view2, androidY);
        }
        return (float)(view2.getY() + view2.getContentTranslationY()) + (float)view2.getScale() * androidY;
    }

    public static int getSwingDimension(@NotNull SceneView view2, int androidDimension) {
        if (((Boolean)StudioFlags.NELE_DP_SIZED_PREVIEW.get()).booleanValue()) {
            return (int)Math.round(view2.getScale() * (double)Coordinates.pxToDp(view2, androidDimension));
        }
        return (int)Math.round(view2.getScale() * (double)androidDimension);
    }

    public static float getSwingDimension(@NotNull SceneView view2, float androidDimension) {
        if (((Boolean)StudioFlags.NELE_DP_SIZED_PREVIEW.get()).booleanValue()) {
            return (float)view2.getScale() * Coordinates.pxToDp(view2, androidDimension);
        }
        return (float)view2.getScale() * androidDimension;
    }

    public static int dpToPx(@NotNull SceneView view2, int androidDp) {
        return Coordinates.dpToPx(view2.getSceneManager(), (float)androidDp);
    }

    @Deprecated
    public static int pxToDp(@NotNull NlModel model2, int androidPx) {
        Configuration configuration = model2.getConfiguration();
        int dpiValue = configuration.getDensity().getDpiValue();
        return Math.round((float)androidPx * (DEFAULT_DENSITY / (float)dpiValue));
    }

    public static int dpToPx(@NotNull SceneView view2, float androidDp) {
        return Coordinates.dpToPx(view2.getSceneManager(), androidDp);
    }

    public static int pxToDp(@NotNull SceneView view2, int androidPx) {
        return Coordinates.pxToDp(view2.getSceneManager(), androidPx);
    }

    public static float pxToDp(@NotNull SceneView view2, float androidPx) {
        return Coordinates.pxToDp(view2.getSceneManager(), androidPx);
    }

    public static int dpToPx(@NotNull SceneManager manager, float androidDp) {
        return Math.round(androidDp * manager.getSceneScalingFactor());
    }

    public static int pxToDp(@NotNull SceneManager manager, int androidPx) {
        return Math.round((float)androidPx / manager.getSceneScalingFactor());
    }

    public static float pxToDp(@NotNull SceneManager manager, float androidPx) {
        return androidPx / manager.getSceneScalingFactor();
    }

    public static int getSwingXDip(@NotNull SceneView view2, int androidDpX) {
        return Coordinates.getSwingX(view2, Coordinates.dpToPx(view2.getSceneManager(), (float)androidDpX));
    }

    public static float getSwingXDip(@NotNull SceneView view2, float androidDpX) {
        return Coordinates.getSwingX(view2, view2.getSceneScalingFactor() * androidDpX);
    }

    public static int getSwingYDip(@NotNull SceneView view2, int androidDpY) {
        return Coordinates.getSwingY(view2, Coordinates.dpToPx(view2.getSceneManager(), (float)androidDpY));
    }

    public static float getSwingYDip(@NotNull SceneView view2, float androidDpX) {
        return Coordinates.getSwingY(view2, view2.getSceneScalingFactor() * androidDpX);
    }

    public static int getSwingDimensionDip(@NotNull SceneView view2, int androidDpDimension) {
        return Coordinates.getSwingDimension(view2, Coordinates.dpToPx(view2.getSceneManager(), (float)androidDpDimension));
    }

    public static float getSwingDimensionDip(@NotNull SceneView view2, float androidDpDimension) {
        return Coordinates.getSwingDimension(view2, view2.getSceneScalingFactor() * androidDpDimension);
    }

    public static Rectangle getSwingRectDip(@NotNull SceneView view2, @NotNull Rectangle rect) {
        return new Rectangle(Coordinates.getSwingXDip(view2, rect.x), Coordinates.getSwingYDip(view2, rect.y), Coordinates.getSwingDimensionDip(view2, rect.width), Coordinates.getSwingDimensionDip(view2, rect.height));
    }

    public static Rectangle2D.Float getSwingRectDip(@NotNull SceneView view2, @NotNull Rectangle2D.Float rect) {
        return new Rectangle2D.Float(Coordinates.getSwingXDip(view2, rect.x), Coordinates.getSwingYDip(view2, rect.y), Coordinates.getSwingDimensionDip(view2, rect.width), Coordinates.getSwingDimensionDip(view2, rect.height));
    }

    public static Rectangle2D.Float getSwingRectDip(@NotNull SceneContext context, @NotNull Rectangle2D.Float rect) {
        return new Rectangle2D.Float(context.getSwingXDip(rect.x), context.getSwingYDip(rect.y), context.getSwingDimensionDip(rect.width), context.getSwingDimensionDip(rect.height));
    }

    public static Rectangle2D.Float getSwingRectDip(@NotNull SceneContext context, @NotNull Rectangle rect) {
        return new Rectangle2D.Float(context.getSwingXDip(rect.x), context.getSwingYDip(rect.y), context.getSwingDimensionDip(rect.width), context.getSwingDimensionDip(rect.height));
    }

    public static int getAndroidX(@NotNull SceneView view2, int swingX) {
        if (((Boolean)StudioFlags.NELE_DP_SIZED_PREVIEW.get()).booleanValue()) {
            int dpX = (int)Math.round((double)(swingX - view2.getX() - view2.getContentTranslationX()) / view2.getScale());
            return Coordinates.dpToPx(view2, dpX);
        }
        return (int)Math.round((double)(swingX - view2.getX() - view2.getContentTranslationX()) / view2.getScale());
    }

    public static int getAndroidXDip(@NotNull SceneView view2, int swingX) {
        return Coordinates.pxToDp(view2, Coordinates.getAndroidX(view2, swingX));
    }

    public static int getAndroidY(@NotNull SceneView view2, int swingY) {
        if (((Boolean)StudioFlags.NELE_DP_SIZED_PREVIEW.get()).booleanValue()) {
            int dpY = (int)Math.round((double)(swingY - view2.getY() - view2.getContentTranslationY()) / view2.getScale());
            return Coordinates.dpToPx(view2, dpY);
        }
        return (int)Math.round((double)(swingY - view2.getY() - view2.getContentTranslationY()) / view2.getScale());
    }

    public static int getAndroidYDip(@NotNull SceneView view2, int swingY) {
        return Coordinates.pxToDp(view2, Coordinates.getAndroidY(view2, swingY));
    }

    @NotNull
    public static Point getAndroidCoordinate(@NotNull SceneView view2, @NotNull Point coord) {
        return new Point(Coordinates.getAndroidX(view2, coord.x), Coordinates.getAndroidY(view2, coord.y));
    }

    public static int getAndroidDimension(@NotNull SceneView view2, int swingDimension) {
        if (((Boolean)StudioFlags.NELE_DP_SIZED_PREVIEW.get()).booleanValue()) {
            int dpDim = (int)Math.round((double)swingDimension / view2.getScale());
            return Coordinates.dpToPx(view2, dpDim);
        }
        return (int)Math.round((double)swingDimension / view2.getScale());
    }

    public static int getAndroidDimension(@NotNull DesignSurface<?> surface2, int swingDimension) {
        if (((Boolean)StudioFlags.NELE_DP_SIZED_PREVIEW.get()).booleanValue()) {
            int dpDim = (int)Math.round((double)swingDimension / surface2.getScale());
            return Coordinates.dpToPx(surface2.getSceneManager(), (float)dpDim);
        }
        return (int)Math.round((double)swingDimension / surface2.getScale());
    }

    public static int getAndroidDimensionDip(@NotNull SceneView view2, int swingDimension) {
        return Coordinates.pxToDp(view2, Coordinates.getAndroidDimension(view2, swingDimension));
    }

    public static int getAndroidDimensionDip(@NotNull Scene scene, int swingDimension) {
        return Coordinates.pxToDp(scene.getSceneManager(), Coordinates.getAndroidDimension(scene.getDesignSurface(), swingDimension));
    }

    @Deprecated
    @Nullable
    public static NlComponent findComponent(@NotNull SceneView view2, int swingX, int swingY) {
        SceneContext sceneContext = SceneContext.get(view2);
        int x = Coordinates.getAndroidXDip(view2, swingX);
        int y = Coordinates.getAndroidYDip(view2, swingY);
        SceneComponent sceneComponent = view2.getScene().findComponent(sceneContext, x, y);
        return sceneComponent != null ? sceneComponent.getNlComponent() : null;
    }

    public static void transformGraphics(@NotNull SceneView view2, @NotNull Graphics2D gc) {
        gc.translate(view2.getX(), view2.getY());
        gc.scale(view2.getScale(), view2.getScale());
    }
}

