/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.editor.DesignToolsSplitEditor;
import com.android.tools.idea.common.editor.SplitEditor;
import com.android.tools.idea.common.error.IssuePanelService;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.editor.multirepresentation.MultiRepresentationPreview;
import com.android.tools.idea.uibuilder.editor.multirepresentation.sourcecode.SourceCodePreview;
import com.intellij.analysis.problemsView.toolWindow.ProblemsViewTab;
import com.intellij.ide.DataManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.openapi.util.text.HtmlChunk;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.content.Content;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u001f\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u00a2\u0006\u0002\u0010\u0006\u001a\u0010\u0010\u0007\u001a\b\u0012\u0002\b\u0003\u0018\u00010\b*\u00020\t\u001a\u0014\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007\u001a*\u0010\u000f\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u001a*\u0010\u0015\u001a\u00020\u0010*\u0006\u0012\u0002\b\u00030\b2\u0006\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000b2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0014\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"DEFAULT_SHARED_ISSUE_PANEL_TAB_NAME", "", "createTabName", "title", "issueCount", "", "(Ljava/lang/String;Ljava/lang/Integer;)Ljava/lang/String;", "getDesignSurface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "isTab", "", "Lcom/intellij/ui/content/Content;", "tab", "Lcom/android/tools/idea/common/error/IssuePanelService$Tab;", "setIssuePanelVisibility", "", "show", "userInvoked", "runnable", "Ljava/lang/Runnable;", "setIssuePanelVisibilityNoTracking", "onAfterSettingVisibility", "intellij.android.designer"})
public final class IssuePanelServiceKt {
    @NotNull
    private static final String DEFAULT_SHARED_ISSUE_PANEL_TAB_NAME = "Designer";

    @VisibleForTesting
    public static final boolean isTab(@NotNull Content $this$isTab, @NotNull IssuePanelService.Tab tab) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)$this$isTab, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)((Object)tab), (String)"tab");
        switch (WhenMappings.$EnumSwitchMapping$0[tab.ordinal()]) {
            case 1: {
                bl = Intrinsics.areEqual((Object)$this$isTab.getTabName(), (Object)DEFAULT_SHARED_ISSUE_PANEL_TAB_NAME);
                break;
            }
            case 2: {
                JComponent jComponent = $this$isTab.getComponent();
                ProblemsViewTab problemsViewTab = jComponent instanceof ProblemsViewTab ? (ProblemsViewTab)jComponent : null;
                bl = Intrinsics.areEqual((Object)(problemsViewTab != null ? problemsViewTab.getTabId() : null), (Object)"CurrentFile");
                break;
            }
            case 3: {
                JComponent jComponent = $this$isTab.getComponent();
                ProblemsViewTab problemsViewTab = jComponent instanceof ProblemsViewTab ? (ProblemsViewTab)jComponent : null;
                bl = Intrinsics.areEqual((Object)(problemsViewTab != null ? problemsViewTab.getTabId() : null), (Object)"ProjectErrors");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return bl;
    }

    public static final void setIssuePanelVisibilityNoTracking(@NotNull DesignSurface<?> $this$setIssuePanelVisibilityNoTracking, boolean show2, boolean userInvoked, @Nullable Runnable onAfterSettingVisibility) {
        Intrinsics.checkNotNullParameter($this$setIssuePanelVisibilityNoTracking, (String)"<this>");
        Object object = StudioFlags.NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get()");
        if (((Boolean)object).booleanValue()) {
            Project project = $this$setIssuePanelVisibilityNoTracking.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            IssuePanelService.Companion.getInstance(project).setSharedIssuePanelVisibility(show2, onAfterSettingVisibility);
        } else {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable($this$setIssuePanelVisibilityNoTracking, show2, userInvoked, onAfterSettingVisibility){
                final /* synthetic */ DesignSurface<?> $this_setIssuePanelVisibilityNoTracking;
                final /* synthetic */ boolean $show;
                final /* synthetic */ boolean $userInvoked;
                final /* synthetic */ Runnable $onAfterSettingVisibility;
                {
                    this.$this_setIssuePanelVisibilityNoTracking = $receiver;
                    this.$show = $show;
                    this.$userInvoked = $userInvoked;
                    this.$onAfterSettingVisibility = $onAfterSettingVisibility;
                }

                public final void run() {
                    this.$this_setIssuePanelVisibilityNoTracking.getIssuePanel().setMinimized(!this.$show);
                    if (this.$userInvoked) {
                        this.$this_setIssuePanelVisibilityNoTracking.getIssuePanel().disableAutoSize();
                    }
                    Runnable runnable2 = this.$onAfterSettingVisibility;
                    if (runnable2 != null) {
                        runnable2.run();
                    }
                    this.$this_setIssuePanelVisibilityNoTracking.revalidate();
                    this.$this_setIssuePanelVisibilityNoTracking.repaint();
                }
            });
        }
    }

    public static /* synthetic */ void setIssuePanelVisibilityNoTracking$default(DesignSurface designSurface, boolean bl, boolean bl2, Runnable runnable2, int n, Object object) {
        if ((n & 4) != 0) {
            runnable2 = null;
        }
        IssuePanelServiceKt.setIssuePanelVisibilityNoTracking(designSurface, bl, bl2, runnable2);
    }

    public static final void setIssuePanelVisibility(@NotNull DesignSurface<?> $this$setIssuePanelVisibility, boolean show2, boolean userInvoked, @Nullable Runnable runnable2) {
        Intrinsics.checkNotNullParameter($this$setIssuePanelVisibility, (String)"<this>");
        $this$setIssuePanelVisibility.getAnalyticsManager().trackShowIssuePanel();
        IssuePanelServiceKt.setIssuePanelVisibilityNoTracking($this$setIssuePanelVisibility, show2, userInvoked, runnable2);
    }

    public static /* synthetic */ void setIssuePanelVisibility$default(DesignSurface designSurface, boolean bl, boolean bl2, Runnable runnable2, int n, Object object) {
        if ((n & 4) != 0) {
            runnable2 = null;
        }
        IssuePanelServiceKt.setIssuePanelVisibility(designSurface, bl, bl2, runnable2);
    }

    private static final String createTabName(String title, Integer issueCount) {
        if (issueCount == null || issueCount <= 0) {
            return title;
        }
        String string = new HtmlBuilder().append(title).append(" ").append((HtmlChunk)HtmlChunk.tag((String)"font").attr("color", ColorUtil.toHtmlColor((Color)UIUtil.getInactiveTextColor())).addText(String.valueOf(issueCount))).wrapWithHtmlBody().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"HtmlBuilder()\n    .appen\u2026tmlBody()\n    .toString()");
        return string;
    }

    @Nullable
    public static final DesignSurface<?> getDesignSurface(@NotNull FileEditor $this$getDesignSurface) {
        Intrinsics.checkNotNullParameter((Object)$this$getDesignSurface, (String)"<this>");
        FileEditor fileEditor = $this$getDesignSurface;
        if (fileEditor instanceof DesignToolsSplitEditor) {
            return ((DesignToolsSplitEditor)$this$getDesignSurface).getDesignerEditor().getComponent().getSurface();
        }
        if (fileEditor instanceof SplitEditor) {
            Object p = ((SplitEditor)$this$getDesignSurface).getPreview();
            Object object = p instanceof SourceCodePreview ? (SourceCodePreview)p : null;
            if (object == null || (object = ((MultiRepresentationPreview)object).getCurrentRepresentation()) == null || (object = object.getComponent()) == null) {
                return null;
            }
            Object component = object;
            return (DesignSurface)((Object)DataManager.getInstance().getDataContext((Component)component).getData(DesignerDataKeys.DESIGN_SURFACE));
        }
        return null;
    }

    public static final /* synthetic */ String access$createTabName(String title, Integer issueCount) {
        return IssuePanelServiceKt.createTabName(title, issueCount);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[IssuePanelService.Tab.values().length];
            nArray[IssuePanelService.Tab.DESIGN_TOOLS.ordinal()] = 1;
            nArray[IssuePanelService.Tab.CURRENT_FILE.ordinal()] = 2;
            nArray[IssuePanelService.Tab.PROJECT_ERRORS.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

