/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.common.error.DesignToolsIssueProvider;
import com.android.tools.idea.common.error.DesignerCommonIssueModel;
import com.android.tools.idea.common.error.DesignerCommonIssuePanel;
import com.android.tools.idea.common.error.DesignerCommonIssuePanelModelProvider;
import com.android.tools.idea.common.error.DesignerCommonIssuePanelUsageTracker;
import com.android.tools.idea.common.error.DesignerCommonIssueProviderKt;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.error.IssuePanel;
import com.android.tools.idea.common.error.IssuePanelService;
import com.android.tools.idea.common.error.IssuePanelServiceKt;
import com.android.tools.idea.common.error.IssueView;
import com.android.tools.idea.common.error.NotSuppressedFilter;
import com.android.tools.idea.common.error.SelectedEditorFilter;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.type.DesignerEditorFileType;
import com.android.tools.idea.common.type.DesignerEditorFileTypeKt;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.uibuilder.type.DrawableFileType;
import com.android.tools.idea.uibuilder.type.LayoutFileType;
import com.android.tools.idea.uibuilder.type.MenuFileType;
import com.android.tools.idea.uibuilder.type.PreferenceScreenFileType;
import com.google.common.collect.ImmutableList;
import com.google.wireless.android.sdk.stats.UniversalProblemsPanelEvent;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeModelAdapter;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.core.util.PhysicalFileSystemUtilsKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 A2\u00020\u0001:\u0002ABB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\nH\u0002J\u0006\u0010\u0012\u001a\u00020\u0010J\b\u0010\u0013\u001a\u00020\bH\u0002J\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u0015J\b\u0010\u0017\u001a\u0004\u0018\u00010\fJ\b\u0010\u0018\u001a\u00020\bH\u0007J\u000e\u0010\u0019\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\b2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001eH\u0007J\u0010\u0010\u001f\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0010\u0010 \u001a\u00020\n2\u0006\u0010!\u001a\u00020\"H\u0002J\u0012\u0010#\u001a\u00020\n2\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%J\b\u0010&\u001a\u00020\nH\u0007J\u0012\u0010'\u001a\u00020\n2\b\u0010(\u001a\u0004\u0018\u00010\u000eH\u0002J\u0014\u0010)\u001a\u00020\n2\f\u0010$\u001a\b\u0012\u0002\b\u0003\u0018\u00010%J\u0010\u0010*\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\u0018\u0010+\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u00072\b\u0010,\u001a\u0004\u0018\u00010\bJ\b\u0010-\u001a\u00020\nH\u0007J\b\u0010.\u001a\u00020\u0010H\u0002J\u0018\u0010/\u001a\u00020\u00102\u0006\u00100\u001a\u00020\n2\b\u00101\u001a\u0004\u0018\u000102J\u000e\u00103\u001a\u00020\u00102\u0006\u00104\u001a\u000205J\u001a\u00106\u001a\u00020\u00102\u0006\u00100\u001a\u00020\n2\n\b\u0002\u00107\u001a\u0004\u0018\u000108J*\u00109\u001a\u00020\u00102\n\u0010$\u001a\u0006\u0012\u0002\b\u00030%2\u0006\u0010:\u001a\u00020\n2\u0006\u0010;\u001a\u00020<2\u0006\u0010=\u001a\u00020\nJ\u000e\u0010>\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0007J\u0010\u0010?\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u0007H\u0002J\b\u0010@\u001a\u00020\u0010H\u0002R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/android/tools/idea/common/error/IssuePanelService;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "fileToTabName", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "", "inited", "", "sharedIssuePanel", "Lcom/android/tools/idea/common/error/DesignerCommonIssuePanel;", "sharedIssueTab", "Lcom/intellij/ui/content/Content;", "addIssuePanel", "", "addSharedIssueTabToProblemsPanel", "focusIssuePanelIfVisible", "getEmptyMessage", "getSelectedIssues", "", "Lcom/android/tools/idea/common/error/Issue;", "getSelectedSharedIssuePanel", "getSharedIssuePanelTabTitle", "getSharedPanelIssues", "getTabNameOfSupportedDesignerFile", "file", "initIssueTabs", "problemsViewWindow", "Lcom/intellij/openapi/wm/ToolWindow;", "isComposeFile", "isDesignEditor", "editor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "isIssuePanelVisible", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "isSharedIssuePanelAddedToProblemsPane", "isSharedIssueTabShowing", "tab", "isShowingIssuePanel", "isSupportedDesignerFileType", "registerFile", "tabTitle", "removeSharedIssueTabFromProblemsPanel", "selectSharedIssuePanelTab", "setIssuePanelVisibility", "visible", "selectedTab", "Lcom/android/tools/idea/common/error/IssuePanelService$Tab;", "setSelectedNode", "nodeVisitor", "Lcom/intellij/ui/tree/TreeVisitor;", "setSharedIssuePanelVisibility", "onAfterSettingVisibility", "Ljava/lang/Runnable;", "showIssueForComponent", "userInvoked", "component", "Lcom/android/tools/idea/common/model/NlComponent;", "collapseOthers", "unregisterFile", "updateIssuePanelVisibility", "updateSharedIssuePanelTabName", "Companion", "Tab", "intellij.android.designer"})
public final class IssuePanelService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @Nullable
    private Content sharedIssueTab;
    @Nullable
    private DesignerCommonIssuePanel sharedIssuePanel;
    private boolean inited;
    @NotNull
    private final Map<VirtualFile, String> fileToTabName;
    @NotNull
    private static final DataKey<List<Issue>> SELECTED_ISSUES;
    @NotNull
    public static final String DESIGN_TOOL_TAB_NAME = "Designer";

    public IssuePanelService(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.fileToTabName = new LinkedHashMap();
        ToolWindowManager manager = ToolWindowManager.Companion.getInstance(this.project);
        final ToolWindow problemsView = manager.getToolWindow("Problems View");
        if (problemsView != null) {
            UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                @Override
                public final void run() {
                    this.initIssueTabs(problemsView);
                }
            });
        } else {
            MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
            Intrinsics.checkNotNullExpressionValue((Object)messageBusConnection, (String)"project.messageBus.connect()");
            final MessageBusConnection connection = messageBusConnection;
            ToolWindowManagerListener listener2 = null;
            listener2 = new ToolWindowManagerListener(){

                public void toolWindowsRegistered(@NotNull List<String> ids, @NotNull ToolWindowManager toolWindowManager) {
                    ToolWindow problemsViewToolWindow;
                    Intrinsics.checkNotNullParameter(ids, (String)"ids");
                    Intrinsics.checkNotNullParameter((Object)toolWindowManager, (String)"toolWindowManager");
                    if (ids.contains("Problems View") && (problemsViewToolWindow = ProblemsView.getToolWindow((Project)project)) != null) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(this, problemsViewToolWindow){
                            final /* synthetic */ IssuePanelService this$0;
                            final /* synthetic */ ToolWindow $problemsViewToolWindow;
                            {
                                this.this$0 = $receiver;
                                this.$problemsViewToolWindow = $problemsViewToolWindow;
                            }

                            public final void run() {
                                this.this$0.initIssueTabs(this.$problemsViewToolWindow);
                            }
                        });
                        connection.disconnect();
                    }
                }
            };
            Topic topic = ToolWindowManagerListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            connection.subscribe(topic, (Object)listener2);
        }
    }

    @UiThread
    public final void initIssueTabs(@NotNull ToolWindow problemsViewWindow) {
        Intrinsics.checkNotNullParameter((Object)problemsViewWindow, (String)"problemsViewWindow");
        if (problemsViewWindow.isDisposed()) {
            return;
        }
        if (this.inited) {
            return;
        }
        this.inited = true;
        ContentManager contentManager = problemsViewWindow.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"problemsViewWindow.contentManager");
        ContentManager contentManager2 = contentManager;
        ContentFactory contentFactory = contentManager2.getFactory();
        Intrinsics.checkNotNullExpressionValue((Object)contentFactory, (String)"contentManager.factory");
        ContentFactory contentFactory2 = contentFactory;
        Object object = StudioFlags.NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get()");
        if (((Boolean)object).booleanValue()) {
            Content content2;
            DesignToolsIssueProvider issueProvider2 = new DesignToolsIssueProvider(this.project, DesignerCommonIssueProviderKt.plus(NotSuppressedFilter.INSTANCE, new SelectedEditorFilter(this.project)));
            DesignerCommonIssueModel treeModel = DesignerCommonIssuePanelModelProvider.Companion.getInstance(this.project).getModel();
            DesignerCommonIssuePanel issuePanel2 = new DesignerCommonIssuePanel((Disposable)this.project, this.project, treeModel, issueProvider2, (Function0<String>)((Function0)new Function0<String>((Object)this){

                @NotNull
                public final String invoke() {
                    return IssuePanelService.access$getEmptyMessage((IssuePanelService)this.receiver);
                }
            }));
            treeModel.addTreeModelListener((TreeModelListener)new TreeModelAdapter(this){
                final /* synthetic */ IssuePanelService this$0;
                {
                    this.this$0 = $receiver;
                }

                protected void process(@NotNull TreeModelEvent event, @NotNull TreeModelAdapter.EventType type) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    Intrinsics.checkNotNullParameter((Object)type, (String)"type");
                    IssuePanelService.access$updateSharedIssuePanelTabName(this.this$0);
                }
            });
            this.sharedIssuePanel = issuePanel2;
            Content $this$initIssueTabs_u24lambda_u2d0 = content2 = contentFactory2.createContent(issuePanel2.getComponent(), "Design Issue", true);
            boolean bl = false;
            $this$initIssueTabs_u24lambda_u2d0.setTabName(DESIGN_TOOL_TAB_NAME);
            $this$initIssueTabs_u24lambda_u2d0.setPinnable(false);
            this.sharedIssueTab = $this$initIssueTabs_u24lambda_u2d0;
            $this$initIssueTabs_u24lambda_u2d0.setCloseable(false);
            contentManager2.addContent($this$initIssueTabs_u24lambda_u2d0);
        }
        ContentManagerListener contentManagerListener2 = new ContentManagerListener(this){
            final /* synthetic */ IssuePanelService this$0;
            {
                this.this$0 = $receiver;
            }

            public void selectionChanged(@NotNull ContentManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                Content content2 = event.getContent();
                Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"event.content");
                Content content3 = content2;
                UniversalProblemsPanelEvent.ActivatedTab selectedTab = IssuePanelServiceKt.isTab(content3, Tab.CURRENT_FILE) ? UniversalProblemsPanelEvent.ActivatedTab.CURRENT_FILE : (IssuePanelServiceKt.isTab(content3, Tab.PROJECT_ERRORS) ? UniversalProblemsPanelEvent.ActivatedTab.PROJECT_ERRORS : (IssuePanelServiceKt.isTab(content3, Tab.DESIGN_TOOLS) ? UniversalProblemsPanelEvent.ActivatedTab.DESIGN_TOOLS : UniversalProblemsPanelEvent.ActivatedTab.UNKNOWN_TAB));
                DesignerCommonIssuePanelUsageTracker.Companion.getInstance().trackSelectingTab(selectedTab, IssuePanelService.access$getProject$p(this.this$0));
            }
        };
        contentManager2.addContentManagerListener(contentManagerListener2);
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect();
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(this){
            final /* synthetic */ IssuePanelService this$0;
            {
                this.this$0 = $receiver;
            }

            public void fileOpened(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                FileEditor editor = source.getSelectedEditor(file2);
                this.updateIssuePanelVisibility(file2, editor, true);
            }

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                if (!source.hasOpenFiles()) {
                    this.this$0.removeSharedIssueTabFromProblemsPanel();
                }
            }

            public void selectionChanged(@NotNull FileEditorManagerEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                this.updateIssuePanelVisibility(event.getNewFile(), event.getNewEditor(), false);
            }

            private final void updateIssuePanelVisibility(VirtualFile newFile, FileEditor newEditor, boolean selectIfVisible) {
                DesignSurface<?> surface2;
                if (newFile == null) {
                    IssuePanelService.setSharedIssuePanelVisibility$default(this.this$0, false, null, 2, null);
                    return;
                }
                if (IssuePanelService.access$isComposeFile(this.this$0, newFile) || IssuePanelService.access$isSupportedDesignerFileType(this.this$0, newFile)) {
                    IssuePanelService.access$addIssuePanel(this.this$0);
                    return;
                }
                FileEditor fileEditor = newEditor;
                DesignSurface<Object> designSurface = surface2 = fileEditor != null ? IssuePanelServiceKt.getDesignSurface(fileEditor) : null;
                if (surface2 != null) {
                    IssuePanelService.access$updateIssuePanelVisibility(this.this$0, newFile);
                } else {
                    this.this$0.removeSharedIssueTabFromProblemsPanel();
                }
            }
        });
        Object object2 = StudioFlags.NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get()");
        if (((Boolean)object2).booleanValue()) {
            boolean isDesignFile;
            block8: {
                boolean bl;
                FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.project).getSelectedEditors();
                Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getInstance(project).selectedEditors");
                Object[] $this$any$iv = fileEditorArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    FileEditor it = (FileEditor)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!this.isDesignEditor(it)) continue;
                    bl = true;
                    break block8;
                }
                bl = isDesignFile = false;
            }
            if (isDesignFile) {
                if (problemsViewWindow.isVisible()) {
                    IssuePanelService.setSharedIssuePanelVisibility$default(this, true, null, 2, null);
                } else {
                    problemsViewWindow.hide(new Runnable(this){
                        final /* synthetic */ IssuePanelService this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        public final void run() {
                            IssuePanelService.access$updateSharedIssuePanelTabName(this.this$0);
                            IssuePanelService.access$selectSharedIssuePanelTab(this.this$0);
                        }
                    });
                }
            }
        }
    }

    private final void updateIssuePanelVisibility(VirtualFile file2) {
        DesignerEditorFileType psiFileType;
        PsiFile psiFile2 = PhysicalFileSystemUtilsKt.toPsiFile((VirtualFile)file2, (Project)this.project);
        DesignerEditorFileType designerEditorFileType = psiFileType = psiFile2 != null ? DesignerEditorFileTypeKt.typeOf(psiFile2) : null;
        if (psiFileType instanceof DrawableFileType) {
            this.removeSharedIssueTabFromProblemsPanel();
        } else {
            this.addIssuePanel();
        }
    }

    private final void addIssuePanel() {
        this.addSharedIssueTabToProblemsPanel();
        this.updateSharedIssuePanelTabName();
    }

    private final void selectSharedIssuePanelTab() {
        block1: {
            Content content2 = this.sharedIssueTab;
            if (content2 == null) {
                return;
            }
            Content tab = content2;
            ContentManager contentManager = tab.getManager();
            if (contentManager == null) break block1;
            contentManager.setSelectedContent(tab);
        }
    }

    @VisibleForTesting
    public final boolean removeSharedIssueTabFromProblemsPanel() {
        Content content2 = this.sharedIssueTab;
        if (content2 == null) {
            return false;
        }
        Content tab = content2;
        ToolWindow toolWindow = ProblemsView.getToolWindow((Project)this.project);
        if (toolWindow == null) {
            return false;
        }
        ToolWindow toolWindow2 = toolWindow;
        ContentManager contentManager = toolWindow2.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        ContentManager contentManager2 = contentManager;
        contentManager2.removeContent(tab, false);
        return true;
    }

    private final boolean addSharedIssueTabToProblemsPanel() {
        Content content2 = this.sharedIssueTab;
        if (content2 == null) {
            return false;
        }
        Content tab = content2;
        ToolWindow toolWindow = ProblemsView.getToolWindow((Project)this.project);
        if (toolWindow == null) {
            return false;
        }
        ToolWindow toolWindow2 = toolWindow;
        ContentManager contentManager = toolWindow2.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"toolWindow.contentManager");
        ContentManager contentManager2 = contentManager;
        Content[] contentArray = contentManager2.getContents();
        Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"contentManager.contents");
        if (ArraysKt.contains((Object[])contentArray, (Object)tab)) {
            return false;
        }
        contentManager2.addContent(tab, contentManager2.getContentCount());
        return true;
    }

    public final boolean isShowingIssuePanel(@Nullable DesignSurface<?> surface2) {
        Object object = StudioFlags.NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get()");
        if (((Boolean)object).booleanValue()) {
            return this.isSharedIssueTabShowing(this.sharedIssueTab);
        }
        Disposable disposable2 = surface2;
        return disposable2 != null && (disposable2 = disposable2.getIssuePanel()) != null ? !disposable2.isMinimized() : false;
    }

    public final void setIssuePanelVisibility(boolean visible, @Nullable Tab selectedTab) {
        Runnable runnable2;
        Content content2;
        if (selectedTab == Tab.DESIGN_TOOLS) {
            IssuePanelService.setSharedIssuePanelVisibility$default(this, visible, null, 2, null);
            return;
        }
        ToolWindow toolWindow = ProblemsView.getToolWindow((Project)this.project);
        if (toolWindow == null) {
            return;
        }
        ToolWindow problemsViewPanel = toolWindow;
        ContentManager contentManager = problemsViewPanel.getContentManager();
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"problemsViewPanel.contentManager");
        ContentManager contentManager2 = contentManager;
        if (selectedTab != null) {
            Object object;
            block7: {
                Content[] contentArray = contentManager2.getContents();
                Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"contentManager.contents");
                Object[] $this$firstOrNull$iv = contentArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Content it = (Content)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!IssuePanelServiceKt.isTab(it, selectedTab)) continue;
                    object = element$iv;
                    break block7;
                }
                object = null;
            }
            content2 = (Content)object;
        } else {
            content2 = null;
        }
        Content contentOfTab = content2;
        Runnable runnable3 = runnable2 = contentOfTab != null ? (Runnable)new Runnable(contentManager2, contentOfTab){
            final /* synthetic */ ContentManager $contentManager;
            final /* synthetic */ Content $contentOfTab;
            {
                this.$contentManager = $contentManager;
                this.$contentOfTab = $contentOfTab;
            }

            public final void run() {
                this.$contentManager.setSelectedContent(this.$contentOfTab);
            }
        } : null;
        if (visible) {
            problemsViewPanel.show(runnable2);
        } else {
            problemsViewPanel.hide(runnable2);
        }
    }

    public final void setSharedIssuePanelVisibility(boolean visible, @Nullable Runnable onAfterSettingVisibility) {
        Content content2 = this.sharedIssueTab;
        if (content2 == null) {
            return;
        }
        Content tab = content2;
        ToolWindow toolWindow = ProblemsView.getToolWindow((Project)this.project);
        if (toolWindow == null) {
            return;
        }
        ToolWindow problemsViewPanel = toolWindow;
        DesignerCommonIssuePanelUsageTracker.Companion.getInstance().trackChangingCommonIssuePanelVisibility(visible, this.project);
        if (visible) {
            if (!this.isSharedIssueTabShowing(tab)) {
                problemsViewPanel.show(new Runnable(this, onAfterSettingVisibility){
                    final /* synthetic */ IssuePanelService this$0;
                    final /* synthetic */ Runnable $onAfterSettingVisibility;
                    {
                        this.this$0 = $receiver;
                        this.$onAfterSettingVisibility = $onAfterSettingVisibility;
                    }

                    public final void run() {
                        block0: {
                            IssuePanelService.access$updateSharedIssuePanelTabName(this.this$0);
                            IssuePanelService.access$selectSharedIssuePanelTab(this.this$0);
                            Runnable runnable2 = this.$onAfterSettingVisibility;
                            if (runnable2 == null) break block0;
                            runnable2.run();
                        }
                    }
                });
            }
        } else {
            problemsViewPanel.hide(new Runnable(onAfterSettingVisibility){
                final /* synthetic */ Runnable $onAfterSettingVisibility;
                {
                    this.$onAfterSettingVisibility = $onAfterSettingVisibility;
                }

                public final void run() {
                    block0: {
                        Runnable runnable2 = this.$onAfterSettingVisibility;
                        if (runnable2 == null) break block0;
                        runnable2.run();
                    }
                }
            });
        }
    }

    public static /* synthetic */ void setSharedIssuePanelVisibility$default(IssuePanelService issuePanelService, boolean bl, Runnable runnable2, int n, Object object) {
        if ((n & 2) != 0) {
            runnable2 = null;
        }
        issuePanelService.setSharedIssuePanelVisibility(bl, runnable2);
    }

    @TestOnly
    public final boolean isSharedIssuePanelAddedToProblemsPane() {
        boolean bl;
        block3: {
            Content content2 = this.sharedIssueTab;
            if (content2 == null) {
                return false;
            }
            Content tab = content2;
            ToolWindow toolWindow = ProblemsView.getToolWindow((Project)this.project);
            if (toolWindow == null) {
                return false;
            }
            ToolWindow problemsViewPanel = toolWindow;
            Content[] contentArray = problemsViewPanel.getContentManager().getContents();
            Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"problemsViewPanel.contentManager.contents");
            Object[] $this$any$iv = contentArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                Content it = (Content)element$iv;
                boolean bl2 = false;
                if (!(it == tab)) continue;
                bl = true;
                break block3;
            }
            bl = false;
        }
        return bl;
    }

    @Nullable
    public final List<Issue> getSharedPanelIssues() {
        Object object = this.sharedIssuePanel;
        return object != null && (object = ((DesignerCommonIssuePanel)object).getIssueProvider()) != null ? object.getFilteredIssues() : null;
    }

    private final void updateSharedIssuePanelTabName() {
        Content content2 = this.sharedIssueTab;
        if (content2 == null) {
            return;
        }
        Content tab = content2;
        Object object = this.sharedIssuePanel;
        Integer count = object != null && (object = ((DesignerCommonIssuePanel)object).getIssueProvider()) != null && (object = object.getFilteredIssues()) != null && (object = CollectionsKt.distinct((Iterable)((Iterable)object))) != null ? Integer.valueOf(object.size()) : null;
        ModalityState modalityState$iv = null;
        boolean $i$f$runInEdt = false;
        Application app$iv = ApplicationManager.getApplication();
        if (app$iv.isDispatchThread()) {
            boolean bl = false;
            tab.setDisplayName(IssuePanelServiceKt.access$createTabName(this.getSharedIssuePanelTabTitle(), count));
        } else {
            boolean $i$f$invokeLater = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(tab, this, count){
                final /* synthetic */ Content $tab$inlined;
                final /* synthetic */ IssuePanelService this$0;
                final /* synthetic */ Integer $count$inlined;
                {
                    this.$tab$inlined = content2;
                    this.this$0 = issuePanelService;
                    this.$count$inlined = n;
                }

                public final void run() {
                    boolean bl = false;
                    this.$tab$inlined.setDisplayName(IssuePanelServiceKt.access$createTabName(this.this$0.getSharedIssuePanelTabTitle(), this.$count$inlined));
                }
            }, ModalityState.defaultModalityState());
        }
    }

    @VisibleForTesting
    @NotNull
    public final String getSharedIssuePanelTabTitle() {
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.project).getSelectedEditors();
        if (fileEditorArray == null) {
            return DESIGN_TOOL_TAB_NAME;
        }
        FileEditor[] editors = fileEditorArray;
        if (editors.length != 1) {
            return DESIGN_TOOL_TAB_NAME;
        }
        VirtualFile virtualFile2 = editors[0].getFile();
        if (virtualFile2 == null) {
            return DESIGN_TOOL_TAB_NAME;
        }
        VirtualFile file2 = virtualFile2;
        String string = this.fileToTabName.get(file2);
        if (string != null) {
            String it = string;
            boolean bl = false;
            return it;
        }
        if (this.isComposeFile(file2)) {
            return "Compose";
        }
        String name = this.getTabNameOfSupportedDesignerFile(file2);
        if (name != null) {
            return name;
        }
        FileEditor fileEditor = editors[0];
        Intrinsics.checkNotNullExpressionValue((Object)fileEditor, (String)"editors[0]");
        DesignSurface<?> designSurface = IssuePanelServiceKt.getDesignSurface(fileEditor);
        if (designSurface == null) {
            return DESIGN_TOOL_TAB_NAME;
        }
        DesignSurface<?> surface2 = designSurface;
        if (surface2.getName() != null) {
            String string2 = surface2.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"surface.name");
            return string2;
        }
        return DESIGN_TOOL_TAB_NAME;
    }

    private final boolean isDesignEditor(FileEditor editor) {
        VirtualFile virtualFile2 = editor.getFile();
        if (virtualFile2 == null) {
            return false;
        }
        VirtualFile virtualFile3 = virtualFile2;
        return this.isComposeFile(virtualFile3) || this.isSupportedDesignerFileType(virtualFile3) || IssuePanelServiceKt.getDesignSurface(editor) != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isComposeFile(VirtualFile file2) {
        String extension = file2.getExtension();
        FileType fileType = file2.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"file.fileType");
        FileType fileType2 = fileType;
        PsiFile psiFile2 = PhysicalFileSystemUtilsKt.toPsiFile((VirtualFile)file2, (Project)this.project);
        if (!Intrinsics.areEqual((Object)extension, (Object)KotlinFileType.INSTANCE.getDefaultExtension())) return false;
        if (!Intrinsics.areEqual((Object)fileType2, (Object)KotlinFileType.INSTANCE)) return false;
        PsiFile psiFile3 = psiFile2;
        PsiFile psiFile4 = psiFile3;
        if (psiFile3 == null) return false;
        AndroidModuleSystem androidModuleSystem = ProjectSystemUtil.getModuleSystem((PsiElement)((PsiElement)psiFile4));
        psiFile4 = androidModuleSystem;
        if (androidModuleSystem == null) return false;
        if (!psiFile4.getUsesCompose()) return false;
        return true;
    }

    private final boolean isSupportedDesignerFileType(VirtualFile file2) {
        return this.getTabNameOfSupportedDesignerFile(file2) != null;
    }

    private final String getTabNameOfSupportedDesignerFile(VirtualFile file2) {
        PsiFile psiFile2 = PhysicalFileSystemUtilsKt.toPsiFile((VirtualFile)file2, (Project)this.project);
        if (psiFile2 == null) {
            return null;
        }
        PsiFile psiFile3 = psiFile2;
        return LayoutFileType.INSTANCE.isResourceTypeOf(psiFile3) ? "Layout and Qualifiers" : (PreferenceScreenFileType.INSTANCE.isResourceTypeOf(psiFile3) ? "Preference" : (MenuFileType.INSTANCE.isResourceTypeOf(psiFile3) ? "Menu" : null));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    private final String getEmptyMessage() {
        String string;
        void $this$mapNotNullTo$iv$iv;
        FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.project).getSelectedEditors();
        Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getInstance(project).selectedEditors");
        Object[] $this$mapNotNull$iv = fileEditorArray;
        boolean $i$f$mapNotNull = false;
        Object[] objectArray = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        int n = ((void)$this$forEach$iv$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            VirtualFile it$iv$iv;
            void element$iv$iv$iv;
            void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
            boolean bl = false;
            FileEditor it = (FileEditor)element$iv$iv;
            boolean bl2 = false;
            if (it.getFile() == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List files = (List)destination$iv$iv;
        if (files.isEmpty()) {
            return "No problems found";
        }
        List psiFiles2 = (List)ApplicationManager.getApplication().runReadAction(new Computable(files, this){
            final /* synthetic */ List<VirtualFile> $files;
            final /* synthetic */ IssuePanelService this$0;
            {
                this.$files = $files;
                this.this$0 = $receiver;
            }

            /*
             * WARNING - void declaration
             */
            public final List<PsiFile> compute() {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Iterable iterable = this.$files;
                IssuePanelService issuePanelService = this.this$0;
                boolean $i$f$mapNotNull = false;
                void var4_4 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    PsiFile it$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    VirtualFile it = (VirtualFile)element$iv$iv;
                    boolean bl2 = false;
                    if (PhysicalFileSystemUtilsKt.toPsiFile((VirtualFile)it, (Project)IssuePanelService.access$getProject$p(issuePanelService)) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        });
        String fileNameString2 = CollectionsKt.joinToString$default((Iterable)files, null, null, null, (int)0, null, (Function1)getEmptyMessage.fileNameString.1.INSTANCE, (int)31, null);
        if (psiFiles2.size() == files.size()) {
            boolean bl;
            block7: {
                Intrinsics.checkNotNullExpressionValue((Object)psiFiles2, (String)"psiFiles");
                Iterable $this$all$iv = psiFiles2;
                boolean $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PsiFile it = (PsiFile)element$iv;
                        boolean bl4 = false;
                        if (LayoutFileType.INSTANCE.isResourceTypeOf(it)) continue;
                        bl = false;
                        break block7;
                    }
                    bl = true;
                }
            }
            if (bl) {
                string = "No layout problems in " + fileNameString2 + " and qualifiers";
                return string;
            }
        }
        string = "No problems in " + fileNameString2;
        return string;
    }

    /*
     * WARNING - void declaration
     */
    public final void showIssueForComponent(@NotNull DesignSurface<?> surface2, boolean userInvoked, @NotNull NlComponent component, boolean collapseOthers) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Object object = StudioFlags.NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get()");
        if (((Boolean)object).booleanValue()) {
            IssuePanelService.setSharedIssuePanelVisibility$default(this, true, null, 2, null);
        } else {
            IssuePanel issuePanel2 = surface2.getIssuePanel();
            Intrinsics.checkNotNullExpressionValue((Object)issuePanel2, (String)"surface.issuePanel");
            IssuePanel issuePanel3 = issuePanel2;
            IssueModel issueModel = surface2.getIssueModel();
            Intrinsics.checkNotNullExpressionValue((Object)issueModel, (String)"surface.issueModel");
            IssueModel issueModel2 = issueModel;
            Issue issue = issueModel2.getHighestSeverityIssue(component);
            if (issue == null) {
                return;
            }
            Issue issue2 = issue;
            IssueView issueView = issuePanel3.getDisplayIssueView(issue2);
            if (issueView != null) {
                IssuePanelServiceKt.setIssuePanelVisibility$default(surface2, true, userInvoked, null, 4, null);
                if (collapseOthers) {
                    void $this$forEach$iv;
                    IssueView it$iv$iv;
                    boolean bl;
                    Issue it;
                    boolean bl2;
                    Object element$iv$iv;
                    Iterator $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv;
                    Object it2;
                    void $this$filterTo$iv$iv;
                    ImmutableList<Issue> immutableList = issueModel2.getIssues();
                    Intrinsics.checkNotNullExpressionValue(immutableList, (String)"issueModel.issues");
                    Iterable $this$filter$iv = (Iterable)immutableList;
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                        it2 = (Issue)element$iv$iv2;
                        boolean bl3 = false;
                        if (!(!Intrinsics.areEqual((Object)it2, (Object)issue2))) continue;
                        destination$iv$iv.add(element$iv$iv2);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    boolean $i$f$mapNotNull = false;
                    $this$filterTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    Iterator $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    it2 = $this$forEach$iv$iv$iv.iterator();
                    while (it2.hasNext()) {
                        Object element$iv$iv$iv;
                        element$iv$iv = element$iv$iv$iv = it2.next();
                        bl2 = false;
                        it = (Issue)element$iv$iv;
                        boolean bl4 = false;
                        if (issuePanel3.getDisplayIssueView(it) == null) continue;
                        bl = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    boolean $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IssueView it3 = (IssueView)element$iv;
                        boolean bl5 = false;
                        it3.setExpanded(false);
                    }
                    ImmutableList<Issue> immutableList2 = issueModel2.getIssues();
                    Intrinsics.checkNotNullExpressionValue(immutableList2, (String)"issueModel.issues");
                    $this$mapNotNull$iv = (Iterable)immutableList2;
                    $i$f$mapNotNull = false;
                    $this$mapNotNullTo$iv$iv = $this$mapNotNull$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$mapNotNullTo = false;
                    $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    $i$f$forEach = false;
                    it2 = $this$forEach$iv$iv$iv.iterator();
                    while (it2.hasNext()) {
                        Object element$iv$iv$iv = it2.next();
                        element$iv$iv = element$iv$iv$iv;
                        bl2 = false;
                        it = (Issue)element$iv$iv;
                        boolean bl6 = false;
                        if (issuePanel3.getDisplayIssueView(it) == null) continue;
                        bl = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    $this$mapNotNull$iv = (List)destination$iv$iv;
                    $i$f$filter = false;
                    $this$mapNotNullTo$iv$iv = $this$filter$iv;
                    destination$iv$iv = new ArrayList();
                    $i$f$filterTo = false;
                    for (Object element$iv$iv3 : $this$filterTo$iv$iv) {
                        it2 = (IssueView)element$iv$iv3;
                        boolean bl7 = false;
                        if (!(!Intrinsics.areEqual((Object)((IssueView)it2).getIssue(), (Object)issue2))) continue;
                        destination$iv$iv.add(element$iv$iv3);
                    }
                    $this$filter$iv = (List)destination$iv$iv;
                    $i$f$forEach2 = false;
                    for (Object element$iv : $this$forEach$iv) {
                        IssueView it4 = (IssueView)element$iv;
                        boolean bl8 = false;
                        it4.setExpanded(false);
                    }
                }
                issuePanel3.scrollToIssueView(issueView);
            }
        }
    }

    public final boolean isIssuePanelVisible(@NotNull DesignSurface<?> surface2) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        Object object = StudioFlags.NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get()");
        return (Boolean)object != false ? this.isSharedIssueTabShowing(this.sharedIssueTab) : !surface2.getIssuePanel().isMinimized();
    }

    private final boolean isSharedIssueTabShowing(Content tab) {
        block6: {
            block5: {
                if (tab == null) {
                    return false;
                }
                ToolWindow toolWindow = ProblemsView.getToolWindow((Project)this.project);
                if (toolWindow == null) {
                    return false;
                }
                ToolWindow problemsViewPanel = toolWindow;
                if (!problemsViewPanel.isVisible()) break block5;
                Content[] contentArray = problemsViewPanel.getContentManager().getContents();
                Intrinsics.checkNotNullExpressionValue((Object)contentArray, (String)"problemsViewPanel.contentManager.contents");
                if (ArraysKt.contains((Object[])contentArray, (Object)tab)) break block6;
            }
            return false;
        }
        return tab.isSelected();
    }

    @Nullable
    public final DesignerCommonIssuePanel getSelectedSharedIssuePanel() {
        Content content2 = this.sharedIssueTab;
        return (content2 != null ? content2.isSelected() : false) ? this.sharedIssuePanel : null;
    }

    public final void focusIssuePanelIfVisible() {
        ToolWindow toolWindow = ProblemsView.getToolWindow((Project)this.project);
        if (toolWindow == null) {
            return;
        }
        ToolWindow problemsViewPanel = toolWindow;
        if (problemsViewPanel.isVisible()) {
            problemsViewPanel.activate(null, true);
        }
    }

    @NotNull
    public final List<Issue> getSelectedIssues() {
        Object object = this.sharedIssuePanel;
        if (object == null || (object = ((DesignerCommonIssuePanel)object).getComponent()) == null) {
            return CollectionsKt.emptyList();
        }
        Object issuePanelComponent = object;
        List list = (List)DataManager.getInstance().getDataContext((Component)issuePanelComponent).getData(SELECTED_ISSUES);
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    public final void registerFile(@NotNull VirtualFile file2, @Nullable String tabTitle) {
        boolean bl;
        block4: {
            Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
            if (tabTitle != null) {
                this.fileToTabName.put(file2, tabTitle);
            } else {
                this.fileToTabName.remove(file2);
            }
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)this.project).getSelectedEditors();
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getInstance(project).selectedEditors");
            Object[] $this$any$iv = fileEditorArray;
            boolean $i$f$any = false;
            for (Object element$iv : $this$any$iv) {
                FileEditor it = (FileEditor)element$iv;
                boolean bl2 = false;
                if (!Intrinsics.areEqual((Object)it.getFile(), (Object)file2)) continue;
                bl = true;
                break block4;
            }
            bl = false;
        }
        if (bl) {
            this.updateIssuePanelVisibility(file2);
        }
    }

    public final void unregisterFile(@NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.fileToTabName.remove(file2);
    }

    public final void setSelectedNode(@NotNull TreeVisitor nodeVisitor) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)nodeVisitor, (String)"nodeVisitor");
            DesignerCommonIssuePanel designerCommonIssuePanel = this.sharedIssuePanel;
            if (designerCommonIssuePanel == null) break block0;
            designerCommonIssuePanel.setSelectedNode(nodeVisitor);
        }
    }

    @JvmStatic
    @NotNull
    public static final IssuePanelService getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ String access$getEmptyMessage(IssuePanelService $this) {
        return $this.getEmptyMessage();
    }

    public static final /* synthetic */ void access$updateSharedIssuePanelTabName(IssuePanelService $this) {
        $this.updateSharedIssuePanelTabName();
    }

    public static final /* synthetic */ boolean access$isComposeFile(IssuePanelService $this, VirtualFile file2) {
        return $this.isComposeFile(file2);
    }

    public static final /* synthetic */ boolean access$isSupportedDesignerFileType(IssuePanelService $this, VirtualFile file2) {
        return $this.isSupportedDesignerFileType(file2);
    }

    public static final /* synthetic */ void access$addIssuePanel(IssuePanelService $this) {
        $this.addIssuePanel();
    }

    public static final /* synthetic */ void access$updateIssuePanelVisibility(IssuePanelService $this, VirtualFile file2) {
        $this.updateIssuePanelVisibility(file2);
    }

    public static final /* synthetic */ void access$selectSharedIssuePanelTab(IssuePanelService $this) {
        $this.selectSharedIssuePanelTab();
    }

    static {
        DataKey dataKey = DataKey.create((String)(DesignerCommonIssuePanel.class.getName() + "_selectedIssues"));
        Intrinsics.checkNotNullExpressionValue((Object)dataKey, (String)"create<List<Issue>>(Desi\u2026name + \"_selectedIssues\")");
        SELECTED_ISSUES = dataKey;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R0\u0010\u0005\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\b \t*\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u00070\u00070\u0006\u00a2\u0006\u0002\b\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/common/error/IssuePanelService$Companion;", "", "()V", "DESIGN_TOOL_TAB_NAME", "", "SELECTED_ISSUES", "Lcom/intellij/openapi/actionSystem/DataKey;", "", "Lcom/android/tools/idea/common/error/Issue;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "getSELECTED_ISSUES", "()Lcom/intellij/openapi/actionSystem/DataKey;", "getInstance", "Lcom/android/tools/idea/common/error/IssuePanelService;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.android.designer"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final IssuePanelService getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(IssuePanelService.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"project.getService(IssuePanelService::class.java)");
            return (IssuePanelService)object;
        }

        @NotNull
        public final DataKey<List<Issue>> getSELECTED_ISSUES() {
            return SELECTED_ISSUES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/common/error/IssuePanelService$Tab;", "", "(Ljava/lang/String;I)V", "CURRENT_FILE", "PROJECT_ERRORS", "DESIGN_TOOLS", "intellij.android.designer"})
    public static final class Tab
    extends Enum<Tab> {
        public static final /* enum */ Tab CURRENT_FILE = new Tab();
        public static final /* enum */ Tab PROJECT_ERRORS = new Tab();
        public static final /* enum */ Tab DESIGN_TOOLS = new Tab();
        private static final /* synthetic */ Tab[] $VALUES;

        public static Tab[] values() {
            return (Tab[])$VALUES.clone();
        }

        public static Tab valueOf(String value2) {
            return Enum.valueOf(Tab.class, value2);
        }

        static {
            $VALUES = tabArray = new Tab[]{Tab.CURRENT_FILE, Tab.PROJECT_ERRORS, Tab.DESIGN_TOOLS};
        }
    }
}

