/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.common.error.DesignerCommonIssueNode;
import com.android.tools.idea.common.error.DesignerCommonIssueRoot;
import com.android.tools.idea.common.error.DesignerIssueNodeVisitor;
import com.android.tools.idea.common.error.Issue;
import com.android.tools.idea.common.error.IssueNode;
import com.android.tools.idea.common.error.IssuedFileNode;
import com.android.tools.idea.common.error.NoFileNode;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.uibuilder.visual.visuallint.VisualLintRenderIssue;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.ui.tree.TreeVisitor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u0003H\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00112\u0006\u0010\b\u001a\u00020\u0011H\u0002J\u0018\u0010\u0012\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00132\u0006\u0010\b\u001a\u00020\u0013H\u0002J\u0018\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00152\u0006\u0010\b\u001a\u00020\u0015H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/common/error/DesignerIssueNodeVisitor;", "Lcom/intellij/ui/tree/TreeVisitor;", "node", "Lcom/android/tools/idea/common/error/DesignerCommonIssueNode;", "(Lcom/android/tools/idea/common/error/DesignerCommonIssueNode;)V", "compareNode", "Lcom/intellij/ui/tree/TreeVisitor$Action;", "node1", "node2", "createIndexString", "", "component", "Lcom/android/tools/idea/common/model/NlComponent;", "visit", "path", "Ljavax/swing/tree/TreePath;", "visitIssueNode", "Lcom/android/tools/idea/common/error/IssueNode;", "visitIssuedFileNode", "Lcom/android/tools/idea/common/error/IssuedFileNode;", "visitNoFileNode", "Lcom/android/tools/idea/common/error/NoFileNode;", "intellij.android.designer"})
public final class DesignerIssueNodeVisitor
implements TreeVisitor {
    @NotNull
    private final DesignerCommonIssueNode node;

    public DesignerIssueNodeVisitor(@NotNull DesignerCommonIssueNode node) {
        Intrinsics.checkNotNullParameter((Object)((Object)node), (String)"node");
        this.node = node;
    }

    @NotNull
    public TreeVisitor.Action visit(@NotNull TreePath path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Object visitedNode = path.getLastPathComponent();
        return !(visitedNode instanceof DesignerCommonIssueNode) ? TreeVisitor.Action.CONTINUE : this.compareNode((DesignerCommonIssueNode)((Object)visitedNode), this.node);
    }

    private final TreeVisitor.Action compareNode(DesignerCommonIssueNode node1, DesignerCommonIssueNode node2) {
        if (node1 == null || node2 == null) {
            return node1 == null && node2 == null ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE;
        }
        if (!Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(((Object)((Object)node1)).getClass()), (Object)Reflection.getOrCreateKotlinClass(((Object)((Object)node2)).getClass()))) {
            return TreeVisitor.Action.CONTINUE;
        }
        DesignerCommonIssueNode designerCommonIssueNode = node1;
        return designerCommonIssueNode instanceof IssuedFileNode ? this.visitIssuedFileNode((IssuedFileNode)node1, (IssuedFileNode)node2) : (designerCommonIssueNode instanceof NoFileNode ? this.visitNoFileNode((NoFileNode)node1, (NoFileNode)node2) : (designerCommonIssueNode instanceof IssueNode ? this.visitIssueNode((IssueNode)node1, (IssueNode)node2) : (designerCommonIssueNode instanceof DesignerCommonIssueRoot ? (node1 == node2 ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE) : TreeVisitor.Action.CONTINUE)));
    }

    private final TreeVisitor.Action visitIssuedFileNode(IssuedFileNode node1, IssuedFileNode node2) {
        TreeVisitor.Action action2;
        if (!Intrinsics.areEqual((Object)node1.getFile(), (Object)node2.getFile())) {
            action2 = TreeVisitor.Action.CONTINUE;
        } else {
            NodeDescriptor nodeDescriptor = node1.getParentDescriptor();
            Object object = nodeDescriptor != null ? nodeDescriptor.getElement() : null;
            DesignerCommonIssueNode designerCommonIssueNode = object instanceof DesignerCommonIssueNode ? (DesignerCommonIssueNode)((Object)object) : null;
            NodeDescriptor nodeDescriptor2 = node2.getParentDescriptor();
            object = nodeDescriptor2 != null ? nodeDescriptor2.getElement() : null;
            action2 = this.compareNode(designerCommonIssueNode, object instanceof DesignerCommonIssueNode ? (DesignerCommonIssueNode)((Object)object) : null);
        }
        return action2;
    }

    private final TreeVisitor.Action visitNoFileNode(NoFileNode node1, NoFileNode node2) {
        TreeVisitor.Action action2;
        if (!Intrinsics.areEqual((Object)node1.getName(), (Object)node2.getName())) {
            action2 = TreeVisitor.Action.CONTINUE;
        } else {
            NodeDescriptor nodeDescriptor = node1.getParentDescriptor();
            Object object = nodeDescriptor != null ? nodeDescriptor.getElement() : null;
            DesignerCommonIssueNode designerCommonIssueNode = object instanceof DesignerCommonIssueNode ? (DesignerCommonIssueNode)((Object)object) : null;
            NodeDescriptor nodeDescriptor2 = node2.getParentDescriptor();
            object = nodeDescriptor2 != null ? nodeDescriptor2.getElement() : null;
            action2 = this.compareNode(designerCommonIssueNode, object instanceof DesignerCommonIssueNode ? (DesignerCommonIssueNode)((Object)object) : null);
        }
        return action2;
    }

    private final TreeVisitor.Action visitIssueNode(IssueNode node1, IssueNode node2) {
        Issue issue1 = node1.getIssue();
        Issue issue2 = node2.getIssue();
        NodeDescriptor nodeDescriptor = node1.getParentDescriptor();
        Object object = nodeDescriptor != null ? nodeDescriptor.getElement() : null;
        NodeDescriptor nodeDescriptor2 = node2.getParentDescriptor();
        TreeVisitor.Action actionAfterComparingParents = this.compareNode(object instanceof DesignerCommonIssueNode ? (DesignerCommonIssueNode)((Object)object) : null, (object = nodeDescriptor2 != null ? nodeDescriptor2.getElement() : null) instanceof DesignerCommonIssueNode ? (DesignerCommonIssueNode)((Object)object) : null);
        if (actionAfterComparingParents == TreeVisitor.Action.CONTINUE) {
            return TreeVisitor.Action.CONTINUE;
        }
        if (issue1 instanceof VisualLintRenderIssue || issue2 instanceof VisualLintRenderIssue) {
            List files2;
            if (!(issue1 instanceof VisualLintRenderIssue) || !(issue2 instanceof VisualLintRenderIssue)) {
                return TreeVisitor.Action.CONTINUE;
            }
            if (!Intrinsics.areEqual((Object)issue1.getSummary(), (Object)issue2.getSummary())) {
                return TreeVisitor.Action.CONTINUE;
            }
            List files1 = CollectionsKt.toList((Iterable)((VisualLintRenderIssue)issue1).getModels());
            if (!Intrinsics.areEqual((Object)files1, (Object)(files2 = CollectionsKt.toList((Iterable)((VisualLintRenderIssue)issue2).getModels())))) {
                return TreeVisitor.Action.CONTINUE;
            }
            Function1[] function1Array = new Function1[]{visitIssueNode.comparator.1.INSTANCE, visitIssueNode.comparator.2.INSTANCE, new Function1<NlComponent, Comparable<?>>(this){
                final /* synthetic */ DesignerIssueNodeVisitor this$0;
                {
                    this.this$0 = $receiver;
                    super(1);
                }

                @Nullable
                public final Comparable<?> invoke(@NotNull NlComponent it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return (Comparable)((Object)DesignerIssueNodeVisitor.access$createIndexString(this.this$0, it));
                }
            }};
            Comparator comparator2 = ComparisonsKt.compareBy((Function1[])function1Array);
            Iterator visitedNodeIterator = CollectionsKt.sortedWith((Iterable)((VisualLintRenderIssue)issue1).getComponents(), (Comparator)comparator2).iterator();
            Iterator nodeIterator = CollectionsKt.sortedWith((Iterable)((VisualLintRenderIssue)issue2).getComponents(), (Comparator)comparator2).iterator();
            while (visitedNodeIterator.hasNext() && nodeIterator.hasNext()) {
                if (comparator2.compare(visitedNodeIterator.next(), nodeIterator.next()) == 0) continue;
                return TreeVisitor.Action.CONTINUE;
            }
            return visitedNodeIterator.hasNext() || nodeIterator.hasNext() ? TreeVisitor.Action.CONTINUE : TreeVisitor.Action.INTERRUPT;
        }
        return Intrinsics.areEqual((Object)issue1, (Object)issue2) ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE;
    }

    private final String createIndexString(NlComponent component) {
        NlComponent nlComponent;
        List orders = new ArrayList();
        NlComponent current = component;
        while ((nlComponent = current) != null && (nlComponent = nlComponent.getParent()) != null) {
            NlComponent parent = nlComponent;
            int order = parent.getChildren().indexOf(current);
            orders.add(order);
            current = parent;
        }
        return CollectionsKt.joinToString$default((Iterable)CollectionsKt.reversed((Iterable)orders), (CharSequence)",", null, null, (int)0, null, null, (int)62, null);
    }

    public static final /* synthetic */ String access$createIndexString(DesignerIssueNodeVisitor $this, NlComponent component) {
        return $this.createIndexString(component);
    }
}

