/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.error;

import com.android.tools.idea.common.error.DesignerCommonIssueDetailPanel;
import com.android.tools.idea.common.error.DesignerCommonIssueNode;
import com.android.tools.idea.common.error.IssueNode;
import com.intellij.analysis.problemsView.toolWindow.ProblemsView;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0010\u001a\u00020\tH\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0007J\b\u0010\u0013\u001a\u00020\u0012H\u0007J\u0010\u0010\u0014\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/common/error/DesignerCommonIssueSidePanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "fileToEditorMap", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lcom/intellij/openapi/editor/Editor;", "splitter", "Lcom/intellij/ui/OnePixelSplitter;", "dispose", "", "getEditor", "file", "hasFirstComponent", "", "hasSecondComponent", "loadIssueNode", "issueNode", "Lcom/android/tools/idea/common/error/DesignerCommonIssueNode;", "intellij.android.designer"})
public final class DesignerCommonIssueSidePanel
extends JPanel
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final OnePixelSplitter splitter;
    @NotNull
    private final Map<VirtualFile, Editor> fileToEditorMap;

    public DesignerCommonIssueSidePanel(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(new BorderLayout());
        this.project = project;
        this.splitter = new OnePixelSplitter(true, 0.5f, 0.1f, 0.9f);
        this.fileToEditorMap = new LinkedHashMap();
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.splitter.setFirstComponent(null);
        this.splitter.setSecondComponent(null);
        this.splitter.setResizeEnabled(true);
        this.add((Component)this.splitter, "Center");
        MessageBusConnection messageBusConnection = this.project.getMessageBus().connect((Disposable)this);
        Topic topic = FileEditorManagerListener.FILE_EDITOR_MANAGER;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"FILE_EDITOR_MANAGER");
        messageBusConnection.subscribe(topic, (Object)new FileEditorManagerListener(){

            public void fileClosed(@NotNull FileEditorManager source, @NotNull VirtualFile file2) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)source, (String)"source");
                    Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
                    Editor editor = (Editor)fileToEditorMap.remove(file2);
                    if (editor == null) break block0;
                    Editor editor2 = editor;
                    boolean bl = false;
                    EditorFactory.getInstance().releaseEditor(editor2);
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public final boolean loadIssueNode(@Nullable DesignerCommonIssueNode issueNode) {
        Editor editor;
        Editor editor2;
        DesignerCommonIssueDetailPanel designerCommonIssueDetailPanel;
        OnePixelSplitter onePixelSplitter = this.splitter;
        IssueNode issueNode2 = issueNode instanceof IssueNode ? (IssueNode)issueNode : null;
        if (issueNode2 != null) {
            void node;
            IssueNode issueNode3 = issueNode2;
            OnePixelSplitter onePixelSplitter2 = onePixelSplitter;
            boolean bl = false;
            designerCommonIssueDetailPanel = new DesignerCommonIssueDetailPanel(this.project, node.getIssue());
            onePixelSplitter = onePixelSplitter2;
        } else {
            designerCommonIssueDetailPanel = null;
        }
        onePixelSplitter.setFirstComponent((JComponent)designerCommonIssueDetailPanel);
        if (issueNode == null) {
            this.splitter.setSecondComponent(null);
            return false;
        }
        VirtualFile virtualFile2 = issueNode.getVirtualFile();
        if (virtualFile2 != null) {
            VirtualFile it = virtualFile2;
            boolean bl = false;
            editor2 = this.getEditor(it);
        } else {
            editor2 = editor = null;
        }
        if (editor != null) {
            editor.setBorder((Border)JBUI.Borders.empty());
            Navigatable navigable = issueNode.getNavigatable();
            if (navigable instanceof OpenFileDescriptor) {
                ((OpenFileDescriptor)navigable).navigateIn(editor);
            }
        }
        Editor editor3 = editor;
        this.splitter.setSecondComponent(editor3 != null ? editor3.getComponent() : null);
        return this.splitter.getFirstComponent() != null || this.splitter.getSecondComponent() != null;
    }

    private final Editor getEditor(VirtualFile file2) {
        Editor editor = this.fileToEditorMap.get(file2);
        if (editor != null) {
            return editor;
        }
        Document document = ProblemsView.getDocument((Project)this.project, (VirtualFile)file2);
        if (document == null) {
            return null;
        }
        Document document2 = document;
        Editor newEditor = EditorFactory.getInstance().createEditor(document2, this.project, file2, false, EditorKind.PREVIEW);
        if (newEditor != null) {
            this.fileToEditorMap.put(file2, newEditor);
        }
        return newEditor;
    }

    public void dispose() {
        for (Editor editor : this.fileToEditorMap.values()) {
            EditorFactory.getInstance().releaseEditor(editor);
        }
        this.fileToEditorMap.clear();
    }

    @TestOnly
    public final boolean hasFirstComponent() {
        return this.splitter.getFirstComponent() != null;
    }

    @TestOnly
    public final boolean hasSecondComponent() {
        return this.splitter.getSecondComponent() != null;
    }
}

