/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.editor;

import com.android.tools.idea.common.editor.DesignerEditorPanel;
import com.android.tools.idea.common.editor.SplitEditorPreviewNotificationHandler;
import com.android.tools.idea.common.lint.BackgroundEditorHighlighter;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DesignerEditor
extends UserDataHolderBase
implements FileEditor,
SplitEditorPreviewNotificationHandler {
    protected final Project myProject;
    protected final VirtualFile myFile;
    private DesignerEditorPanel myEditorPanel;
    private BackgroundEditorHighlighter myBackgroundHighlighter;

    public DesignerEditor(@NotNull VirtualFile file2, @NotNull Project project) {
        this.myProject = project;
        this.myFile = file2;
    }

    @NotNull
    public abstract String getEditorId();

    @NotNull
    protected abstract DesignerEditorPanel createEditorPanel();

    @NotNull
    public DesignerEditorPanel getComponent() {
        if (this.myEditorPanel == null) {
            this.myEditorPanel = this.createEditorPanel();
            Disposer.register((Disposable)this, (Disposable)this.myEditorPanel);
        }
        return this.myEditorPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.getComponent().getPreferredFocusedComponent();
    }

    public void setState(@NotNull FileEditorState state) {
    }

    public void dispose() {
    }

    public boolean isValid() {
        return this.myFile.isValid();
    }

    public boolean isModified() {
        return false;
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener2) {
    }

    @NotNull
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        if (this.myBackgroundHighlighter == null) {
            this.myBackgroundHighlighter = new BackgroundEditorHighlighter(this.myEditorPanel, this.myEditorPanel.getModelLintIssueAnnotator());
        }
        return this.myBackgroundHighlighter;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    @Nullable
    public StructureViewBuilder getStructureViewBuilder() {
        return null;
    }

    @Nullable
    public VirtualFile getFile() {
        return this.myFile;
    }

    @Override
    public void updateNotifications() {
        DesignerEditorPanel currentPanel = this.myEditorPanel;
        if (currentPanel != null) {
            currentPanel.updateNotifications(this.getFile(), this, this.myProject);
        }
    }
}

