/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.analytics;

import com.android.tools.adtui.actions.ZoomType;
import com.android.tools.idea.common.analytics.CommonUsageTracker;
import com.android.tools.idea.common.editor.DesignerEditorPanel;
import com.android.tools.idea.common.surface.DesignSurface;
import com.google.wireless.android.sdk.stats.LayoutEditorEvent;
import com.google.wireless.android.sdk.stats.LayoutEditorState;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0011\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eJ\u0010\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u001f\u001a\u00020\u0017J\u0006\u0010 \u001a\u00020\u0017J\u000e\u0010!\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\"R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0004R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/common/analytics/DesignerAnalyticsManager;", "", "surface", "Lcom/android/tools/idea/common/surface/DesignSurface;", "(Lcom/android/tools/idea/common/surface/DesignSurface;)V", "editorMode", "Lcom/google/wireless/android/sdk/stats/LayoutEditorState$Mode;", "getEditorMode", "()Lcom/google/wireless/android/sdk/stats/LayoutEditorState$Mode;", "layoutType", "Lcom/google/wireless/android/sdk/stats/LayoutEditorState$Type;", "getLayoutType", "()Lcom/google/wireless/android/sdk/stats/LayoutEditorState$Type;", "panelState", "Lcom/android/tools/idea/common/editor/DesignerEditorPanel$State;", "getSurface", "()Lcom/android/tools/idea/common/surface/DesignSurface;", "setSurface", "surfaceType", "Lcom/google/wireless/android/sdk/stats/LayoutEditorState$Surfaces;", "getSurfaceType", "()Lcom/google/wireless/android/sdk/stats/LayoutEditorState$Surfaces;", "setEditorModeWithoutTracking", "", "track", "type", "Lcom/google/wireless/android/sdk/stats/LayoutEditorEvent$LayoutEditorEventType;", "trackIssuePanel", "minimized", "", "trackSelectEditorMode", "trackShowIssuePanel", "trackUnknownEvent", "trackZoom", "Lcom/android/tools/adtui/actions/ZoomType;", "intellij.android.designer"})
public class DesignerAnalyticsManager {
    @NotNull
    private DesignSurface<?> surface;
    @NotNull
    private final LayoutEditorState.Surfaces surfaceType;
    @NotNull
    private DesignerEditorPanel.State panelState;
    @NotNull
    private final LayoutEditorState.Type layoutType;

    public DesignerAnalyticsManager(@NotNull DesignSurface<?> surface2) {
        Intrinsics.checkNotNullParameter(surface2, (String)"surface");
        this.surface = surface2;
        this.surfaceType = LayoutEditorState.Surfaces.UNKNOWN_SURFACES;
        this.panelState = DesignerEditorPanel.State.DEACTIVATED;
        this.layoutType = LayoutEditorState.Type.UNKNOWN_TYPE;
    }

    @NotNull
    protected final DesignSurface<?> getSurface() {
        return this.surface;
    }

    protected final void setSurface(@NotNull DesignSurface<?> designSurface) {
        Intrinsics.checkNotNullParameter(designSurface, (String)"<set-?>");
        this.surface = designSurface;
    }

    @NotNull
    public LayoutEditorState.Surfaces getSurfaceType() {
        return this.surfaceType;
    }

    @NotNull
    public final LayoutEditorState.Mode getEditorMode() {
        LayoutEditorState.Mode mode;
        switch (WhenMappings.$EnumSwitchMapping$0[this.panelState.ordinal()]) {
            case 1: {
                mode = LayoutEditorState.Mode.DESIGN_MODE;
                break;
            }
            case 2: {
                mode = LayoutEditorState.Mode.PREVIEW_MODE;
                break;
            }
            case 3: {
                mode = LayoutEditorState.Mode.UNKOWN_MODE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return mode;
    }

    @NotNull
    public LayoutEditorState.Type getLayoutType() {
        return this.layoutType;
    }

    public final void trackShowIssuePanel() {
        this.track(LayoutEditorEvent.LayoutEditorEventType.SHOW_LINT_MESSAGES);
    }

    public final void trackUnknownEvent() {
        this.track(LayoutEditorEvent.LayoutEditorEventType.UNKNOWN_EVENT_TYPE);
    }

    public final void trackZoom(@NotNull ZoomType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.ZOOM_ACTUAL);
                break;
            }
            case 2: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.ZOOM_IN);
                break;
            }
            case 3: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.ZOOM_OUT);
                break;
            }
            case 4: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.ZOOM_FIT);
                break;
            }
        }
    }

    public final void setEditorModeWithoutTracking(@NotNull DesignerEditorPanel.State panelState) {
        Intrinsics.checkNotNullParameter((Object)((Object)panelState), (String)"panelState");
        this.panelState = panelState;
    }

    public final void trackSelectEditorMode(@NotNull DesignerEditorPanel.State panelState) {
        Intrinsics.checkNotNullParameter((Object)((Object)panelState), (String)"panelState");
        switch (WhenMappings.$EnumSwitchMapping$0[panelState.ordinal()]) {
            case 1: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.SELECT_VISUAL_MODE);
                break;
            }
            case 2: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.SELECT_SPLIT_MODE);
                break;
            }
            case 3: {
                this.track(LayoutEditorEvent.LayoutEditorEventType.SELECT_TEXT_MODE);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final void trackIssuePanel(boolean minimized) {
        if (minimized) {
            this.track(LayoutEditorEvent.LayoutEditorEventType.MINIMIZE_ERROR_PANEL);
        } else {
            this.track(LayoutEditorEvent.LayoutEditorEventType.RESTORE_ERROR_PANEL);
        }
    }

    protected final void track(@NotNull LayoutEditorEvent.LayoutEditorEventType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        CommonUsageTracker.Companion.getInstance(this.surface).logAction(type);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[DesignerEditorPanel.State.values().length];
            nArray[DesignerEditorPanel.State.FULL.ordinal()] = 1;
            nArray[DesignerEditorPanel.State.SPLIT.ordinal()] = 2;
            nArray[DesignerEditorPanel.State.DEACTIVATED.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[ZoomType.values().length];
            nArray[ZoomType.ACTUAL.ordinal()] = 1;
            nArray[ZoomType.IN.ordinal()] = 2;
            nArray[ZoomType.OUT.ordinal()] = 3;
            nArray[ZoomType.FIT.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

