/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.ide.common.rendering.HardwareConfigHelper;
import com.android.sdklib.devices.Device;
import com.android.sdklib.devices.State;
import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.actions.DesignerActionUtils;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.uibuilder.surface.NlSupportedActions;
import com.android.tools.idea.uibuilder.surface.NlSupportedActionsKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import org.jetbrains.annotations.NotNull;

public class ToggleDeviceOrientationAction
extends AnAction {
    private ToggleDeviceOrientationAction() {
    }

    @NotNull
    public static ToggleDeviceOrientationAction getInstance() {
        return (ToggleDeviceOrientationAction)ActionManager.getInstance().getAction("Android.Designer.ToggleDeviceOrientation");
    }

    public void update(@NotNull AnActionEvent e) {
        if (DesignerActionUtils.isActionEventFromJTextField(e)) {
            e.getPresentation().setEnabled(false);
            return;
        }
        DesignSurface surface2 = (DesignSurface)((Object)e.getData(DesignerDataKeys.DESIGN_SURFACE));
        if (surface2 != null && surface2.getConfigurations().stream().allMatch(config -> HardwareConfigHelper.isWear((Device)config.getDevice()))) {
            e.getPresentation().setEnabled(false);
            return;
        }
        e.getPresentation().setEnabled(NlSupportedActionsKt.isActionSupported(surface2, NlSupportedActions.SWITCH_DEVICE_ORIENTATION));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        DesignSurface surface2 = (DesignSurface)((Object)e.getRequiredData(DesignerDataKeys.DESIGN_SURFACE));
        surface2.getConfigurations().forEach(configuration -> {
            if (HardwareConfigHelper.isWear((Device)configuration.getDevice())) {
                return;
            }
            State current = configuration.getDeviceState();
            State flip = configuration.getNextDeviceState(current);
            if (flip != null) {
                configuration.setDeviceState(flip);
            }
        });
    }
}

