/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.common.actions;

import com.android.tools.idea.actions.DesignerDataKeys;
import com.android.tools.idea.common.actions.DesignerActionUtils;
import com.android.tools.idea.common.error.IssueModel;
import com.android.tools.idea.common.error.IssuePanelService;
import com.android.tools.idea.common.error.IssuePanelServiceKt;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.uibuilder.surface.NlSupportedActions;
import com.android.tools.idea.uibuilder.surface.NlSupportedActionsKt;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.project.Project;
import com.intellij.util.IconUtil;
import icons.StudioIcons;
import javax.swing.Icon;
import kotlin.Pair;
import org.jetbrains.annotations.NotNull;

public class IssueNotificationAction
extends ToggleAction {
    public static final String NO_ISSUE = "No Issue";
    public static final String SHOW_ISSUE = "Show Warnings and Errors";
    private static final String DEFAULT_TOOLTIP = "Toggle visibility of issue panel";
    private static final Icon DISABLED_ICON = IconUtil.desaturate((Icon)StudioIcons.Common.ERROR_INLINE);

    @NotNull
    protected Pair<Icon, String> getNoErrorsIconAndDescription(@NotNull AnActionEvent event) {
        return new Pair(null, null);
    }

    @NotNull
    public static IssueNotificationAction getInstance() {
        return (IssueNotificationAction)ActionManager.getInstance().getAction("Android.Designer.IssueNotificationAction");
    }

    public void update(@NotNull AnActionEvent event) {
        if (DesignerActionUtils.isActionEventFromJTextField(event)) {
            event.getPresentation().setEnabled(false);
            return;
        }
        super.update(event);
        DesignSurface surface2 = (DesignSurface)((Object)event.getData(DesignerDataKeys.DESIGN_SURFACE));
        Presentation presentation = event.getPresentation();
        if (surface2 == null || !NlSupportedActionsKt.isActionSupported(surface2, NlSupportedActions.TOGGLE_ISSUE_PANEL)) {
            event.getPresentation().setEnabled(false);
            presentation.setText(SHOW_ISSUE);
            presentation.setDescription(DEFAULT_TOOLTIP);
            presentation.setIcon(DISABLED_ICON);
        } else {
            event.getPresentation().setEnabled(true);
            IssueModel issueModel = surface2.getIssueModel();
            int markerCount = issueModel.getIssueCount();
            presentation.setDescription(markerCount == 0 ? NO_ISSUE : SHOW_ISSUE);
            if (markerCount == 0) {
                Pair<Icon, String> iconAndDescription = this.getNoErrorsIconAndDescription(event);
                if (iconAndDescription.getSecond() != null) {
                    presentation.setText((String)iconAndDescription.getSecond());
                }
                if (iconAndDescription.getFirst() == null) {
                    presentation.setIcon(IssueNotificationAction.getIssueTypeIcon(issueModel));
                } else {
                    presentation.setIcon((Icon)iconAndDescription.getFirst());
                }
            } else {
                presentation.setIcon(IssueNotificationAction.getIssueTypeIcon(issueModel));
                presentation.setText(DEFAULT_TOOLTIP);
            }
        }
    }

    public boolean isSelected(@NotNull AnActionEvent e) {
        DesignSurface surface2 = (DesignSurface)((Object)e.getData(DesignerDataKeys.DESIGN_SURFACE));
        if (surface2 == null) {
            return false;
        }
        return IssuePanelService.getInstance(surface2.getProject()).isIssuePanelVisible(surface2);
    }

    public void setSelected(@NotNull AnActionEvent e, boolean state) {
        DesignSurface surface2 = (DesignSurface)((Object)e.getData(DesignerDataKeys.DESIGN_SURFACE));
        if (surface2 == null) {
            return;
        }
        IssuePanelServiceKt.setIssuePanelVisibility(surface2, state, true, () -> {
            Project project;
            if (((Boolean)StudioFlags.NELE_USE_SHARED_ISSUE_PANEL_FOR_DESIGN_TOOLS.get()).booleanValue() && (project = (Project)e.getData(PlatformDataKeys.PROJECT)) != null) {
                IssuePanelService.getInstance(project).focusIssuePanelIfVisible();
            }
        });
    }

    @NotNull
    private static Icon getIssueTypeIcon(@NotNull IssueModel issueModel) {
        Icon icon2 = issueModel.getErrorCount() > 0 ? StudioIcons.Common.ERROR_INLINE : (issueModel.getWarningCount() > 0 ? StudioIcons.Common.WARNING_INLINE : (issueModel.getIssueCount() > 0 ? StudioIcons.Common.INFO_INLINE : DISABLED_ICON));
        return icon2;
    }
}

